/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.io.crypto.KeyProviderForTesting;
import org.apache.hadoop.hbase.regionserver.wal.SecureProtobufLogReader;
import org.apache.hadoop.hbase.regionserver.wal.SecureProtobufLogWriter;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.DefaultWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestSecureWAL {
    static final Log LOG = LogFactory.getLog(TestSecureWAL.class);
    static final HBaseTestingUtility TEST_UTIL;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.set("hbase.crypto.keyprovider", KeyProviderForTesting.class.getName());
        conf.set("hbase.crypto.master.key.name", "hbase");
        conf.setClass("hbase.regionserver.hlog.reader.impl", SecureProtobufLogReader.class, WAL.Reader.class);
        conf.setClass("hbase.regionserver.hlog.writer.impl", SecureProtobufLogWriter.class, WALProvider.Writer.class);
        conf.setBoolean("hbase.regionserver.wal.encryption", true);
        FSUtils.setRootDir((Configuration)conf, (Path)TEST_UTIL.getDataTestDir());
    }

    @Test
    public void testSecureWAL() throws Exception {
        TableName tableName = TableName.valueOf((String)"TestSecureWAL");
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor(tableName.getName()));
        HRegionInfo regioninfo = new HRegionInfo(tableName, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, false);
        int total = 10;
        byte[] row = Bytes.toBytes((String)"row");
        byte[] family = Bytes.toBytes((String)"family");
        byte[] value = Bytes.toBytes((String)"Test value");
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        WALFactory wals = new WALFactory(TEST_UTIL.getConfiguration(), null, "TestSecureWAL");
        AtomicLong sequenceId = new AtomicLong(1L);
        WAL wal = wals.getWAL(regioninfo.getEncodedNameAsBytes());
        for (int i = 0; i < 10; ++i) {
            WALEdit kvs = new WALEdit();
            kvs.add((Cell)new KeyValue(row, family, Bytes.toBytes((int)i), value));
            wal.append(htd, regioninfo, new WALKey(regioninfo.getEncodedNameAsBytes(), tableName, System.currentTimeMillis()), kvs, sequenceId, true, null);
        }
        wal.sync();
        Path walPath = DefaultWALProvider.getCurrentFileName((WAL)wal);
        wals.shutdown();
        long length = fs.getFileStatus(walPath).getLen();
        FSDataInputStream in = fs.open(walPath);
        byte[] fileData = new byte[(int)length];
        IOUtils.readFully((InputStream)in, (byte[])fileData);
        in.close();
        Assert.assertFalse((String)"Cells appear to be plaintext", (boolean)Bytes.contains((byte[])fileData, (byte[])value));
        WAL.Reader reader = wals.createReader(TEST_UTIL.getTestFileSystem(), walPath);
        int count = 0;
        WAL.Entry entry = new WAL.Entry();
        while (reader.next(entry) != null) {
            ++count;
            ArrayList cells = entry.getEdit().getCells();
            Assert.assertTrue((String)"Should be one KV per WALEdit", (cells.size() == 1 ? 1 : 0) != 0);
            for (Cell cell : cells) {
                byte[] thisRow = cell.getRow();
                Assert.assertTrue((String)"Incorrect row", (boolean)Bytes.equals((byte[])thisRow, (byte[])row));
                byte[] thisFamily = cell.getFamily();
                Assert.assertTrue((String)"Incorrect family", (boolean)Bytes.equals((byte[])thisFamily, (byte[])family));
                byte[] thisValue = cell.getValue();
                Assert.assertTrue((String)"Incorrect value", (boolean)Bytes.equals((byte[])thisValue, (byte[])value));
            }
        }
        Assert.assertEquals((String)"Should have read back as many KVs as written", (long)10L, (long)count);
        reader.close();
    }

    static {
        ((Log4JLogger)LogFactory.getLog((String)"org.apache.hadoop.hbase.regionserver.wal")).getLogger().setLevel(Level.ALL);
        TEST_UTIL = new HBaseTestingUtility();
    }
}

