/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.Bytes;

public class HFileTestUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createHFile(Configuration configuration, FileSystem fs, Path path, byte[] family, byte[] qualifier, byte[] startKey, byte[] endKey, int numRows) throws IOException {
        HFileContext meta = new HFileContextBuilder().build();
        HFile.Writer writer = HFile.getWriterFactory((Configuration)configuration, (CacheConfig)new CacheConfig(configuration)).withPath(fs, path).withFileContext(meta).create();
        long now = System.currentTimeMillis();
        try {
            for (byte[] key : Bytes.iterateOnSplits((byte[])startKey, (byte[])endKey, (int)(numRows - 2))) {
                KeyValue kv = new KeyValue(key, family, qualifier, now, key);
                writer.append((Cell)kv);
            }
        }
        finally {
            writer.appendFileInfo(StoreFile.BULKLOAD_TIME_KEY, Bytes.toBytes((long)System.currentTimeMillis()));
            writer.close();
        }
    }
}

