/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.trace;

import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.trace.HBaseHTraceConfiguration;
import org.apache.htrace.HTraceConfiguration;
import org.apache.htrace.Sampler;
import org.apache.htrace.Span;
import org.apache.htrace.SpanReceiver;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceScope;
import org.apache.htrace.TraceTree;
import org.apache.htrace.impl.POJOSpanReceiver;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestHTraceHooks {
    private static final byte[] FAMILY_BYTES = "family".getBytes();
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static POJOSpanReceiver rcvr;

    @BeforeClass
    public static void before() throws Exception {
        TEST_UTIL.startMiniCluster(2, 3);
        rcvr = new POJOSpanReceiver((HTraceConfiguration)new HBaseHTraceConfiguration(TEST_UTIL.getConfiguration()));
        Trace.addReceiver((SpanReceiver)rcvr);
    }

    @AfterClass
    public static void after() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
        Trace.removeReceiver((SpanReceiver)rcvr);
        rcvr = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTraceCreateTable() throws Exception {
        HTable table;
        try (TraceScope tableCreationSpan = Trace.startSpan((String)"creating table", (Sampler)Sampler.ALWAYS);){
            table = TEST_UTIL.createTable(TableName.valueOf((String)"table"), FAMILY_BYTES);
        }
        TEST_UTIL.waitFor(1000L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return rcvr.getSpans().size() >= 5;
            }
        });
        Collection spans = rcvr.getSpans();
        TraceTree traceTree = new TraceTree(spans);
        List roots = traceTree.getSpansByParent().find(477902L);
        Assert.assertEquals((long)1L, (long)roots.size());
        Span createTableRoot = (Span)roots.iterator().next();
        Assert.assertEquals((Object)"creating table", (Object)createTableRoot.getDescription());
        int createTableCount = 0;
        for (Span s : traceTree.getSpansByParent().find(createTableRoot.getSpanId())) {
            if (!s.getDescription().startsWith("MasterService.CreateTable")) continue;
            ++createTableCount;
        }
        Assert.assertTrue((createTableCount >= 1 ? 1 : 0) != 0);
        Assert.assertTrue((traceTree.getSpansByParent().find(createTableRoot.getSpanId()).size() > 3 ? 1 : 0) != 0);
        Assert.assertTrue((spans.size() > 5 ? 1 : 0) != 0);
        Put put = new Put("row".getBytes());
        put.add(FAMILY_BYTES, "col".getBytes(), "value".getBytes());
        try (TraceScope putSpan = Trace.startSpan((String)"doing put", (Sampler)Sampler.ALWAYS);){
            table.put(put);
        }
        spans = rcvr.getSpans();
        traceTree = new TraceTree(spans);
        roots = traceTree.getSpansByParent().find(477902L);
        Assert.assertEquals((long)2L, (long)roots.size());
        Span putRoot = null;
        for (Span root : roots) {
            if (!root.getDescription().equals("doing put")) continue;
            putRoot = root;
        }
        Assert.assertNotNull(putRoot);
    }
}

