/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.mapreduce.RowCounter;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.LauncherSecurityManager;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.GenericOptionsParser;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRowCounter {
    final Log LOG = LogFactory.getLog(this.getClass());
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final String TABLE_NAME = "testRowCounter";
    private static final String COL_FAM = "col_fam";
    private static final String COL1 = "c1";
    private static final String COL2 = "c2";
    private static final String COMPOSITE_COLUMN = "C:A:A";
    private static final int TOTAL_ROWS = 10;
    private static final int ROWS_WITH_ONE_COL = 2;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster();
        TEST_UTIL.startMiniMapReduceCluster();
        HTable table = TEST_UTIL.createTable(TableName.valueOf((String)TABLE_NAME), Bytes.toBytes((String)COL_FAM));
        TestRowCounter.writeRows((Table)table);
        table.close();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
        TEST_UTIL.shutdownMiniMapReduceCluster();
    }

    @Test
    public void testRowCounterNoColumn() throws Exception {
        String[] args = new String[]{TABLE_NAME};
        this.runRowCount(args, 10);
    }

    @Test
    public void testRowCounterExclusiveColumn() throws Exception {
        String[] args = new String[]{TABLE_NAME, "col_fam:c1"};
        this.runRowCount(args, 8);
    }

    @Test
    public void testRowCounterColumnWithColonInQualifier() throws Exception {
        String[] args = new String[]{TABLE_NAME, "col_fam:C:A:A"};
        this.runRowCount(args, 8);
    }

    @Test
    public void testRowCounterHiddenColumn() throws Exception {
        String[] args = new String[]{TABLE_NAME, "col_fam:c2"};
        this.runRowCount(args, 10);
    }

    @Test
    public void testRowCounterTimeRange() throws Exception {
        byte[] family = Bytes.toBytes((String)COL_FAM);
        byte[] col1 = Bytes.toBytes((String)COL1);
        Put put1 = new Put(Bytes.toBytes((String)"row_timerange_1"));
        Put put2 = new Put(Bytes.toBytes((String)"row_timerange_2"));
        Put put3 = new Put(Bytes.toBytes((String)"row_timerange_3"));
        HTable table = TEST_UTIL.truncateTable(TableName.valueOf((String)TABLE_NAME));
        long ts = System.currentTimeMillis();
        put1.add(family, col1, ts, Bytes.toBytes((String)"val1"));
        table.put(put1);
        Thread.sleep(100L);
        ts = System.currentTimeMillis();
        put2.add(family, col1, ts, Bytes.toBytes((String)"val2"));
        put3.add(family, col1, ts, Bytes.toBytes((String)"val3"));
        table.put(put2);
        table.put(put3);
        table.close();
        String[] args = new String[]{TABLE_NAME, "col_fam:c1", "--starttime=0", "--endtime=" + ts};
        this.runRowCount(args, 1);
        args = new String[]{TABLE_NAME, "col_fam:c1", "--starttime=0", "--endtime=" + (ts - 10L)};
        this.runRowCount(args, 1);
        args = new String[]{TABLE_NAME, "col_fam:c1", "--starttime=" + ts, "--endtime=" + (ts + 1000L)};
        this.runRowCount(args, 2);
        args = new String[]{TABLE_NAME, "col_fam:c1", "--starttime=" + (ts - 30000L), "--endtime=" + (ts + 30000L)};
        this.runRowCount(args, 3);
    }

    private void runRowCount(String[] args, int expectedCount) throws Exception {
        GenericOptionsParser opts = new GenericOptionsParser(TEST_UTIL.getConfiguration(), args);
        Configuration conf = opts.getConfiguration();
        args = opts.getRemainingArgs();
        Job job = RowCounter.createSubmittableJob((Configuration)conf, (String[])args);
        job.waitForCompletion(true);
        Assert.assertTrue((boolean)job.isSuccessful());
        Counter counter = job.getCounters().findCounter((Enum)RowCounter.RowCounterMapper.Counters.ROWS);
        Assert.assertEquals((long)expectedCount, (long)counter.getValue());
    }

    private static void writeRows(Table table) throws IOException {
        Put put;
        byte[] row;
        int i;
        byte[] family = Bytes.toBytes((String)COL_FAM);
        byte[] value = Bytes.toBytes((String)"abcd");
        byte[] col1 = Bytes.toBytes((String)COL1);
        byte[] col2 = Bytes.toBytes((String)COL2);
        byte[] col3 = Bytes.toBytes((String)COMPOSITE_COLUMN);
        ArrayList<Put> rowsUpdate = new ArrayList<Put>();
        for (i = 0; i < 8; ++i) {
            row = Bytes.toBytes((String)("row" + i));
            put = new Put(row);
            put.add(family, col1, value);
            put.add(family, col2, value);
            put.add(family, col3, value);
            rowsUpdate.add(put);
        }
        while (i < 10) {
            row = Bytes.toBytes((String)("row" + i));
            put = new Put(row);
            put.add(family, col2, value);
            rowsUpdate.add(put);
            ++i;
        }
        table.put(rowsUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImportMain() throws Exception {
        PrintStream oldPrintStream = System.err;
        SecurityManager SECURITY_MANAGER = System.getSecurityManager();
        LauncherSecurityManager newSecurityManager = new LauncherSecurityManager();
        System.setSecurityManager(newSecurityManager);
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        String[] args = new String[]{};
        System.setErr(new PrintStream(data));
        try {
            System.setErr(new PrintStream(data));
            try {
                RowCounter.main((String[])args);
                Assert.fail((String)"should be SecurityException");
            }
            catch (SecurityException e) {
                Assert.assertEquals((long)-1L, (long)newSecurityManager.getExitCode());
                Assert.assertTrue((boolean)data.toString().contains("Wrong number of parameters:"));
                Assert.assertTrue((boolean)data.toString().contains("Usage: RowCounter [options] <tablename> [--starttime=[start] --endtime=[end] [--range=[startKey],[endKey]] [<column1> <column2>...]"));
                Assert.assertTrue((boolean)data.toString().contains("-Dhbase.client.scanner.caching=100"));
                Assert.assertTrue((boolean)data.toString().contains("-Dmapreduce.map.speculative=false"));
            }
            data.reset();
            try {
                args = new String[]{"table", "--range=1"};
                RowCounter.main((String[])args);
                Assert.fail((String)"should be SecurityException");
            }
            catch (SecurityException e) {
                Assert.assertEquals((long)-1L, (long)newSecurityManager.getExitCode());
                Assert.assertTrue((boolean)data.toString().contains("Please specify range in such format as \"--range=a,b\" or, with only one boundary, \"--range=,b\" or \"--range=a,\""));
                Assert.assertTrue((boolean)data.toString().contains("Usage: RowCounter [options] <tablename> [--starttime=[start] --endtime=[end] [--range=[startKey],[endKey]] [<column1> <column2>...]"));
            }
        }
        finally {
            System.setErr(oldPrintStream);
            System.setSecurityManager(SECURITY_MANAGER);
        }
    }
}

