/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.CacheTestUtils;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketAllocator;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketAllocatorException;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;
import org.apache.hadoop.hbase.io.hfile.bucket.CacheFullException;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.IdLock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={SmallTests.class})
public class TestBucketCache {
    private static final Random RAND = new Random();
    @Parameterized.Parameter(value=0)
    public int constructedBlockSize;
    @Parameterized.Parameter(value=1)
    public int[] constructedBlockSizes;
    BucketCache cache;
    final int CACHE_SIZE = 1000000;
    final int NUM_BLOCKS = 100;
    final int BLOCK_SIZE = 10000;
    final int NUM_THREADS = 1000;
    final int NUM_QUERIES = 10000;
    final long capacitySize = 0x2000000L;
    final int writeThreads = 3;
    final int writerQLen = 64;
    String ioEngineName = "heap";
    String persistencePath = null;

    @Parameterized.Parameters(name="{index}: blockSize={0}, bucketSizes={1}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({8192, null}, {16384, new int[]{3072, 5120, 9216, 17408, 29696, 33792, 66560, 99328, 132096}});
    }

    @Before
    public void setup() throws FileNotFoundException, IOException {
        this.cache = new MockedBucketCache(this.ioEngineName, 0x2000000L, this.constructedBlockSize, this.constructedBlockSizes, 3, 64, this.persistencePath);
    }

    @After
    public void tearDown() {
        this.cache.shutdown();
    }

    private static <T> T randFrom(List<T> a) {
        return a.get(RAND.nextInt(a.size()));
    }

    @Test
    public void testBucketAllocator() throws BucketAllocatorException {
        BucketAllocator mAllocator = this.cache.getAllocator();
        List<Integer> BLOCKSIZES = Arrays.asList(4096, 8192, 65536, 98304);
        boolean full = false;
        ArrayList<Long> allocations = new ArrayList<Long>();
        ArrayList<Integer> tmp = new ArrayList<Integer>(BLOCKSIZES);
        while (!full) {
            Integer blockSize = null;
            try {
                blockSize = TestBucketCache.randFrom(tmp);
                allocations.add(mAllocator.allocateBlock(blockSize.intValue()));
            }
            catch (CacheFullException cfe) {
                tmp.remove(blockSize);
                if (!tmp.isEmpty()) continue;
                full = true;
            }
        }
        for (Integer blockSize : BLOCKSIZES) {
            BucketAllocator.BucketSizeInfo bucketSizeInfo = mAllocator.roundUpToBucketSizeInfo(blockSize.intValue());
            BucketAllocator.IndexStatistics indexStatistics = bucketSizeInfo.statistics();
            Assert.assertEquals((String)("unexpected freeCount for " + bucketSizeInfo), (long)0L, (long)indexStatistics.freeCount());
        }
        Iterator<Integer> i$ = allocations.iterator();
        while (i$.hasNext()) {
            long offset = (Long)((Object)i$.next());
            Assert.assertEquals((long)mAllocator.sizeOfAllocation(offset), (long)mAllocator.freeBlock(offset));
        }
        Assert.assertEquals((long)0L, (long)mAllocator.getUsedSize());
    }

    @Test
    public void testCacheSimple() throws Exception {
        CacheTestUtils.testCacheSimple((BlockCache)this.cache, 10000, 10000);
    }

    @Test
    public void testCacheMultiThreadedSingleKey() throws Exception {
        CacheTestUtils.hammerSingleKey((BlockCache)this.cache, 10000, 1000, 10000);
    }

    @Test
    public void testHeapSizeChanges() throws Exception {
        this.cache.stopWriterThreads();
        CacheTestUtils.testHeapSizeChanges((BlockCache)this.cache, 10000);
    }

    private void cacheAndWaitUntilFlushedToBucket(BucketCache cache, BlockCacheKey cacheKey, Cacheable block) throws InterruptedException {
        cache.cacheBlock(cacheKey, block);
        while (!cache.backingMap.containsKey(cacheKey)) {
            Thread.sleep(100L);
        }
    }

    @Test
    public void testMemoryLeak() throws Exception {
        final BlockCacheKey cacheKey = new BlockCacheKey("dummy", 1L);
        this.cacheAndWaitUntilFlushedToBucket(this.cache, cacheKey, new CacheTestUtils.ByteArrayCacheable(new byte[10]));
        long lockId = ((BucketCache.BucketEntry)this.cache.backingMap.get(cacheKey)).offset();
        IdLock.Entry lockEntry = this.cache.offsetLock.getLockEntry(lockId);
        Thread evictThread = new Thread("evict-block"){

            @Override
            public void run() {
                TestBucketCache.this.cache.evictBlock(cacheKey);
            }
        };
        evictThread.start();
        this.cache.offsetLock.waitForWaiters(lockId, 1);
        this.cache.blockEvicted(cacheKey, (BucketCache.BucketEntry)this.cache.backingMap.remove(cacheKey), true);
        this.cacheAndWaitUntilFlushedToBucket(this.cache, cacheKey, new CacheTestUtils.ByteArrayCacheable(new byte[10]));
        this.cache.offsetLock.releaseLockEntry(lockEntry);
        evictThread.join();
        Assert.assertEquals((long)1L, (long)this.cache.getBlockCount());
        Assert.assertTrue((this.cache.getCurrentSize() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"We should have a block!", (boolean)this.cache.iterator().hasNext());
    }

    private class MockedBucketCache
    extends BucketCache {
        public MockedBucketCache(String ioEngineName, long capacity, int blockSize, int[] bucketSizes, int writerThreads, int writerQLen, String persistencePath) throws FileNotFoundException, IOException {
            super(ioEngineName, capacity, blockSize, bucketSizes, writerThreads, writerQLen, persistencePath);
            this.wait_when_cache = true;
        }

        public void cacheBlock(BlockCacheKey cacheKey, Cacheable buf, boolean inMemory, boolean cacheDataInL1) {
            if (super.getBlock(cacheKey, true, false, true) != null) {
                throw new RuntimeException("Cached an already cached block");
            }
            super.cacheBlock(cacheKey, buf, inMemory, cacheDataInL1);
        }

        public void cacheBlock(BlockCacheKey cacheKey, Cacheable buf) {
            if (super.getBlock(cacheKey, true, false, true) != null) {
                throw new RuntimeException("Cached an already cached block");
            }
            super.cacheBlock(cacheKey, buf);
        }
    }
}

