/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.replication.TableCFs;
import org.apache.hadoop.hbase.mapreduce.replication.VerifyReplication;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.wal.AbstractFSWAL;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.replication.regionserver.Replication;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceInterface;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.mapreduce.Job;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={ReplicationTests.class, LargeTests.class})
public class TestReplicationSmallTests
extends TestReplicationBase {
    private static final Log LOG = LogFactory.getLog(TestReplicationSmallTests.class);
    private static final String PEER_ID = "2";
    @Rule
    public TestName name = new TestName();

    @Before
    public void setUp() throws Exception {
        for (JVMClusterUtil.RegionServerThread r : utility1.getHBaseCluster().getRegionServerThreads()) {
            utility1.getAdmin().rollWALWriter(r.getRegionServer().getServerName());
        }
        int rowCount = utility1.countRows(tableName);
        utility1.deleteTableData(tableName);
        Scan scan = new Scan();
        int lastCount = 0;
        for (int i = 0; i < 10; ++i) {
            if (i == 9) {
                Assert.fail((String)"Waited too much time for truncate");
            }
            ResultScanner scanner = htable2.getScanner(scan);
            Result[] res = scanner.next(rowCount);
            scanner.close();
            if (res.length == 0) break;
            if (res.length < lastCount) {
                --i;
            }
            lastCount = res.length;
            LOG.info((Object)("Still got " + res.length + " rows"));
            Thread.sleep(500L);
        }
    }

    @Test(timeout=300000L)
    public void testDeleteTypes() throws Exception {
        Result res;
        int i;
        LOG.info((Object)"testDeleteTypes");
        byte[] v1 = Bytes.toBytes((String)"v1");
        byte[] v2 = Bytes.toBytes((String)"v2");
        byte[] v3 = Bytes.toBytes((String)"v3");
        htable1 = utility1.getConnection().getTable(tableName);
        long t = EnvironmentEdgeManager.currentTime();
        Put put = new Put(row);
        put.addColumn(famName, row, t, v1);
        htable1.put(put);
        put = new Put(row);
        put.addColumn(famName, row, t + 1L, v2);
        htable1.put(put);
        put = new Put(row);
        put.addColumn(famName, row, t + 2L, v3);
        htable1.put(put);
        Get get = new Get(row);
        get.readAllVersions();
        for (int i2 = 0; i2 < 10; ++i2) {
            Result res2;
            if (i2 == 9) {
                Assert.fail((String)"Waited too much time for put replication");
            }
            if ((res2 = htable2.get(get)).size() >= 3) {
                Assert.assertArrayEquals((byte[])CellUtil.cloneValue((Cell)res2.rawCells()[0]), (byte[])v3);
                Assert.assertArrayEquals((byte[])CellUtil.cloneValue((Cell)res2.rawCells()[1]), (byte[])v2);
                Assert.assertArrayEquals((byte[])CellUtil.cloneValue((Cell)res2.rawCells()[2]), (byte[])v1);
                break;
            }
            LOG.info((Object)"Rows not available");
            Thread.sleep(500L);
        }
        Delete d = new Delete(row);
        d.addColumn(famName, row, t);
        htable1.delete(d);
        get = new Get(row);
        get.readAllVersions();
        for (i = 0; i < 10; ++i) {
            if (i == 9) {
                Assert.fail((String)"Waited too much time for put replication");
            }
            if ((res = htable2.get(get)).size() <= 2) {
                Assert.assertArrayEquals((byte[])CellUtil.cloneValue((Cell)res.rawCells()[0]), (byte[])v3);
                Assert.assertArrayEquals((byte[])CellUtil.cloneValue((Cell)res.rawCells()[1]), (byte[])v2);
                break;
            }
            LOG.info((Object)"Version not deleted");
            Thread.sleep(500L);
        }
        d = new Delete(row);
        d.addColumns(famName, row, t + 2L);
        htable1.delete(d);
        get = new Get(row);
        for (i = 0; i < 10; ++i) {
            if (i == 9) {
                Assert.fail((String)"Waited too much time for del replication");
            }
            if ((res = htable2.get(get)).size() < 1) break;
            LOG.info((Object)"Rows not deleted");
            Thread.sleep(500L);
        }
    }

    @Test(timeout=300000L)
    public void testSimplePutDelete() throws Exception {
        LOG.info((Object)"testSimplePutDelete");
        Put put = new Put(row);
        put.addColumn(famName, row, row);
        htable1 = utility1.getConnection().getTable(tableName);
        htable1.put(put);
        Get get = new Get(row);
        for (int i = 0; i < 10; ++i) {
            Result res;
            if (i == 9) {
                Assert.fail((String)"Waited too much time for put replication");
            }
            if (!(res = htable2.get(get)).isEmpty()) {
                Assert.assertArrayEquals((byte[])res.value(), (byte[])row);
                break;
            }
            LOG.info((Object)"Row not available");
            Thread.sleep(500L);
        }
        Delete del = new Delete(row);
        htable1.delete(del);
        get = new Get(row);
        for (int i = 0; i < 10; ++i) {
            Result res;
            if (i == 9) {
                Assert.fail((String)"Waited too much time for del replication");
            }
            if ((res = htable2.get(get)).size() < 1) break;
            LOG.info((Object)"Row not deleted");
            Thread.sleep(500L);
        }
    }

    @Test(timeout=300000L)
    public void testSmallBatch() throws Exception {
        LOG.info((Object)"testSmallBatch");
        this.loadData("", row);
        Scan scan = new Scan();
        ResultScanner scanner1 = htable1.getScanner(scan);
        Result[] res1 = scanner1.next(100);
        scanner1.close();
        Assert.assertEquals((long)100L, (long)res1.length);
        this.waitForReplication(100, 10);
    }

    private void waitForReplication(int expectedRows, int retries) throws IOException, InterruptedException {
        for (int i = 0; i < retries; ++i) {
            Scan scan = new Scan();
            if (i == retries - 1) {
                Assert.fail((String)"Waited too much time for normal batch replication");
            }
            ResultScanner scanner = htable2.getScanner(scan);
            Result[] res = scanner.next(expectedRows);
            scanner.close();
            if (res.length == expectedRows) break;
            LOG.info((Object)("Only got " + res.length + " rows"));
            Thread.sleep(500L);
        }
    }

    private void loadData(String prefix, byte[] row) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>(100);
        for (int i = 0; i < 100; ++i) {
            Put put = new Put(Bytes.toBytes((String)(prefix + Integer.toString(i))));
            put.addColumn(famName, row, row);
            puts.add(put);
        }
        htable1.put(puts);
    }

    @Test(timeout=300000L)
    public void testDisableEnable() throws Exception {
        Result res;
        int i;
        hbaseAdmin.disableReplicationPeer(PEER_ID);
        byte[] rowkey = Bytes.toBytes((String)"disable enable");
        Put put = new Put(rowkey);
        put.addColumn(famName, row, row);
        htable1.put(put);
        Get get = new Get(rowkey);
        for (i = 0; i < 10; ++i) {
            res = htable2.get(get);
            if (res.size() >= 1) {
                Assert.fail((String)"Replication wasn't disabled");
                continue;
            }
            LOG.info((Object)"Row not replicated, let's wait a bit more...");
            Thread.sleep(500L);
        }
        hbaseAdmin.enableReplicationPeer(PEER_ID);
        for (i = 0; i < 10; ++i) {
            res = htable2.get(get);
            if (!res.isEmpty()) {
                Assert.assertArrayEquals((byte[])res.value(), (byte[])row);
                return;
            }
            LOG.info((Object)"Row not available");
            Thread.sleep(500L);
        }
        Assert.fail((String)"Waited too much time for put replication");
    }

    @Test(timeout=300000L)
    public void testAddAndRemoveClusters() throws Exception {
        LOG.info((Object)"testAddAndRemoveClusters");
        hbaseAdmin.removeReplicationPeer(PEER_ID);
        Thread.sleep(500L);
        byte[] rowKey = Bytes.toBytes((String)"Won't be replicated");
        Put put = new Put(rowKey);
        put.addColumn(famName, row, row);
        htable1.put(put);
        Get get = new Get(rowKey);
        for (int i = 0; i < 10 && i != 9; ++i) {
            Result res = htable2.get(get);
            if (res.size() >= 1) {
                Assert.fail((String)"Not supposed to be replicated");
                continue;
            }
            LOG.info((Object)"Row not replicated, let's wait a bit more...");
            Thread.sleep(500L);
        }
        ReplicationPeerConfig rpc = new ReplicationPeerConfig();
        rpc.setClusterKey(utility2.getClusterKey());
        hbaseAdmin.addReplicationPeer(PEER_ID, rpc);
        Thread.sleep(500L);
        rowKey = Bytes.toBytes((String)"do rep");
        put = new Put(rowKey);
        put.addColumn(famName, row, row);
        LOG.info((Object)"Adding new row");
        htable1.put(put);
        get = new Get(rowKey);
        for (int i = 0; i < 10; ++i) {
            Result res;
            if (i == 9) {
                Assert.fail((String)"Waited too much time for put replication");
            }
            if (!(res = htable2.get(get)).isEmpty()) {
                Assert.assertArrayEquals((byte[])res.value(), (byte[])row);
                break;
            }
            LOG.info((Object)"Row not available");
            Thread.sleep(500L * (long)i);
        }
    }

    @Test(timeout=300000L)
    public void testLoading() throws Exception {
        LOG.info((Object)"Writing out rows to table1 in testLoading");
        ArrayList<Put> puts = new ArrayList<Put>(1000);
        for (int i = 0; i < 1000; ++i) {
            Put put = new Put(Bytes.toBytes((int)i));
            put.addColumn(famName, row, row);
            puts.add(put);
        }
        htable1.put(puts);
        Scan scan = new Scan();
        ResultScanner scanner = htable1.getScanner(scan);
        Result[] res = scanner.next(1000);
        scanner.close();
        Assert.assertEquals((long)1000L, (long)res.length);
        LOG.info((Object)"Looking in table2 for replicated rows in testLoading");
        long start = System.currentTimeMillis();
        long retries = 100L;
        int i = 0;
        while ((long)i < 100L) {
            scan = new Scan();
            scanner = htable2.getScanner(scan);
            res = scanner.next(1000);
            scanner.close();
            if (res.length == 1000) break;
            if ((long)i == 99L) {
                int lastRow = -1;
                for (Result result : res) {
                    int currentRow = Bytes.toInt((byte[])result.getRow());
                    for (int row = lastRow + 1; row < currentRow; ++row) {
                        LOG.error((Object)("Row missing: " + row));
                    }
                    lastRow = currentRow;
                }
                LOG.error((Object)("Last row: " + lastRow));
                Assert.fail((String)("Waited too much time for normal batch replication, " + res.length + " instead of " + 1000 + "; waited=" + (System.currentTimeMillis() - start) + "ms"));
            } else {
                LOG.info((Object)("Only got " + res.length + " rows... retrying"));
                Thread.sleep(500L);
            }
            ++i;
        }
    }

    @Test(timeout=300000L)
    public void testVerifyRepJob() throws Exception {
        this.testSmallBatch();
        String[] args = new String[]{PEER_ID, tableName.getNameAsString()};
        this.runVerifyReplication(args, 100, 0);
        Scan scan = new Scan();
        ResultScanner rs = htable2.getScanner(scan);
        Put put = null;
        for (Result result : rs) {
            put = new Put(result.getRow());
            Cell firstVal = result.rawCells()[0];
            put.addColumn(CellUtil.cloneFamily((Cell)firstVal), CellUtil.cloneQualifier((Cell)firstVal), Bytes.toBytes((String)"diff data"));
            htable2.put(put);
        }
        Delete delete = new Delete(put.getRow());
        htable2.delete(delete);
        this.runVerifyReplication(args, 0, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testVerifyRepJobWithRawOptions() throws Exception {
        LOG.info((Object)this.name.getMethodName());
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[] familyname = Bytes.toBytes((String)"fam_raw");
        byte[] row = Bytes.toBytes((String)"row_raw");
        Table lHtable1 = null;
        Table lHtable2 = null;
        try {
            ColumnFamilyDescriptor fam = ColumnFamilyDescriptorBuilder.newBuilder((byte[])familyname).setMaxVersions(100).setScope(1).build();
            TableDescriptor table = TableDescriptorBuilder.newBuilder((TableName)tableName).addColumnFamily(fam).build();
            scopes = new TreeMap(Bytes.BYTES_COMPARATOR);
            for (ColumnFamilyDescriptor columnFamilyDescriptor : table.getColumnFamilies()) {
                scopes.put(columnFamilyDescriptor.getName(), columnFamilyDescriptor.getScope());
            }
            Connection connection1 = ConnectionFactory.createConnection((Configuration)conf1);
            Connection connection2 = ConnectionFactory.createConnection((Configuration)conf2);
            Throwable throwable = null;
            try (Admin admin1 = connection1.getAdmin();){
                admin1.createTable(table, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            Throwable throwable4 = null;
            try (Admin admin2 = connection2.getAdmin();){
                admin2.createTable(table, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE);
            }
            catch (Throwable throwable5) {
                Throwable throwable6 = throwable5;
                throw throwable5;
            }
            utility1.waitUntilAllRegionsAssigned(tableName);
            utility2.waitUntilAllRegionsAssigned(tableName);
            lHtable1 = utility1.getConnection().getTable(tableName);
            lHtable2 = utility2.getConnection().getTable(tableName);
            Put put = new Put(row);
            put.addColumn(familyname, row, row);
            lHtable1.put(put);
            Get get = new Get(row);
            for (int i = 0; i < 10; ++i) {
                Result res;
                if (i == 9) {
                    Assert.fail((String)"Waited too much time for put replication");
                }
                if (!(res = lHtable2.get(get)).isEmpty()) {
                    Assert.assertArrayEquals((byte[])res.value(), (byte[])row);
                    break;
                }
                LOG.info((Object)"Row not available");
                Thread.sleep(500L);
            }
            Delete del = new Delete(row);
            lHtable1.delete(del);
            Get get2 = new Get(row);
            for (int i = 0; i < 10; ++i) {
                Result res;
                if (i == 9) {
                    Assert.fail((String)"Waited too much time for del replication");
                }
                if ((res = lHtable2.get(get2)).size() < 1) break;
                LOG.info((Object)"Row not deleted");
                Thread.sleep(500L);
            }
            String[] argsWithoutRaw = new String[]{PEER_ID, tableName.getNameAsString()};
            this.runVerifyReplication(argsWithoutRaw, 0, 0);
            String[] argsWithRawAsTrue = new String[]{"--raw", PEER_ID, tableName.getNameAsString()};
            this.runVerifyReplication(argsWithRawAsTrue, 1, 0);
        }
        finally {
            if (lHtable1 != null) {
                lHtable1.close();
            }
            if (lHtable2 != null) {
                lHtable2.close();
            }
        }
    }

    private void runVerifyReplication(String[] args, int expectedGoodRows, int expectedBadRows) throws IOException, InterruptedException, ClassNotFoundException {
        Job job = new VerifyReplication().createSubmittableJob(new Configuration(conf1), args);
        if (job == null) {
            Assert.fail((String)"Job wasn't created, see the log");
        }
        if (!job.waitForCompletion(true)) {
            Assert.fail((String)"Job failed, see the log");
        }
        Assert.assertEquals((long)expectedGoodRows, (long)job.getCounters().findCounter((Enum)VerifyReplication.Verifier.Counters.GOODROWS).getValue());
        Assert.assertEquals((long)expectedBadRows, (long)job.getCounters().findCounter((Enum)VerifyReplication.Verifier.Counters.BADROWS).getValue());
    }

    @Test(timeout=300000L)
    public void testHBase14905() throws Exception {
        byte[] qualifierName = Bytes.toBytes((String)"f1");
        Put put = new Put(Bytes.toBytes((String)"r1"));
        put.addColumn(famName, qualifierName, Bytes.toBytes((String)"v1002"));
        htable1.put(put);
        put.addColumn(famName, qualifierName, Bytes.toBytes((String)"v1001"));
        htable1.put(put);
        put.addColumn(famName, qualifierName, Bytes.toBytes((String)"v1112"));
        htable1.put(put);
        Scan scan = new Scan();
        scan.readVersions(100);
        ResultScanner scanner1 = htable1.getScanner(scan);
        Result[] res1 = scanner1.next(1);
        scanner1.close();
        Assert.assertEquals((long)1L, (long)res1.length);
        Assert.assertEquals((long)3L, (long)res1[0].getColumnCells(famName, qualifierName).size());
        for (int i = 0; i < 10; ++i) {
            scan = new Scan();
            scan.readVersions(100);
            scanner1 = htable2.getScanner(scan);
            res1 = scanner1.next(1);
            scanner1.close();
            if (res1.length != 1) {
                LOG.info((Object)("Only got " + res1.length + " rows"));
                Thread.sleep(500L);
            } else {
                int cellNumber = res1[0].getColumnCells(famName, Bytes.toBytes((String)"f1")).size();
                if (cellNumber == 3) break;
                LOG.info((Object)("Only got " + cellNumber + " cells"));
                Thread.sleep(500L);
            }
            if (i != 9) continue;
            Assert.fail((String)"Waited too much time for normal batch replication");
        }
        put.addColumn(famName, qualifierName, Bytes.toBytes((String)"v1111"));
        htable2.put(put);
        put.addColumn(famName, qualifierName, Bytes.toBytes((String)"v1112"));
        htable2.put(put);
        scan = new Scan();
        scan.readVersions(100);
        scanner1 = htable2.getScanner(scan);
        res1 = scanner1.next(100);
        scanner1.close();
        Assert.assertEquals((long)1L, (long)res1.length);
        Assert.assertEquals((long)5L, (long)res1[0].getColumnCells(famName, qualifierName).size());
        String[] args = new String[]{"--versions=100", PEER_ID, tableName.getNameAsString()};
        this.runVerifyReplication(args, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testVersionMismatchHBase14905() throws Exception {
        byte[] qualifierName = Bytes.toBytes((String)"f1");
        Put put = new Put(Bytes.toBytes((String)"r1"));
        long ts = System.currentTimeMillis();
        put.addColumn(famName, qualifierName, ts + 1L, Bytes.toBytes((String)"v1"));
        htable1.put(put);
        put.addColumn(famName, qualifierName, ts + 2L, Bytes.toBytes((String)"v2"));
        htable1.put(put);
        put.addColumn(famName, qualifierName, ts + 3L, Bytes.toBytes((String)"v3"));
        htable1.put(put);
        Scan scan = new Scan();
        scan.readVersions(100);
        ResultScanner scanner1 = htable1.getScanner(scan);
        Result[] res1 = scanner1.next(1);
        scanner1.close();
        Assert.assertEquals((long)1L, (long)res1.length);
        Assert.assertEquals((long)3L, (long)res1[0].getColumnCells(famName, qualifierName).size());
        for (int i = 0; i < 10; ++i) {
            scan = new Scan();
            scan.readVersions(100);
            scanner1 = htable2.getScanner(scan);
            res1 = scanner1.next(1);
            scanner1.close();
            if (res1.length != 1) {
                LOG.info((Object)("Only got " + res1.length + " rows"));
                Thread.sleep(500L);
            } else {
                int cellNumber = res1[0].getColumnCells(famName, Bytes.toBytes((String)"f1")).size();
                if (cellNumber == 3) break;
                LOG.info((Object)("Only got " + cellNumber + " cells"));
                Thread.sleep(500L);
            }
            if (i != 9) continue;
            Assert.fail((String)"Waited too much time for normal batch replication");
        }
        try {
            hbaseAdmin.disableReplicationPeer(PEER_ID);
            Put put2 = new Put(Bytes.toBytes((String)"r1"));
            put2.addColumn(famName, qualifierName, ts + 2L, Bytes.toBytes((String)"v99"));
            htable2.put(put2);
            scan = new Scan();
            scan.readVersions(100);
            scanner1 = htable2.getScanner(scan);
            res1 = scanner1.next(100);
            scanner1.close();
            Assert.assertEquals((long)1L, (long)res1.length);
            Assert.assertEquals((long)3L, (long)res1[0].getColumnCells(famName, qualifierName).size());
            String[] args = new String[]{"--versions=100", PEER_ID, tableName.getNameAsString()};
            this.runVerifyReplication(args, 0, 1);
        }
        finally {
            hbaseAdmin.enableReplicationPeer(PEER_ID);
        }
    }

    @Test(timeout=300000L)
    public void testCompactionWALEdits() throws Exception {
        WALProtos.CompactionDescriptor compactionDescriptor = WALProtos.CompactionDescriptor.getDefaultInstance();
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)htable1.getName()).setStartKey(HConstants.EMPTY_START_ROW).setEndKey(HConstants.EMPTY_END_ROW).build();
        WALEdit edit = WALEdit.createCompaction((RegionInfo)hri, (WALProtos.CompactionDescriptor)compactionDescriptor);
        Replication.scopeWALEdits((WALKey)new WALKey(), (WALEdit)edit, (Configuration)htable1.getConfiguration(), null);
    }

    @Test(timeout=300000L)
    public void testVerifyListReplicatedTable() throws Exception {
        int i;
        LOG.info((Object)"testVerifyListReplicatedTable");
        String tName = "VerifyListReplicated_";
        String colFam = "cf1";
        int numOfTables = 3;
        Admin hadmin = utility1.getAdmin();
        for (int i2 = 0; i2 < 3; ++i2) {
            hadmin.createTable(TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)("VerifyListReplicated_" + i2))).addColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"cf1")).setScope(1).build()).build());
        }
        List replicationColFams = hbaseAdmin.listReplicatedTableCFs();
        int[] match = new int[3];
        for (i = 0; i < replicationColFams.size(); ++i) {
            int m;
            TableCFs replicationEntry = (TableCFs)replicationColFams.get(i);
            String tn = replicationEntry.getTable().getNameAsString();
            if (!tn.startsWith("VerifyListReplicated_") || !replicationEntry.getColumnFamilyMap().containsKey("cf1")) continue;
            int n = m = Integer.parseInt(tn.substring(tn.length() - 1));
            match[n] = match[n] + 1;
        }
        for (i = 0; i < match.length; ++i) {
            Assert.assertTrue((String)("listReplicated() does not match table " + i), (match[i] == 1 ? 1 : 0) != 0);
        }
        for (i = 0; i < 3; ++i) {
            TableName tableName = TableName.valueOf((String)("VerifyListReplicated_" + i));
            hadmin.disableTable(tableName);
            hadmin.deleteTable(tableName);
        }
        hadmin.close();
    }

    @Test
    public void testReplicationInReplay() throws Exception {
        TableName tableName = htable1.getName();
        HRegion region = (HRegion)utility1.getMiniHBaseCluster().getRegions(tableName).get(0);
        RegionInfo hri = region.getRegionInfo();
        TreeMap<byte[], Integer> scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        for (byte[] fam : htable1.getDescriptor().getColumnFamilyNames()) {
            scopes.put(fam, 1);
        }
        MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl();
        int index = utility1.getMiniHBaseCluster().getServerWith(hri.getRegionName());
        WAL wal = utility1.getMiniHBaseCluster().getRegionServer(index).getWAL(region.getRegionInfo());
        byte[] rowName = Bytes.toBytes((String)"testReplicationInReplay");
        byte[] qualifier = Bytes.toBytes((String)"q");
        byte[] value = Bytes.toBytes((String)"v");
        WALEdit edit = new WALEdit(true);
        long now = EnvironmentEdgeManager.currentTime();
        edit.add((Cell)new KeyValue(rowName, famName, qualifier, now, value));
        WALKey walKey = new WALKey(hri.getEncodedNameAsBytes(), tableName, now, mvcc, scopes);
        wal.append(hri, walKey, edit, true);
        wal.sync();
        Get get = new Get(rowName);
        for (int i = 0; i < 10 && i != 9; ++i) {
            Result res = htable2.get(get);
            if (res.size() >= 1) {
                Assert.fail((String)("Not supposed to be replicated for " + Bytes.toString((byte[])res.getRow())));
                continue;
            }
            LOG.info((Object)"Row not replicated, let's wait a bit more...");
            Thread.sleep(500L);
        }
    }

    @Test(timeout=300000L)
    public void testVerifyReplicationPrefixFiltering() throws Exception {
        byte[] prefixRow = Bytes.toBytes((String)"prefixrow");
        byte[] prefixRow2 = Bytes.toBytes((String)"secondrow");
        this.loadData("prefixrow", prefixRow);
        this.loadData("secondrow", prefixRow2);
        this.loadData("aaa", row);
        this.loadData("zzz", row);
        this.waitForReplication(400, 40);
        String[] args = new String[]{"--row-prefixes=prefixrow,secondrow", PEER_ID, tableName.getNameAsString()};
        this.runVerifyReplication(args, 200, 0);
    }

    @Test(timeout=300000L)
    public void testVerifyReplicationSnapshotArguments() {
        Object[] args = new String[]{"--sourceSnapshotName=snapshot1", PEER_ID, tableName.getNameAsString()};
        Assert.assertFalse((String)Lists.newArrayList((Object[])args).toString(), (boolean)new VerifyReplication().doCommandLine((String[])args));
        args = new String[]{"--sourceSnapshotTmpDir=tmp", PEER_ID, tableName.getNameAsString()};
        Assert.assertFalse((String)Lists.newArrayList((Object[])args).toString(), (boolean)new VerifyReplication().doCommandLine((String[])args));
        args = new String[]{"--sourceSnapshotName=snapshot1", "--sourceSnapshotTmpDir=tmp", PEER_ID, tableName.getNameAsString()};
        Assert.assertTrue((String)Lists.newArrayList((Object[])args).toString(), (boolean)new VerifyReplication().doCommandLine((String[])args));
        args = new String[]{"--peerSnapshotName=snapshot1", PEER_ID, tableName.getNameAsString()};
        Assert.assertFalse((String)Lists.newArrayList((Object[])args).toString(), (boolean)new VerifyReplication().doCommandLine((String[])args));
        args = new String[]{"--peerSnapshotTmpDir=/tmp/", PEER_ID, tableName.getNameAsString()};
        Assert.assertFalse((String)Lists.newArrayList((Object[])args).toString(), (boolean)new VerifyReplication().doCommandLine((String[])args));
        args = new String[]{"--peerSnapshotName=snapshot1", "--peerSnapshotTmpDir=/tmp/", "--peerFSAddress=tempfs", "--peerHBaseRootAddress=hdfs://tempfs:50070/hbase/", PEER_ID, tableName.getNameAsString()};
        Assert.assertTrue((String)Lists.newArrayList((Object[])args).toString(), (boolean)new VerifyReplication().doCommandLine((String[])args));
        args = new String[]{"--sourceSnapshotName=snapshot1", "--sourceSnapshotTmpDir=/tmp/", "--peerSnapshotName=snapshot2", "--peerSnapshotTmpDir=/tmp/", "--peerFSAddress=tempfs", "--peerHBaseRootAddress=hdfs://tempfs:50070/hbase/", PEER_ID, tableName.getNameAsString()};
        Assert.assertTrue((String)Lists.newArrayList((Object[])args).toString(), (boolean)new VerifyReplication().doCommandLine((String[])args));
    }

    @Test(timeout=300000L)
    public void testVerifyReplicationWithSnapshotSupport() throws Exception {
        this.testSmallBatch();
        Path rootDir = FSUtils.getRootDir((Configuration)conf1);
        FileSystem fs = rootDir.getFileSystem(conf1);
        String sourceSnapshotName = "sourceSnapshot-" + System.currentTimeMillis();
        SnapshotTestingUtils.createSnapshotAndValidate((Admin)utility1.getAdmin(), (TableName)tableName, (String)new String(famName), (String)sourceSnapshotName, (Path)rootDir, (FileSystem)fs, (boolean)true);
        Path peerRootDir = FSUtils.getRootDir((Configuration)conf2);
        FileSystem peerFs = peerRootDir.getFileSystem(conf2);
        String peerSnapshotName = "peerSnapshot-" + System.currentTimeMillis();
        SnapshotTestingUtils.createSnapshotAndValidate((Admin)utility2.getAdmin(), (TableName)tableName, (String)new String(famName), (String)peerSnapshotName, (Path)peerRootDir, (FileSystem)peerFs, (boolean)true);
        String peerFSAddress = peerFs.getUri().toString();
        String temPath1 = utility1.getRandomDir().toString();
        String temPath2 = "/tmp2";
        String[] args = new String[]{"--sourceSnapshotName=" + sourceSnapshotName, "--sourceSnapshotTmpDir=" + temPath1, "--peerSnapshotName=" + peerSnapshotName, "--peerSnapshotTmpDir=" + temPath2, "--peerFSAddress=" + peerFSAddress, "--peerHBaseRootAddress=" + FSUtils.getRootDir((Configuration)conf2), PEER_ID, tableName.getNameAsString()};
        Job job = new VerifyReplication().createSubmittableJob(conf1, args);
        if (job == null) {
            Assert.fail((String)"Job wasn't created, see the log");
        }
        if (!job.waitForCompletion(true)) {
            Assert.fail((String)"Job failed, see the log");
        }
        Assert.assertEquals((long)100L, (long)job.getCounters().findCounter((Enum)VerifyReplication.Verifier.Counters.GOODROWS).getValue());
        Assert.assertEquals((long)0L, (long)job.getCounters().findCounter((Enum)VerifyReplication.Verifier.Counters.BADROWS).getValue());
        Scan scan = new Scan();
        ResultScanner rs = htable2.getScanner(scan);
        Put put = null;
        for (Result result : rs) {
            put = new Put(result.getRow());
            Cell firstVal = result.rawCells()[0];
            put.addColumn(CellUtil.cloneFamily((Cell)firstVal), CellUtil.cloneQualifier((Cell)firstVal), Bytes.toBytes((String)"diff data"));
            htable2.put(put);
        }
        Delete delete = new Delete(put.getRow());
        htable2.delete(delete);
        sourceSnapshotName = "sourceSnapshot-" + System.currentTimeMillis();
        SnapshotTestingUtils.createSnapshotAndValidate((Admin)utility1.getAdmin(), (TableName)tableName, (String)new String(famName), (String)sourceSnapshotName, (Path)rootDir, (FileSystem)fs, (boolean)true);
        peerSnapshotName = "peerSnapshot-" + System.currentTimeMillis();
        SnapshotTestingUtils.createSnapshotAndValidate((Admin)utility2.getAdmin(), (TableName)tableName, (String)new String(famName), (String)peerSnapshotName, (Path)peerRootDir, (FileSystem)peerFs, (boolean)true);
        args = new String[]{"--sourceSnapshotName=" + sourceSnapshotName, "--sourceSnapshotTmpDir=" + temPath1, "--peerSnapshotName=" + peerSnapshotName, "--peerSnapshotTmpDir=" + temPath2, "--peerFSAddress=" + peerFSAddress, "--peerHBaseRootAddress=" + FSUtils.getRootDir((Configuration)conf2), PEER_ID, tableName.getNameAsString()};
        job = new VerifyReplication().createSubmittableJob(conf1, args);
        if (job == null) {
            Assert.fail((String)"Job wasn't created, see the log");
        }
        if (!job.waitForCompletion(true)) {
            Assert.fail((String)"Job failed, see the log");
        }
        Assert.assertEquals((long)0L, (long)job.getCounters().findCounter((Enum)VerifyReplication.Verifier.Counters.GOODROWS).getValue());
        Assert.assertEquals((long)100L, (long)job.getCounters().findCounter((Enum)VerifyReplication.Verifier.Counters.BADROWS).getValue());
    }

    @Test
    public void testEmptyWALRecovery() throws Exception {
        int i;
        int numRs = utility1.getHBaseCluster().getRegionServerThreads().size();
        ArrayList<Path> emptyWalPaths = new ArrayList<Path>();
        long ts = System.currentTimeMillis();
        for (i = 0; i < numRs; ++i) {
            RegionInfo regionInfo = ((HRegion)utility1.getHBaseCluster().getRegions(htable1.getName()).get(0)).getRegionInfo();
            WAL wal = utility1.getHBaseCluster().getRegionServer(i).getWAL(regionInfo);
            Path currentWalPath = AbstractFSWALProvider.getCurrentFileName((WAL)wal);
            String walGroupId = AbstractFSWALProvider.getWALPrefixFromWALName((String)currentWalPath.getName());
            Path emptyWalPath = new Path(utility1.getDataTestDir(), walGroupId + "." + ts);
            utility1.getTestFileSystem().create(emptyWalPath).close();
            emptyWalPaths.add(emptyWalPath);
        }
        for (i = 0; i < numRs; ++i) {
            HRegionServer hrs = utility1.getHBaseCluster().getRegionServer(i);
            Replication replicationService = (Replication)hrs.getReplicationSourceService();
            replicationService.preLogRoll(null, (Path)emptyWalPaths.get(i));
            replicationService.postLogRoll(null, (Path)emptyWalPaths.get(i));
            RegionInfo regionInfo = ((HRegion)utility1.getHBaseCluster().getRegions(htable1.getName()).get(0)).getRegionInfo();
            WAL wal = hrs.getWAL(regionInfo);
            wal.rollWriter(true);
        }
        this.waitForLogAdvance(numRs);
        this.testSimplePutDelete();
    }

    private void waitForLogAdvance(final int numRs) throws Exception {
        Waiter.waitFor((Configuration)conf1, (long)10000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                for (int i = 0; i < numRs; ++i) {
                    HRegionServer hrs = TestReplicationBase.utility1.getHBaseCluster().getRegionServer(i);
                    RegionInfo regionInfo = ((HRegion)TestReplicationBase.utility1.getHBaseCluster().getRegions(TestReplicationBase.htable1.getName()).get(0)).getRegionInfo();
                    WAL wal = hrs.getWAL(regionInfo);
                    Path currentFile = ((AbstractFSWAL)wal).getCurrentFileName();
                    Replication replicationService = (Replication)TestReplicationBase.utility1.getHBaseCluster().getRegionServer(i).getReplicationSourceService();
                    for (ReplicationSourceInterface rsi : replicationService.getReplicationManager().getSources()) {
                        ReplicationSource source = (ReplicationSource)rsi;
                        if (currentFile.equals((Object)source.getCurrentPath())) continue;
                        return false;
                    }
                }
                return true;
            }
        });
    }
}

