/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.AbstractFSContractTestBase;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.junit.Test;

public abstract class AbstractContractDeleteTest
extends AbstractFSContractTestBase {
    @Test
    public void testDeleteEmptyDirNonRecursive() throws Throwable {
        Path path = this.path("testDeleteEmptyDirNonRecursive");
        this.mkdirs(path);
        this.assertDeleted(path, false);
    }

    @Test
    public void testDeleteEmptyDirRecursive() throws Throwable {
        Path path = this.path("testDeleteEmptyDirRecursive");
        this.mkdirs(path);
        this.assertDeleted(path, true);
    }

    @Test
    public void testDeleteNonexistentPathRecursive() throws Throwable {
        Path path = this.path("testDeleteNonexistentPathRecursive");
        this.assertPathDoesNotExist("leftover", path);
        ContractTestUtils.rejectRootOperation(path);
        AbstractContractDeleteTest.assertFalse((String)("Returned true attempting to delete a nonexistent path " + path), (boolean)this.getFileSystem().delete(path, false));
    }

    @Test
    public void testDeleteNonexistentPathNonRecursive() throws Throwable {
        Path path = this.path("testDeleteNonexistentPathNonRecursive");
        this.assertPathDoesNotExist("leftover", path);
        ContractTestUtils.rejectRootOperation(path);
        AbstractContractDeleteTest.assertFalse((String)("Returned true attempting to recursively delete a nonexistent path " + path), (boolean)this.getFileSystem().delete(path, false));
    }

    @Test
    public void testDeleteNonEmptyDirNonRecursive() throws Throwable {
        Path path = this.path("testDeleteNonEmptyDirNonRecursive");
        this.mkdirs(path);
        Path file = new Path(path, "childfile");
        ContractTestUtils.writeTextFile(this.getFileSystem(), file, "goodbye, world", true);
        try {
            ContractTestUtils.rejectRootOperation(path);
            boolean deleted = this.getFileSystem().delete(path, false);
            AbstractContractDeleteTest.fail((String)("non recursive delete should have raised an exception, but completed with exit code " + deleted));
        }
        catch (IOException expected) {
            this.handleExpectedException(expected);
        }
        this.assertIsDirectory(path);
    }

    @Test
    public void testDeleteNonEmptyDirRecursive() throws Throwable {
        Path path = this.path("testDeleteNonEmptyDirRecursive");
        this.mkdirs(path);
        Path file = new Path(path, "childfile");
        ContractTestUtils.writeTextFile(this.getFileSystem(), file, "goodbye, world", true);
        this.assertDeleted(path, true);
        this.assertPathDoesNotExist("not deleted", file);
    }

    @Test
    public void testDeleteDeepEmptyDir() throws Throwable {
        this.mkdirs(this.path("testDeleteDeepEmptyDir/d1/d2/d3/d4"));
        this.assertDeleted(this.path("testDeleteDeepEmptyDir/d1/d2/d3"), true);
        this.assertPathDoesNotExist("not deleted", this.path("testDeleteDeepEmptyDir/d1/d2/d3/d4"));
        this.assertPathDoesNotExist("not deleted", this.path("testDeleteDeepEmptyDir/d1/d2/d3"));
        this.assertPathExists("parent dir is deleted", this.path("testDeleteDeepEmptyDir/d1/d2"));
    }

    @Test
    public void testDeleteSingleFile() throws Throwable {
        Path path = this.path("testDeleteSingleFile/d1/d2");
        this.mkdirs(path);
        Path file = new Path(path, "childfile");
        ContractTestUtils.writeTextFile(this.getFileSystem(), file, "single file to be deleted.", true);
        this.assertPathExists("single file not created", file);
        this.assertDeleted(file, false);
    }
}

