/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.api;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.management.api.ClusterManagementException;
import org.apache.geode.management.api.ClusterManagementGetResult;
import org.apache.geode.management.api.ClusterManagementListOperationsResult;
import org.apache.geode.management.api.ClusterManagementListResult;
import org.apache.geode.management.api.ClusterManagementOperation;
import org.apache.geode.management.api.ClusterManagementOperationResult;
import org.apache.geode.management.api.ClusterManagementRealizationResult;
import org.apache.geode.management.api.ClusterManagementResult;
import org.apache.geode.management.api.ClusterManagementServiceTransport;
import org.apache.geode.management.api.CommandType;
import org.apache.geode.management.api.ConnectionConfig;
import org.apache.geode.management.configuration.AbstractConfiguration;
import org.apache.geode.management.internal.CompletableFutureProxy;
import org.apache.geode.management.internal.RestTemplateResponseErrorHandler;
import org.apache.geode.management.runtime.OperationResult;
import org.apache.geode.management.runtime.RuntimeInfo;
import org.apache.geode.util.internal.GeodeJsonMapper;
import org.apache.http.Header;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.message.BasicHeader;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.DefaultUriTemplateHandler;
import org.springframework.web.util.UriTemplateHandler;

@Experimental
public class RestTemplateClusterManagementServiceTransport
implements ClusterManagementServiceTransport {
    static final ResponseErrorHandler DEFAULT_ERROR_HANDLER = new RestTemplateResponseErrorHandler();
    private final RestTemplate restTemplate;
    private final ScheduledExecutorService longRunningStatusPollingThreadPool = Executors.newScheduledThreadPool(1);

    public RestTemplateClusterManagementServiceTransport(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
        this.restTemplate.setErrorHandler(DEFAULT_ERROR_HANDLER);
    }

    public RestTemplateClusterManagementServiceTransport(ConnectionConfig connectionConfig) {
        this(new RestTemplate(), connectionConfig);
    }

    public RestTemplateClusterManagementServiceTransport(RestTemplate restTemplate, ConnectionConfig connectionConfig) {
        this(restTemplate);
        this.configureConnection(connectionConfig);
    }

    @Override
    public void configureConnection(ConnectionConfig connectionConfig) {
        if (connectionConfig == null) {
            throw new IllegalStateException("ConnectionConfig cannot be null. Please use setConnectionConfig()");
        }
        if (connectionConfig.getHost() == null || connectionConfig.getPort() <= 0) {
            throw new IllegalArgumentException("host and port needs to be specified in order to build the service.");
        }
        DefaultUriTemplateHandler templateHandler = new DefaultUriTemplateHandler();
        String schema = connectionConfig.getSslContext() == null ? "http" : "https";
        templateHandler.setBaseUrl(schema + "://" + connectionConfig.getHost() + ":" + connectionConfig.getPort() + "/management");
        this.restTemplate.setUriTemplateHandler((UriTemplateHandler)templateHandler);
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        if (connectionConfig.getFollowRedirects()) {
            clientBuilder.setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
        }
        if (connectionConfig.getAuthToken() != null) {
            List<Header> defaultHeaders = Arrays.asList(new BasicHeader("Authorization", "Bearer " + connectionConfig.getAuthToken()));
            clientBuilder.setDefaultHeaders(defaultHeaders);
        } else if (connectionConfig.getUsername() != null) {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(connectionConfig.getHost(), connectionConfig.getPort()), (Credentials)new UsernamePasswordCredentials(connectionConfig.getUsername(), connectionConfig.getPassword()));
            clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
        }
        clientBuilder.setSSLContext(connectionConfig.getSslContext());
        clientBuilder.setSSLHostnameVerifier(connectionConfig.getHostnameVerifier());
        requestFactory.setHttpClient((HttpClient)clientBuilder.build());
        this.restTemplate.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        MappingJackson2HttpMessageConverter messageConverter = new MappingJackson2HttpMessageConverter();
        messageConverter.setPrettyPrint(false);
        messageConverter.setObjectMapper(GeodeJsonMapper.getMapperIgnoringUnknownProperties());
        this.restTemplate.getMessageConverters().removeIf(m -> m.getClass().getName().equals(MappingJackson2HttpMessageConverter.class.getName()));
        this.restTemplate.getMessageConverters().add(messageConverter);
    }

    @Override
    public <T extends AbstractConfiguration<?>> ClusterManagementRealizationResult submitMessage(T configMessage, CommandType command, Class<? extends ClusterManagementRealizationResult> responseType) {
        switch (command) {
            case CREATE: {
                return this.create(configMessage, responseType);
            }
            case DELETE: {
                return this.delete(configMessage, responseType);
            }
        }
        throw new IllegalArgumentException("Unable to process command " + (Object)((Object)command) + ". Perhaps you need to use a different method in ClusterManagementServiceTransport.");
    }

    @Override
    public <T extends AbstractConfiguration<R>, R extends RuntimeInfo> ClusterManagementGetResult<T, R> submitMessageForGet(T config, Class<? extends ClusterManagementGetResult> responseType) {
        return (ClusterManagementGetResult)this.restTemplate.exchange(this.getIdentityEndpoint(config), HttpMethod.GET, RestTemplateClusterManagementServiceTransport.makeEntity(config), responseType, new Object[0]).getBody();
    }

    @Override
    public <T extends AbstractConfiguration<R>, R extends RuntimeInfo> ClusterManagementListResult<T, R> submitMessageForList(T config, Class<? extends ClusterManagementListResult> responseType) {
        String endPoint = "/v1" + config.getLinks().getList();
        return (ClusterManagementListResult)this.restTemplate.exchange(endPoint + "/?id={id}&group={group}", HttpMethod.GET, RestTemplateClusterManagementServiceTransport.makeEntity(config), responseType, new Object[]{config.getId(), config.getGroup()}).getBody();
    }

    @Override
    public <A extends ClusterManagementOperation<V>, V extends OperationResult> ClusterManagementListOperationsResult<V> submitMessageForListOperation(A opType, Class<? extends ClusterManagementListOperationsResult> responseType) {
        ClusterManagementListOperationsResult result = (ClusterManagementListOperationsResult)this.assertSuccessful((ClusterManagementResult)this.restTemplate.exchange("/v1" + opType.getEndpoint(), HttpMethod.GET, RestTemplateClusterManagementServiceTransport.makeEntity(null), ClusterManagementListOperationsResult.class, new Object[0]).getBody());
        return new ClusterManagementListOperationsResult(result.getResult().stream().map(r -> this.reAnimate((ClusterManagementOperationResult)r, opType.getEndpoint())).collect(Collectors.toList()));
    }

    @Override
    public <A extends ClusterManagementOperation<V>, V extends OperationResult> ClusterManagementOperationResult<V> submitMessageForStart(A op) {
        ClusterManagementOperationResult result = (ClusterManagementOperationResult)this.assertSuccessful((ClusterManagementResult)this.restTemplate.exchange("/v1" + op.getEndpoint(), HttpMethod.POST, RestTemplateClusterManagementServiceTransport.makeEntity(op), ClusterManagementOperationResult.class, new Object[0]).getBody());
        return this.reAnimate(result, op.getEndpoint());
    }

    @Override
    public boolean isConnected() {
        try {
            return ((String)this.restTemplate.getForEntity("/v1/ping", String.class, new Object[0]).getBody()).equals("pong");
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void close() {
        this.longRunningStatusPollingThreadPool.shutdownNow();
    }

    private <V extends OperationResult> ClusterManagementOperationResult<V> reAnimate(ClusterManagementOperationResult<V> result, String endPoint) {
        String uri = "/v1" + endPoint + "/" + result.getOperationId();
        CompletableFuture<Date> futureOperationEnded = new CompletableFuture<Date>();
        CompletableFutureProxy operationResult = new CompletableFutureProxy(this.restTemplate, uri, this.longRunningStatusPollingThreadPool, futureOperationEnded);
        return new ClusterManagementOperationResult(result, operationResult, result.getOperationStart(), futureOperationEnded, result.getOperator(), result.getOperationId());
    }

    private <T extends AbstractConfiguration<?>> ClusterManagementRealizationResult create(T config, Class<? extends ClusterManagementRealizationResult> expectedResult) {
        String endPoint = "/v1" + config.getLinks().getList();
        return (ClusterManagementRealizationResult)this.restTemplate.exchange(endPoint, HttpMethod.POST, RestTemplateClusterManagementServiceTransport.makeEntity(config), expectedResult, new Object[0]).getBody();
    }

    private <T extends AbstractConfiguration<?>> ClusterManagementRealizationResult delete(T config, Class<? extends ClusterManagementRealizationResult> expectedResult) {
        String uri = this.getIdentityEndpoint(config);
        return (ClusterManagementRealizationResult)this.restTemplate.exchange(uri + "?group={group}", HttpMethod.DELETE, RestTemplateClusterManagementServiceTransport.makeEntity(null), expectedResult, new Object[]{config.getGroup()}).getBody();
    }

    public static <T> HttpEntity<T> makeEntity(T config) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("X-Include-Class", "true");
        return new HttpEntity(config, (MultiValueMap)headers);
    }

    private String getIdentityEndpoint(AbstractConfiguration<?> config) {
        String uri = config.getLinks().getSelf();
        if (uri == null) {
            throw new IllegalArgumentException("Unable to construct the URI with the current configuration.");
        }
        return "/v1" + uri;
    }

    private <T extends ClusterManagementResult> T assertSuccessful(T result) {
        if (result == null) {
            ClusterManagementResult somethingVeryBadHappened = new ClusterManagementResult(ClusterManagementResult.StatusCode.ERROR, "Unable to parse server response.");
            throw new ClusterManagementException(somethingVeryBadHappened);
        }
        if (!result.isSuccessful()) {
            throw new ClusterManagementException(result);
        }
        return result;
    }
}

