/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.flume.FlumeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(HostInfo.class);
    private final String referenceName;
    private final String hostName;
    private final int portNumber;

    public HostInfo(String referenceName, String hostName, int portNumber) {
        this.referenceName = referenceName;
        this.hostName = hostName;
        this.portNumber = portNumber;
    }

    public String getReferenceName() {
        return this.referenceName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public String toString() {
        return this.referenceName + "{" + this.hostName + ":" + this.portNumber + "}";
    }

    static List<HostInfo> getHostInfoList(Properties properties) {
        ArrayList<HostInfo> hosts = new ArrayList<HostInfo>();
        String hostNames = properties.getProperty("hosts");
        if (hostNames != null && !hostNames.isEmpty()) {
            String[] hostList = hostNames.split("\\s+");
            for (int i = 0; i < hostList.length; ++i) {
                String hostAndPortStr = properties.getProperty("hosts." + hostList[i]);
                if (hostAndPortStr == null) continue;
                String[] hostAndPort = hostAndPortStr.split(":");
                if (hostAndPort.length != 2) {
                    LOGGER.error("Invalid host address" + hostAndPortStr);
                    throw new FlumeException("Invalid host address" + hostAndPortStr);
                }
                Integer port = null;
                try {
                    port = Integer.parseInt(hostAndPort[1]);
                }
                catch (NumberFormatException e) {
                    LOGGER.error("Invalid port number" + hostAndPortStr, (Throwable)e);
                    throw new FlumeException("Invalid port number" + hostAndPortStr);
                }
                HostInfo info = new HostInfo(hostList[i], hostAndPort[0].trim(), port);
                hosts.add(info);
            }
        }
        return hosts;
    }
}

