/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.auth;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.security.auth.callback.CallbackHandler;
import org.apache.flume.auth.FlumeAuthenticator;
import org.apache.flume.auth.KerberosAuthenticator;
import org.apache.flume.auth.SecurityException;
import org.apache.flume.auth.SimpleAuthenticator;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.SecurityUtil;

public class FlumeAuthenticationUtil {
    private static KerberosAuthenticator kerbAuthenticator;

    private FlumeAuthenticationUtil() {
    }

    public static synchronized FlumeAuthenticator getAuthenticator(String principal, String keytab) throws SecurityException {
        if (principal == null && keytab == null) {
            return SimpleAuthenticator.getSimpleAuthenticator();
        }
        Preconditions.checkArgument((principal != null ? 1 : 0) != 0, (Object)"Principal can not be null when keytab is provided");
        Preconditions.checkArgument((keytab != null ? 1 : 0) != 0, (Object)"Keytab can not be null when Principal is provided");
        if (kerbAuthenticator == null) {
            kerbAuthenticator = new KerberosAuthenticator();
        }
        kerbAuthenticator.authenticate(principal, keytab);
        return kerbAuthenticator;
    }

    public static CallbackHandler getSaslGssCallbackHandler() {
        return new SaslRpcServer.SaslGssCallbackHandler();
    }

    public static String[] splitKerberosName(String principal) throws IOException {
        String resolvedPrinc = SecurityUtil.getServerPrincipal((String)principal, (String)"");
        return SaslRpcServer.splitKerberosName((String)resolvedPrinc);
    }

    @VisibleForTesting
    static void clearCredentials() {
        kerbAuthenticator = null;
    }
}

