/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.util;

import org.apache.flink.api.common.CodeAnalysisMode;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.ExecutionEnvironmentFactory;
import org.apache.flink.optimizer.DataStatistics;
import org.apache.flink.optimizer.Optimizer;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plandump.PlanJSONDumpGenerator;
import org.apache.flink.optimizer.plantranslate.JobGraphGenerator;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.minicluster.LocalFlinkMiniCluster;

public class TestEnvironment
extends ExecutionEnvironment {
    private final LocalFlinkMiniCluster executor;
    private TestEnvironment lastEnv = null;

    public JobExecutionResult getLastJobExecutionResult() {
        if (this.lastEnv == null) {
            return this.lastJobExecutionResult;
        }
        return this.lastEnv.getLastJobExecutionResult();
    }

    public TestEnvironment(LocalFlinkMiniCluster executor, int parallelism) {
        this.executor = executor;
        this.setParallelism(parallelism);
        this.getConfig().setCodeAnalysisMode(CodeAnalysisMode.DISABLE);
    }

    public TestEnvironment(LocalFlinkMiniCluster executor, int parallelism, boolean isObjectReuseEnabled) {
        this(executor, parallelism);
        if (isObjectReuseEnabled) {
            this.getConfig().enableObjectReuse();
        } else {
            this.getConfig().disableObjectReuse();
        }
    }

    public void startNewSession() throws Exception {
    }

    public JobExecutionResult execute(String jobName) throws Exception {
        OptimizedPlan op = this.compileProgram(jobName);
        JobGraphGenerator jgg = new JobGraphGenerator();
        JobGraph jobGraph = jgg.compileJobGraph(op);
        this.lastJobExecutionResult = this.executor.submitJobAndWait(jobGraph, false);
        return this.lastJobExecutionResult;
    }

    public String getExecutionPlan() throws Exception {
        OptimizedPlan op = this.compileProgram("unused");
        PlanJSONDumpGenerator jsonGen = new PlanJSONDumpGenerator();
        return jsonGen.getOptimizerPlanAsJSON(op);
    }

    private OptimizedPlan compileProgram(String jobName) {
        Plan p = this.createProgramPlan(jobName);
        Optimizer pc = new Optimizer(new DataStatistics(), this.executor.configuration());
        return pc.compile(p);
    }

    public void setAsContext() {
        ExecutionEnvironmentFactory factory = new ExecutionEnvironmentFactory(){

            public ExecutionEnvironment createExecutionEnvironment() {
                TestEnvironment.this.lastEnv = new TestEnvironment(TestEnvironment.this.executor, TestEnvironment.this.getParallelism(), TestEnvironment.this.getConfig().isObjectReuseEnabled());
                return TestEnvironment.this.lastEnv;
            }
        };
        TestEnvironment.initializeContextEnvironment((ExecutionEnvironmentFactory)factory);
    }
}

