/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.slf4j.Log4jLogger;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogLevelRule
extends ExternalResource {
    public static final boolean LOGGING_ENABLED = LoggerFactory.getLogger((String)"ROOT").isErrorEnabled();
    private Map<String, org.slf4j.event.Level> testLevels = new HashMap<String, org.slf4j.event.Level>();
    private List<Runnable> resetActions = new ArrayList<Runnable>();
    private static final Map<org.slf4j.event.Level, Level> SLF_TO_LOG4J = new HashMap<org.slf4j.event.Level, Level>();
    private LoggerContext log4jContext;

    public void before() throws Exception {
        if (!LOGGING_ENABLED) {
            return;
        }
        for (Map.Entry<String, org.slf4j.event.Level> levelEntry : this.testLevels.entrySet()) {
            Logger logger = LoggerFactory.getLogger((String)levelEntry.getKey());
            if (logger instanceof Log4jLogger) {
                this.setLog4jLevel(levelEntry.getKey(), levelEntry.getValue());
                continue;
            }
            throw new UnsupportedOperationException("Cannot change log level of " + logger);
        }
        if (this.log4jContext != null) {
            this.log4jContext.updateLoggers();
        }
    }

    private void setLog4jLevel(String logger, org.slf4j.event.Level level) {
        Configuration conf;
        LoggerConfig loggerConfig;
        if (this.log4jContext == null) {
            this.log4jContext = (LoggerContext)LogManager.getContext((boolean)false);
        }
        if ((loggerConfig = (LoggerConfig)(conf = this.log4jContext.getConfiguration()).getLoggers().get(logger)) != null) {
            Level oldLevel = loggerConfig.getLevel();
            loggerConfig.setLevel(SLF_TO_LOG4J.get(level));
            this.resetActions.add(() -> loggerConfig.setLevel(oldLevel));
        } else {
            conf.addLogger(logger, new LoggerConfig(logger, SLF_TO_LOG4J.get(level), true));
            this.resetActions.add(() -> conf.removeLogger(logger));
        }
    }

    public void after() {
        this.resetActions.forEach(Runnable::run);
        if (this.log4jContext != null) {
            this.log4jContext.updateLoggers();
        }
    }

    public LogLevelRule set(Class<?> clazz, org.slf4j.event.Level level) {
        return this.set(clazz.getName(), level);
    }

    public LogLevelRule set(Package logPackage, org.slf4j.event.Level level) {
        return this.set(logPackage.getName(), level);
    }

    public LogLevelRule set(String classOrPackageName, org.slf4j.event.Level level) {
        this.testLevels.put(classOrPackageName, level);
        return this;
    }

    static {
        SLF_TO_LOG4J.put(org.slf4j.event.Level.ERROR, Level.ERROR);
        SLF_TO_LOG4J.put(org.slf4j.event.Level.WARN, Level.WARN);
        SLF_TO_LOG4J.put(org.slf4j.event.Level.INFO, Level.INFO);
        SLF_TO_LOG4J.put(org.slf4j.event.Level.DEBUG, Level.DEBUG);
        SLF_TO_LOG4J.put(org.slf4j.event.Level.TRACE, Level.TRACE);
    }
}

