/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.testutils.junit.extensions.retry;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.flink.testutils.junit.RetryOnException;
import org.apache.flink.testutils.junit.RetryOnFailure;
import org.apache.flink.testutils.junit.extensions.retry.RetryTestExecutionExtension;
import org.apache.flink.testutils.junit.extensions.retry.strategy.RetryOnExceptionStrategy;
import org.apache.flink.testutils.junit.extensions.retry.strategy.RetryOnFailureStrategy;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;

public class RetryExtension
implements TestTemplateInvocationContextProvider,
AfterAllCallback {
    static final ExtensionContext.Namespace RETRY_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{"retryLog"});
    static final String RETRY_KEY = "testRetry";

    public boolean supportsTestTemplate(ExtensionContext context) {
        RetryOnFailure retryOnFailure = this.getRetryAnnotation(context, RetryOnFailure.class);
        RetryOnException retryOnException = this.getRetryAnnotation(context, RetryOnException.class);
        return retryOnException != null || retryOnFailure != null;
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext context) {
        int totalTimes;
        RetryOnFailure retryOnFailure = this.getRetryAnnotation(context, RetryOnFailure.class);
        RetryOnException retryOnException = this.getRetryAnnotation(context, RetryOnException.class);
        if (retryOnFailure != null && retryOnException != null) {
            throw new IllegalArgumentException("You cannot combine the RetryOnFailure and RetryOnException annotations.");
        }
        Map testLog = (Map)context.getStore(RETRY_NAMESPACE).getOrComputeIfAbsent((Object)RETRY_KEY, key -> new HashMap());
        if (retryOnException != null) {
            totalTimes = retryOnException.times() + 1;
            testLog.put(RetryExtension.getTestMethodKey(context), new RetryOnExceptionStrategy(totalTimes, retryOnException.exception()));
        } else if (retryOnFailure != null) {
            totalTimes = retryOnFailure.times() + 1;
            testLog.put(RetryExtension.getTestMethodKey(context), new RetryOnFailureStrategy(totalTimes));
        } else {
            throw new IllegalArgumentException("Unsupported retry strategy.");
        }
        return IntStream.rangeClosed(1, totalTimes).mapToObj(i -> new RetryContext(i, totalTimes));
    }

    public void afterAll(ExtensionContext context) throws Exception {
        context.getStore(RETRY_NAMESPACE).remove((Object)RETRY_KEY);
    }

    static String getTestMethodKey(ExtensionContext context) {
        return context.getRequiredTestClass().getCanonicalName() + "#" + context.getRequiredTestMethod().getName();
    }

    private <T extends Annotation> T getRetryAnnotation(ExtensionContext context, Class<T> annotationClass) {
        Method testMethod = context.getRequiredTestMethod();
        T annotation = testMethod.getAnnotation(annotationClass);
        if (annotation == null) {
            annotation = ((Class)context.getTestClass().get()).getAnnotation(annotationClass);
        }
        return annotation;
    }

    class RetryContext
    implements TestTemplateInvocationContext {
        final int retryIndex;
        final int totalTimes;

        RetryContext(int retryIndex, int totalTimes) {
            this.totalTimes = totalTimes;
            this.retryIndex = retryIndex;
        }

        public String getDisplayName(int invocationIndex) {
            return String.format("Attempt [%d/%d]", this.retryIndex, this.totalTimes);
        }

        public List<Extension> getAdditionalExtensions() {
            return Arrays.asList(new RetryTestExecutionExtension(this.retryIndex, this.totalTimes));
        }
    }
}

