/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import javax.annotation.Nonnull;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.util.Util;
import org.apache.flink.table.planner.plan.utils.TemporalJoinUtil;

public class TemporalTableJoinUtil {
    public static boolean isEventTimeTemporalJoin(@Nonnull RexNode joinCondition) {
        RexVisitorImpl<Void> temporalConditionFinder = new RexVisitorImpl<Void>(true){

            @Override
            public Void visitCall(RexCall call) {
                if (call.getOperator() == TemporalJoinUtil.INITIAL_TEMPORAL_JOIN_CONDITION() && TemporalJoinUtil.isInitialRowTimeTemporalTableJoin(call) || TemporalTableJoinUtil.isRowTimeTemporalTableJoinCondition(call)) {
                    throw new Util.FoundOne(call);
                }
                return (Void)super.visitCall(call);
            }
        };
        try {
            joinCondition.accept(temporalConditionFinder);
        }
        catch (Util.FoundOne found) {
            return true;
        }
        return false;
    }

    public static boolean isRowTimeTemporalTableJoinCondition(RexCall call) {
        return call.getOperator() == TemporalJoinUtil.TEMPORAL_JOIN_CONDITION() && call.operands.size() == 5;
    }
}

