/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexTableInputRef;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlPostfixOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.util.TimestampString;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.ContextResolvedFunction;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.data.conversion.DayTimeIntervalDurationConverter;
import org.apache.flink.table.data.conversion.YearMonthIntervalPeriodConverter;
import org.apache.flink.table.data.util.DataFormatConverters;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.plan.utils.FlinkRexUtil$;
import org.apache.flink.table.planner.utils.TimestampStringUtils;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.YearMonthIntervalType;
import org.apache.flink.util.Preconditions;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001B\u0001\u0003\u0001E\u0011ADU3y\u001d>$W\rV8FqB\u0014Xm]:j_:\u001cuN\u001c<feR,'O\u0003\u0002\u0004\t\u0005)Q\u000f^5mg*\u0011QAB\u0001\u0005a2\fgN\u0003\u0002\b\u0011\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0005\u000b\u0003\u0015!\u0018M\u00197f\u0015\tYA\"A\u0003gY&t7N\u0003\u0002\u000e\u001d\u00051\u0011\r]1dQ\u0016T\u0011aD\u0001\u0004_J<7\u0001A\n\u0004\u0001IQ\u0002CA\n\u0019\u001b\u0005!\"BA\u000b\u0017\u0003\u0011a\u0017M\\4\u000b\u0003]\tAA[1wC&\u0011\u0011\u0004\u0006\u0002\u0007\u001f\nTWm\u0019;\u0011\u0007m\u0001#%D\u0001\u001d\u0015\tib$A\u0002sKbT!a\b\u0007\u0002\u000f\r\fGnY5uK&\u0011\u0011\u0005\b\u0002\u000b%\u0016Dh+[:ji>\u0014\bcA\u0012'Q5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CE\u0001\u0004PaRLwN\u001c\t\u0003S1j\u0011A\u000b\u0006\u0003W!\t1\"\u001a=qe\u0016\u001c8/[8og&\u0011QF\u000b\u0002\u0013%\u0016\u001cx\u000e\u001c<fI\u0016C\bO]3tg&|g\u000e\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u0003)\u0011X\r\u001f\"vS2$WM\u001d\t\u00037EJ!A\r\u000f\u0003\u0015I+\u0007PQ;jY\u0012,'\u000f\u0003\u00055\u0001\t\u0005\t\u0015!\u00036\u0003)Ig\u000e];u\u001d\u0006lWm\u001d\t\u0004GYB\u0014BA\u001c%\u0005\u0015\t%O]1z!\tI\u0004I\u0004\u0002;}A\u00111\bJ\u0007\u0002y)\u0011Q\bE\u0001\u0007yI|w\u000e\u001e \n\u0005}\"\u0013A\u0002)sK\u0012,g-\u0003\u0002B\u0005\n11\u000b\u001e:j]\u001eT!a\u0010\u0013\t\u0011\u0011\u0003!\u0011!Q\u0001\n\u0015\u000bqBZ;oGRLwN\\\"bi\u0006dwn\u001a\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011\"\tqaY1uC2|w-\u0003\u0002K\u000f\nya)\u001e8di&|gnQ1uC2|w\r\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003N\u00039\u0019\u0017\r^1m_\u001el\u0015M\\1hKJ\u0004\"A\u0012(\n\u0005=;%AD\"bi\u0006dwnZ'b]\u0006<WM\u001d\u0005\t#\u0002\u0011\t\u0011)A\u0005%\u0006AA/[7f5>tW\r\u0005\u0002T-6\tAK\u0003\u0002V-\u0005!Q\u000f^5m\u0013\t9FK\u0001\u0005US6,'l\u001c8f\u0011\u0015I\u0006\u0001\"\u0001[\u0003\u0019a\u0014N\\5u}Q11,\u00180`A\u0006\u0004\"\u0001\u0018\u0001\u000e\u0003\tAQa\f-A\u0002ABQ\u0001\u000e-A\u0002UBQ\u0001\u0012-A\u0002\u0015CQ\u0001\u0014-A\u00025CQ!\u0015-A\u0002ICQa\u0019\u0001\u0005B\u0011\fQB^5tSRLe\u000e];u%\u00164GC\u0001\u0012f\u0011\u00151'\r1\u0001h\u0003!Ig\u000e];u%\u00164\u0007CA\u000ei\u0013\tIGDA\u0006SKbLe\u000e];u%\u00164\u0007\"B6\u0001\t\u0003b\u0017A\u0005<jg&$H+\u00192mK&s\u0007/\u001e;SK\u001a$\"AI7\t\u000b9T\u0007\u0019A8\u0002!I,\u0007\u0010V1cY\u0016Le\u000e];u%\u00164\u0007CA\u000eq\u0013\t\tHD\u0001\tSKb$\u0016M\u00197f\u0013:\u0004X\u000f\u001e*fM\")1\u000f\u0001C!i\u0006ia/[:ji2{7-\u00197SK\u001a$\"AI;\t\u000bY\u0014\b\u0019A<\u0002\u00111|7-\u00197SK\u001a\u0004\"a\u0007=\n\u0005ed\"a\u0003*fq2{7-\u00197SK\u001aDQa\u001f\u0001\u0005Bq\fAB^5tSRd\u0015\u000e^3sC2$\"AI?\t\u000byT\b\u0019A@\u0002\u000f1LG/\u001a:bYB\u00191$!\u0001\n\u0007\u0005\rAD\u0001\u0006SKbd\u0015\u000e^3sC2Dq!a\u0002\u0001\t\u0003\nI!A\u0005wSNLGoQ1mYR\u0019!%a\u0003\t\u0011\u00055\u0011Q\u0001a\u0001\u0003\u001f\t!b\u001c:j%\u0016D8)\u00197m!\rY\u0012\u0011C\u0005\u0004\u0003'a\"a\u0002*fq\u000e\u000bG\u000e\u001c\u0005\b\u0003/\u0001A\u0011IA\r\u0003A1\u0018n]5u\r&,G\u000eZ!dG\u0016\u001c8\u000fF\u0002#\u00037A\u0001\"!\b\u0002\u0016\u0001\u0007\u0011qD\u0001\fM&,G\u000eZ!dG\u0016\u001c8\u000fE\u0002\u001c\u0003CI1!a\t\u001d\u00059\u0011V\r\u001f$jK2$\u0017iY2fgNDq!a\n\u0001\t\u0003\nI#A\nwSNLGoQ8se\u0016dg+\u0019:jC\ndW\rF\u0002#\u0003WA\u0001\"!\f\u0002&\u0001\u0007\u0011qF\u0001\u000fG>\u0014(/\u001a7WCJL\u0017M\u00197f!\rY\u0012\u0011G\u0005\u0004\u0003ga\"!\u0005*fq\u000e{'O]3m-\u0006\u0014\u0018.\u00192mK\"9\u0011q\u0007\u0001\u0005B\u0005e\u0012!\u0004<jg&$(+\u00198hKJ+g\rF\u0002#\u0003wA\u0001\"!\u0010\u00026\u0001\u0007\u0011qH\u0001\te\u0006tw-\u001a*fMB\u00191$!\u0011\n\u0007\u0005\rCDA\u0006SKb\u0014\u0016M\\4f%\u00164\u0007bBA$\u0001\u0011\u0005\u0013\u0011J\u0001\u000em&\u001c\u0018\u000e^*vEF+XM]=\u0015\u0007\t\nY\u0005\u0003\u0005\u0002N\u0005\u0015\u0003\u0019AA(\u0003!\u0019XOY)vKJL\bcA\u000e\u0002R%\u0019\u00111\u000b\u000f\u0003\u0017I+\u0007pU;c#V,'/\u001f\u0005\b\u0003/\u0002A\u0011IA-\u0003E1\u0018n]5u\tft\u0017-\\5d!\u0006\u0014\u0018-\u001c\u000b\u0004E\u0005m\u0003\u0002CA/\u0003+\u0002\r!a\u0018\u0002\u0019\u0011Lh.Y7jGB\u000b'/Y7\u0011\u0007m\t\t'C\u0002\u0002dq\u0011qBU3y\tft\u0017-\\5d!\u0006\u0014\u0018-\u001c\u0005\b\u0003O\u0002A\u0011IA5\u0003%1\u0018n]5u\u001fZ,'\u000fF\u0002#\u0003WB\u0001\"!\u001c\u0002f\u0001\u0007\u0011qN\u0001\u0005_Z,'\u000fE\u0002\u001c\u0003cJ1!a\u001d\u001d\u0005\u001d\u0011V\r_(wKJDq!a\u001e\u0001\t\u0003\nI(\u0001\u000bwSNLG\u000fU1ui\u0016\u0014hNR5fY\u0012\u0014VM\u001a\u000b\u0004E\u0005m\u0004\u0002CA?\u0003k\u0002\r!a \u0002\u0011\u0019LW\r\u001c3SK\u001a\u00042aGAA\u0013\r\t\u0019\t\b\u0002\u0013%\u0016D\b+\u0019;uKJtg)[3mIJ+g\rC\u0004\u0002\b\u0002!I!!#\u0002\u001d1|wn[;q\rVt7\r^5p]R9!%a#\u0002\u0016\u0006-\u0006\u0002CAG\u0003\u000b\u0003\r!a$\u0002\u0015%$WM\u001c;jM&,'\u000fE\u0002G\u0003#K1!a%H\u0005Q)fN]3t_24X\rZ%eK:$\u0018NZ5fe\"A\u0011qSAC\u0001\u0004\tI*\u0001\u0005pa\u0016\u0014\u0018M\u001c3t!\u0015\tY*!*)\u001d\u0011\ti*!)\u000f\u0007m\ny*C\u0001&\u0013\r\t\u0019\u000bJ\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9+!+\u0003\u0007M+\u0017OC\u0002\u0002$\u0012B\u0001\"!,\u0002\u0006\u0002\u0007\u0011qV\u0001\u000b_V$\b/\u001e;UsB,\u0007\u0003BAY\u0003ok!!a-\u000b\u0007\u0005U\u0006\"A\u0003usB,7/\u0003\u0003\u0002:\u0006M&\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u000f\u0005u\u0006\u0001\"\u0003\u0002@\u00069!/\u001a9mC\u000e,Gc\u0001\u001d\u0002B\"9\u00111YA^\u0001\u0004A\u0014aA:ue\u0002")
public class RexNodeToExpressionConverter
implements RexVisitor<Option<ResolvedExpression>> {
    private final RexBuilder rexBuilder;
    private final String[] inputNames;
    private final FunctionCatalog functionCatalog;
    private final TimeZone timeZone;

    @Override
    public void visitList(Iterable<? extends RexNode> x$1, List<Option<ResolvedExpression>> x$2) {
        RexVisitor.super.visitList(x$1, x$2);
    }

    @Override
    public List<Option<ResolvedExpression>> visitList(Iterable<? extends RexNode> x$1) {
        return RexVisitor.super.visitList(x$1);
    }

    @Override
    public void visitEach(Iterable<? extends RexNode> x$1) {
        RexVisitor.super.visitEach(x$1);
    }

    @Override
    public Option<ResolvedExpression> visitInputRef(RexInputRef inputRef) {
        Preconditions.checkArgument((inputRef.getIndex() < this.inputNames.length ? 1 : 0) != 0);
        return new Some((Object)new FieldReferenceExpression(this.inputNames[inputRef.getIndex()], LogicalTypeDataTypeConverter.fromLogicalTypeToDataType((LogicalType)FlinkTypeFactory$.MODULE$.toLogicalType(inputRef.getType())), 0, inputRef.getIndex()));
    }

    @Override
    public Option<ResolvedExpression> visitTableInputRef(RexTableInputRef rexTableInputRef) {
        return this.visitInputRef(rexTableInputRef);
    }

    @Override
    public Option<ResolvedExpression> visitLocalRef(RexLocalRef localRef) {
        throw new TableException("Bug: RexLocalRef should have been expanded");
    }

    @Override
    public Option<ResolvedExpression> visitLiteral(RexLiteral literal) {
        Object object;
        Comparable comparable = literal.getValue();
        if (comparable instanceof SqlTrimFunction.Flag) {
            return None$.MODULE$;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        LogicalType literalType = FlinkTypeFactory$.MODULE$.toLogicalType(literal.getType());
        LogicalTypeRoot logicalTypeRoot = literalType.getTypeRoot();
        if (LogicalTypeRoot.DATE.equals(logicalTypeRoot)) {
            Integer v = literal.getValueAs(Integer.class);
            object = DataFormatConverters.LocalDateConverter.INSTANCE.toExternal((Object)v);
        } else if (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
            Integer v = literal.getValueAs(Integer.class);
            object = DataFormatConverters.LocalTimeConverter.INSTANCE.toExternal((Object)v);
        } else if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
            TimestampString v = literal.getValueAs(TimestampString.class);
            object = TimestampStringUtils.toLocalDateTime(v);
        } else if (LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(logicalTypeRoot)) {
            TimestampString v = literal.getValueAs(TimestampString.class);
            object = TimestampStringUtils.toLocalDateTime(v).atZone(this.timeZone.toZoneId()).toInstant();
        } else if (LogicalTypeRoot.INTERVAL_DAY_TIME.equals(logicalTypeRoot)) {
            Long v = literal.getValueAs(Long.class);
            object = DayTimeIntervalDurationConverter.INSTANCE.toExternal(v);
        } else if (LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(logicalTypeRoot)) {
            Integer v = literal.getValueAs(Integer.class);
            object = YearMonthIntervalPeriodConverter.create((YearMonthIntervalType)((YearMonthIntervalType)literalType)).toExternal(v);
        } else if (LogicalTypeRoot.TINYINT.equals(logicalTypeRoot)) {
            object = literal.getValueAs(Byte.class);
        } else if (LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot)) {
            object = literal.getValueAs(Short.class);
        } else if (LogicalTypeRoot.INTEGER.equals(logicalTypeRoot)) {
            object = literal.getValueAs(Integer.class);
        } else if (LogicalTypeRoot.BIGINT.equals(logicalTypeRoot)) {
            object = literal.getValueAs(Long.class);
        } else if (LogicalTypeRoot.FLOAT.equals(logicalTypeRoot)) {
            object = literal.getValueAs(Float.class);
        } else if (LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot)) {
            object = literal.getValueAs(Double.class);
        } else {
            boolean bl = LogicalTypeRoot.VARCHAR.equals(logicalTypeRoot) ? true : LogicalTypeRoot.CHAR.equals(logicalTypeRoot);
            if (bl) {
                object = literal.getValueAs(String.class);
            } else if (LogicalTypeRoot.BOOLEAN.equals(logicalTypeRoot)) {
                object = literal.getValueAs(Boolean.class);
            } else if (LogicalTypeRoot.DECIMAL.equals(logicalTypeRoot)) {
                object = literal.getValueAs(BigDecimal.class);
            } else {
                boolean bl2 = LogicalTypeRoot.BINARY.equals(logicalTypeRoot) ? true : LogicalTypeRoot.VARBINARY.equals(logicalTypeRoot);
                object = bl2 ? (Object)literal.getValueAs(byte[].class) : literal.getValue();
            }
        }
        Object literalValue = object;
        DataType dataType = LogicalTypeDataTypeConverter.fromLogicalTypeToDataType((LogicalType)literalType);
        return literalValue == null ? new Some((Object)ApiExpressionUtils.valueLiteral(null, (DataType)((DataType)dataType.nullable()))) : new Some((Object)ApiExpressionUtils.valueLiteral((Object)literalValue, (DataType)((DataType)dataType.notNull())));
    }

    @Override
    public Option<ResolvedExpression> visitCall(RexCall oriRexCall) {
        None$ none$;
        RexCall rexCall = (RexCall)FlinkRexUtil$.MODULE$.expandSearch(this.rexBuilder, oriRexCall);
        Buffer operands = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(rexCall.getOperands()).map((Function1 & Serializable & scala.Serializable)operand -> (ResolvedExpression)operand.accept(this).orNull(Predef$.MODULE$.$conforms()), Buffer$.MODULE$.canBuildFrom());
        DataType outputType = LogicalTypeDataTypeConverter.fromLogicalTypeToDataType((LogicalType)FlinkTypeFactory$.MODULE$.toLogicalType(rexCall.getType()));
        if (operands.contains(null)) {
            none$ = None$.MODULE$;
        } else {
            Option<ResolvedExpression> option;
            SqlOperator sqlOperator = rexCall.getOperator();
            SqlBinaryOperator sqlBinaryOperator = SqlStdOperatorTable.OR;
            SqlOperator sqlOperator2 = sqlOperator;
            if (!(sqlBinaryOperator != null ? !((Object)sqlBinaryOperator).equals(sqlOperator2) : sqlOperator2 != null)) {
                option = Option$.MODULE$.apply(operands.reduceLeft((Function2 & Serializable & scala.Serializable)(l, r) -> CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.OR, (List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ResolvedExpression[]{l, r}))), (DataType)outputType)));
            } else {
                SqlBinaryOperator sqlBinaryOperator2 = SqlStdOperatorTable.AND;
                SqlOperator sqlOperator3 = sqlOperator;
                if (!(sqlBinaryOperator2 != null ? !((Object)sqlBinaryOperator2).equals(sqlOperator3) : sqlOperator3 != null)) {
                    option = Option$.MODULE$.apply(operands.reduceLeft((Function2 & Serializable & scala.Serializable)(l, r) -> CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.AND, (List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ResolvedExpression[]{l, r}))), (DataType)outputType)));
                } else {
                    SqlFunction sqlFunction = SqlStdOperatorTable.CAST;
                    SqlOperator sqlOperator4 = sqlOperator;
                    if (!(sqlFunction != null ? !((Object)sqlFunction).equals(sqlOperator4) : sqlOperator4 != null)) {
                        option = Option$.MODULE$.apply((Object)CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.CAST, (List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ResolvedExpression[]{(ResolvedExpression)operands.head(), ApiExpressionUtils.typeLiteral((DataType)outputType)}))), (DataType)outputType));
                    } else {
                        SqlFunction sqlFunction2 = FlinkSqlOperatorTable.TRY_CAST;
                        SqlOperator sqlOperator5 = sqlOperator;
                        if (!(sqlFunction2 != null ? !((Object)sqlFunction2).equals(sqlOperator5) : sqlOperator5 != null)) {
                            option = Option$.MODULE$.apply((Object)CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.TRY_CAST, (List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ResolvedExpression[]{(ResolvedExpression)operands.head(), ApiExpressionUtils.typeLiteral((DataType)outputType)}))), (DataType)outputType));
                        } else {
                            boolean bl = sqlOperator instanceof SqlFunction ? true : sqlOperator instanceof SqlPostfixOperator;
                            if (bl) {
                                ArrayList<String> names = new ArrayList<String>(rexCall.getOperator().getNameAsId().names);
                                names.set(names.size() - 1, this.replace(names.get(names.size() - 1)));
                                UnresolvedIdentifier id = UnresolvedIdentifier.of((String[])((String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(names).asScala()).toArray(ClassTag$.MODULE$.apply(String.class))));
                                option = this.lookupFunction(id, (Seq<ResolvedExpression>)operands, outputType);
                            } else {
                                option = this.lookupFunction(UnresolvedIdentifier.of((String[])new String[]{this.replace(String.valueOf((Object)sqlOperator.getKind()))}), (Seq<ResolvedExpression>)operands, outputType);
                            }
                        }
                    }
                }
            }
            none$ = option;
        }
        return none$;
    }

    @Override
    public Option<ResolvedExpression> visitFieldAccess(RexFieldAccess fieldAccess) {
        return None$.MODULE$;
    }

    @Override
    public Option<ResolvedExpression> visitCorrelVariable(RexCorrelVariable correlVariable) {
        return None$.MODULE$;
    }

    @Override
    public Option<ResolvedExpression> visitRangeRef(RexRangeRef rangeRef) {
        return None$.MODULE$;
    }

    @Override
    public Option<ResolvedExpression> visitSubQuery(RexSubQuery subQuery) {
        return None$.MODULE$;
    }

    @Override
    public Option<ResolvedExpression> visitDynamicParam(RexDynamicParam dynamicParam) {
        return None$.MODULE$;
    }

    @Override
    public Option<ResolvedExpression> visitOver(RexOver over) {
        return None$.MODULE$;
    }

    @Override
    public Option<ResolvedExpression> visitPatternFieldRef(RexPatternFieldRef fieldRef) {
        return None$.MODULE$;
    }

    private Option<ResolvedExpression> lookupFunction(UnresolvedIdentifier identifier, Seq<ResolvedExpression> operands, DataType outputType) {
        None$ none$;
        Success success;
        Optional f;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> $this.functionCatalog.lookupFunction(identifier));
        if (try_ instanceof Success && (f = (Optional)(success = (Success)try_).value()) != null) {
            None$ none$2;
            Optional optional = f;
            if (optional.isPresent()) {
                FunctionIdentifier functionIdentifier;
                ContextResolvedFunction resolvedFunction = (ContextResolvedFunction)optional.get();
                FunctionDefinition functionDefinition = resolvedFunction.getDefinition();
                if (functionDefinition instanceof BuiltInFunctionDefinition) {
                    BuiltInFunctionDefinition builtInFunctionDefinition = (BuiltInFunctionDefinition)functionDefinition;
                    functionIdentifier = FunctionIdentifier.of((String)builtInFunctionDefinition.getName());
                } else {
                    functionIdentifier = resolvedFunction.getIdentifier().orElse(null);
                }
                FunctionIdentifier identifier2 = functionIdentifier;
                none$2 = new Some((Object)new CallExpression(resolvedFunction.isTemporary(), identifier2, resolvedFunction.getDefinition(), JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList(operands), outputType));
            } else {
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        } else if (try_ instanceof Failure) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError((Object)try_);
        }
        return none$;
    }

    private String replace(String str) {
        return str.replaceAll("\\s|_", "");
    }

    public RexNodeToExpressionConverter(RexBuilder rexBuilder, String[] inputNames, FunctionCatalog functionCatalog, CatalogManager catalogManager, TimeZone timeZone) {
        this.rexBuilder = rexBuilder;
        this.inputNames = inputNames;
        this.functionCatalog = functionCatalog;
        this.timeZone = timeZone;
    }
}

