/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.trait;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.table.planner.plan.logical.WindowSpec;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.util.Preconditions;

public class RelWindowProperties {
    private final ImmutableBitSet windowStartColumns;
    private final ImmutableBitSet windowEndColumns;
    private final ImmutableBitSet windowTimeColumns;
    private final WindowSpec windowSpec;
    private final LogicalType timeAttributeType;

    @Nullable
    public static RelWindowProperties create(ImmutableBitSet windowStartColumns, ImmutableBitSet windowEndColumns, ImmutableBitSet windowTimeColumns, WindowSpec windowSpec, LogicalType timeAttributeType) {
        if (windowStartColumns.isEmpty() || windowEndColumns.isEmpty()) {
            return null;
        }
        return new RelWindowProperties(windowStartColumns, windowEndColumns, windowTimeColumns, windowSpec, timeAttributeType);
    }

    private RelWindowProperties(ImmutableBitSet windowStartColumns, ImmutableBitSet windowEndColumns, ImmutableBitSet windowTimeColumns, WindowSpec windowSpec, LogicalType timeAttributeType) {
        Preconditions.checkArgument((boolean)LogicalTypeChecks.canBeTimeAttributeType((LogicalType)timeAttributeType), (String)"Time attribute shouldn't be a '%s' type.", (Object[])new Object[]{timeAttributeType});
        this.windowStartColumns = (ImmutableBitSet)Preconditions.checkNotNull((Object)windowStartColumns);
        this.windowEndColumns = (ImmutableBitSet)Preconditions.checkNotNull((Object)windowEndColumns);
        this.windowTimeColumns = (ImmutableBitSet)Preconditions.checkNotNull((Object)windowTimeColumns);
        this.windowSpec = (WindowSpec)Preconditions.checkNotNull((Object)windowSpec);
        this.timeAttributeType = (LogicalType)Preconditions.checkNotNull((Object)timeAttributeType);
    }

    @Nullable
    public RelWindowProperties copy(ImmutableBitSet windowStartColumns, ImmutableBitSet windowEndColumns, ImmutableBitSet windowTimeColumns) {
        return RelWindowProperties.create(windowStartColumns, windowEndColumns, windowTimeColumns, this.windowSpec, this.timeAttributeType);
    }

    public ImmutableBitSet getWindowStartColumns() {
        return this.windowStartColumns;
    }

    public ImmutableBitSet getWindowEndColumns() {
        return this.windowEndColumns;
    }

    public ImmutableBitSet getWindowTimeColumns() {
        return this.windowTimeColumns;
    }

    public ImmutableBitSet getWindowColumns() {
        return this.windowStartColumns.union(this.windowEndColumns).union(this.windowTimeColumns);
    }

    public WindowSpec getWindowSpec() {
        return this.windowSpec;
    }

    public boolean isRowtime() {
        return LogicalTypeChecks.isRowtimeAttribute((LogicalType)this.timeAttributeType);
    }

    public LogicalType getTimeAttributeType() {
        return this.timeAttributeType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelWindowProperties that = (RelWindowProperties)o;
        return Objects.equals(this.windowStartColumns, that.windowStartColumns) && Objects.equals(this.windowEndColumns, that.windowEndColumns) && Objects.equals(this.windowTimeColumns, that.windowTimeColumns) && Objects.equals(this.windowSpec, that.windowSpec);
    }

    public int hashCode() {
        return Objects.hash(this.windowStartColumns, this.windowEndColumns, this.windowTimeColumns, this.windowSpec);
    }

    public String toString() {
        return String.format("[windowStart=%s, windowEnd=%s, windowTime=%s, window=%s]", this.windowStartColumns, this.windowEndColumns, this.windowTimeColumns, this.windowSpec);
    }
}

