/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.TableFunctionScan;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.functions.TemporalTableFunction;
import org.apache.flink.table.functions.TemporalTableFunctionImpl;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeContext;
import org.apache.flink.table.planner.plan.rules.logical.GetTemporalTableFunctionCall;
import org.apache.flink.table.planner.plan.rules.logical.LogicalCorrelateToJoinFromTemporalTableFunctionRule$;
import org.apache.flink.table.planner.plan.rules.logical.TemporalTableFunctionCall;
import org.apache.flink.table.planner.plan.utils.ExpandTableScanShuttle;
import org.apache.flink.table.planner.plan.utils.TemporalJoinUtil$;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001B\u0001\u0003\u0001M\u00111\u0007T8hS\u000e\fGnQ8se\u0016d\u0017\r^3U_*{\u0017N\u001c$s_6$V-\u001c9pe\u0006dG+\u00192mK\u001a+hn\u0019;j_:\u0014V\u000f\\3\u000b\u0005\r!\u0011a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003\u000b\u0019\tQA];mKNT!a\u0002\u0005\u0002\tAd\u0017M\u001c\u0006\u0003\u0013)\tq\u0001\u001d7b]:,'O\u0003\u0002\f\u0019\u0005)A/\u00192mK*\u0011QBD\u0001\u0006M2Lgn\u001b\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u001a\u001b\u00051\"BA\u0004\u0018\u0015\tAb\"A\u0004dC2\u001c\u0017\u000e^3\n\u0005i1\"A\u0003*fY>\u0003HOU;mK\")A\u0004\u0001C\u0001;\u00051A(\u001b8jiz\"\u0012A\b\t\u0003?\u0001i\u0011A\u0001\u0005\u0006C\u0001!IAI\u0001\u001dKb$(/Y2u\u001d\u0006lWM\u0012:p[RKW.Z!uiJL'-\u001e;f)\t\u0019\u0003\u0007\u0005\u0002%[9\u0011Qe\u000b\t\u0003M%j\u0011a\n\u0006\u0003QI\ta\u0001\u0010:p_Rt$\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J\u0013A\u0002)sK\u0012,g-\u0003\u0002/_\t11\u000b\u001e:j]\u001eT!\u0001L\u0015\t\u000bE\u0002\u0003\u0019\u0001\u001a\u0002\u001bQLW.Z!uiJL'-\u001e;f!\t\u0019d'D\u00015\u0015\t)$\"A\u0006fqB\u0014Xm]:j_:\u001c\u0018BA\u001c5\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\u0006s\u0001!IAO\u0001\u0014SN\u0004&o\\2uS6,'+\u001a4fe\u0016t7-\u001a\u000b\u0003w}\u0002\"\u0001P\u001f\u000e\u0003%J!AP\u0015\u0003\u000f\t{w\u000e\\3b]\")\u0001\t\u000fa\u0001\u0003\u0006)B/Z7q_J\fG\u000eV1cY\u00164UO\\2uS>t\u0007C\u0001\"F\u001b\u0005\u0019%B\u0001#\u000b\u0003%1WO\\2uS>t7/\u0003\u0002G\u0007\nIB+Z7q_J\fG\u000eV1cY\u00164UO\\2uS>t\u0017*\u001c9m\u0011\u0015A\u0005\u0001\"\u0003J\u0003\t*\u0007\u0010\u001e:bGRt\u0015-\\3Ge>l\u0007K]5nCJL8*Z=BiR\u0014\u0018NY;uKR\u00111E\u0013\u0005\u0006\u0017\u001e\u0003\rAM\u0001\u000bKb\u0004(/Z:tS>t\u0007\"B'\u0001\t\u0003r\u0015aB8o\u001b\u0006$8\r\u001b\u000b\u0003\u001fJ\u0003\"\u0001\u0010)\n\u0005EK#\u0001B+oSRDQa\u0015'A\u0002Q\u000bAaY1mYB\u0011Q#V\u0005\u0003-Z\u0011aBU3m\u001fB$(+\u001e7f\u0007\u0006dG\u000eC\u0003Y\u0001\u0011%\u0011,A\u000bde\u0016\fG/\u001a*jO\"$X\t\u001f9sKN\u001c\u0018n\u001c8\u0015\u000bi\u0003W-\\8\u0011\u0005msV\"\u0001/\u000b\u0005u;\u0012a\u0001:fq&\u0011q\f\u0018\u0002\b%\u0016Dhj\u001c3f\u0011\u0015\tw\u000b1\u0001c\u0003)\u0011X\r\u001f\"vS2$WM\u001d\t\u00037\u000eL!\u0001\u001a/\u0003\u0015I+\u0007PQ;jY\u0012,'\u000fC\u0003g/\u0002\u0007q-\u0001\u0005mK\u001a$hj\u001c3f!\tA7.D\u0001j\u0015\tQw#A\u0002sK2L!\u0001\\5\u0003\u000fI+GNT8eK\")an\u0016a\u0001O\u0006I!/[4ii:{G-\u001a\u0005\u0006a^\u0003\raI\u0001\u0006M&,G\u000eZ\u0004\u0006e\nA\ta]\u00014\u0019><\u0017nY1m\u0007>\u0014(/\u001a7bi\u0016$vNS8j]\u001a\u0013x.\u001c+f[B|'/\u00197UC\ndWMR;oGRLwN\u001c*vY\u0016\u0004\"a\b;\u0007\u000b\u0005\u0011\u0001\u0012A;\u0014\u0005Q4\bC\u0001\u001fx\u0013\tA\u0018F\u0001\u0004B]f\u0014VM\u001a\u0005\u00069Q$\tA\u001f\u000b\u0002g\"9A\u0010\u001eb\u0001\n\u0003i\u0018\u0001C%O'R\u000bejQ#\u0016\u0003QAaa ;!\u0002\u0013!\u0012!C%O'R\u000bejQ#!\u0001")
public class LogicalCorrelateToJoinFromTemporalTableFunctionRule
extends RelOptRule {
    public static RelOptRule INSTANCE() {
        return LogicalCorrelateToJoinFromTemporalTableFunctionRule$.MODULE$.INSTANCE();
    }

    private String extractNameFromTimeAttribute(Expression timeAttribute) {
        FieldReferenceExpression fieldReferenceExpression;
        block3: {
            block2: {
                Expression expression = timeAttribute;
                if (!(expression instanceof FieldReferenceExpression)) break block2;
                fieldReferenceExpression = (FieldReferenceExpression)expression;
                if (fieldReferenceExpression.getOutputDataType().getLogicalType().isAnyOf(new LogicalTypeRoot[]{LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE, LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE})) break block3;
            }
            throw new ValidationException(new StringBuilder(49).append("Invalid timeAttribute [").append(timeAttribute).append("] in TemporalTableFunction").toString());
        }
        String string = fieldReferenceExpression.getName();
        return string;
    }

    private boolean isProctimeReference(TemporalTableFunctionImpl temporalTableFunction) {
        FieldReferenceExpression fieldRef = (FieldReferenceExpression)temporalTableFunction.getTimeAttribute();
        return LogicalTypeChecks.isProctimeAttribute((LogicalType)fieldRef.getOutputDataType().getLogicalType());
    }

    private String extractNameFromPrimaryKeyAttribute(Expression expression) {
        Expression expression2 = expression;
        if (!(expression2 instanceof FieldReferenceExpression)) {
            throw new ValidationException(new StringBuilder(101).append("Unsupported expression [").append(expression).append("] as primary key. ").append("Only top-level (not nested) field references are supported.").toString());
        }
        FieldReferenceExpression fieldReferenceExpression = (FieldReferenceExpression)expression2;
        String string = fieldReferenceExpression.getName();
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onMatch(RelOptRuleCall call) {
        LogicalCorrelate logicalCorrelate = (LogicalCorrelate)call.rel(0);
        Object leftNode = call.rel(1);
        TableFunctionScan rightTableFunctionScan = (TableFunctionScan)call.rel(2);
        RelOptCluster cluster = logicalCorrelate.getCluster();
        Option<TemporalTableFunctionCall> option = new GetTemporalTableFunctionCall(cluster.getRexBuilder(), (RelNode)leftNode).visit(rightTableFunctionScan.getCall());
        if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        } else {
            Some some;
            TemporalTableFunctionCall temporalTableFunctionCall;
            if (!(option instanceof Some) || (temporalTableFunctionCall = (TemporalTableFunctionCall)(some = (Some)option).value()) == null) throw new MatchError(option);
            TemporalTableFunction rightTemporalTableFunction = temporalTableFunctionCall.temporalTableFunction();
            RexNode leftTimeAttribute = temporalTableFunctionCall.timeAttribute();
            if (!(rightTemporalTableFunction instanceof TemporalTableFunctionImpl)) throw new MatchError(option);
            TemporalTableFunctionImpl temporalTableFunctionImpl = (TemporalTableFunctionImpl)rightTemporalTableFunction;
            QueryOperation underlyingHistoryTable = temporalTableFunctionImpl.getUnderlyingHistoryTable();
            RexBuilder rexBuilder = cluster.getRexBuilder();
            FlinkOptimizeContext flinkContext = (FlinkOptimizeContext)ShortcutUtils.unwrapContext(call.getPlanner());
            FlinkRelBuilder relBuilder = flinkContext.getFlinkRelBuilder();
            RelNode temporalTable = relBuilder.queryOperation(underlyingHistoryTable).build();
            ExpandTableScanShuttle shuttle = new ExpandTableScanShuttle();
            RelNode rightNode = temporalTable.accept(shuttle);
            RexNode rightTimeIndicatorExpression = this.createRightExpression(rexBuilder, (RelNode)leftNode, rightNode, this.extractNameFromTimeAttribute(temporalTableFunctionImpl.getTimeAttribute()));
            RexNode rightPrimaryKeyExpression = this.createRightExpression(rexBuilder, (RelNode)leftNode, rightNode, this.extractNameFromPrimaryKeyAttribute(temporalTableFunctionImpl.getPrimaryKey()));
            relBuilder.push((RelNode)leftNode);
            relBuilder.push(rightNode);
            RexNode condition = this.isProctimeReference(temporalTableFunctionImpl) ? TemporalJoinUtil$.MODULE$.makeProcTimeTemporalFunctionJoinConCall(rexBuilder, leftTimeAttribute, rightPrimaryKeyExpression) : TemporalJoinUtil$.MODULE$.makeRowTimeTemporalFunctionJoinConCall(rexBuilder, leftTimeAttribute, rightTimeIndicatorExpression, rightPrimaryKeyExpression);
            relBuilder.join(JoinRelType.INNER, condition);
            call.transformTo(relBuilder.build());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private RexNode createRightExpression(RexBuilder rexBuilder, RelNode leftNode, RelNode rightNode, String field) {
        int rightReferencesOffset = leftNode.getRowType().getFieldCount();
        RelDataTypeField rightDataTypeField = rightNode.getRowType().getField(field, false, false);
        return rexBuilder.makeInputRef(rightDataTypeField.getType(), rightReferencesOffset + rightDataTypeField.getIndex());
    }

    public LogicalCorrelateToJoinFromTemporalTableFunctionRule() {
        super(RelOptRule.operand(LogicalCorrelate.class, RelOptRule.some(RelOptRule.operand(RelNode.class, RelOptRule.any()), RelOptRule.operand(TableFunctionScan.class, RelOptRule.none()))), "LogicalCorrelateToJoinFromTemporalTableFunctionRule");
    }
}

