/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.optimize;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.hint.Hintable;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.planner.hint.FlinkHints;
import org.apache.flink.table.planner.hint.JoinHintsRelShuttle;
import org.apache.flink.table.planner.hint.JoinStrategy;
import org.apache.flink.table.planner.hint.LookupJoinHintOptions;

public class JoinHintsResolver
extends JoinHintsRelShuttle {
    private final Set<RelHint> allHints = new HashSet<RelHint>();
    private final Set<RelHint> validHints = new HashSet<RelHint>();
    private final Map<String, Map<String, Boolean>> allOptionsInJoinHints = new HashMap<String, Map<String, Boolean>>();

    final List<RelNode> resolve(List<RelNode> roots) {
        List<RelNode> resolvedRoots = roots.stream().map(node -> node.accept(this)).collect(Collectors.toList());
        this.validateHints();
        return resolvedRoots;
    }

    @Override
    protected RelNode visitBiRel(BiRel biRel) {
        Optional<String> leftName = this.extractAliasOrTableName(biRel.getLeft());
        Optional<String> rightName = this.extractAliasOrTableName(biRel.getRight());
        HashSet<RelHint> existentKVHints = new HashSet<RelHint>();
        ImmutableList<RelHint> oldHints = ((Hintable)((Object)biRel)).getHints();
        ArrayList<RelHint> newHints = new ArrayList<RelHint>();
        for (RelHint hint : oldHints) {
            if (JoinStrategy.isLookupHint(hint.hintName)) {
                this.allHints.add(this.trimInheritPath(hint));
                Configuration conf = Configuration.fromMap(hint.kvOptions);
                String lookupTable = (String)conf.get(LookupJoinHintOptions.LOOKUP_TABLE);
                this.initOptionInfoAboutJoinHintsForCheck(hint.hintName, Collections.singletonList(lookupTable));
                assert (null != lookupTable);
                if (!rightName.isPresent() || !this.matchIdentifier(lookupTable, rightName.get())) continue;
                this.validHints.add(this.trimInheritPath(hint));
                this.updateInfoForOptionCheck(hint.hintName, rightName);
                newHints.add(hint);
                continue;
            }
            if (JoinStrategy.isJoinStrategy(hint.hintName)) {
                this.allHints.add(this.trimInheritPath(hint));
                this.initOptionInfoAboutJoinHintsForCheck(hint.hintName, hint.listOptions);
                List<String> newOptions = this.getNewJoinHintOptions(leftName, rightName, hint.listOptions, hint.hintName);
                boolean isValidOption = JoinStrategy.validOptions(hint.hintName, newOptions);
                if (!isValidOption) continue;
                this.validHints.add(this.trimInheritPath(hint));
                newHints.add(RelHint.builder(hint.hintName).hintOptions(Collections.singletonList(newOptions.get(0))).build());
                continue;
            }
            if (existentKVHints.contains(hint)) continue;
            existentKVHints.add(hint);
            newHints.add(hint);
        }
        RelNode newNode = super.visitChildren(biRel);
        List<RelHint> oldJoinHints = FlinkHints.getAllJoinHints(oldHints);
        if (!oldJoinHints.isEmpty()) {
            return ((Hintable)((Object)newNode)).withHints(newHints);
        }
        return newNode;
    }

    private List<String> getNewJoinHintOptions(Optional<String> leftName, Optional<String> rightName, List<String> listOptions, String hintName) {
        this.updateInfoForOptionCheck(hintName, leftName);
        this.updateInfoForOptionCheck(hintName, rightName);
        return listOptions.stream().map(option -> {
            if (leftName.isPresent() && rightName.isPresent() && this.matchIdentifier((String)option, (String)leftName.get()) && this.matchIdentifier((String)option, (String)rightName.get())) {
                throw new ValidationException(String.format("Ambitious option: %s in hint: %s, the input relations are: %s, %s", option, hintName, leftName, rightName));
            }
            if (leftName.isPresent() && this.matchIdentifier((String)option, (String)leftName.get())) {
                return "LEFT";
            }
            if (rightName.isPresent() && this.matchIdentifier((String)option, (String)rightName.get())) {
                return "RIGHT";
            }
            return "";
        }).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
    }

    private void validateHints() {
        HashSet<RelHint> invalidHints = new HashSet<RelHint>(this.allHints);
        invalidHints.removeAll(this.validHints);
        String errorPattern = "The options of following hints cannot match the name of input tables or views: %s";
        StringBuilder errorMsgSb = new StringBuilder();
        AtomicBoolean containsInvalidOptions = new AtomicBoolean(false);
        for (String hintName : this.allOptionsInJoinHints.keySet()) {
            Map<String, Boolean> optionCheckedStatus = this.allOptionsInJoinHints.get(hintName);
            errorMsgSb.append("\n");
            errorMsgSb.append(String.format("`%s` in `%s`", optionCheckedStatus.keySet().stream().filter(op -> {
                boolean checked;
                boolean bl = checked = (Boolean)optionCheckedStatus.get(op) == false;
                if (checked) {
                    containsInvalidOptions.set(true);
                }
                return checked;
            }).collect(Collectors.joining(", ")), hintName));
        }
        if (containsInvalidOptions.get()) {
            throw new ValidationException(String.format(errorPattern, errorMsgSb));
        }
        if (!invalidHints.isEmpty()) {
            errorPattern = "The options of following hints is invalid: %s";
            String errorMsg = invalidHints.stream().map(hint -> {
                String hintName = hint.hintName;
                if (JoinStrategy.isLookupHint(hintName)) {
                    return hint.hintName;
                }
                return hint.hintName + " :" + StringUtils.join(hint.listOptions, (String)", ");
            }).collect(Collectors.joining("\n", "\n", ""));
            throw new ValidationException(String.format(errorPattern, errorMsg));
        }
    }

    private RelHint trimInheritPath(RelHint hint) {
        RelHint.Builder builder = RelHint.builder(hint.hintName);
        if (hint.listOptions.isEmpty()) {
            return builder.hintOptions(hint.kvOptions).build();
        }
        return builder.hintOptions(hint.listOptions).build();
    }

    private Optional<String> extractAliasOrTableName(RelNode node) {
        Optional<String> tableName;
        Optional<String> aliasName = FlinkHints.getTableAlias(node);
        if (aliasName.isPresent()) {
            return aliasName;
        }
        Optional<TableScan> tableScan = this.getTableScan(node);
        if (tableScan.isPresent() && (tableName = FlinkHints.getTableName(tableScan.get().getTable())).isPresent()) {
            return tableName;
        }
        return Optional.empty();
    }

    private Optional<TableScan> getTableScan(RelNode node) {
        if (node instanceof TableScan) {
            return Optional.of((TableScan)node);
        }
        if (FlinkHints.canTransposeToTableScan(node)) {
            return this.getTableScan(node.getInput(0));
        }
        return Optional.empty();
    }

    private boolean matchIdentifier(String option, String tableIdentifier) {
        String[] optionNames = option.split("\\.");
        int optionNameLength = optionNames.length;
        String[] tableNames = tableIdentifier.split("\\.");
        int tableNameLength = tableNames.length;
        for (int i = 0; i < Math.min(optionNameLength, tableNameLength); ++i) {
            String currOptionName = optionNames[optionNameLength - 1 - i];
            String currTableName = tableNames[tableNameLength - 1 - i];
            if (currOptionName.equals(currTableName)) continue;
            return false;
        }
        return true;
    }

    private void initOptionInfoAboutJoinHintsForCheck(String hintName, List<String> definedTables) {
        if (this.allOptionsInJoinHints.containsKey(hintName)) {
            Map<String, Boolean> optionCheckedStatus = this.allOptionsInJoinHints.get(hintName);
            definedTables.forEach(table -> {
                if (!optionCheckedStatus.containsKey(table)) {
                    optionCheckedStatus.put((String)table, false);
                }
            });
        } else {
            this.allOptionsInJoinHints.put(hintName, new HashSet<String>(definedTables).stream().collect(Collectors.toMap(table -> table, table -> false)));
        }
    }

    private void updateInfoForOptionCheck(String hintName, Optional<String> tableName) {
        if (tableName.isPresent()) {
            Map<String, Boolean> optionMapper = this.allOptionsInJoinHints.get(hintName);
            for (String option : optionMapper.keySet()) {
                if (!this.matchIdentifier(option, tableName.get())) continue;
                this.allOptionsInJoinHints.get(hintName).put(option, true);
            }
        }
    }
}

