/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.ObjectCodec;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.TreeNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeUtil;
import org.apache.flink.table.types.DataType;

@Internal
final class ColumnJsonDeserializer
extends StdDeserializer<Column> {
    private static final String SUPPORTED_KINDS = Arrays.toString(new String[]{"PHYSICAL", "COMPUTED", "METADATA"});

    ColumnJsonDeserializer() {
        super(Column.class);
    }

    public Column deserialize(JsonParser jsonParser, DeserializationContext ctx) throws IOException {
        Column.PhysicalColumn column;
        String columnKind;
        ObjectNode jsonNode = (ObjectNode)jsonParser.readValueAsTree();
        String columnName = jsonNode.required("name").asText();
        switch (columnKind = Optional.ofNullable(jsonNode.get("kind")).map(JsonNode::asText).orElse("PHYSICAL")) {
            case "PHYSICAL": {
                column = ColumnJsonDeserializer.deserializePhysicalColumn(columnName, jsonNode, jsonParser.getCodec(), ctx);
                break;
            }
            case "COMPUTED": {
                column = ColumnJsonDeserializer.deserializeComputedColumn(columnName, jsonNode, jsonParser.getCodec(), ctx);
                break;
            }
            case "METADATA": {
                column = ColumnJsonDeserializer.deserializeMetadataColumn(columnName, jsonNode, jsonParser.getCodec(), ctx);
                break;
            }
            default: {
                throw new ValidationException(String.format("Cannot recognize column type '%s'. Allowed types: %s.", columnKind, SUPPORTED_KINDS));
            }
        }
        return column.withComment((String)JsonSerdeUtil.deserializeOptionalField(jsonNode, "comment", String.class, jsonParser.getCodec(), ctx).orElse(null));
    }

    private static Column.PhysicalColumn deserializePhysicalColumn(String columnName, ObjectNode jsonNode, ObjectCodec codec, DeserializationContext ctx) throws IOException {
        return Column.physical((String)columnName, (DataType)((DataType)ctx.readValue(JsonSerdeUtil.traverse((TreeNode)jsonNode.required("dataType"), codec), DataType.class)));
    }

    private static Column.ComputedColumn deserializeComputedColumn(String columnName, ObjectNode jsonNode, ObjectCodec codec, DeserializationContext ctx) throws IOException {
        return Column.computed((String)columnName, (ResolvedExpression)((ResolvedExpression)ctx.readValue(JsonSerdeUtil.traverse((TreeNode)jsonNode.required("expression"), codec), ResolvedExpression.class)));
    }

    private static Column.MetadataColumn deserializeMetadataColumn(String columnName, ObjectNode jsonNode, ObjectCodec codec, DeserializationContext ctx) throws IOException {
        return Column.metadata((String)columnName, (DataType)((DataType)ctx.readValue(JsonSerdeUtil.traverse((TreeNode)jsonNode.required("dataType"), codec), DataType.class)), (String)JsonSerdeUtil.deserializeOptionalField(jsonNode, "metadataKey", String.class, codec, ctx).orElse(null), (boolean)jsonNode.required("isVirtual").asBoolean());
    }
}

