/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.processor.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.processor.utils.InputPriorityGraphGenerator;
import org.apache.flink.table.planner.plan.nodes.exec.visitor.AbstractExecNodeExactlyOnceVisitor;

@Internal
public class InputOrderCalculator
extends InputPriorityGraphGenerator {
    private final Set<ExecNode<?>> boundaries;

    public InputOrderCalculator(ExecNode<?> root, Set<ExecNode<?>> boundaries, InputProperty.DamBehavior safeDamBehavior) {
        super(Collections.singletonList(root), boundaries, safeDamBehavior);
        this.boundaries = boundaries;
    }

    public Map<ExecNode<?>, Integer> calculate() {
        this.createTopologyGraph();
        this.dealWithPossiblyRelatedBoundaries();
        Map<ExecNode<?>, Integer> distances = this.graph.calculateMaximumDistance();
        HashSet<Integer> boundaryDistanceSet = new HashSet<Integer>();
        for (ExecNode<?> boundary : this.boundaries) {
            boundaryDistanceSet.add(distances.getOrDefault(boundary, 0));
        }
        ArrayList boundaryDistanceList = new ArrayList(boundaryDistanceSet);
        Collections.sort(boundaryDistanceList);
        HashMap results = new HashMap();
        for (ExecNode<?> boundary : this.boundaries) {
            results.put(boundary, boundaryDistanceList.indexOf(distances.get(boundary)));
        }
        return results;
    }

    private void dealWithPossiblyRelatedBoundaries() {
        ArrayList boundaries = new ArrayList(this.boundaries);
        for (int i = 0; i < boundaries.size(); ++i) {
            ExecNode boundaryA = (ExecNode)boundaries.get(i);
            for (int j = i + 1; j < boundaries.size(); ++j) {
                ExecNode boundaryB = (ExecNode)boundaries.get(j);
                if (this.graph.canReach(boundaryA, boundaryB) || this.graph.canReach(boundaryB, boundaryA)) continue;
                this.dealWithPossiblyRelatedBoundaries(boundaryA, boundaryB);
            }
        }
    }

    private void dealWithPossiblyRelatedBoundaries(ExecNode<?> boundaryA, ExecNode<?> boundaryB) {
        Set<ExecNode<?>> ancestorsA = InputOrderCalculator.calculateAllAncestors(boundaryA);
        Set<ExecNode<?>> ancestorsB = InputOrderCalculator.calculateAllAncestors(boundaryB);
        if (InputOrderCalculator.checkPipelinedPath(boundaryA, ancestorsB)) {
            this.graph.makeAsFarAs(boundaryB, boundaryA);
        }
        if (InputOrderCalculator.checkPipelinedPath(boundaryB, ancestorsA)) {
            this.graph.makeAsFarAs(boundaryA, boundaryB);
        }
    }

    private static Set<ExecNode<?>> calculateAllAncestors(ExecNode<?> node) {
        final HashSet ret = new HashSet();
        AbstractExecNodeExactlyOnceVisitor visitor = new AbstractExecNodeExactlyOnceVisitor(){

            @Override
            protected void visitNode(ExecNode<?> node) {
                ret.add(node);
                this.visitInputs(node);
            }
        };
        node.accept(visitor);
        return ret;
    }

    @VisibleForTesting
    static boolean checkPipelinedPath(ExecNode<?> node, Set<ExecNode<?>> goals) {
        PipelinedPathChecker checker = new PipelinedPathChecker(goals);
        node.accept(checker);
        return checker.res;
    }

    @Override
    protected void resolveInputPriorityConflict(ExecNode<?> node, int higherInput, int lowerInput) {
        throw new IllegalStateException("A conflict is detected. This is a bug. Please file an issue.\nTo work around this bug, please set " + OptimizerConfigOptions.TABLE_OPTIMIZER_MULTIPLE_INPUT_ENABLED.key() + " to false to disable multiple input operator.");
    }

    private static class PipelinedPathChecker
    extends AbstractExecNodeExactlyOnceVisitor {
        private final Set<ExecNode<?>> goals;
        private boolean res;

        private PipelinedPathChecker(Set<ExecNode<?>> goals) {
            this.goals = goals;
            this.res = false;
        }

        @Override
        protected void visitNode(ExecNode<?> node) {
            if (this.goals.contains(node)) {
                this.res = true;
                return;
            }
            List<InputProperty> inputProperties = node.getInputProperties();
            for (int i = 0; i < inputProperties.size(); ++i) {
                if (inputProperties.get(i).getDamBehavior().stricterOrEqual(InputProperty.DamBehavior.END_INPUT)) continue;
                this.visit(node.getInputEdges().get(i).getSource());
                if (!this.res) continue;
                return;
            }
        }
    }
}

