/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.hint;

import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.hint.Hintable;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.flink.table.planner.hint.JoinHintsRelShuttle;
import org.apache.flink.table.planner.hint.JoinStrategy;

public class CapitalizeJoinHintsShuttle
extends JoinHintsRelShuttle {
    @Override
    protected RelNode visitBiRel(BiRel biRel) {
        Hintable hBiRel = (Hintable)((Object)biRel);
        AtomicBoolean changed = new AtomicBoolean(false);
        List<RelHint> hintsWithCapitalJoinHints = hBiRel.getHints().stream().map(hint -> {
            String capitalHintName = hint.hintName.toUpperCase(Locale.ROOT);
            if (JoinStrategy.isJoinStrategy(capitalHintName)) {
                changed.set(true);
                if (JoinStrategy.isLookupHint(hint.hintName)) {
                    return RelHint.builder(capitalHintName).hintOptions(hint.kvOptions).inheritPath(hint.inheritPath).build();
                }
                return RelHint.builder(capitalHintName).hintOptions(hint.listOptions).inheritPath(hint.inheritPath).build();
            }
            return hint;
        }).collect(Collectors.toList());
        if (changed.get()) {
            return super.visit(hBiRel.withHints(hintsWithCapitalJoinHints));
        }
        return super.visit(biRel);
    }
}

