/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.sql;

import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.functions.sql.BuiltInSqlFunction;

public class MatchRowTimeFunction
extends BuiltInSqlFunction {
    public MatchRowTimeFunction() {
        super("MATCH_ROWTIME", SqlKind.OTHER_FUNCTION, null, null, null, SqlFunctionCategory.MATCH_RECOGNIZE);
    }

    @Override
    public String getAllowedSignatures(String opNameToUse) {
        return "MATCH_ROWTIME([rowtime_field])";
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.between(0, 1);
    }

    @Override
    public String getSignatureTemplate(int operandsCount) {
        switch (operandsCount) {
            case 0: {
                return "{}";
            }
            case 1: {
                return "{0})";
            }
        }
        throw new AssertionError();
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        List<SqlNode> operands = callBinding.operands();
        int n = operands.size();
        assert (n == 0 || n == 1);
        if (n == 0) {
            return true;
        }
        SqlNode operand = callBinding.operand(0);
        if (operand.getKind() != SqlKind.IDENTIFIER) {
            if (throwOnFailure) {
                throw new ValidationException(String.format("The function %s requires a field reference as argument, but actual argument is not a simple field reference.", callBinding.getOperator().getName()));
            }
            return false;
        }
        RelDataType operandType = callBinding.getOperandType(0);
        if (FlinkTypeFactory.isRowtimeIndicatorType(operandType)) {
            return true;
        }
        if (throwOnFailure) {
            throw new ValidationException(String.format("The function %s requires argument to be a row time attribute type, but is '%s'.", callBinding.getOperator().getName(), operandType));
        }
        return false;
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        if (opBinding.getOperandCount() == 0) {
            FlinkTypeFactory typeFactory = (FlinkTypeFactory)opBinding.getTypeFactory();
            return typeFactory.createRowtimeIndicatorType(false, false);
        }
        return opBinding.getOperandType(0);
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }
}

