/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.planner.codegen.calls.BuiltInMethods;
import org.apache.flink.table.planner.functions.casting.AbstractExpressionCodeGeneratorCastRule;
import org.apache.flink.table.planner.functions.casting.CastRulePredicate;
import org.apache.flink.table.planner.functions.casting.CastRuleUtils;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

class TimeToTimestampCastRule
extends AbstractExpressionCodeGeneratorCastRule<Number, TimestampData> {
    static final TimeToTimestampCastRule INSTANCE = new TimeToTimestampCastRule();

    private TimeToTimestampCastRule() {
        super(CastRulePredicate.builder().input(LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE).target(LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE).target(LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE).build());
    }

    @Override
    public String generateExpression(CodeGeneratorCastRule.Context context, String inputTerm, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        if (targetLogicalType.is(LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE)) {
            return CastRuleUtils.staticCall(BuiltInMethods.TIMESTAMP_FROM_EPOCH_MILLIS(), inputTerm);
        }
        if (targetLogicalType.is(LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE)) {
            return CastRuleUtils.staticCall(BuiltInMethods.TIME_TO_TIMESTAMP_WITH_LOCAL_TIME_ZONE(), inputTerm, context.getSessionTimeZoneTerm());
        }
        throw new IllegalArgumentException("This is a bug. Please file an issue.");
    }
}

