/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.planner.codegen.calls.BuiltInMethods;
import org.apache.flink.table.planner.functions.casting.AbstractExpressionCodeGeneratorCastRule;
import org.apache.flink.table.planner.functions.casting.CastRulePredicate;
import org.apache.flink.table.planner.functions.casting.CastRuleUtils;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;

class StringToTimestampCastRule
extends AbstractExpressionCodeGeneratorCastRule<StringData, TimestampData> {
    static final StringToTimestampCastRule INSTANCE = new StringToTimestampCastRule();

    private StringToTimestampCastRule() {
        super(CastRulePredicate.builder().input(LogicalTypeFamily.CHARACTER_STRING).target(LogicalTypeFamily.TIMESTAMP).build());
    }

    @Override
    public String generateExpression(CodeGeneratorCastRule.Context context, String inputTerm, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        int targetPrecision = LogicalTypeChecks.getPrecision((LogicalType)targetLogicalType);
        if (targetLogicalType.is(LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE)) {
            return CastRuleUtils.staticCall(BuiltInMethods.STRING_DATA_TO_TIMESTAMP(), inputTerm, targetPrecision);
        }
        return CastRuleUtils.staticCall(BuiltInMethods.STRING_DATA_TO_TIMESTAMP_WITH_ZONE(), inputTerm, targetPrecision, context.getSessionTimeZoneTerm());
    }

    @Override
    public boolean canFail(LogicalType inputLogicalType, LogicalType targetLogicalType) {
        return true;
    }
}

