/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import java.util.function.Consumer;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.planner.codegen.CodeGenUtils;
import org.apache.flink.table.planner.codegen.calls.BuiltInMethods;
import org.apache.flink.table.planner.functions.casting.AbstractNullAwareCodeGeneratorCastRule;
import org.apache.flink.table.planner.functions.casting.CastCodeBlock;
import org.apache.flink.table.planner.functions.casting.CastRulePredicate;
import org.apache.flink.table.planner.functions.casting.CastRuleProvider;
import org.apache.flink.table.planner.functions.casting.CastRuleUtils;
import org.apache.flink.table.planner.functions.casting.CharVarCharTrimPadCastRule;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;

class MapAndMultisetToStringCastRule
extends AbstractNullAwareCodeGeneratorCastRule<ArrayData, String> {
    static final MapAndMultisetToStringCastRule INSTANCE = new MapAndMultisetToStringCastRule();

    private MapAndMultisetToStringCastRule() {
        super(CastRulePredicate.builder().predicate(MapAndMultisetToStringCastRule::isMapOrMultiset).build());
    }

    private static boolean isMapOrMultiset(LogicalType input, LogicalType target) {
        return target.is(LogicalTypeFamily.CHARACTER_STRING) && (input.is(LogicalTypeRoot.MAP) && CastRuleProvider.exists(((MapType)input).getKeyType(), target) && CastRuleProvider.exists(((MapType)input).getValueType(), target) || input.is(LogicalTypeRoot.MULTISET) && CastRuleProvider.exists(((MultisetType)input).getElementType(), target));
    }

    @Override
    protected String generateCodeBlockInternal(CodeGeneratorCastRule.Context context, String inputTerm, String returnVariable, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        LogicalType keyType = inputLogicalType.is(LogicalTypeRoot.MULTISET) ? ((MultisetType)inputLogicalType).getElementType() : ((MapType)inputLogicalType).getKeyType();
        IntType valueType = inputLogicalType.is(LogicalTypeRoot.MULTISET) ? new IntType(false) : ((MapType)inputLogicalType).getValueType();
        String builderTerm = CodeGenUtils.newName("builder");
        context.declareClassField(CodeGenUtils.className(StringBuilder.class), builderTerm, CastRuleUtils.constructorCall(StringBuilder.class, new Object[0]));
        String keyArrayTerm = CodeGenUtils.newName("keys");
        String valueArrayTerm = CodeGenUtils.newName("values");
        String resultStringTerm = CodeGenUtils.newName("resultString");
        int length = LogicalTypeChecks.getLength((LogicalType)targetLogicalType);
        CastRuleUtils.CodeWriter writer = new CastRuleUtils.CodeWriter().declStmt(ArrayData.class, keyArrayTerm, CastRuleUtils.methodCall(inputTerm, "keyArray", new Object[0])).declStmt(ArrayData.class, valueArrayTerm, CastRuleUtils.methodCall(inputTerm, "valueArray", new Object[0])).stmt(CastRuleUtils.methodCall(builderTerm, "setLength", 0)).stmt(CastRuleUtils.methodCall(builderTerm, "append", CastRuleUtils.strLiteral("{"))).forStmt(CastRuleUtils.methodCall(inputTerm, "size", new Object[0]), (arg_0, arg_1) -> MapAndMultisetToStringCastRule.lambda$generateCodeBlockInternal$5(context, keyType, (LogicalType)valueType, valueArrayTerm, builderTerm, length, keyArrayTerm, inputLogicalType, arg_0, arg_1)).stmt(CastRuleUtils.methodCall(builderTerm, "append", CastRuleUtils.strLiteral("}")));
        return CharVarCharTrimPadCastRule.padAndTrimStringIfNeeded(writer, targetLogicalType, context.legacyBehaviour(), length, resultStringTerm, builderTerm).assignStmt(returnVariable, CastRuleUtils.staticCall(BuiltInMethods.BINARY_STRING_DATA_FROM_STRING(), resultStringTerm)).toString();
    }

    private static /* synthetic */ void lambda$generateCodeBlockInternal$5(CodeGeneratorCastRule.Context context, LogicalType keyType, LogicalType valueType, String valueArrayTerm, String builderTerm, int length, String keyArrayTerm, LogicalType inputLogicalType, String indexTerm, CastRuleUtils.CodeWriter loopBodyWriter) {
        String keyTerm = CodeGenUtils.newName("key");
        String keyIsNullTerm = CodeGenUtils.newName("keyIsNull");
        String valueTerm = CodeGenUtils.newName("value");
        String valueIsNullTerm = CodeGenUtils.newName("valueIsNull");
        CastCodeBlock keyCast = CastRuleProvider.generateAlwaysNonNullCodeBlock(context, keyTerm, keyType, (LogicalType)VarCharType.STRING_TYPE);
        CastCodeBlock valueCast = CastRuleProvider.generateAlwaysNonNullCodeBlock(context, valueTerm, valueType, (LogicalType)VarCharType.STRING_TYPE);
        Consumer<CastRuleUtils.CodeWriter> appendNonNullValue = bodyWriter -> bodyWriter.assignStmt(valueTerm, CodeGenUtils.rowFieldReadAccess(indexTerm, valueArrayTerm, valueType)).append(valueCast).stmt(CastRuleUtils.methodCall(builderTerm, "append", valueCast.getReturnTerm()));
        if (!context.legacyBehaviour() && CharVarCharTrimPadCastRule.couldTrim(length)) {
            loopBodyWriter.ifStmt(CharVarCharTrimPadCastRule.stringExceedsLength(builderTerm, length), CastRuleUtils.CodeWriter::breakStmt);
        }
        loopBodyWriter.ifStmt(indexTerm + " != 0", thenBodyWriter -> thenBodyWriter.stmt(CastRuleUtils.methodCall(builderTerm, "append", CastRuleUtils.strLiteral(", ")))).declPrimitiveStmt(keyType, keyTerm).declStmt(Boolean.TYPE, keyIsNullTerm, CastRuleUtils.methodCall(keyArrayTerm, "isNullAt", indexTerm)).declPrimitiveStmt(valueType, valueTerm).declStmt(Boolean.TYPE, valueIsNullTerm, CastRuleUtils.methodCall(valueArrayTerm, "isNullAt", indexTerm)).ifStmt("!" + keyIsNullTerm, thenBodyWriter -> thenBodyWriter.assignStmt(keyTerm, CodeGenUtils.rowFieldReadAccess(indexTerm, keyArrayTerm, keyType)).append(keyCast).stmt(CastRuleUtils.methodCall(builderTerm, "append", keyCast.getReturnTerm())), elseBodyWriter -> elseBodyWriter.stmt(CastRuleUtils.methodCall(builderTerm, "append", CastRuleUtils.nullLiteral(context.legacyBehaviour())))).stmt(CastRuleUtils.methodCall(builderTerm, "append", CastRuleUtils.strLiteral("=")));
        if (inputLogicalType.is(LogicalTypeRoot.MULTISET)) {
            appendNonNullValue.accept(loopBodyWriter);
        } else {
            loopBodyWriter.ifStmt("!" + valueIsNullTerm, appendNonNullValue, elseBodyWriter -> elseBodyWriter.stmt(CastRuleUtils.methodCall(builderTerm, "append", CastRuleUtils.nullLiteral(context.legacyBehaviour()))));
        }
    }
}

