/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import java.util.Arrays;
import org.apache.flink.table.planner.functions.casting.AbstractExpressionCodeGeneratorCastRule;
import org.apache.flink.table.planner.functions.casting.CastRulePredicate;
import org.apache.flink.table.planner.functions.casting.CastRuleUtils;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;

class BinaryToBinaryCastRule
extends AbstractExpressionCodeGeneratorCastRule<byte[], byte[]> {
    static final BinaryToBinaryCastRule INSTANCE = new BinaryToBinaryCastRule();

    private BinaryToBinaryCastRule() {
        super(CastRulePredicate.builder().input(LogicalTypeFamily.BINARY_STRING).target(LogicalTypeFamily.BINARY_STRING).build());
    }

    @Override
    public String generateExpression(CodeGeneratorCastRule.Context context, String inputTerm, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        int inputLength = LogicalTypeChecks.getLength((LogicalType)inputLogicalType);
        int targetLength = LogicalTypeChecks.getLength((LogicalType)targetLogicalType);
        if (context.legacyBehaviour() || (!BinaryToBinaryCastRule.couldTrim(targetLength) || inputLength <= targetLength) && !BinaryToBinaryCastRule.couldPad(targetLogicalType, targetLength)) {
            return inputTerm;
        }
        return CastRuleUtils.ternaryOperator(CastRuleUtils.arrayLength(inputTerm) + " == " + targetLength, inputTerm, CastRuleUtils.staticCall(Arrays.class, "copyOf", inputTerm, targetLength));
    }

    static boolean couldTrim(int targetLength) {
        return targetLength < Integer.MAX_VALUE;
    }

    static boolean couldPad(LogicalType targetType, int targetLength) {
        return targetType.is(LogicalTypeRoot.BINARY) && targetLength < Integer.MAX_VALUE;
    }

    static void trimOrPadByteArray(String returnVariable, int targetLength, String deserializedByteArrayTerm, CastRuleUtils.CodeWriter writer) {
        writer.assignStmt(returnVariable, CastRuleUtils.staticCall(Arrays.class, "copyOf", deserializedByteArrayTerm, targetLength));
    }
}

