/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions.converter.converters;

import java.util.LinkedList;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlJsonConstructorNullClause;
import org.apache.calcite.sql.SqlOperator;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.planner.expressions.converter.CallExpressionConvertRule;
import org.apache.flink.table.planner.expressions.converter.converters.CustomizedConverter;
import org.apache.flink.table.planner.expressions.converter.converters.JsonConverterUtil;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;

@Internal
class JsonObjectConverter
extends CustomizedConverter {
    JsonObjectConverter() {
    }

    @Override
    public RexNode convert(CallExpression call, CallExpressionConvertRule.ConvertContext context) {
        JsonObjectConverter.checkArgument(call, (call.getChildren().size() - 1) % 2 == 0);
        LinkedList<RexNode> operands = new LinkedList<RexNode>();
        SqlJsonConstructorNullClause onNull = JsonConverterUtil.getOnNullArgument(call, 0);
        operands.add(context.getRelBuilder().getRexBuilder().makeFlag(onNull));
        for (int i = 1; i < call.getChildren().size(); ++i) {
            Expression operand = (Expression)call.getChildren().get(i);
            if (i % 2 == 1 && !(operand instanceof ValueLiteralExpression)) {
                throw new TableException(String.format("Argument at position %s must be a string literal.", i));
            }
            operands.add(context.toRexNode(operand));
        }
        return context.getRelBuilder().getRexBuilder().makeCall((SqlOperator)FlinkSqlOperatorTable.JSON_OBJECT, operands);
    }
}

