/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.calcite;

import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataTypeSystemImpl;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;
import org.apache.flink.util.function.QuadFunction;

@Internal
public class FlinkTypeSystem
extends RelDataTypeSystemImpl {
    public static final FlinkTypeSystem INSTANCE = new FlinkTypeSystem();
    public static final DecimalType DECIMAL_SYSTEM_DEFAULT = new DecimalType(38, 18);

    private FlinkTypeSystem() {
    }

    @Override
    public int getMaxNumericPrecision() {
        return 38;
    }

    @Override
    public int getMaxNumericScale() {
        return 38;
    }

    @Override
    public int getDefaultPrecision(SqlTypeName typeName) {
        switch (typeName) {
            case VARCHAR: 
            case VARBINARY: {
                return Integer.MAX_VALUE;
            }
            case TIMESTAMP: {
                return 6;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return 6;
            }
        }
        return super.getDefaultPrecision(typeName);
    }

    @Override
    public int getMaxPrecision(SqlTypeName typeName) {
        switch (typeName) {
            case VARCHAR: 
            case VARBINARY: 
            case CHAR: 
            case BINARY: {
                return Integer.MAX_VALUE;
            }
            case TIMESTAMP: {
                return 9;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return 9;
            }
        }
        return super.getMaxPrecision(typeName);
    }

    @Override
    public boolean shouldConvertRaggedUnionTypesToVarying() {
        return true;
    }

    @Override
    public RelDataType deriveAvgAggType(RelDataTypeFactory typeFactory, RelDataType argRelDataType) {
        LogicalType argType = FlinkTypeFactory.toLogicalType(argRelDataType);
        LogicalType resultType = LogicalTypeMerging.findAvgAggType((LogicalType)argType);
        return ShortcutUtils.unwrapTypeFactory(typeFactory).createFieldTypeFromLogicalType(resultType);
    }

    @Override
    public RelDataType deriveSumType(RelDataTypeFactory typeFactory, RelDataType argRelDataType) {
        LogicalType argType = FlinkTypeFactory.toLogicalType(argRelDataType);
        LogicalType resultType = LogicalTypeMerging.findSumAggType((LogicalType)argType);
        return ShortcutUtils.unwrapTypeFactory(typeFactory).createFieldTypeFromLogicalType(resultType);
    }

    @Override
    public RelDataType deriveDecimalPlusType(RelDataTypeFactory typeFactory, RelDataType type1, RelDataType type2) {
        return this.deriveDecimalType(typeFactory, type1, type2, (QuadFunction<Integer, Integer, Integer, Integer, DecimalType>)((QuadFunction)LogicalTypeMerging::findAdditionDecimalType));
    }

    @Override
    public RelDataType deriveDecimalModType(RelDataTypeFactory typeFactory, RelDataType type1, RelDataType type2) {
        return this.deriveDecimalRelDataType(typeFactory, type1, type2, (QuadFunction<Integer, Integer, Integer, Integer, RelDataType>)((QuadFunction)(p1, s1, p2, s2) -> {
            if (s1 == 0 && s2 == 0) {
                return type2;
            }
            DecimalType result = LogicalTypeMerging.findModuloDecimalType((int)p1, (int)s1, (int)p2, (int)s2);
            return typeFactory.createSqlType(SqlTypeName.DECIMAL, result.getPrecision(), result.getScale());
        }));
    }

    @Override
    public RelDataType deriveDecimalDivideType(RelDataTypeFactory typeFactory, RelDataType type1, RelDataType type2) {
        return this.deriveDecimalType(typeFactory, type1, type2, (QuadFunction<Integer, Integer, Integer, Integer, DecimalType>)((QuadFunction)LogicalTypeMerging::findDivisionDecimalType));
    }

    @Override
    public RelDataType deriveDecimalMultiplyType(RelDataTypeFactory typeFactory, RelDataType type1, RelDataType type2) {
        return this.deriveDecimalType(typeFactory, type1, type2, (QuadFunction<Integer, Integer, Integer, Integer, DecimalType>)((QuadFunction)LogicalTypeMerging::findMultiplicationDecimalType));
    }

    @Nullable
    private RelDataType deriveDecimalType(RelDataTypeFactory typeFactory, RelDataType type1, RelDataType type2, QuadFunction<Integer, Integer, Integer, Integer, DecimalType> deriveImpl) {
        return this.deriveDecimalRelDataType(typeFactory, type1, type2, (QuadFunction<Integer, Integer, Integer, Integer, RelDataType>)((QuadFunction)(p1, s1, p2, s2) -> {
            DecimalType result = (DecimalType)deriveImpl.apply(p1, s1, p2, s2);
            return typeFactory.createSqlType(SqlTypeName.DECIMAL, result.getPrecision(), result.getScale());
        }));
    }

    @Nullable
    private RelDataType deriveDecimalRelDataType(RelDataTypeFactory typeFactory, RelDataType type1, RelDataType type2, QuadFunction<Integer, Integer, Integer, Integer, RelDataType> deriveImpl) {
        if (this.canDeriveDecimal(type1, type2)) {
            RelDataType decType1 = this.adjustType(typeFactory, type1);
            RelDataType decType2 = this.adjustType(typeFactory, type2);
            return (RelDataType)deriveImpl.apply((Object)decType1.getPrecision(), (Object)decType1.getScale(), (Object)decType2.getPrecision(), (Object)decType2.getScale());
        }
        return null;
    }

    private RelDataType adjustType(RelDataTypeFactory typeFactory, RelDataType relDataType) {
        return RelDataTypeFactoryImpl.isJavaType(relDataType) ? typeFactory.decimalOf(relDataType) : relDataType;
    }

    private boolean canDeriveDecimal(RelDataType type1, RelDataType type2) {
        return SqlTypeUtil.isExactNumeric(type1) && SqlTypeUtil.isExactNumeric(type2) && (SqlTypeUtil.isDecimal(type1) || SqlTypeUtil.isDecimal(type2));
    }
}

