/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.calcite.util.NlsString;
import org.apache.flink.sql.parser.ddl.constraint.SqlTableConstraint;

public abstract class SqlTableColumn
extends SqlCall {
    private static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("COLUMN_DECL", SqlKind.COLUMN_DECL);
    protected final SqlIdentifier name;
    protected final SqlNode comment;

    private SqlTableColumn(SqlParserPos pos, SqlIdentifier name, @Nullable SqlNode comment) {
        super(pos);
        this.name = Objects.requireNonNull(name, "Column name should not be null");
        this.comment = comment;
    }

    protected abstract void unparseColumn(SqlWriter var1, int var2, int var3);

    @Override
    @Nonnull
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        this.name.unparse(writer, leftPrec, rightPrec);
        this.unparseColumn(writer, leftPrec, rightPrec);
        if (this.comment != null) {
            writer.keyword("COMMENT");
            this.comment.unparse(writer, leftPrec, rightPrec);
        }
    }

    public SqlIdentifier getName() {
        return this.name;
    }

    public Optional<SqlNode> getComment() {
        return Optional.ofNullable(this.comment);
    }

    public static class SqlComputedColumn
    extends SqlTableColumn {
        private final SqlNode expr;

        public SqlComputedColumn(SqlParserPos pos, SqlIdentifier name, @Nullable SqlNode comment, SqlNode expr) {
            super(pos, name, comment);
            this.expr = Objects.requireNonNull(expr, "Column expression should not be null");
        }

        public SqlNode getExpr() {
            return this.expr;
        }

        @Override
        protected void unparseColumn(SqlWriter writer, int leftPrec, int rightPrec) {
            writer.keyword("AS");
            this.expr.unparse(writer, leftPrec, rightPrec);
        }

        @Override
        @Nonnull
        public List<SqlNode> getOperandList() {
            return ImmutableNullableList.of(this.name, this.expr, this.comment);
        }
    }

    public static class SqlMetadataColumn
    extends SqlTableColumn {
        private final SqlDataTypeSpec type;
        @Nullable
        private final SqlNode metadataAlias;
        private final boolean isVirtual;

        public SqlMetadataColumn(SqlParserPos pos, SqlIdentifier name, @Nullable SqlNode comment, SqlDataTypeSpec type, @Nullable SqlNode metadataAlias, boolean isVirtual) {
            super(pos, name, comment);
            this.type = Objects.requireNonNull(type, "Column type should not be null");
            this.metadataAlias = metadataAlias;
            this.isVirtual = isVirtual;
        }

        public SqlDataTypeSpec getType() {
            return this.type;
        }

        public Optional<String> getMetadataAlias() {
            return Optional.ofNullable(this.metadataAlias).map(alias -> ((NlsString)SqlLiteral.value(alias)).getValue());
        }

        public boolean isVirtual() {
            return this.isVirtual;
        }

        @Override
        protected void unparseColumn(SqlWriter writer, int leftPrec, int rightPrec) {
            this.type.unparse(writer, leftPrec, rightPrec);
            if (this.type.getNullable() != null && !this.type.getNullable().booleanValue()) {
                writer.keyword("NOT NULL");
            }
            writer.keyword("METADATA");
            if (this.metadataAlias != null) {
                writer.keyword("FROM");
                this.metadataAlias.unparse(writer, leftPrec, rightPrec);
            }
            if (this.isVirtual) {
                writer.keyword("VIRTUAL");
            }
        }

        @Override
        @Nonnull
        public List<SqlNode> getOperandList() {
            return ImmutableNullableList.of(this.name, this.type, this.comment);
        }
    }

    public static class SqlRegularColumn
    extends SqlTableColumn {
        private SqlDataTypeSpec type;
        @Nullable
        private final SqlTableConstraint constraint;

        public SqlRegularColumn(SqlParserPos pos, SqlIdentifier name, @Nullable SqlNode comment, SqlDataTypeSpec type, @Nullable SqlTableConstraint constraint) {
            super(pos, name, comment);
            this.type = Objects.requireNonNull(type, "Column type should not be null");
            this.constraint = constraint;
        }

        public SqlDataTypeSpec getType() {
            return this.type;
        }

        public void setType(SqlDataTypeSpec type) {
            this.type = type;
        }

        public Optional<SqlTableConstraint> getConstraint() {
            return Optional.ofNullable(this.constraint);
        }

        @Override
        protected void unparseColumn(SqlWriter writer, int leftPrec, int rightPrec) {
            this.type.unparse(writer, leftPrec, rightPrec);
            if (this.type.getNullable() != null && !this.type.getNullable().booleanValue()) {
                writer.keyword("NOT NULL");
            }
            if (this.constraint != null) {
                this.constraint.unparse(writer, leftPrec, rightPrec);
            }
        }

        @Override
        @Nonnull
        public List<SqlNode> getOperandList() {
            return ImmutableNullableList.of(this.name, this.type, this.constraint, this.comment);
        }
    }
}

