/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.NlsString;
import org.apache.flink.annotation.Internal;
import org.apache.flink.sql.parser.dml.RichSqlInsert;
import org.apache.flink.sql.parser.dml.SqlStatementSet;

@Internal
public class SqlCompilePlan
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("COMPILE PLAN", SqlKind.OTHER);
    private final SqlNode planFile;
    private final boolean ifNotExists;
    private SqlNode operand;

    public SqlCompilePlan(SqlParserPos pos, SqlNode planFile, boolean ifNotExists, SqlNode operand) {
        super(pos);
        this.planFile = planFile;
        this.ifNotExists = ifNotExists;
        this.operand = this.checkOperand(operand);
    }

    public String getPlanFile() {
        return ((NlsString)SqlLiteral.value(this.planFile)).getValue();
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    @Override
    @Nonnull
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    @Nonnull
    public List<SqlNode> getOperandList() {
        return Collections.singletonList(this.operand);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("COMPILE");
        writer.keyword("PLAN");
        this.planFile.unparse(writer, leftPrec, rightPrec);
        if (this.isIfNotExists()) {
            writer.keyword("IF");
            writer.keyword("NOT");
            writer.keyword("EXISTS");
        }
        writer.keyword("FOR");
        this.operand.unparse(writer, leftPrec, rightPrec);
    }

    @Override
    public void setOperand(int i, SqlNode operand) {
        if (i != 0) {
            throw new UnsupportedOperationException("SqlCompilePlan supports only one operand with index 0.");
        }
        this.operand = this.checkOperand(operand);
    }

    private SqlNode checkOperand(SqlNode operand) {
        if (!(operand instanceof RichSqlInsert) && !(operand instanceof SqlStatementSet)) {
            throw new UnsupportedOperationException("SqlCompilePlan supports only RichSqlInsert or SqlStatementSet as operand.");
        }
        return operand;
    }
}

