/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.flink.sql.parser.SqlUnparseUtils;

public class SqlAlterDatabase
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("ALTER DATABASE", SqlKind.OTHER_DDL);
    private final SqlIdentifier databaseName;
    private final SqlNodeList propertyList;

    public SqlAlterDatabase(SqlParserPos pos, SqlIdentifier databaseName, SqlNodeList propertyList) {
        super(pos);
        this.databaseName = Objects.requireNonNull(databaseName, "tableName should not be null");
        this.propertyList = Objects.requireNonNull(propertyList, "propertyList should not be null");
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.databaseName, this.propertyList);
    }

    public SqlIdentifier getDatabaseName() {
        return this.databaseName;
    }

    public SqlNodeList getPropertyList() {
        return this.propertyList;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("ALTER DATABASE");
        this.databaseName.unparse(writer, leftPrec, rightPrec);
        writer.keyword("SET");
        SqlWriter.Frame withFrame = writer.startList("(", ")");
        for (SqlNode property : this.propertyList) {
            SqlUnparseUtils.printIndent(writer);
            property.unparse(writer, leftPrec, rightPrec);
        }
        writer.newlineAndIndent();
        writer.endList(withFrame);
    }

    public String[] fullDatabaseName() {
        return this.databaseName.names.toArray(new String[0]);
    }
}

