/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.text.Collator;
import java.util.Locale;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserUtil;
import org.apache.calcite.util.SerializableCharset;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.initialization.qual.UnderInitialization;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.apache.flink.calcite.shaded.org.checkerframework.dataflow.qual.Pure;

public class SqlCollation
implements Serializable {
    public static final SqlCollation COERCIBLE = new SqlCollation(Coercibility.COERCIBLE);
    public static final SqlCollation IMPLICIT = new SqlCollation(Coercibility.IMPLICIT);
    protected final String collationName;
    protected final SerializableCharset wrappedCharset;
    protected final Locale locale;
    protected final String strength;
    private final Coercibility coercibility;

    public SqlCollation(Coercibility coercibility) {
        this(CalciteSystemProperty.DEFAULT_COLLATION.value(), coercibility);
    }

    public SqlCollation(String collation, Coercibility coercibility) {
        this.coercibility = coercibility;
        SqlParserUtil.ParsedCollation parseValues = SqlParserUtil.parseCollation(collation);
        Charset charset = parseValues.getCharset();
        this.wrappedCharset = SerializableCharset.forCharset(charset);
        this.locale = parseValues.getLocale();
        this.strength = parseValues.getStrength().toLowerCase(Locale.ROOT);
        this.collationName = this.generateCollationName(charset);
    }

    public SqlCollation(Coercibility coercibility, Locale locale, Charset charset, String strength) {
        this.coercibility = coercibility;
        charset = SqlUtil.getCharset(charset.name());
        this.wrappedCharset = SerializableCharset.forCharset(charset);
        this.locale = locale;
        this.strength = strength.toLowerCase(Locale.ROOT);
        this.collationName = this.generateCollationName(charset);
    }

    public boolean equals(@Nullable Object o) {
        return this == o || o instanceof SqlCollation && this.collationName.equals(((SqlCollation)o).collationName);
    }

    public int hashCode() {
        return this.collationName.hashCode();
    }

    protected String generateCollationName(@UnderInitialization SqlCollation this, Charset charset) {
        return charset.name().toUpperCase(Locale.ROOT) + "$" + String.valueOf(this.locale) + "$" + this.strength;
    }

    public static @Nullable SqlCollation getCoercibilityDyadicOperator(SqlCollation col1, SqlCollation col2) {
        return SqlCollation.getCoercibilityDyadic(col1, col2);
    }

    public static SqlCollation getCoercibilityDyadicOperatorThrows(SqlCollation col1, SqlCollation col2) {
        SqlCollation ret = SqlCollation.getCoercibilityDyadic(col1, col2);
        if (null == ret) {
            throw Static.RESOURCE.invalidCompare(col1.collationName, "" + (Object)((Object)col1.coercibility), col2.collationName, "" + (Object)((Object)col2.coercibility)).ex();
        }
        return ret;
    }

    public static String getCoercibilityDyadicComparison(SqlCollation col1, SqlCollation col2) {
        return SqlCollation.getCoercibilityDyadicOperatorThrows((SqlCollation)col1, (SqlCollation)col2).collationName;
    }

    protected static @Nullable SqlCollation getCoercibilityDyadic(SqlCollation col1, SqlCollation col2) {
        assert (null != col1);
        assert (null != col2);
        Coercibility coercibility1 = col1.getCoercibility();
        Coercibility coercibility2 = col2.getCoercibility();
        switch (coercibility1) {
            case COERCIBLE: {
                switch (coercibility2) {
                    case COERCIBLE: {
                        return col2;
                    }
                    case IMPLICIT: {
                        return col2;
                    }
                    case NONE: {
                        return null;
                    }
                    case EXPLICIT: {
                        return col2;
                    }
                }
                throw Util.unexpected(coercibility2);
            }
            case IMPLICIT: {
                switch (coercibility2) {
                    case COERCIBLE: {
                        return col1;
                    }
                    case IMPLICIT: {
                        if (col1.collationName.equals(col2.collationName)) {
                            return col2;
                        }
                        return null;
                    }
                    case NONE: {
                        return null;
                    }
                    case EXPLICIT: {
                        return col2;
                    }
                }
                throw Util.unexpected(coercibility2);
            }
            case NONE: {
                switch (coercibility2) {
                    case COERCIBLE: 
                    case IMPLICIT: 
                    case NONE: {
                        return null;
                    }
                    case EXPLICIT: {
                        return col2;
                    }
                }
                throw Util.unexpected(coercibility2);
            }
            case EXPLICIT: {
                switch (coercibility2) {
                    case COERCIBLE: 
                    case IMPLICIT: 
                    case NONE: {
                        return col1;
                    }
                    case EXPLICIT: {
                        if (col1.collationName.equals(col2.collationName)) {
                            return col2;
                        }
                        throw Static.RESOURCE.differentCollations(col1.collationName, col2.collationName).ex();
                    }
                }
                throw Util.unexpected(coercibility2);
            }
        }
        throw Util.unexpected(coercibility1);
    }

    public String toString() {
        return "COLLATE " + this.collationName;
    }

    public void unparse(SqlWriter writer) {
        writer.keyword("COLLATE");
        writer.identifier(this.collationName, false);
    }

    public Charset getCharset() {
        return this.wrappedCharset.getCharset();
    }

    public final String getCollationName() {
        return this.collationName;
    }

    public final Coercibility getCoercibility() {
        return this.coercibility;
    }

    public final Locale getLocale() {
        return this.locale;
    }

    @Pure
    public @Nullable Collator getCollator() {
        return null;
    }

    public static enum Coercibility {
        EXPLICIT,
        IMPLICIT,
        COERCIBLE,
        NONE;

    }
}

