/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.runtime.CalciteException;
import org.apache.calcite.runtime.Resources;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalLiteral;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlUnresolvedFunction;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.fun.SqlLiteralChainOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlOperandMetadata;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SelectScope;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorException;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Static;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableMap;
import org.apache.flink.calcite.shaded.com.google.common.collect.Lists;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public class SqlCallBinding
extends SqlOperatorBinding {
    private final SqlValidator validator;
    private final @Nullable SqlValidatorScope scope;
    private final SqlCall call;

    public SqlCallBinding(SqlValidator validator, @Nullable SqlValidatorScope scope, SqlCall call) {
        super(validator.getTypeFactory(), call.getOperator());
        this.validator = validator;
        this.scope = scope;
        this.call = call;
    }

    @Override
    public int getGroupCount() {
        SelectScope selectScope = SqlValidatorUtil.getEnclosingSelectScope(this.scope);
        if (selectScope == null) {
            return 0;
        }
        SqlSelect select = selectScope.getNode();
        SqlNodeList group = select.getGroup();
        if (group != null) {
            int n = 0;
            for (SqlNode groupItem : group) {
                if (groupItem instanceof SqlNodeList && ((SqlNodeList)groupItem).size() == 0) continue;
                ++n;
            }
            return n;
        }
        return this.validator.isAggregate(select) ? 0 : -1;
    }

    public SqlValidator getValidator() {
        return this.validator;
    }

    public @Nullable SqlValidatorScope getScope() {
        return this.scope;
    }

    public SqlCall getCall() {
        return this.call;
    }

    public List<SqlNode> operands() {
        if (this.hasAssignment() && !(this.call.getOperator() instanceof SqlUnresolvedFunction)) {
            return this.permutedOperands(this.call);
        }
        List<SqlNode> operandList = this.call.getOperandList();
        SqlOperandTypeChecker checker = this.call.getOperator().getOperandTypeChecker();
        if (checker == null) {
            return operandList;
        }
        SqlOperandCountRange range = checker.getOperandCountRange();
        ArrayList<SqlNode> list = Lists.newArrayList(operandList);
        while (list.size() < range.getMax() && checker.isOptional(list.size()) && checker.isFixedParameters()) {
            list.add(DefaultCallHolder.DEFAULT_CALL);
        }
        return list;
    }

    private boolean hasAssignment() {
        for (SqlNode operand : this.call.getOperandList()) {
            if (operand == null || operand.getKind() != SqlKind.ARGUMENT_ASSIGNMENT) continue;
            return true;
        }
        return false;
    }

    private List<SqlNode> permutedOperands(SqlCall call) {
        SqlOperandMetadata operandMetadata = Objects.requireNonNull((SqlOperandMetadata)call.getOperator().getOperandTypeChecker(), () -> "operandTypeChecker is null for " + call + ", operator " + call.getOperator());
        List<String> paramNames = operandMetadata.paramNames();
        ArrayList<SqlNode> permuted = new ArrayList<SqlNode>();
        SqlNameMatcher nameMatcher = this.validator.getCatalogReader().nameMatcher();
        block0: for (String paramName : paramNames) {
            Pair<String, SqlIdentifier> args = null;
            for (int j = 0; j < call.getOperandList().size(); ++j) {
                SqlCall call2 = (SqlCall)call.operand(j);
                assert (call2.getKind() == SqlKind.ARGUMENT_ASSIGNMENT);
                SqlIdentifier operandID = (SqlIdentifier)call2.operand(1);
                String operandName = operandID.getSimple();
                if (nameMatcher.matches(operandName, paramName)) {
                    permuted.add((SqlNode)call2.operand(0));
                    continue block0;
                }
                if (args == null && nameMatcher.isCaseSensitive() && operandName.equalsIgnoreCase(paramName)) {
                    args = Pair.of(paramName, operandID);
                }
                if (j != call.getOperandList().size() - 1) continue;
                if (args != null) {
                    throw SqlUtil.newContextException(((SqlIdentifier)args.right).getParserPosition(), Static.RESOURCE.paramNotFoundInFunctionDidYouMean(((SqlIdentifier)args.right).getSimple(), call.getOperator().getName(), (String)args.left));
                }
                if (!operandMetadata.isFixedParameters()) continue;
                permuted.add(DefaultCallHolder.DEFAULT_CALL);
            }
        }
        return permuted;
    }

    public SqlNode operand(int i) {
        return this.operands().get(i);
    }

    public SqlCall permutedCall() {
        List<SqlNode> operandList = this.operands();
        if (operandList.equals(this.call.getOperandList())) {
            return this.call;
        }
        return this.call.getOperator().createCall(this.call.pos, operandList);
    }

    @Override
    public SqlMonotonicity getOperandMonotonicity(int ordinal) {
        return this.call.getOperandList().get(ordinal).getMonotonicity(this.scope);
    }

    @Override
    public @Nullable String getStringLiteralOperand(int ordinal) {
        Object node = this.call.operand(ordinal);
        Comparable o = SqlLiteral.value(node);
        return o instanceof NlsString ? ((NlsString)o).getValue() : null;
    }

    @Override
    public int getIntLiteralOperand(int ordinal) {
        Object node = this.call.operand(ordinal);
        Comparable o = SqlLiteral.value(node);
        if (o instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)o;
            try {
                return bd.intValueExact();
            }
            catch (ArithmeticException e) {
                throw SqlUtil.newContextException(((SqlNode)node).pos, Static.RESOURCE.numberLiteralOutOfRange(bd.toString()));
            }
        }
        throw new AssertionError();
    }

    @Override
    public <T> @Nullable T getOperandLiteralValue(int ordinal, Class<T> clazz) {
        SqlNode node = this.operand(ordinal);
        return SqlCallBinding.valueAs(node, clazz);
    }

    private static <T> @Nullable T valueAs(SqlNode node, Class<T> clazz) {
        switch (node.getKind()) {
            case ARRAY_VALUE_CONSTRUCTOR: {
                ArrayList<Object> list = new ArrayList<Object>();
                for (SqlNode o : ((SqlCall)node).getOperandList()) {
                    list.add(SqlCallBinding.valueAs(o, Object.class));
                }
                return clazz.cast(ImmutableNullableList.copyOf(list));
            }
            case MAP_VALUE_CONSTRUCTOR: {
                ImmutableMap.Builder<Object, Object> builder2 = ImmutableMap.builder();
                List<SqlNode> operands = ((SqlCall)node).getOperandList();
                for (int i = 0; i < operands.size(); i += 2) {
                    SqlNode key = operands.get(i);
                    SqlNode value = operands.get(i + 1);
                    builder2.put(Objects.requireNonNull(SqlCallBinding.valueAs(key, Object.class), "key"), Objects.requireNonNull(SqlCallBinding.valueAs(value, Object.class), "value"));
                }
                return clazz.cast(builder2.build());
            }
            case CAST: {
                return SqlCallBinding.valueAs(((SqlCall)node).operand(0), clazz);
            }
            case LITERAL: {
                SqlLiteral literal = (SqlLiteral)node;
                if (literal.getTypeName() == SqlTypeName.NULL) {
                    return null;
                }
                return literal.getValueAs(clazz);
            }
            case LITERAL_CHAIN: {
                SqlLiteral literal = SqlLiteralChainOperator.concatenateOperands((SqlCall)node);
                return literal.getValueAs(clazz);
            }
            case INTERVAL_QUALIFIER: {
                SqlIntervalQualifier q = (SqlIntervalQualifier)node;
                SqlIntervalLiteral.IntervalValue intervalValue = new SqlIntervalLiteral.IntervalValue(q, 1, q.toString());
                SqlLiteral literal = new SqlLiteral(intervalValue, q.typeName(), q.pos);
                return literal.getValueAs(clazz);
            }
            case DEFAULT: {
                return null;
            }
        }
        if (SqlUtil.isNullLiteral(node, true)) {
            return null;
        }
        return null;
    }

    @Override
    public boolean isOperandNull(int ordinal, boolean allowCast) {
        return SqlUtil.isNullLiteral(this.operand(ordinal), allowCast);
    }

    @Override
    public boolean isOperandLiteral(int ordinal, boolean allowCast) {
        return SqlUtil.isLiteral(this.operand(ordinal), allowCast);
    }

    @Override
    public int getOperandCount() {
        return this.call.getOperandList().size();
    }

    @Override
    public RelDataType getOperandType(int ordinal) {
        Object operand = this.call.operand(ordinal);
        RelDataType type = SqlTypeUtil.deriveType(this, operand);
        SqlValidatorNamespace namespace = this.validator.getNamespace((SqlNode)operand);
        if (namespace != null) {
            return namespace.getType();
        }
        return type;
    }

    @Override
    public @Nullable RelDataType getCursorOperand(int ordinal) {
        Object operand = this.call.operand(ordinal);
        if (!SqlUtil.isCallTo(operand, SqlStdOperatorTable.CURSOR)) {
            return null;
        }
        SqlCall cursorCall = (SqlCall)operand;
        Object query = cursorCall.operand(0);
        return SqlTypeUtil.deriveType(this, query);
    }

    @Override
    public @Nullable String getColumnListParamInfo(int ordinal, String paramName, List<String> columnList) {
        Object operand = this.call.operand(ordinal);
        if (!SqlUtil.isCallTo(operand, SqlStdOperatorTable.ROW)) {
            return null;
        }
        columnList.addAll(SqlIdentifier.simpleNames(((SqlCall)operand).getOperandList()));
        return this.validator.getParentCursor(paramName);
    }

    @Override
    public CalciteException newError(Resources.ExInst<SqlValidatorException> e) {
        return this.validator.newValidationError(this.call, e);
    }

    public CalciteException newValidationSignatureError() {
        return this.validator.newValidationError(this.call, Static.RESOURCE.canNotApplyOp2Type(this.getOperator().getName(), this.call.getCallSignature(this.validator, this.scope), this.getOperator().getAllowedSignatures()));
    }

    public CalciteException newValidationError(Resources.ExInst<SqlValidatorException> ex) {
        return this.validator.newValidationError(this.call, ex);
    }

    public boolean isTypeCoercionEnabled() {
        return this.validator.config().typeCoercionEnabled();
    }

    private static class DefaultCallHolder {
        private static final SqlCall DEFAULT_CALL = SqlStdOperatorTable.DEFAULT.createCall(SqlParserPos.ZERO, new SqlNode[0]);

        private DefaultCallHolder() {
        }
    }
}

