/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.runtime;

import org.apache.calcite.DataContext;
import org.apache.calcite.rel.metadata.NullSentinel;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.FunctionContext;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public class FunctionContexts {
    private FunctionContexts() {
    }

    public static FunctionContext of(DataContext root, Object[] argumentValues) {
        return new FunctionContextImpl(root, argumentValues);
    }

    private static class FunctionContextImpl
    implements FunctionContext {
        private final DataContext root;
        private final @Nullable Object[] argumentValues;

        FunctionContextImpl(DataContext root, @Nullable Object[] argumentValues) {
            this.root = root;
            this.argumentValues = argumentValues;
        }

        @Override
        public RelDataTypeFactory getTypeFactory() {
            return this.root.getTypeFactory();
        }

        @Override
        public int getParameterCount() {
            return this.argumentValues.length;
        }

        @Override
        public boolean isArgumentConstant(int ordinal) {
            return this.argumentValue(ordinal) != null;
        }

        private @Nullable Object argumentValue(int ordinal) {
            if (ordinal < 0 || ordinal >= this.argumentValues.length) {
                throw new IndexOutOfBoundsException("argument ordinal " + ordinal + " is out of range");
            }
            return this.argumentValues[ordinal];
        }

        @Override
        public <V> @Nullable V getArgumentValueAs(int ordinal, Class<V> valueClass) {
            Object v = this.argumentValue(ordinal);
            if (v == null) {
                throw new IllegalArgumentException("value of argument " + ordinal + " is not constant");
            }
            if (v == NullSentinel.INSTANCE) {
                return null;
            }
            if (valueClass == String.class && !(v instanceof String)) {
                return valueClass.cast(v.toString());
            }
            return valueClass.cast(v);
        }
    }
}

