/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.Compiler$class;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rg\u0001B\u0001\u0003\u0001=\u0011qCU8x)&lWMQ8v]\u0012,GMU1oO\u0016|e/\u001a:\u000b\u0005\r!\u0011!C1hOJ,w-\u0019;f\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011!\u0002;bE2,'BA\u0005\u000b\u0003\u00151G.\u001b8l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001U\u0011\u0001cF\n\u0005\u0001EI#\u0007E\u0003\u0013'U\u00193%D\u0001\u0003\u0013\t!\"AA\u0010Qe>\u001cWm]:Gk:\u001cG/[8o/&$\bn\u00117fC:,\bo\u0015;bi\u0016\u0004\"AF\f\r\u0001\u0011)\u0001\u0004\u0001b\u00013\t\t1*\u0005\u0002\u001bAA\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t9aj\u001c;iS:<\u0007CA\u000e\"\u0013\t\u0011CDA\u0002B]f\u0004\"\u0001J\u0014\u000e\u0003\u0015R!A\n\u0003\u0002\u000bQL\b/Z:\n\u0005!*#\u0001B\"S_^\u00042AK\u00170\u001b\u0005Y#B\u0001\u0017\u0007\u0003\u001d\u0019w\u000eZ3hK:L!AL\u0016\u0003\u0011\r{W\u000e]5mKJ\u0004\"A\u0005\u0019\n\u0005E\u0012!!F$f]\u0016\u0014\u0018\r^3e\u0003\u001e<'/Z4bi&|gn\u001d\t\u0003gYj\u0011\u0001\u000e\u0006\u0003k\u0019\tA!\u001e;jY&\u0011q\u0007\u000e\u0002\b\u0019><w-\u001b8h\u0011!I\u0004A!A!\u0002\u0013Q\u0014aD4f]\u0006;wM]3hCRLwN\\:\u0011\u0005)Z\u0014B\u0001\u001f,\u0005u9UM\\3sCR,G-Q4he\u0016<\u0017\r^5p]N4UO\\2uS>t\u0007\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011B \u0002)\u0005<wM]3hCRLwN\\*uCR,G+\u001f9f!\t\u0001u)D\u0001B\u0015\t\u00115)A\u0005usB,W\u000f^5mg*\u0011A)R\u0001\u0005U\u00064\u0018M\u0003\u0002G\u0011\u0005\u0019\u0011\r]5\n\u0005!\u000b%a\u0003*poRK\b/Z%oM>D\u0001B\u0013\u0001\u0003\u0002\u0003\u0006IaS\u0001\rS:\u0004X\u000f\u001e*poRK\b/\u001a\t\u0003I1K!!T\u0013\u0003\u0019\r\u0013vn\u001e+za\u0016LeNZ8\t\u0011=\u0003!\u0011!Q\u0001\nA\u000bq\u0002\u001d:fG\u0016$\u0017N\\4PM\u001a\u001cX\r\u001e\t\u00037EK!A\u0015\u000f\u0003\t1{gn\u001a\u0005\t)\u0002\u0011\t\u0011)A\u0005+\u0006Q!o\\<US6,\u0017\n\u001a=\u0011\u0005m1\u0016BA,\u001d\u0005\rIe\u000e\u001e\u0005\t3\u0002\u0011\t\u0011)A\u0005!\u0006\u0001R.\u001b8SKR,g\u000e^5p]RKW.\u001a\u0005\t7\u0002\u0011\t\u0011)A\u0005!\u0006\u0001R.\u0019=SKR,g\u000e^5p]RKW.\u001a\u0005\u0006;\u0002!\tAX\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011}\u0003\u0017MY2eK\u001a\u00042A\u0005\u0001\u0016\u0011\u0015ID\f1\u0001;\u0011\u0015qD\f1\u0001@\u0011\u0015QE\f1\u0001L\u0011\u0015yE\f1\u0001Q\u0011\u0015!F\f1\u0001V\u0011\u0015IF\f1\u0001Q\u0011\u0015YF\f1\u0001Q\u0011%A\u0007\u00011AA\u0002\u0013%\u0011.\u0001\u0004pkR\u0004X\u000f^\u000b\u0002G!I1\u000e\u0001a\u0001\u0002\u0004%I\u0001\\\u0001\u000b_V$\b/\u001e;`I\u0015\fHCA7q!\tYb.\u0003\u0002p9\t!QK\\5u\u0011\u001d\t(.!AA\u0002\r\n1\u0001\u001f\u00132\u0011\u0019\u0019\b\u0001)Q\u0005G\u00059q.\u001e;qkR\u0004\u0003\"C;\u0001\u0001\u0004\u0005\r\u0011\"\u0003w\u0003Ua\u0017m\u001d;Ue&<w-\u001a:j]\u001e$6o\u0015;bi\u0016,\u0012a\u001e\t\u0004qv\u0004V\"A=\u000b\u0005i\\\u0018!B:uCR,'B\u0001?F\u0003\u0019\u0019w.\\7p]&\u0011a0\u001f\u0002\u000b-\u0006dW/Z*uCR,\u0007bCA\u0001\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0007\t\u0011\u0004\\1tiR\u0013\u0018nZ4fe&tw\rV:Ti\u0006$Xm\u0018\u0013fcR\u0019Q.!\u0002\t\u000fE|\u0018\u0011!a\u0001o\"9\u0011\u0011\u0002\u0001!B\u00139\u0018A\u00067bgR$&/[4hKJLgn\u001a+t'R\fG/\u001a\u0011\t\u0017\u00055\u0001\u00011AA\u0002\u0013%\u0011qB\u0001\u0011C\u000e\u001cW/\\;mCR|'o\u0015;bi\u0016,\"!!\u0005\u0011\tal\u00181\u0003\t\u0005\u0003+\tI\"\u0004\u0002\u0002\u0018)\u0011a\u0005C\u0005\u0005\u00037\t9BA\u0002S_^D1\"a\b\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\"\u0005!\u0012mY2v[Vd\u0017\r^8s'R\fG/Z0%KF$2!\\A\u0012\u0011%\t\u0018QDA\u0001\u0002\u0004\t\t\u0002\u0003\u0005\u0002(\u0001\u0001\u000b\u0015BA\t\u0003E\t7mY;nk2\fGo\u001c:Ti\u0006$X\r\t\u0005\f\u0003W\u0001\u0001\u0019!a\u0001\n\u0013\ti#A\u0005eCR\f7\u000b^1uKV\u0011\u0011q\u0006\t\u0007q\u0006E\u0002+!\u000e\n\u0007\u0005M\u0012P\u0001\u0005NCB\u001cF/\u0019;f!\u0019\t9$!\u0010\u0002\u00145\u0011\u0011\u0011\b\u0006\u0004k\u0005m\"\"\u0001#\n\t\u0005}\u0012\u0011\b\u0002\u0005\u0019&\u001cH\u000fC\u0006\u0002D\u0001\u0001\r\u00111A\u0005\n\u0005\u0015\u0013!\u00043bi\u0006\u001cF/\u0019;f?\u0012*\u0017\u000fF\u0002n\u0003\u000fB\u0011\"]A!\u0003\u0003\u0005\r!a\f\t\u0011\u0005-\u0003\u0001)Q\u0005\u0003_\t!\u0002Z1uCN#\u0018\r^3!\u0011-\ty\u0005\u0001a\u0001\u0002\u0004%I!!\u0015\u0002\u0011\u0019,hn\u0019;j_:,\u0012a\f\u0005\f\u0003+\u0002\u0001\u0019!a\u0001\n\u0013\t9&\u0001\u0007gk:\u001cG/[8o?\u0012*\u0017\u000fF\u0002n\u00033B\u0001\"]A*\u0003\u0003\u0005\ra\f\u0005\b\u0003;\u0002\u0001\u0015)\u00030\u0003%1WO\\2uS>t\u0007\u0005C\u0004\u0002b\u0001!\t%a\u0019\u0002\t=\u0004XM\u001c\u000b\u0004[\u0006\u0015\u0004\u0002CA4\u0003?\u0002\r!!\u001b\u0002\r\r|gNZ5h!\u0011\tY'!\u001d\u000e\u0005\u00055$bAA8\u0011\u0005i1m\u001c8gS\u001e,(/\u0019;j_:LA!a\u001d\u0002n\ti1i\u001c8gS\u001e,(/\u0019;j_:Dq!a\u001e\u0001\t\u0003\nI(\u0001\bqe>\u001cWm]:FY\u0016lWM\u001c;\u0015\u000f5\fY(a \u0002\u001c\"9\u0011QPA;\u0001\u0004\u0019\u0013AB5oaV$8\t\u0003\u0005\u0002\u0002\u0006U\u0004\u0019AAB\u0003\r\u0019G\u000f\u001f\t\u0005\u0003\u000b\u000b9\nE\u0004\u0002\b\u0006MUcI\u0012\u000e\u0005\u0005%%\u0002BAF\u0003\u001b\u000b\u0011BZ;oGRLwN\\:\u000b\u0007\u0019\u000byIC\u0002\u0002\u0012\"\t\u0011b\u001d;sK\u0006l\u0017N\\4\n\t\u0005U\u0015\u0011\u0012\u0002\u0015\u0017\u0016LX\r\u001a)s_\u000e,7o\u001d$v]\u000e$\u0018n\u001c8\n\t\u0005e\u00151\u0013\u0002\b\u0007>tG/\u001a=u\u0011!\ti*!\u001eA\u0002\u0005}\u0015aA8viB)\u0011\u0011UASG5\u0011\u00111\u0015\u0006\u0003k!IA!a*\u0002$\nI1i\u001c7mK\u000e$xN\u001d\u0005\b\u0003W\u0003A\u0011IAW\u0003\u001dyg\u000eV5nKJ$r!\\AX\u0003g\u000bY\fC\u0004\u00022\u0006%\u0006\u0019\u0001)\u0002\u0013QLW.Z:uC6\u0004\b\u0002CAA\u0003S\u0003\r!!.\u0011\t\u0005\u0015\u0015qW\u0005\u0005\u0003s\u000b\u0019J\u0001\bP]RKW.\u001a:D_:$X\r\u001f;\t\u0011\u0005u\u0015\u0011\u0016a\u0001\u0003?Cq!a0\u0001\t\u0003\n\t-A\u0003dY>\u001cX\rF\u0001n\u0001")
public class RowTimeBoundedRangeOver<K>
extends ProcessFunctionWithCleanupState<K, CRow, CRow>
implements Compiler<GeneratedAggregations>,
Logging {
    private final GeneratedAggregationsFunction genAggregations;
    private final RowTypeInfo aggregationStateType;
    private final CRowTypeInfo inputRowType;
    private final long precedingOffset;
    private final int rowTimeIdx;
    private CRow output;
    private ValueState<Object> lastTriggeringTsState;
    private ValueState<Row> accumulatorState;
    private MapState<Object, List<Row>> dataState;
    private GeneratedAggregations function;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    private Logger LOG$lzycompute() {
        RowTimeBoundedRangeOver rowTimeBoundedRangeOver = this;
        synchronized (rowTimeBoundedRangeOver) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler$class.compile(this, cl, name, code);
    }

    private CRow output() {
        return this.output;
    }

    private void output_$eq(CRow x$1) {
        this.output = x$1;
    }

    private ValueState<Object> lastTriggeringTsState() {
        return this.lastTriggeringTsState;
    }

    private void lastTriggeringTsState_$eq(ValueState<Object> x$1) {
        this.lastTriggeringTsState = x$1;
    }

    private ValueState<Row> accumulatorState() {
        return this.accumulatorState;
    }

    private void accumulatorState_$eq(ValueState<Row> x$1) {
        this.accumulatorState = x$1;
    }

    private MapState<Object, List<Row>> dataState() {
        return this.dataState;
    }

    private void dataState_$eq(MapState<Object, List<Row>> x$1) {
        this.dataState = x$1;
    }

    private GeneratedAggregations function() {
        return this.function;
    }

    private void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling AggregateHelper: ", " \\n\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations.name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Code:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations.code()}))).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations.name(), this.genAggregations.code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.function().open(this.getRuntimeContext());
        this.output_$eq(new CRow(this.function().createOutputRow(), true));
        ValueStateDescriptor lastTriggeringTsDescriptor = new ValueStateDescriptor("lastTriggeringTsState", Long.TYPE);
        this.lastTriggeringTsState_$eq((ValueState<Object>)this.getRuntimeContext().getState(lastTriggeringTsDescriptor));
        ValueStateDescriptor accumulatorStateDescriptor = new ValueStateDescriptor("accumulatorState", (TypeInformation)this.aggregationStateType);
        this.accumulatorState_$eq((ValueState<Row>)this.getRuntimeContext().getState(accumulatorStateDescriptor));
        BasicTypeInfo keyTypeInformation = BasicTypeInfo.LONG_TYPE_INFO;
        ListTypeInfo valueTypeInformation = new ListTypeInfo((TypeInformation)this.inputRowType.rowType());
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor("dataState", (TypeInformation)keyTypeInformation, (TypeInformation)valueTypeInformation);
        this.dataState_$eq((MapState<Object, List<Row>>)this.getRuntimeContext().getMapState(mapStateDescriptor));
        this.initCleanupTimeState("RowTimeBoundedRangeOverCleanupTime");
    }

    public void processElement(CRow inputC, KeyedProcessFunction.Context ctx, Collector<CRow> out) {
        Row input = inputC.row();
        this.processCleanupTimer(ctx, ctx.timerService().currentProcessingTime());
        long triggeringTs = BoxesRunTime.unboxToLong((Object)input.getField(this.rowTimeIdx));
        long lastTriggeringTs = BoxesRunTime.unboxToLong((Object)this.lastTriggeringTsState().value());
        if (triggeringTs > lastTriggeringTs) {
            List data = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)triggeringTs));
            if (data == null) {
                ArrayList<Row> data2 = new ArrayList<Row>();
                data2.add(input);
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)triggeringTs), data2);
                ctx.timerService().registerEventTimeTimer(triggeringTs);
            } else {
                data.add(input);
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)triggeringTs), (Object)data);
            }
        }
    }

    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        if (this.isProcessingTimeTimer(ctx)) {
            if (this.stateCleaningEnabled()) {
                Iterator keysIt = this.dataState().keys().iterator();
                long lastProcessedTime = BoxesRunTime.unboxToLong((Object)this.lastTriggeringTsState().value());
                boolean noRecordsToProcess = true;
                while (keysIt.hasNext() && noRecordsToProcess) {
                    if (BoxesRunTime.unboxToLong(keysIt.next()) <= lastProcessedTime) continue;
                    noRecordsToProcess = false;
                }
                if (noRecordsToProcess) {
                    this.cleanupState((Seq<State>)Predef$.MODULE$.wrapRefArray((Object[])new State[]{this.dataState(), this.accumulatorState(), this.lastTriggeringTsState()}));
                    this.function().cleanup();
                } else {
                    this.processCleanupTimer((KeyedProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
                }
            }
            return;
        }
        ((TimestampedCollector)out).eraseTimestamp();
        List inputs = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)timestamp));
        if (inputs != null) {
            Row accumulators = (Row)this.accumulatorState().value();
            int dataListIndex = 0;
            boolean aggregatesIndex = false;
            if (accumulators == null) {
                accumulators = this.function().createAccumulators();
                aggregatesIndex = false;
            }
            Iterator iter = this.dataState().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                long dataTs = BoxesRunTime.unboxToLong(entry.getKey());
                long offset = timestamp - dataTs;
                if (offset <= this.precedingOffset) continue;
                List retractDataList = (List)entry.getValue();
                for (dataListIndex = 0; dataListIndex < retractDataList.size(); ++dataListIndex) {
                    Row retractRow = (Row)retractDataList.get(dataListIndex);
                    this.function().retract(accumulators, retractRow);
                }
                iter.remove();
            }
            for (dataListIndex = 0; dataListIndex < inputs.size(); ++dataListIndex) {
                Row curRow = (Row)inputs.get(dataListIndex);
                this.function().accumulate(accumulators, curRow);
            }
            this.function().setAggregationResults(accumulators, this.output().row());
            for (dataListIndex = 0; dataListIndex < inputs.size(); ++dataListIndex) {
                aggregatesIndex = false;
                this.function().setForwardedFields((Row)inputs.get(dataListIndex), this.output().row());
                out.collect((Object)this.output());
            }
            this.accumulatorState().update((Object)accumulators);
        }
        this.lastTriggeringTsState().update((Object)BoxesRunTime.boxToLong((long)timestamp));
        this.processCleanupTimer((KeyedProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
    }

    public void close() {
        if (this.function() != null) {
            this.function().close();
        }
    }

    public RowTimeBoundedRangeOver(GeneratedAggregationsFunction genAggregations, RowTypeInfo aggregationStateType, CRowTypeInfo inputRowType, long precedingOffset, int rowTimeIdx, long minRetentionTime, long maxRetentionTime) {
        this.genAggregations = genAggregations;
        this.aggregationStateType = aggregationStateType;
        this.inputRowType = inputRowType;
        this.precedingOffset = precedingOffset;
        this.rowTimeIdx = rowTimeIdx;
        super(minRetentionTime, maxRetentionTime);
        Compiler$class.$init$(this);
        Logging$class.$init$(this);
        Preconditions.checkNotNull((Object)aggregationStateType);
        Preconditions.checkNotNull((Object)BoxesRunTime.boxToLong((long)precedingOffset));
    }
}

