/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.Compiler$class;
import org.apache.flink.table.codegen.GeneratedTableAggregationsFunction;
import org.apache.flink.table.runtime.TableAggregateCollector;
import org.apache.flink.table.runtime.aggregate.GeneratedTableAggregations;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005uf\u0001B\u0001\u0003\u0001=\u0011Ad\u0012:pkB$\u0016M\u00197f\u0003\u001e<\u0007K]8dKN\u001ch)\u001e8di&|gN\u0003\u0002\u0004\t\u0005I\u0011mZ4sK\u001e\fG/\u001a\u0006\u0003\u000b\u0019\tqA];oi&lWM\u0003\u0002\b\u0011\u0005)A/\u00192mK*\u0011\u0011BC\u0001\u0006M2Lgn\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0005A92\u0003\u0002\u0001\u0012SI\u0002RAE\n\u0016G\rj\u0011AA\u0005\u0003)\t\u0011q\u0004\u0015:pG\u0016\u001c8OR;oGRLwN\\,ji\"\u001cE.Z1okB\u001cF/\u0019;f!\t1r\u0003\u0004\u0001\u0005\u000ba\u0001!\u0019A\r\u0003\u0003-\u000b\"A\u0007\u0011\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\u000f9{G\u000f[5oOB\u00111$I\u0005\u0003Eq\u00111!\u00118z!\t!s%D\u0001&\u0015\t1C!A\u0003usB,7/\u0003\u0002)K\t!1IU8x!\rQSfL\u0007\u0002W)\u0011AFB\u0001\bG>$WmZ3o\u0013\tq3F\u0001\u0005D_6\u0004\u0018\u000e\\3s!\t\u0011\u0002'\u0003\u00022\u0005\tQr)\u001a8fe\u0006$X\r\u001a+bE2,\u0017iZ4sK\u001e\fG/[8ogB\u00111GN\u0007\u0002i)\u0011QGB\u0001\u0005kRLG.\u0003\u00028i\t9Aj\\4hS:<\u0007\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\u0002)\u001d,g\u000eV1cY\u0016\fum\u001a:fO\u0006$\u0018n\u001c8t!\tQ3(\u0003\u0002=W\t\u0011s)\u001a8fe\u0006$X\r\u001a+bE2,\u0017iZ4sK\u001e\fG/[8og\u001a+hn\u0019;j_:D\u0001B\u0010\u0001\u0003\u0002\u0003\u0006IaP\u0001\u0015C\u001e<'/Z4bi&|gn\u0015;bi\u0016$\u0016\u0010]3\u0011\u0005\u0001;U\"A!\u000b\u0005\t\u001b\u0015!\u0003;za\u0016,H/\u001b7t\u0015\t!U)\u0001\u0003kCZ\f'B\u0001$\t\u0003\r\t\u0007/[\u0005\u0003\u0011\u0006\u00131BU8x)f\u0004X-\u00138g_\"A!\n\u0001B\u0001B\u0003%1*\u0001\nhK:,'/\u0019;f%\u0016$(/Y2uS>t\u0007CA\u000eM\u0013\tiEDA\u0004C_>dW-\u00198\t\u0011=\u0003!\u0011!Q\u0001\nA\u000bAb\u001a:pkB\\U-_*ju\u0016\u0004\"aG)\n\u0005Ic\"aA%oi\"AA\u000b\u0001B\u0001B\u0003%Q+\u0001\tnS:\u0014V\r^3oi&|g\u000eV5nKB\u00111DV\u0005\u0003/r\u0011A\u0001T8oO\"A\u0011\f\u0001B\u0001B\u0003%Q+\u0001\tnCb\u0014V\r^3oi&|g\u000eV5nK\")1\f\u0001C\u00019\u00061A(\u001b8jiz\"r!\u00180`A\u0006\u00147\rE\u0002\u0013\u0001UAQ!\u000f.A\u0002iBQA\u0010.A\u0002}BQA\u0013.A\u0002-CQa\u0014.A\u0002ACQ\u0001\u0016.A\u0002UCQ!\u0017.A\u0002UC\u0011\"\u001a\u0001A\u0002\u0003\u0007I\u0011\u00024\u0002\u0011\u0019,hn\u0019;j_:,\u0012a\f\u0005\nQ\u0002\u0001\r\u00111A\u0005\n%\fABZ;oGRLwN\\0%KF$\"A[7\u0011\u0005mY\u0017B\u00017\u001d\u0005\u0011)f.\u001b;\t\u000f9<\u0017\u0011!a\u0001_\u0005\u0019\u0001\u0010J\u0019\t\rA\u0004\u0001\u0015)\u00030\u0003%1WO\\2uS>t\u0007\u0005C\u0005s\u0001\u0001\u0007\t\u0019!C\u0005g\u0006Aa-\u001b:tiJ{w/F\u0001L\u0011%)\b\u00011AA\u0002\u0013%a/\u0001\u0007gSJ\u001cHOU8x?\u0012*\u0017\u000f\u0006\u0002ko\"9a\u000e^A\u0001\u0002\u0004Y\u0005BB=\u0001A\u0003&1*A\u0005gSJ\u001cHOU8xA!I1\u0010\u0001a\u0001\u0002\u0004%I\u0001`\u0001\u0006gR\fG/Z\u000b\u0002{B)a0!\u0002\u0002\n5\tqPC\u0002|\u0003\u0003Q1!a\u0001F\u0003\u0019\u0019w.\\7p]&\u0019\u0011qA@\u0003\u0015Y\u000bG.^3Ti\u0006$X\r\u0005\u0003\u0002\f\u0005=QBAA\u0007\u0015\t1\u0003\"\u0003\u0003\u0002\u0012\u00055!a\u0001*po\"Y\u0011Q\u0003\u0001A\u0002\u0003\u0007I\u0011BA\f\u0003%\u0019H/\u0019;f?\u0012*\u0017\u000fF\u0002k\u00033A\u0001B\\A\n\u0003\u0003\u0005\r! \u0005\b\u0003;\u0001\u0001\u0015)\u0003~\u0003\u0019\u0019H/\u0019;fA!Y\u0011\u0011\u0005\u0001A\u0002\u0003\u0007I\u0011BA\u0012\u0003!\u0019g\u000e^*uCR,WCAA\u0013!\u0015q\u0018QAA\u0014!\u0011\tI#!\r\u000e\u0005\u0005-\"\u0002BA\u0017\u0003_\tA\u0001\\1oO*\tA)C\u0002X\u0003WA1\"!\u000e\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00028\u0005a1M\u001c;Ti\u0006$Xm\u0018\u0013fcR\u0019!.!\u000f\t\u00139\f\u0019$!AA\u0002\u0005\u0015\u0002\u0002CA\u001f\u0001\u0001\u0006K!!\n\u0002\u0013\rtGo\u0015;bi\u0016\u0004\u0003bCA!\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0007\nqbY8oG\u0006$8i\u001c7mK\u000e$xN]\u000b\u0003\u0003\u000b\u0002B!a\u0012\u0002J5\tA!C\u0002\u0002L\u0011\u0011q\u0003V1cY\u0016\fum\u001a:fO\u0006$XmQ8mY\u0016\u001cGo\u001c:\t\u0017\u0005=\u0003\u00011AA\u0002\u0013%\u0011\u0011K\u0001\u0014G>t7-\u0019;D_2dWm\u0019;pe~#S-\u001d\u000b\u0004U\u0006M\u0003\"\u00038\u0002N\u0005\u0005\t\u0019AA#\u0011!\t9\u0006\u0001Q!\n\u0005\u0015\u0013\u0001E2p]\u000e\fGoQ8mY\u0016\u001cGo\u001c:!\u0011\u001d\tY\u0006\u0001C!\u0003;\nAa\u001c9f]R\u0019!.a\u0018\t\u0011\u0005\u0005\u0014\u0011\fa\u0001\u0003G\naaY8oM&<\u0007\u0003BA3\u0003Wj!!a\u001a\u000b\u0007\u0005%\u0004\"A\u0007d_:4\u0017nZ;sCRLwN\\\u0005\u0005\u0003[\n9GA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\b\u0003c\u0002A\u0011IA:\u00039\u0001(o\\2fgN,E.Z7f]R$rA[A;\u0003s\n)\nC\u0004\u0002x\u0005=\u0004\u0019A\u0012\u0002\r%t\u0007/\u001e;D\u0011!\tY(a\u001cA\u0002\u0005u\u0014aA2uqB!\u0011qPAI!\u001d\t\t)!$\u0016G\rj!!a!\u000b\t\u0005\u0015\u0015qQ\u0001\nMVt7\r^5p]NT1ARAE\u0015\r\tY\tC\u0001\ngR\u0014X-Y7j]\u001eLA!a$\u0002\u0004\n!2*Z=fIB\u0013xnY3tg\u001a+hn\u0019;j_:LA!a%\u0002\u000e\n91i\u001c8uKb$\b\u0002CAL\u0003_\u0002\r!!'\u0002\u0007=,H\u000fE\u0003\u0002\u001c\u0006}5%\u0004\u0002\u0002\u001e*\u0011Q\u0007C\u0005\u0005\u0003C\u000biJA\u0005D_2dWm\u0019;pe\"9\u0011Q\u0015\u0001\u0005B\u0005\u001d\u0016aB8o)&lWM\u001d\u000b\bU\u0006%\u0016QVA[\u0011\u001d\tY+a)A\u0002U\u000b\u0011\u0002^5nKN$\u0018-\u001c9\t\u0011\u0005m\u00141\u0015a\u0001\u0003_\u0003B!a \u00022&!\u00111WAG\u00059ye\u000eV5nKJ\u001cuN\u001c;fqRD\u0001\"a&\u0002$\u0002\u0007\u0011\u0011\u0014\u0005\b\u0003s\u0003A\u0011IA^\u0003\u0015\u0019Gn\\:f)\u0005Q\u0007")
public class GroupTableAggProcessFunction<K>
extends ProcessFunctionWithCleanupState<K, CRow, CRow>
implements Compiler<GeneratedTableAggregations>,
Logging {
    private final GeneratedTableAggregationsFunction genTableAggregations;
    private final RowTypeInfo aggregationStateType;
    private final boolean generateRetraction;
    private final int groupKeySize;
    private GeneratedTableAggregations function;
    private boolean firstRow;
    private ValueState<Row> state;
    private ValueState<Long> cntState;
    private TableAggregateCollector concatCollector;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    private Logger LOG$lzycompute() {
        GroupTableAggProcessFunction groupTableAggProcessFunction = this;
        synchronized (groupTableAggProcessFunction) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    @Override
    public Class<GeneratedTableAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler$class.compile(this, cl, name, code);
    }

    private GeneratedTableAggregations function() {
        return this.function;
    }

    private void function_$eq(GeneratedTableAggregations x$1) {
        this.function = x$1;
    }

    private boolean firstRow() {
        return this.firstRow;
    }

    private void firstRow_$eq(boolean x$1) {
        this.firstRow = x$1;
    }

    private ValueState<Row> state() {
        return this.state;
    }

    private void state_$eq(ValueState<Row> x$1) {
        this.state = x$1;
    }

    private ValueState<Long> cntState() {
        return this.cntState;
    }

    private void cntState_$eq(ValueState<Long> x$1) {
        this.cntState = x$1;
    }

    private TableAggregateCollector concatCollector() {
        return this.concatCollector;
    }

    private void concatCollector_$eq(TableAggregateCollector x$1) {
        this.concatCollector = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling TableAggregateHelper: ", " \\n\\n "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genTableAggregations.name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Code:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genTableAggregations.code()}))).toString());
        Class<GeneratedTableAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genTableAggregations.name(), this.genTableAggregations.code());
        this.LOG().debug("Instantiating TableAggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.function().open(this.getRuntimeContext());
        ValueStateDescriptor stateDescriptor = new ValueStateDescriptor("GroupTableAggregateState", (TypeInformation)this.aggregationStateType);
        this.state_$eq((ValueState<Row>)this.getRuntimeContext().getState(stateDescriptor));
        ValueStateDescriptor inputCntDescriptor = new ValueStateDescriptor("GroupTableAggregateInputCounter", Types.LONG());
        this.cntState_$eq((ValueState<Long>)this.getRuntimeContext().getState(inputCntDescriptor));
        this.concatCollector_$eq(new TableAggregateCollector(this.groupKeySize));
        this.concatCollector().setResultRow(this.function().createOutputRow());
        this.initCleanupTimeState("GroupTableAggregateCleanupTime");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processElement(CRow inputC, KeyedProcessFunction.Context ctx, Collector<CRow> out) {
        long currentTime = ctx.timerService().currentProcessingTime();
        this.processCleanupTimer(ctx, currentTime);
        Row input = inputC.row();
        Row accumulators = (Row)this.state().value();
        Long inputCnt = (Long)this.cntState().value();
        if (accumulators == null) {
            if (!inputC.change()) return;
            this.firstRow_$eq(true);
            accumulators = this.function().createAccumulators();
        } else {
            this.firstRow_$eq(false);
        }
        this.function().setForwardedFields(input, this.concatCollector().getResultRow());
        this.concatCollector().out_$eq(out);
        if (!this.firstRow() && this.generateRetraction && !this.genTableAggregations.emitValuesIncrementally()) {
            this.concatCollector().setChange(false);
            this.function().emit(accumulators, this.concatCollector());
            this.concatCollector().setChange(true);
        }
        if (inputCnt == null) {
            inputCnt = Predef$.MODULE$.long2Long(0L);
        }
        if (inputC.change()) {
            inputCnt = Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(inputCnt) + 1L);
            this.function().accumulate(accumulators, input);
        } else {
            inputCnt = Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(inputCnt) - 1L);
            this.function().retract(accumulators, input);
        }
        if (BoxesRunTime.equalsNumObject((Number)inputCnt, (Object)BoxesRunTime.boxToInteger((int)0))) {
            this.state().clear();
            this.cntState().clear();
            return;
        } else {
            this.function().emit(accumulators, this.concatCollector());
            this.state().update((Object)accumulators);
            this.cntState().update((Object)inputCnt);
        }
    }

    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        if (this.stateCleaningEnabled()) {
            this.cleanupState((Seq<State>)Predef$.MODULE$.wrapRefArray((Object[])new State[]{this.state(), this.cntState()}));
            this.function().cleanup();
        }
    }

    public void close() {
        if (this.function() != null) {
            this.function().close();
        }
    }

    public GroupTableAggProcessFunction(GeneratedTableAggregationsFunction genTableAggregations, RowTypeInfo aggregationStateType, boolean generateRetraction, int groupKeySize, long minRetentionTime, long maxRetentionTime) {
        this.genTableAggregations = genTableAggregations;
        this.aggregationStateType = aggregationStateType;
        this.generateRetraction = generateRetraction;
        this.groupKeySize = groupKeySize;
        super(minRetentionTime, maxRetentionTime);
        Compiler$class.$init$(this);
        Logging$class.$init$(this);
    }
}

