/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.Iterator;
import org.apache.flink.api.common.functions.RichGroupReduceFunction;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.Compiler$class;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00055a\u0001B\u0001\u0003\u0001=\u0011a\u0006R1uCN+G\u000fV;nE2,7i\\;oi^Kg\u000eZ8x\u0003\u001e<'+\u001a3vG\u0016<%o\\;q\rVt7\r^5p]*\u00111\u0001B\u0001\nC\u001e<'/Z4bi\u0016T!!\u0002\u0004\u0002\u000fI,h\u000e^5nK*\u0011q\u0001C\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u0013)\tQA\u001a7j].T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u0011A)\u0002B!\u0005\r\u001b55\t!C\u0003\u0002\u0014)\u0005Ia-\u001e8di&|gn\u001d\u0006\u0003+Y\taaY8n[>t'BA\f\t\u0003\r\t\u0007/[\u0005\u00033I\u0011qCU5dQ\u001e\u0013x.\u001e9SK\u0012,8-\u001a$v]\u000e$\u0018n\u001c8\u0011\u0005mqR\"\u0001\u000f\u000b\u0005uA\u0011!\u0002;za\u0016\u001c\u0018BA\u0010\u001d\u0005\r\u0011vn\u001e\t\u0004C\u00112S\"\u0001\u0012\u000b\u0005\r2\u0011aB2pI\u0016<WM\\\u0005\u0003K\t\u0012\u0001bQ8na&dWM\u001d\t\u0003O!j\u0011AA\u0005\u0003S\t\u0011QcR3oKJ\fG/\u001a3BO\u001e\u0014XmZ1uS>t7\u000f\u0005\u0002,]5\tAF\u0003\u0002.\r\u0005!Q\u000f^5m\u0013\tyCFA\u0004M_\u001e<\u0017N\\4\t\u0011E\u0002!Q1A\u0005\nI\nqbZ3o\u0003\u001e<'/Z4bi&|gn]\u000b\u0002gA\u0011\u0011\u0005N\u0005\u0003k\t\u0012QdR3oKJ\fG/\u001a3BO\u001e\u0014XmZ1uS>t7OR;oGRLwN\u001c\u0005\to\u0001\u0011\t\u0011)A\u0005g\u0005\u0001r-\u001a8BO\u001e\u0014XmZ1uS>t7\u000f\t\u0005\ts\u0001\u0011)\u0019!C\u0005u\u0005Qq/\u001b8e_^\u001c\u0016N_3\u0016\u0003m\u0002\"\u0001P \u000e\u0003uR\u0011AP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0001v\u0012A\u0001T8oO\"A!\t\u0001B\u0001B\u0003%1(A\u0006xS:$wn^*ju\u0016\u0004\u0003\"\u0002#\u0001\t\u0003)\u0015A\u0002\u001fj]&$h\bF\u0002G\u000f\"\u0003\"a\n\u0001\t\u000bE\u001a\u0005\u0019A\u001a\t\u000be\u001a\u0005\u0019A\u001e\t\u0013)\u0003\u0001\u0019!a\u0001\n\u0013Y\u0015AB8viB,H/F\u0001\u001b\u0011%i\u0005\u00011AA\u0002\u0013%a*\u0001\u0006pkR\u0004X\u000f^0%KF$\"a\u0014*\u0011\u0005q\u0002\u0016BA)>\u0005\u0011)f.\u001b;\t\u000fMc\u0015\u0011!a\u00015\u0005\u0019\u0001\u0010J\u0019\t\rU\u0003\u0001\u0015)\u0003\u001b\u0003\u001dyW\u000f\u001e9vi\u0002B\u0011b\u0016\u0001A\u0002\u0003\u0007I\u0011B&\u0002\u0019\u0005\u001c7-^7vY\u0006$xN]:\t\u0013e\u0003\u0001\u0019!a\u0001\n\u0013Q\u0016\u0001E1dGVlW\u000f\\1u_J\u001cx\fJ3r)\ty5\fC\u0004T1\u0006\u0005\t\u0019\u0001\u000e\t\ru\u0003\u0001\u0015)\u0003\u001b\u00035\t7mY;nk2\fGo\u001c:tA!Iq\f\u0001a\u0001\u0002\u0004%I\u0001Y\u0001\tMVt7\r^5p]V\ta\u0005C\u0005c\u0001\u0001\u0007\t\u0019!C\u0005G\u0006aa-\u001e8di&|gn\u0018\u0013fcR\u0011q\n\u001a\u0005\b'\u0006\f\t\u00111\u0001'\u0011\u00191\u0007\u0001)Q\u0005M\u0005Ia-\u001e8di&|g\u000e\t\u0005\u0006Q\u0002!\t%[\u0001\u0005_B,g\u000e\u0006\u0002PU\")1n\u001aa\u0001Y\u000611m\u001c8gS\u001e\u0004\"!\u001c9\u000e\u00039T!a\u001c\u0005\u0002\u001b\r|gNZ5hkJ\fG/[8o\u0013\t\thNA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\u0006g\u0002!\t\u0005^\u0001\u0007e\u0016$WoY3\u0015\u0007=+x\u0010C\u0003we\u0002\u0007q/A\u0004sK\u000e|'\u000fZ:\u0011\u0007al($D\u0001z\u0015\tQ80\u0001\u0003mC:<'\"\u0001?\u0002\t)\fg/Y\u0005\u0003}f\u0014\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0005\b\u0003\u0003\u0011\b\u0019AA\u0002\u0003\ryW\u000f\u001e\t\u0006\u0003\u000b\tIAG\u0007\u0003\u0003\u000fQ!!\f\u0005\n\t\u0005-\u0011q\u0001\u0002\n\u0007>dG.Z2u_J\u0004")
public class DataSetTumbleCountWindowAggReduceGroupFunction
extends RichGroupReduceFunction<Row, Row>
implements Compiler<GeneratedAggregations>,
Logging {
    private final GeneratedAggregationsFunction genAggregations;
    private final long windowSize;
    private Row output;
    private Row accumulators;
    private GeneratedAggregations function;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    private Logger LOG$lzycompute() {
        DataSetTumbleCountWindowAggReduceGroupFunction dataSetTumbleCountWindowAggReduceGroupFunction = this;
        synchronized (dataSetTumbleCountWindowAggReduceGroupFunction) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler$class.compile(this, cl, name, code);
    }

    private GeneratedAggregationsFunction genAggregations() {
        return this.genAggregations;
    }

    private long windowSize() {
        return this.windowSize;
    }

    private Row output() {
        return this.output;
    }

    private void output_$eq(Row x$1) {
        this.output = x$1;
    }

    private Row accumulators() {
        return this.accumulators;
    }

    private void accumulators_$eq(Row x$1) {
        this.accumulators = x$1;
    }

    private GeneratedAggregations function() {
        return this.function;
    }

    private void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling AggregateHelper: ", ".name \\n\\n "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Code:\\n", ".code"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations()}))).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations().name(), this.genAggregations().code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.output_$eq(this.function().createOutputRow());
        this.accumulators_$eq(this.function().createAccumulators());
    }

    public void reduce(Iterable<Row> records, Collector<Row> out) {
        long count = 0L;
        Iterator<Row> iterator = records.iterator();
        while (iterator.hasNext()) {
            if (count == 0L) {
                this.function().resetAccumulator(this.accumulators());
            }
            Row record = iterator.next();
            this.accumulators_$eq(this.function().mergeAccumulatorsPair(this.accumulators(), record));
            if (this.windowSize() != ++count) continue;
            this.function().setForwardedFields(record, this.output());
            this.function().setAggregationResults(this.accumulators(), this.output());
            out.collect((Object)this.output());
            count = 0L;
        }
    }

    public DataSetTumbleCountWindowAggReduceGroupFunction(GeneratedAggregationsFunction genAggregations, long windowSize) {
        this.genAggregations = genAggregations;
        this.windowSize = windowSize;
        Compiler$class.$init$(this);
        Logging$class.$init$(this);
    }
}

