/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.CalciteSchemaBuilder;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.PlannerType;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.calcite.CalciteConfig;
import org.apache.flink.table.calcite.CalciteConfig$;
import org.apache.flink.table.calcite.FlinkPlannerImpl;
import org.apache.flink.table.calcite.FlinkRelBuilder;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogManagerCalciteSchema;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ConnectorCatalogTable;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.Parser;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.executor.StreamExecutor;
import org.apache.flink.table.explain.PlanJsonParser;
import org.apache.flink.table.expressions.ExpressionBridge;
import org.apache.flink.table.expressions.PlannerExpression;
import org.apache.flink.table.expressions.PlannerExpressionConverter$;
import org.apache.flink.table.expressions.PlannerTypeInferenceUtilImpl;
import org.apache.flink.table.factories.TableFactoryUtil;
import org.apache.flink.table.factories.TableSinkFactory;
import org.apache.flink.table.factories.TableSinkFactoryContextImpl;
import org.apache.flink.table.operations.CatalogSinkModifyOperation;
import org.apache.flink.table.operations.CollectModifyOperation;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OutputConversionModifyOperation;
import org.apache.flink.table.operations.PlannerQueryOperation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.UnregisteredSinkModifyOperation;
import org.apache.flink.table.parse.CalciteParser;
import org.apache.flink.table.plan.StreamOptimizer;
import org.apache.flink.table.plan.nodes.LogicalSink;
import org.apache.flink.table.plan.nodes.LogicalSink$;
import org.apache.flink.table.plan.nodes.datastream.DataStreamRel;
import org.apache.flink.table.planner.ParserImpl;
import org.apache.flink.table.planner.PlanningConfigurationBuilder;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.sinks.AppendStreamTableSink;
import org.apache.flink.table.sinks.DataStreamTableSink;
import org.apache.flink.table.sinks.OverwritableTableSink;
import org.apache.flink.table.sinks.PartitionableTableSink;
import org.apache.flink.table.sinks.RetractStreamTableSink;
import org.apache.flink.table.sinks.StreamSelectTableSink;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sinks.TableSinkUtils$;
import org.apache.flink.table.sinks.UpsertStreamTableSink;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.table.util.DummyStreamExecutionEnvironment;
import org.apache.flink.table.util.JavaScalaConversionUtil$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t-e\u0001B\u0001\u0003\u00015\u0011Qb\u0015;sK\u0006l\u0007\u000b\\1o]\u0016\u0014(BA\u0002\u0005\u0003\u001d\u0001H.\u00198oKJT!!\u0002\u0004\u0002\u000bQ\f'\r\\3\u000b\u0005\u001dA\u0011!\u00024mS:\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dY\u0001\"a\u0004\u000b\u000e\u0003AQ!!\u0005\n\u0002\t1\fgn\u001a\u0006\u0002'\u0005!!.\u0019<b\u0013\t)\u0002C\u0001\u0004PE*,7\r\u001e\t\u0003/ii\u0011\u0001\u0007\u0006\u00033\u0011\t!\u0002Z3mK\u001e\fG/[8o\u0013\tY\u0002DA\u0004QY\u0006tg.\u001a:\t\u0011u\u0001!\u0011!Q\u0001\ny\t\u0001\"\u001a=fGV$xN\u001d\t\u0003/}I!\u0001\t\r\u0003\u0011\u0015CXmY;u_JD\u0001B\t\u0001\u0003\u0002\u0003\u0006IaI\u0001\u0007G>tg-[4\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019\"\u0011aA1qS&\u0011\u0001&\n\u0002\f)\u0006\u0014G.Z\"p]\u001aLw\r\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003,\u0003=1WO\\2uS>t7)\u0019;bY><\u0007C\u0001\u00170\u001b\u0005i#B\u0001\u0018\u0005\u0003\u001d\u0019\u0017\r^1m_\u001eL!\u0001M\u0017\u0003\u001f\u0019+hn\u0019;j_:\u001c\u0015\r^1m_\u001eD\u0001B\r\u0001\u0003\u0002\u0003\u0006IaM\u0001\u000fG\u0006$\u0018\r\\8h\u001b\u0006t\u0017mZ3s!\taC'\u0003\u00026[\tq1)\u0019;bY><W*\u00198bO\u0016\u0014\b\"B\u001c\u0001\t\u0003A\u0014A\u0002\u001fj]&$h\bF\u0003:wqjd\b\u0005\u0002;\u00015\t!\u0001C\u0003\u001em\u0001\u0007a\u0004C\u0003#m\u0001\u00071\u0005C\u0003+m\u0001\u00071\u0006C\u00033m\u0001\u00071\u0007C\u0004A\u0001\t\u0007I\u0011B!\u0002\u001d%tG/\u001a:oC2\u001c6\r[3nCV\t!\t\u0005\u0002D\u00116\tAI\u0003\u0002F\r\u0006!!\u000e\u001a2d\u0015\t9\u0005\"A\u0004dC2\u001c\u0017\u000e^3\n\u0005%#%!D\"bY\u000eLG/Z*dQ\u0016l\u0017\r\u0003\u0004L\u0001\u0001\u0006IAQ\u0001\u0010S:$XM\u001d8bYN\u001b\u0007.Z7bA!9Q\n\u0001b\u0001\n\u0013q\u0015\u0001E3yaJ,7o]5p]\n\u0013\u0018\u000eZ4f+\u0005y\u0005c\u0001)T+6\t\u0011K\u0003\u0002S\t\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\t!\u0016K\u0001\tFqB\u0014Xm]:j_:\u0014%/\u001b3hKB\u0011\u0001KV\u0005\u0003/F\u0013\u0011\u0003\u00157b]:,'/\u0012=qe\u0016\u001c8/[8o\u0011\u0019I\u0006\u0001)A\u0005\u001f\u0006\tR\r\u001f9sKN\u001c\u0018n\u001c8Ce&$w-\u001a\u0011\t\u000fm\u0003!\u0019!C\u00059\u0006a\u0002\u000f\\1o]&twmQ8oM&<WO]1uS>t')^5mI\u0016\u0014X#A/\u0011\u0005ir\u0016BA0\u0003\u0005q\u0001F.\u00198oS:<7i\u001c8gS\u001e,(/\u0019;j_:\u0014U/\u001b7eKJDa!\u0019\u0001!\u0002\u0013i\u0016!\b9mC:t\u0017N\\4D_:4\u0017nZ;sCRLwN\u001c\"vS2$WM\u001d\u0011\t\u0011\r\u0004!\u0019!C\u0001\r\u0011\f\u0011b\u001c9uS6L'0\u001a:\u0016\u0003\u0015\u0004\"AZ5\u000e\u0003\u001dT!\u0001\u001b\u0003\u0002\tAd\u0017M\\\u0005\u0003U\u001e\u0014qb\u0015;sK\u0006lw\n\u001d;j[&TXM\u001d\u0005\u0007Y\u0002\u0001\u000b\u0011B3\u0002\u0015=\u0004H/[7ju\u0016\u0014\b\u0005\u000b\u0002l]B\u0011qN]\u0007\u0002a*\u0011\u0011OB\u0001\u000bC:tw\u000e^1uS>t\u0017BA:q\u0005E1\u0016n]5cY\u00164uN\u001d+fgRLgn\u001a\u0005\bk\u0002\u0011\r\u0011\"\u0003w\u0003\u0019\u0001\u0018M]:feV\tq\u000f\u0005\u0002\u0018q&\u0011\u0011\u0010\u0007\u0002\u0007!\u0006\u00148/\u001a:\t\rm\u0004\u0001\u0015!\u0003x\u0003\u001d\u0001\u0018M]:fe\u0002BQ! \u0001\u0005By\f\u0011bZ3u!\u0006\u00148/\u001a:\u0015\u0003]Dq!!\u0001\u0001\t\u0003\n\u0019!A\u0005ue\u0006t7\u000f\\1uKR!\u0011QAA\u001f!\u0019\t9!!\u0004\u0002\u00125\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u0017\u0011\u0012\u0001B;uS2LA!a\u0004\u0002\n\t!A*[:ua\u0011\t\u0019\"!\n\u0011\r\u0005U\u0011QDA\u0011\u001b\t\t9B\u0003\u0003\u0002\u001a\u0005m\u0011a\u00013bO*\u0011aEB\u0005\u0005\u0003?\t9B\u0001\bUe\u0006t7OZ8s[\u0006$\u0018n\u001c8\u0011\t\u0005\r\u0012Q\u0005\u0007\u0001\t-\t9c`A\u0001\u0002\u0003\u0015\t!!\u000b\u0003\u0007}#\u0013'\u0005\u0003\u0002,\u0005]\u0002\u0003BA\u0017\u0003gi!!a\f\u000b\u0005\u0005E\u0012!B:dC2\f\u0017\u0002BA\u001b\u0003_\u0011qAT8uQ&tw\r\u0005\u0003\u0002.\u0005e\u0012\u0002BA\u001e\u0003_\u00111!\u00118z\u0011\u001d\tyd a\u0001\u0003\u0003\nq\u0002^1cY\u0016|\u0005/\u001a:bi&|gn\u001d\t\u0007\u0003\u000f\ti!a\u0011\u0011\t\u0005\u0015\u00131J\u0007\u0003\u0003\u000fR1!!\u0013\u0005\u0003)y\u0007/\u001a:bi&|gn]\u0005\u0005\u0003\u001b\n9EA\bN_\u0012Lg-_(qKJ\fG/[8o\u0011\u001d\t\t\u0006\u0001C!\u0003'\nq!\u001a=qY\u0006Lg\u000e\u0006\u0004\u0002V\u0005\r\u0014Q\u000e\t\u0005\u0003/\niF\u0004\u0003\u0002.\u0005e\u0013\u0002BA.\u0003_\ta\u0001\u0015:fI\u00164\u0017\u0002BA0\u0003C\u0012aa\u0015;sS:<'\u0002BA.\u0003_A\u0001\"!\u0013\u0002P\u0001\u0007\u0011Q\r\t\u0007\u0003\u000f\ti!a\u001a\u0011\t\u0005\u0015\u0013\u0011N\u0005\u0005\u0003W\n9EA\u0005Pa\u0016\u0014\u0018\r^5p]\"A\u0011qNA(\u0001\u0004\t\t(\u0001\u0007fqR\u0014\u0018\rR3uC&d7\u000f\u0005\u0004\u0002.\u0005M\u0014qO\u0005\u0005\u0003k\nyC\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u00022\u0001JA=\u0013\r\tY(\n\u0002\u000e\u000bb\u0004H.Y5o\t\u0016$\u0018-\u001b7\t\u000f\u0005}\u0004\u0001\"\u0003\u0002\u0002\u0006qAO]1og2\fG/\u001a+p%\u0016dG\u0003BAB\u00037\u0003\u0002\"!\f\u0002\u0006\u0006%\u0015QS\u0005\u0005\u0003\u000f\u000byC\u0001\u0004UkBdWM\r\t\u0005\u0003\u0017\u000b\t*\u0004\u0002\u0002\u000e*\u0019\u0011q\u0012$\u0002\u0007I,G.\u0003\u0003\u0002\u0014\u00065%a\u0002*fY:{G-\u001a\t\u0005\u0003[\t9*\u0003\u0003\u0002\u001a\u0006=\"a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003;\u000bi\b1\u0001\u0002D\u0005yQn\u001c3jMf|\u0005/\u001a:bi&|g\u000eC\u0004\u0002\"\u0002!I!a)\u0002\u001f\u001d,GO\u00127j].\u0004F.\u00198oKJ,\"!!*\u0011\t\u0005\u001d\u00161V\u0007\u0003\u0003SS!a\u0012\u0003\n\t\u00055\u0016\u0011\u0016\u0002\u0011\r2Lgn\u001b)mC:tWM]%na2D\u0001\"!-\u0001\t\u00031\u00111W\u0001\u000eO\u0016$(+\u001a7Ck&dG-\u001a:\u0016\u0005\u0005U\u0006\u0003BAT\u0003oKA!!/\u0002*\nya\t\\5oWJ+GNQ;jY\u0012,'\u000f\u0003\u0005\u0002>\u0002!\tABA`\u0003%9W\r^\"p]\u001aLw-F\u0001$\u0011!\t\u0019\r\u0001C\u0001\r\u0005\u0015\u0017aF4fi\u0016CXmY;uS>tWI\u001c<je>tW.\u001a8u+\t\t9\r\u0005\u0003\u0002J\u0006UWBAAf\u0015\u0011\ti-a4\u0002\u0017\u0015tg/\u001b:p]6,g\u000e\u001e\u0006\u0004M\u0005E'bAAj\r\u0005I1\u000f\u001e:fC6LgnZ\u0005\u0005\u0003/\fYM\u0001\u000eTiJ,\u0017-\\#yK\u000e,H/[8o\u000b:4\u0018N]8o[\u0016tG\u000fC\u0004\u0002\\\u0002!I!!8\u0002\u001fQ\u0014\u0018M\\:mCR,Gk\\\"S_^$b!a8\u0002|\u0006u\bCBAq\u0003O\fY/\u0004\u0002\u0002d*!\u0011Q]Ah\u0003)!\u0017\r^1tiJ,\u0017-\\\u0005\u0005\u0003S\f\u0019O\u0001\u0006ECR\f7\u000b\u001e:fC6\u0004B!!<\u0002x6\u0011\u0011q\u001e\u0006\u0005\u0003c\f\u00190A\u0003usB,7OC\u0002\u0002v\u0012\tqA];oi&lW-\u0003\u0003\u0002z\u0006=(\u0001B\"S_^DaaAAm\u0001\u0004I\u0004\u0002CA\u0000\u00033\u0004\r!!#\u0002\u00171|w-[2bYBc\u0017M\u001c\u0005\b\u0005\u0007\u0001A\u0011\u0002B\u0003\u0003-9(/\u001b;f)>\u001c\u0016N\\6\u0016\t\t\u001d!Q\u0005\u000b\t\u0003\u0007\u0013IAa\u0005\u0003*!A!1\u0002B\u0001\u0001\u0004\u0011i!\u0001\buC\ndWm\u00149fe\u0006$\u0018n\u001c8\u0011\t\u0005\u0015#qB\u0005\u0005\u0005#\t9E\u0001\bRk\u0016\u0014\u0018p\u00149fe\u0006$\u0018n\u001c8\t\u0011\tU!\u0011\u0001a\u0001\u0005/\tAa]5oWB1!\u0011\u0004B\u0010\u0005Gi!Aa\u0007\u000b\u0007\tuA!A\u0003tS:\\7/\u0003\u0003\u0003\"\tm!!\u0003+bE2,7+\u001b8l!\u0011\t\u0019C!\n\u0005\u0011\t\u001d\"\u0011\u0001b\u0001\u0003S\u0011\u0011\u0001\u0016\u0005\t\u0005W\u0011\t\u00011\u0001\u0002V\u0005A1/\u001b8l\u001d\u0006lW\rC\u0004\u00030\u0001!IA!\r\u0002\u0019\u001d,G\u000fV1cY\u0016\u001c\u0016N\\6\u0015\t\tM\"1\t\t\u0007\u0003[\u0011)D!\u000f\n\t\t]\u0012q\u0006\u0002\u0007\u001fB$\u0018n\u001c81\t\tm\"q\b\t\u0007\u00053\u0011yB!\u0010\u0011\t\u0005\r\"q\b\u0003\r\u0005\u0003\u0012i#!A\u0001\u0002\u000b\u0005\u0011\u0011\u0006\u0002\u0004?\u0012\u001a\u0004\u0002\u0003B#\u0005[\u0001\rAa\u0012\u0002!=\u0014'.Z2u\u0013\u0012,g\u000e^5gS\u0016\u0014\bc\u0001\u0017\u0003J%\u0019!1J\u0017\u0003!=\u0013'.Z2u\u0013\u0012,g\u000e^5gS\u0016\u0014\bb\u0002B(\u0001\u0011%!\u0011K\u0001\u0013GJ,\u0017\r^3Ek6l\u0017\u0010\u00157b]:,'\u000fF\u0001:\u0011\u001d\u0011)\u0006\u0001C!\u0005/\n1bZ3u\u0015N|g\u000e\u00157b]R!\u0011Q\u000bB-\u0011!\u0011YFa\u0015A\u0002\u0005\u0005\u0013\u0001E7pI&4\u0017p\u00149fe\u0006$\u0018n\u001c8t\u0011\u001d\u0011y\u0006\u0001C!\u0005C\nq\"\u001a=qY\u0006LgNS:p]Bc\u0017M\u001c\u000b\u0007\u0003+\u0012\u0019Ga\u001a\t\u0011\t\u0015$Q\fa\u0001\u0003+\n\u0001B[:p]Bc\u0017M\u001c\u0005\t\u0003_\u0012i\u00061\u0001\u0002r!9!1\u000e\u0001\u0005B\t5\u0014!\u0005;sC:\u001cH.\u0019;f\u0015N|g\u000e\u00157b]R!!q\u000eB>!\u0019\t9!!\u0004\u0003rA\"!1\u000fB<!\u0019\t)\"!\b\u0003vA!\u00111\u0005B<\t1\u0011IH!\u001b\u0002\u0002\u0003\u0005)\u0011AA\u0015\u0005\ryF\u0005\u000f\u0005\t\u0005K\u0012I\u00071\u0001\u0002V!9!q\u0010\u0001\u0005\n\t\u0005\u0015\u0001C8qi&l\u0017N_3\u0015\r\u0005%%1\u0011BD\u0011!\u0011)I! A\u0002\u0005%\u0015aA1ti\"A!\u0011\u0012B?\u0001\u0004\t)*A\nva\u0012\fG/Z:BgJ+GO]1di&|g\u000e")
public class StreamPlanner
implements Planner {
    private final Executor executor;
    public final TableConfig org$apache$flink$table$planner$StreamPlanner$$config;
    private final FunctionCatalog functionCatalog;
    private final CatalogManager catalogManager;
    private final CalciteSchema internalSchema;
    private final ExpressionBridge<PlannerExpression> expressionBridge;
    private final PlanningConfigurationBuilder org$apache$flink$table$planner$StreamPlanner$$planningConfigurationBuilder;
    @VisibleForTesting
    private final StreamOptimizer optimizer;
    private final Parser parser;

    private CalciteSchema internalSchema() {
        return this.internalSchema;
    }

    private ExpressionBridge<PlannerExpression> expressionBridge() {
        return this.expressionBridge;
    }

    public PlanningConfigurationBuilder org$apache$flink$table$planner$StreamPlanner$$planningConfigurationBuilder() {
        return this.org$apache$flink$table$planner$StreamPlanner$$planningConfigurationBuilder;
    }

    public StreamOptimizer optimizer() {
        return this.optimizer;
    }

    private Parser parser() {
        return this.parser;
    }

    public Parser getParser() {
        return this.parser();
    }

    public List<Transformation<?>> translate(List<ModifyOperation> tableOperations) {
        StreamPlanner planner = this.createDummyPlanner();
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(tableOperations).asScala()).map((Function1)new Serializable(this, planner){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamPlanner $outer;
            private final StreamPlanner planner$1;

            public final Transformation<?> apply(ModifyOperation operation) {
                Tuple2<RelNode, Object> tuple2 = this.$outer.org$apache$flink$table$planner$StreamPlanner$$translateToRel(operation);
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    RelNode ast = (RelNode)tuple2._1();
                    boolean updatesAsRetraction = tuple2._2$mcZ$sp();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)ast, (Object)BoxesRunTime.boxToBoolean((boolean)updatesAsRetraction));
                    RelNode ast2 = (RelNode)tuple23._1();
                    boolean updatesAsRetraction2 = tuple23._2$mcZ$sp();
                    RelNode optimizedPlan = this.$outer.org$apache$flink$table$planner$StreamPlanner$$optimize(ast2, updatesAsRetraction2);
                    DataStream<CRow> dataStream = this.$outer.org$apache$flink$table$planner$StreamPlanner$$translateToCRow(this.planner$1, optimizedPlan);
                    return dataStream.getTransformation();
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.planner$1 = planner$1;
            }
        }, Buffer$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Object x$1) {
                return Objects.nonNull(x$1);
            }
        })).asJava();
    }

    public String explain(List<Operation> operations, Seq<ExplainDetail> extraDetails) {
        Predef$.MODULE$.require(((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(operations).asScala()).nonEmpty(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "operations should not be empty";
            }
        });
        Buffer astWithUpdatesAsRetractionTuples = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(operations).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamPlanner $outer;

            public final Tuple2<RelNode, Object> apply(Operation x0$1) {
                Operation operation;
                block7: {
                    Tuple2<RelNode, Object> tuple2;
                    block6: {
                        block5: {
                            Tuple2<RelNode, Object> tuple22;
                            operation = x0$1;
                            if (!(operation instanceof QueryOperation)) break block5;
                            QueryOperation queryOperation = (QueryOperation)operation;
                            RelNode relNode = this.$outer.getRelBuilder().tableOperation(queryOperation).build();
                            RelNode relNode2 = relNode;
                            if (relNode2 instanceof LogicalTableModify) {
                                LogicalTableModify logicalTableModify = (LogicalTableModify)relNode2;
                                List<String> qualifiedName = logicalTableModify.getTable().getQualifiedName();
                                Predef$.MODULE$.require(qualifiedName.size() == 3, (Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "the length of qualified name should be 3.";
                                    }
                                });
                                CatalogSinkModifyOperation modifyOperation = new CatalogSinkModifyOperation(ObjectIdentifier.of((String)qualifiedName.get(0), (String)qualifiedName.get(1), (String)qualifiedName.get(2)), (QueryOperation)new PlannerQueryOperation(logicalTableModify.getInput()));
                                tuple22 = this.$outer.org$apache$flink$table$planner$StreamPlanner$$translateToRel((ModifyOperation)modifyOperation);
                            } else {
                                tuple22 = new Tuple2<RelNode, Object>((Object)relNode, (Object)BoxesRunTime.boxToBoolean((boolean)false));
                            }
                            tuple2 = tuple22;
                            break block6;
                        }
                        if (!(operation instanceof ModifyOperation)) break block7;
                        ModifyOperation modifyOperation = (ModifyOperation)operation;
                        tuple2 = this.$outer.org$apache$flink$table$planner$StreamPlanner$$translateToRel(modifyOperation);
                    }
                    return tuple2;
                }
                throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported operation: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation.getClass().getCanonicalName()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        Buffer optimizedNodes = (Buffer)astWithUpdatesAsRetractionTuples.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamPlanner $outer;

            public final RelNode apply(Tuple2<RelNode, Object> x0$2) {
                Tuple2<RelNode, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    RelNode ast = (RelNode)tuple2._1();
                    boolean updatesAsRetraction = tuple2._2$mcZ$sp();
                    RelNode relNode = this.$outer.org$apache$flink$table$planner$StreamPlanner$$optimize(ast, updatesAsRetraction);
                    return relNode;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        StreamPlanner planner = this.createDummyPlanner();
        Buffer dataStreams = (Buffer)optimizedNodes.map((Function1)new Serializable(this, planner){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamPlanner $outer;
            private final StreamPlanner planner$2;

            public final DataStream<CRow> apply(RelNode p) {
                return this.$outer.org$apache$flink$table$planner$StreamPlanner$$translateToCRow(this.planner$2, p);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.planner$2 = planner$2;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        String astPlan = ((TraversableOnce)astWithUpdatesAsRetractionTuples.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<RelNode, Object> p) {
                return RelOptUtil.toString((RelNode)p._1());
            }
        }, Buffer$.MODULE$.canBuildFrom())).mkString(System.lineSeparator());
        String optimizedPlan = ((TraversableOnce)optimizedNodes.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(RelNode x$1) {
                return RelOptUtil.toString(x$1);
            }
        }, Buffer$.MODULE$.canBuildFrom())).mkString(System.lineSeparator());
        StreamExecutionEnvironment env = ((DataStream)dataStreams.head()).getExecutionEnvironment();
        String jsonSqlPlan = env.getExecutionPlan();
        String sqlPlan = PlanJsonParser.getSqlExecutionPlan(jsonSqlPlan, Predef$.MODULE$.boolean2Boolean(false));
        String explanation = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"== Abstract Syntax Tree =="})).s((Seq)Nil$.MODULE$)).append((Object)System.lineSeparator()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{astPlan}))).append((Object)System.lineSeparator()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"== Optimized Logical Plan =="})).s((Seq)Nil$.MODULE$)).append((Object)System.lineSeparator()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{optimizedPlan}))).append((Object)System.lineSeparator()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"== Physical Execution Plan =="})).s((Seq)Nil$.MODULE$)).append((Object)System.lineSeparator()).toString();
        return extraDetails.contains((Object)ExplainDetail.JSON_EXECUTION_PLAN) ? new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{explanation}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jsonSqlPlan}))).toString() : new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{explanation}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sqlPlan}))).toString();
    }

    public Tuple2<RelNode, Object> org$apache$flink$table$planner$StreamPlanner$$translateToRel(ModifyOperation modifyOperation) {
        block9: {
            OutputConversionModifyOperation.UpdateMode updateMode;
            block13: {
                Tuple2.mcZZ.sp sp2;
                block14: {
                    Tuple2 tuple2;
                    block5: {
                        Tuple2.mcZZ.sp sp3;
                        Tuple2.mcZZ.sp sp4;
                        OutputConversionModifyOperation outputConversionModifyOperation;
                        block11: {
                            block12: {
                                block10: {
                                    ModifyOperation modifyOperation2;
                                    block7: {
                                        Option option;
                                        CatalogSinkModifyOperation catalogSinkModifyOperation;
                                        block8: {
                                            Tuple2 t;
                                            Tuple2 tuple22;
                                            block6: {
                                                block4: {
                                                    modifyOperation2 = modifyOperation;
                                                    if (!(modifyOperation2 instanceof UnregisteredSinkModifyOperation)) break block4;
                                                    UnregisteredSinkModifyOperation unregisteredSinkModifyOperation = (UnregisteredSinkModifyOperation)modifyOperation2;
                                                    tuple2 = this.org$apache$flink$table$planner$StreamPlanner$$writeToSink(unregisteredSinkModifyOperation.getChild(), unregisteredSinkModifyOperation.getSink(), "UnregisteredSink");
                                                    break block5;
                                                }
                                                if (!(modifyOperation2 instanceof CollectModifyOperation)) break block6;
                                                CollectModifyOperation collectModifyOperation = (CollectModifyOperation)modifyOperation2;
                                                StreamSelectTableSink sink = new StreamSelectTableSink(TableSchema.fromResolvedSchema((ResolvedSchema)collectModifyOperation.getChild().getResolvedSchema()));
                                                collectModifyOperation.setSelectResultProvider(sink.getSelectResultProvider());
                                                tuple2 = this.org$apache$flink$table$planner$StreamPlanner$$writeToSink(collectModifyOperation.getChild(), (TableSink)sink, "collect");
                                                break block5;
                                            }
                                            if (!(modifyOperation2 instanceof CatalogSinkModifyOperation)) break block7;
                                            catalogSinkModifyOperation = (CatalogSinkModifyOperation)modifyOperation2;
                                            option = this.getTableSink(catalogSinkModifyOperation.getTableIdentifier()).map((Function1)new Serializable(this, catalogSinkModifyOperation){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ StreamPlanner $outer;
                                                private final CatalogSinkModifyOperation x4$1;

                                                public final Tuple2<RelNode, Object> apply(TableSink<?> sink) {
                                                    TableSinkUtils$.MODULE$.validateSink(this.x4$1.getStaticPartitions(), this.x4$1.getChild(), this.x4$1.getTableIdentifier(), sink);
                                                    TableSink<?> tableSink = sink;
                                                    if (tableSink instanceof PartitionableTableSink) {
                                                        PartitionableTableSink partitionableTableSink = (PartitionableTableSink)tableSink;
                                                        partitionableTableSink.setStaticPartition(this.x4$1.getStaticPartitions());
                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    } else {
                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    }
                                                    TableSink<?> tableSink2 = sink;
                                                    if (tableSink2 instanceof OverwritableTableSink) {
                                                        OverwritableTableSink overwritableTableSink = (OverwritableTableSink)tableSink2;
                                                        overwritableTableSink.setOverwrite(this.x4$1.isOverwrite());
                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    } else {
                                                        Predef$.MODULE$.assert(!this.x4$1.isOverwrite(), (Function0)new Serializable(this, sink){
                                                            public static final long serialVersionUID = 0L;
                                                            private final TableSink sink$1;

                                                            public final String apply() {
                                                                return new StringBuilder().append((Object)"INSERT OVERWRITE requires ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " but actually got "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{OverwritableTableSink.class.getSimpleName()}))).append((Object)this.sink$1.getClass().getName()).toString();
                                                            }
                                                            {
                                                                this.sink$1 = sink$1;
                                                            }
                                                        });
                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    }
                                                    return this.$outer.org$apache$flink$table$planner$StreamPlanner$$writeToSink(this.x4$1.getChild(), sink, this.x4$1.getTableIdentifier().asSummaryString());
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw null;
                                                    }
                                                    this.$outer = $outer;
                                                    this.x4$1 = x4$1;
                                                }
                                            });
                                            if (!(option instanceof Some)) break block8;
                                            Some some = (Some)option;
                                            tuple2 = tuple22 = (t = (Tuple2)some.x());
                                            break block5;
                                        }
                                        if (None$.MODULE$.equals(option)) {
                                            throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sink ", " does not exists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{catalogSinkModifyOperation.getTableIdentifier()})));
                                        }
                                        throw new MatchError((Object)option);
                                    }
                                    if (!(modifyOperation2 instanceof OutputConversionModifyOperation)) break block9;
                                    outputConversionModifyOperation = (OutputConversionModifyOperation)modifyOperation2;
                                    updateMode = outputConversionModifyOperation.getUpdateMode();
                                    if (!OutputConversionModifyOperation.UpdateMode.RETRACT.equals(updateMode)) break block10;
                                    sp4 = new Tuple2.mcZZ.sp(true, true);
                                    break block11;
                                }
                                if (!OutputConversionModifyOperation.UpdateMode.APPEND.equals(updateMode)) break block12;
                                sp4 = new Tuple2.mcZZ.sp(false, false);
                                break block11;
                            }
                            if (!OutputConversionModifyOperation.UpdateMode.UPSERT.equals(updateMode)) break block13;
                            sp4 = new Tuple2.mcZZ.sp(false, true);
                        }
                        sp2 = sp4;
                        if (sp2 == null) break block14;
                        boolean isRetract = sp2._1$mcZ$sp();
                        boolean withChangeFlag = sp2._2$mcZ$sp();
                        Tuple2.mcZZ.sp sp5 = sp3 = new Tuple2.mcZZ.sp(isRetract, withChangeFlag);
                        boolean isRetract2 = sp5._1$mcZ$sp();
                        boolean withChangeFlag2 = sp5._2$mcZ$sp();
                        DataStreamTableSink tableSink = new DataStreamTableSink(TableSchema.fromResolvedSchema((ResolvedSchema)outputConversionModifyOperation.getChild().getResolvedSchema()), TypeConversions.fromDataTypeToLegacyInfo((DataType)outputConversionModifyOperation.getType()), withChangeFlag2);
                        RelNode input = this.getRelBuilder().tableOperation(modifyOperation.getChild()).build();
                        LogicalSink sink = LogicalSink$.MODULE$.create(input, tableSink, "DataStreamTableSink");
                        tuple2 = new Tuple2((Object)sink, (Object)BoxesRunTime.boxToBoolean((boolean)isRetract2));
                    }
                    return tuple2;
                }
                throw new MatchError((Object)sp2);
            }
            throw new MatchError((Object)updateMode);
        }
        throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported ModifyOperation: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{modifyOperation})));
    }

    public FlinkPlannerImpl org$apache$flink$table$planner$StreamPlanner$$getFlinkPlanner() {
        String currentCatalogName = this.catalogManager.getCurrentCatalog();
        String currentDatabase = this.catalogManager.getCurrentDatabase();
        return this.org$apache$flink$table$planner$StreamPlanner$$planningConfigurationBuilder().createFlinkPlanner(currentCatalogName, currentDatabase);
    }

    public FlinkRelBuilder getRelBuilder() {
        String currentCatalogName = this.catalogManager.getCurrentCatalog();
        String currentDatabase = this.catalogManager.getCurrentDatabase();
        return this.org$apache$flink$table$planner$StreamPlanner$$planningConfigurationBuilder().createRelBuilder(currentCatalogName, currentDatabase);
    }

    public TableConfig getConfig() {
        return this.org$apache$flink$table$planner$StreamPlanner$$config;
    }

    public StreamExecutionEnvironment getExecutionEnvironment() {
        return ((StreamExecutor)this.executor).getExecutionEnvironment();
    }

    public DataStream<CRow> org$apache$flink$table$planner$StreamPlanner$$translateToCRow(StreamPlanner planner, RelNode logicalPlan) {
        RelNode relNode = logicalPlan;
        if (relNode instanceof DataStreamRel) {
            DataStreamRel dataStreamRel = (DataStreamRel)relNode;
            this.getExecutionEnvironment().configure((ReadableConfig)this.org$apache$flink$table$planner$StreamPlanner$$config.getConfiguration(), Thread.currentThread().getContextClassLoader());
            DataStream<CRow> dataStream = dataStreamRel.translateToPlan(planner);
            return dataStream;
        }
        throw new TableException("Cannot generate DataStream due to an invalid logical plan. This is a bug and should not happen. Please file an issue.");
    }

    public <T> Tuple2<RelNode, Object> org$apache$flink$table$planner$StreamPlanner$$writeToSink(QueryOperation tableOperation, TableSink<T> sink, String sinkName) {
        block8: {
            boolean bl;
            block6: {
                TableSink<T> tableSink;
                block7: {
                    block5: {
                        tableSink = sink;
                        if (!(tableSink instanceof RetractStreamTableSink)) break block5;
                        RetractStreamTableSink retractStreamTableSink = (RetractStreamTableSink)tableSink;
                        RetractStreamTableSink retractStreamTableSink2 = retractStreamTableSink;
                        if (retractStreamTableSink2 instanceof PartitionableTableSink) {
                            throw new TableException("Partitionable sink in retract stream mode is not supported yet!");
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        bl = true;
                        break block6;
                    }
                    if (!(tableSink instanceof UpsertStreamTableSink)) break block7;
                    UpsertStreamTableSink upsertStreamTableSink = (UpsertStreamTableSink)tableSink;
                    UpsertStreamTableSink upsertStreamTableSink2 = upsertStreamTableSink;
                    if (upsertStreamTableSink2 instanceof PartitionableTableSink) {
                        throw new TableException("Partitionable sink in upsert stream mode is not supported yet!");
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    bl = false;
                    break block6;
                }
                if (!(tableSink instanceof AppendStreamTableSink)) break block8;
                bl = false;
            }
            boolean updatesAsRetraction = bl;
            RelNode input = this.getRelBuilder().tableOperation(tableOperation).build();
            return new Tuple2((Object)LogicalSink$.MODULE$.create(input, sink, sinkName), (Object)BoxesRunTime.boxToBoolean((boolean)updatesAsRetraction));
        }
        throw new ValidationException("Stream Tables can only be emitted by AppendStreamTableSink, RetractStreamTableSink, or UpsertStreamTableSink.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option<TableSink<?>> getTableSink(ObjectIdentifier objectIdentifier) {
        Option lookupResult = JavaScalaConversionUtil$.MODULE$.toScala(this.catalogManager.getTable(objectIdentifier));
        boolean bl = false;
        Some some = null;
        Option option = lookupResult.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final CatalogBaseTable apply(CatalogManager.TableLookupResult x$3) {
                return x$3.getTable();
            }
        });
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            CatalogBaseTable s = (CatalogBaseTable)some.x();
            if (s instanceof ConnectorCatalogTable) {
                return JavaScalaConversionUtil$.MODULE$.toScala(((ConnectorCatalogTable)s).getTableSink());
            }
        }
        if (!bl) return None$.MODULE$;
        CatalogBaseTable s = (CatalogBaseTable)some.x();
        if (!(s instanceof CatalogTable)) return None$.MODULE$;
        Optional catalog = this.catalogManager.getCatalog(objectIdentifier.getCatalogName());
        CatalogTable catalogTable = (CatalogTable)s;
        TableSinkFactoryContextImpl context = new TableSinkFactoryContextImpl(objectIdentifier, catalogTable, (ReadableConfig)this.org$apache$flink$table$planner$StreamPlanner$$config.getConfiguration(), false, ((CatalogManager.TableLookupResult)lookupResult.get()).isTemporary());
        if (!catalog.isPresent()) return Option$.MODULE$.apply((Object)TableFactoryUtil.findAndCreateTableSink((TableSinkFactory.Context)context));
        if (!((Catalog)catalog.get()).getTableFactory().isPresent()) return Option$.MODULE$.apply((Object)TableFactoryUtil.findAndCreateTableSink((TableSinkFactory.Context)context));
        Optional sink = TableFactoryUtil.createTableSinkForCatalogTable((Catalog)((Catalog)catalog.get()), (TableSinkFactory.Context)context);
        if (!sink.isPresent()) return Option$.MODULE$.apply((Object)TableFactoryUtil.findAndCreateTableSink((TableSinkFactory.Context)context));
        return Option$.MODULE$.apply(sink.get());
    }

    private StreamPlanner createDummyPlanner() {
        DummyStreamExecutionEnvironment dummyExecEnv = new DummyStreamExecutionEnvironment(this.getExecutionEnvironment());
        StreamExecutor executor = new StreamExecutor(dummyExecEnv);
        return new StreamPlanner(executor, this.org$apache$flink$table$planner$StreamPlanner$$config, this.functionCatalog, this.catalogManager);
    }

    public String getJsonPlan(List<ModifyOperation> modifyOperations) {
        throw new TableException("This method is not supported for legacy planner, please use Blink planner.");
    }

    public String explainJsonPlan(String jsonPlan, Seq<ExplainDetail> extraDetails) {
        throw new TableException("This method is not supported for legacy planner, please use Blink planner.");
    }

    public List<Transformation<?>> translateJsonPlan(String jsonPlan) {
        throw new TableException("This method is not supported for legacy planner, please use Blink planner.");
    }

    public RelNode org$apache$flink$table$planner$StreamPlanner$$optimize(RelNode ast, boolean updatesAsRetraction) {
        Configuration configuration = this.org$apache$flink$table$planner$StreamPlanner$$config.getConfiguration();
        if (((Enum)configuration.get(ExecutionOptions.RUNTIME_MODE)).equals(RuntimeExecutionMode.STREAMING) && ((Enum)configuration.get(TableConfigOptions.TABLE_PLANNER)).equals(PlannerType.OLD)) {
            return this.optimizer().optimize(ast, updatesAsRetraction, this.getRelBuilder());
        }
        throw new IllegalArgumentException(String.format("Mismatch between configured planner and actual planner. Currently, the 'execution.runtime-mode' and 'table.planner' can only be set when instantiating the table environment. Subsequent changes are not supported. Please instantiate a new TableEnvironment if necessary.", new Object[0]));
    }

    public String explainJsonPlan(String jsonPlan, ExplainDetail[] extraDetails) {
        return this.explainJsonPlan(jsonPlan, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])extraDetails));
    }

    public String explain(List<Operation> operations, ExplainDetail[] extraDetails) {
        return this.explain(operations, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])extraDetails));
    }

    public StreamPlanner(Executor executor, TableConfig config, FunctionCatalog functionCatalog, CatalogManager catalogManager) {
        this.executor = executor;
        this.org$apache$flink$table$planner$StreamPlanner$$config = config;
        this.functionCatalog = functionCatalog;
        this.catalogManager = catalogManager;
        functionCatalog.setPlannerTypeInferenceUtil(PlannerTypeInferenceUtilImpl.INSTANCE);
        this.internalSchema = CalciteSchemaBuilder.asRootSchema(new CatalogManagerCalciteSchema(catalogManager, config, true));
        this.expressionBridge = new ExpressionBridge(PlannerExpressionConverter$.MODULE$.INSTANCE());
        this.org$apache$flink$table$planner$StreamPlanner$$planningConfigurationBuilder = new PlanningConfigurationBuilder(config, functionCatalog, this.internalSchema(), this.expressionBridge());
        this.optimizer = new StreamOptimizer((Function0<CalciteConfig>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamPlanner $outer;

            public final CalciteConfig apply() {
                return this.$outer.org$apache$flink$table$planner$StreamPlanner$$config.getPlannerConfig().unwrap(CalciteConfig.class).orElse(CalciteConfig$.MODULE$.DEFAULT());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.org$apache$flink$table$planner$StreamPlanner$$planningConfigurationBuilder());
        this.parser = new ParserImpl(catalogManager, new Supplier<FlinkPlannerImpl>(this){
            private final /* synthetic */ StreamPlanner $outer;

            public FlinkPlannerImpl get() {
                return this.$outer.org$apache$flink$table$planner$StreamPlanner$$getFlinkPlanner();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Supplier<CalciteParser>(this){
            private final /* synthetic */ StreamPlanner $outer;

            public CalciteParser get() {
                return this.$outer.org$apache$flink$table$planner$StreamPlanner$$planningConfigurationBuilder().createCalciteParser();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

