/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.ExplicitReturnTypeInference;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.flink.calcite.shaded.com.google.common.base.Preconditions;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;

public class SqlGroupedWindowFunction
extends SqlFunction {
    public final SqlGroupedWindowFunction groupFunction;
    private final WindowStartEndReturnTypeInference windowStartEndInf = new WindowStartEndReturnTypeInference();

    public SqlGroupedWindowFunction(String name, SqlKind kind, SqlGroupedWindowFunction groupFunction, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker, SqlFunctionCategory category) {
        super(name, kind, returnTypeInference, operandTypeInference, operandTypeChecker, category);
        this.groupFunction = groupFunction;
        Preconditions.checkArgument(groupFunction == null || groupFunction.groupFunction == null);
    }

    public SqlGroupedWindowFunction(String name, SqlKind kind, SqlGroupedWindowFunction groupFunction, SqlOperandTypeChecker operandTypeChecker) {
        this(name, kind, groupFunction, ReturnTypes.ARG0, null, operandTypeChecker, SqlFunctionCategory.SYSTEM);
    }

    public SqlGroupedWindowFunction auxiliary(SqlKind kind) {
        return this.auxiliary(kind.name(), kind);
    }

    public SqlGroupedWindowFunction auxiliary(String name, SqlKind kind) {
        switch (kind) {
            case TUMBLE_START: 
            case TUMBLE_END: 
            case HOP_START: 
            case HOP_END: 
            case SESSION_START: 
            case SESSION_END: {
                return new SqlGroupedWindowFunction(name, kind, this, (SqlReturnTypeInference)this.windowStartEndInf, null, this.getOperandTypeChecker(), SqlFunctionCategory.SYSTEM);
            }
        }
        return new SqlGroupedWindowFunction(name, kind, this, ReturnTypes.ARG0, null, this.getOperandTypeChecker(), SqlFunctionCategory.SYSTEM);
    }

    public List<SqlGroupedWindowFunction> getAuxiliaryFunctions() {
        return ImmutableList.of();
    }

    @Override
    public boolean isGroup() {
        return this.groupFunction == null;
    }

    @Override
    public boolean isGroupAuxiliary() {
        return this.groupFunction != null;
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlOperatorBinding call) {
        return call.getOperandMonotonicity(0).unstrict();
    }

    private static class WindowStartEndReturnTypeInference
    implements SqlReturnTypeInference {
        private static final ExplicitReturnTypeInference explicit = ReturnTypes.explicit(SqlTypeName.TIMESTAMP, 3);

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            if (opBinding.getOperandType(0).getSqlTypeName().equals((Object)SqlTypeName.TIMESTAMP)) {
                return opBinding.getOperandType(0);
            }
            return explicit.inferReturnType(opBinding);
        }
    }
}

