/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.Strong;
import org.apache.calcite.rel.metadata.NullSentinel;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexAnalyzer;
import org.apache.calcite.rex.RexBiVisitor;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexInterpreter;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexTableInputRef;
import org.apache.calcite.rex.RexUnknownAs;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeCoercionRule;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.RangeSets;
import org.apache.calcite.util.Sarg;
import org.apache.calcite.util.Util;
import org.apache.flink.calcite.shaded.com.google.common.collect.ArrayListMultimap;
import org.apache.flink.calcite.shaded.com.google.common.collect.BoundType;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableRangeSet;
import org.apache.flink.calcite.shaded.com.google.common.collect.Iterables;
import org.apache.flink.calcite.shaded.com.google.common.collect.Range;
import org.apache.flink.calcite.shaded.com.google.common.collect.RangeSet;
import org.apache.flink.calcite.shaded.com.google.common.collect.Sets;
import org.apache.flink.calcite.shaded.com.google.common.collect.TreeRangeSet;

public class RexSimplify {
    private final boolean paranoid;
    public final RexBuilder rexBuilder;
    private final RelOptPredicateList predicates;
    final RexUnknownAs defaultUnknownAs;
    final boolean predicateElimination;
    private final RexExecutor executor;
    private final Strong strong;

    public RexSimplify(RexBuilder rexBuilder, RelOptPredicateList predicates, RexExecutor executor) {
        this(rexBuilder, predicates, RexUnknownAs.UNKNOWN, true, false, executor);
    }

    private RexSimplify(RexBuilder rexBuilder, RelOptPredicateList predicates, RexUnknownAs defaultUnknownAs, boolean predicateElimination, boolean paranoid, RexExecutor executor) {
        this.rexBuilder = Objects.requireNonNull(rexBuilder);
        this.predicates = Objects.requireNonNull(predicates);
        this.defaultUnknownAs = Objects.requireNonNull(defaultUnknownAs);
        this.predicateElimination = predicateElimination;
        this.paranoid = paranoid;
        this.executor = Objects.requireNonNull(executor);
        this.strong = new Strong();
    }

    @Deprecated
    public RexSimplify(RexBuilder rexBuilder, boolean unknownAsFalse, RexExecutor executor) {
        this(rexBuilder, RelOptPredicateList.EMPTY, RexUnknownAs.falseIf(unknownAsFalse), true, false, executor);
    }

    @Deprecated
    public RexSimplify(RexBuilder rexBuilder, RelOptPredicateList predicates, boolean unknownAsFalse, RexExecutor executor) {
        this(rexBuilder, predicates, RexUnknownAs.falseIf(unknownAsFalse), true, false, executor);
    }

    @Deprecated
    public RexSimplify withUnknownAsFalse(boolean unknownAsFalse) {
        RexUnknownAs defaultUnknownAs = RexUnknownAs.falseIf(unknownAsFalse);
        return defaultUnknownAs == this.defaultUnknownAs ? this : new RexSimplify(this.rexBuilder, this.predicates, defaultUnknownAs, this.predicateElimination, this.paranoid, this.executor);
    }

    public RexSimplify withPredicates(RelOptPredicateList predicates) {
        return predicates == this.predicates ? this : new RexSimplify(this.rexBuilder, predicates, this.defaultUnknownAs, this.predicateElimination, this.paranoid, this.executor);
    }

    public RexSimplify withParanoid(boolean paranoid) {
        return paranoid == this.paranoid ? this : new RexSimplify(this.rexBuilder, this.predicates, this.defaultUnknownAs, this.predicateElimination, paranoid, this.executor);
    }

    private RexSimplify withPredicateElimination(boolean predicateElimination) {
        return predicateElimination == this.predicateElimination ? this : new RexSimplify(this.rexBuilder, this.predicates, this.defaultUnknownAs, predicateElimination, this.paranoid, this.executor);
    }

    public RexNode simplifyPreservingType(RexNode e) {
        return this.simplifyPreservingType(e, this.defaultUnknownAs, true);
    }

    public RexNode simplifyPreservingType(RexNode e, RexUnknownAs unknownAs, boolean matchNullability) {
        RexNode e2 = this.simplifyUnknownAs(e, unknownAs);
        if (e2.getType() == e.getType()) {
            return e2;
        }
        if (!matchNullability && SqlTypeUtil.equalSansNullability(this.rexBuilder.typeFactory, e2.getType(), e.getType())) {
            return e2;
        }
        RexNode e3 = this.rexBuilder.makeCast(e.getType(), e2, matchNullability);
        if (e3.equals(e)) {
            return e;
        }
        return e3;
    }

    public RexNode simplify(RexNode e) {
        return this.simplifyUnknownAs(e, this.defaultUnknownAs);
    }

    public final RexNode simplifyUnknownAsFalse(RexNode e) {
        return this.simplifyUnknownAs(e, RexUnknownAs.FALSE);
    }

    public RexNode simplifyUnknownAs(RexNode e, RexUnknownAs unknownAs) {
        RexNode simplified = this.withParanoid(false).simplify(e, unknownAs);
        if (this.paranoid) {
            this.verify(e, simplified, unknownAs);
        }
        return simplified;
    }

    RexNode simplify(RexNode e, RexUnknownAs unknownAs) {
        if (this.strong.isNull(e)) {
            if (e.getType().getSqlTypeName() == SqlTypeName.BOOLEAN) {
                switch (unknownAs) {
                    case FALSE: 
                    case TRUE: {
                        return this.rexBuilder.makeLiteral(unknownAs.toBoolean());
                    }
                }
            }
            return this.rexBuilder.makeNullLiteral(e.getType());
        }
        switch (e.getKind()) {
            case AND: {
                return this.simplifyAnd((RexCall)e, unknownAs);
            }
            case OR: {
                return this.simplifyOr((RexCall)e, unknownAs);
            }
            case NOT: {
                return this.simplifyNot((RexCall)e, unknownAs);
            }
            case CASE: {
                return this.simplifyCase((RexCall)e, unknownAs);
            }
            case COALESCE: {
                return this.simplifyCoalesce((RexCall)e);
            }
            case CAST: {
                return this.simplifyCast((RexCall)e);
            }
            case CEIL: 
            case FLOOR: {
                return this.simplifyCeilFloor((RexCall)e);
            }
            case IS_NULL: 
            case IS_NOT_NULL: 
            case IS_TRUE: 
            case IS_NOT_TRUE: 
            case IS_FALSE: 
            case IS_NOT_FALSE: {
                assert (e instanceof RexCall);
                return this.simplifyIs((RexCall)e, unknownAs);
            }
            case EQUALS: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case NOT_EQUALS: {
                return this.simplifyComparison((RexCall)e, unknownAs);
            }
            case SEARCH: {
                return this.simplifySearch((RexCall)e, unknownAs);
            }
            case LIKE: {
                return this.simplifyLike((RexCall)e);
            }
            case MINUS_PREFIX: {
                return this.simplifyUnaryMinus((RexCall)e, unknownAs);
            }
            case PLUS_PREFIX: {
                return this.simplifyUnaryPlus((RexCall)e, unknownAs);
            }
        }
        if (e.getClass() == RexCall.class) {
            return this.simplifyGenericNode((RexCall)e);
        }
        return e;
    }

    private RexNode simplifyGenericNode(RexCall e) {
        ArrayList<RexNode> operands = new ArrayList<RexNode>(e.operands);
        this.simplifyList(operands, RexUnknownAs.UNKNOWN);
        if (e.operands.equals(operands)) {
            return e;
        }
        return this.rexBuilder.makeCall(e.getType(), e.getOperator(), operands);
    }

    private RexNode simplifyLike(RexCall e) {
        RexLiteral literal;
        if (e.operands.get(1) instanceof RexLiteral && (literal = (RexLiteral)e.operands.get(1)).getValueAs(String.class).equals("%")) {
            return this.rexBuilder.makeLiteral(true);
        }
        return this.simplifyGenericNode(e);
    }

    private RexNode simplifyComparison(RexCall e, RexUnknownAs unknownAs) {
        return this.simplifyComparison(e, unknownAs, Comparable.class);
    }

    private <C extends Comparable<C>> RexNode simplifyComparison(RexCall e, RexUnknownAs unknownAs, Class<C> clazz) {
        Comparison cmp;
        ArrayList<RexNode> operands = new ArrayList<RexNode>(e.operands);
        this.simplifyList(operands, RexUnknownAs.UNKNOWN);
        RexNode o0 = (RexNode)operands.get(0);
        RexNode o1 = (RexNode)operands.get(1);
        if (o0.equals(o1) && RexUtil.isDeterministic(o0)) {
            switch (e.getKind()) {
                case EQUALS: 
                case GREATER_THAN_OR_EQUAL: 
                case LESS_THAN_OR_EQUAL: {
                    RexNode newExpr = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, this.rexBuilder.makeNullLiteral(e.getType()), this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, o0));
                    return this.simplify(newExpr, unknownAs);
                }
                case GREATER_THAN: 
                case LESS_THAN: 
                case NOT_EQUALS: {
                    RexNode newExpr = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, this.rexBuilder.makeNullLiteral(e.getType()), this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, o0));
                    return this.simplify(newExpr, unknownAs);
                }
            }
        }
        if (o0.getType().getSqlTypeName() == SqlTypeName.BOOLEAN && (cmp = Comparison.of(this.rexBuilder.makeCall(e.getOperator(), o0, o1), node -> true)) != null) {
            if (cmp.literal.isAlwaysTrue()) {
                switch (cmp.kind) {
                    case EQUALS: 
                    case GREATER_THAN_OR_EQUAL: {
                        return cmp.ref;
                    }
                    case LESS_THAN: 
                    case NOT_EQUALS: {
                        return this.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, cmp.ref), unknownAs);
                    }
                    case GREATER_THAN: {
                        if (cmp.ref.getType().isNullable()) break;
                        return this.rexBuilder.makeLiteral(false);
                    }
                    case LESS_THAN_OR_EQUAL: {
                        if (cmp.ref.getType().isNullable()) break;
                        return this.rexBuilder.makeLiteral(true);
                    }
                }
            }
            if (cmp.literal.isAlwaysFalse()) {
                switch (cmp.kind) {
                    case EQUALS: 
                    case LESS_THAN_OR_EQUAL: {
                        return this.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, cmp.ref), unknownAs);
                    }
                    case GREATER_THAN: 
                    case NOT_EQUALS: {
                        return cmp.ref;
                    }
                    case GREATER_THAN_OR_EQUAL: {
                        if (cmp.ref.getType().isNullable()) break;
                        return this.rexBuilder.makeLiteral(true);
                    }
                    case LESS_THAN: {
                        if (cmp.ref.getType().isNullable()) break;
                        return this.rexBuilder.makeLiteral(false);
                    }
                }
            }
        }
        if (o0.isA(SqlKind.LITERAL) && o1.isA(SqlKind.LITERAL) && SqlTypeUtil.equalSansNullability(this.rexBuilder.getTypeFactory(), o0.getType(), o1.getType())) {
            Comparable v0 = (Comparable)((RexLiteral)o0).getValueAs(clazz);
            Comparable v1 = (Comparable)((RexLiteral)o1).getValueAs(clazz);
            if (v0 == null || v1 == null) {
                return unknownAs == RexUnknownAs.FALSE ? this.rexBuilder.makeLiteral(false) : this.rexBuilder.makeNullLiteral(e.getType());
            }
            int comparisonResult = v0.compareTo(v1);
            switch (e.getKind()) {
                case EQUALS: {
                    return this.rexBuilder.makeLiteral(comparisonResult == 0);
                }
                case GREATER_THAN: {
                    return this.rexBuilder.makeLiteral(comparisonResult > 0);
                }
                case GREATER_THAN_OR_EQUAL: {
                    return this.rexBuilder.makeLiteral(comparisonResult >= 0);
                }
                case LESS_THAN: {
                    return this.rexBuilder.makeLiteral(comparisonResult < 0);
                }
                case LESS_THAN_OR_EQUAL: {
                    return this.rexBuilder.makeLiteral(comparisonResult <= 0);
                }
                case NOT_EQUALS: {
                    return this.rexBuilder.makeLiteral(comparisonResult != 0);
                }
            }
            throw new AssertionError();
        }
        RexNode e2 = operands.equals(e.operands) ? e : this.rexBuilder.makeCall(e.op, operands);
        return this.simplifyUsingPredicates(e2, clazz);
    }

    @Deprecated
    public RexNode simplifyAnds(Iterable<? extends RexNode> nodes) {
        this.ensureParanoidOff();
        return this.simplifyAnds(nodes, this.defaultUnknownAs);
    }

    RexNode simplifyAnds(Iterable<? extends RexNode> nodes, RexUnknownAs unknownAs) {
        ArrayList<RexNode> terms = new ArrayList<RexNode>();
        ArrayList<RexNode> notTerms = new ArrayList<RexNode>();
        for (RexNode rexNode : nodes) {
            RelOptUtil.decomposeConjunction(rexNode, terms, notTerms);
        }
        this.simplifyList(terms, RexUnknownAs.UNKNOWN);
        this.simplifyList(notTerms, RexUnknownAs.UNKNOWN);
        if (unknownAs == RexUnknownAs.FALSE) {
            return this.simplifyAnd2ForUnknownAsFalse(terms, notTerms);
        }
        return this.simplifyAnd2(terms, notTerms);
    }

    private void simplifyList(List<RexNode> terms, RexUnknownAs unknownAs) {
        for (int i = 0; i < terms.size(); ++i) {
            terms.set(i, this.simplify(terms.get(i), unknownAs));
        }
    }

    private void simplifyAndTerms(List<RexNode> terms, RexUnknownAs unknownAs) {
        RexNode t;
        int i;
        RexSimplify simplify = this;
        for (i = 0; i < terms.size(); ++i) {
            t = terms.get(i);
            if (Predicate.of(t) == null) continue;
            terms.set(i, simplify.simplify(t, unknownAs));
            RelOptPredicateList newPredicates = simplify.predicates.union(this.rexBuilder, RelOptPredicateList.of(this.rexBuilder, terms.subList(i, i + 1)));
            simplify = simplify.withPredicates(newPredicates);
        }
        for (i = 0; i < terms.size(); ++i) {
            t = terms.get(i);
            if (Predicate.of(t) != null) continue;
            terms.set(i, simplify.simplify(t, unknownAs));
        }
    }

    private void simplifyOrTerms(List<RexNode> terms, RexUnknownAs unknownAs) {
        RexNode t;
        int i;
        RexSimplify simplify = this;
        BitSet doneTerms = new BitSet();
        for (i = 0; i < terms.size(); ++i) {
            t = terms.get(i);
            if (!simplify.allowedAsPredicateDuringOrSimplification(t)) continue;
            doneTerms.set(i);
            RexNode t2 = simplify.simplify(t, unknownAs);
            terms.set(i, t2);
            RexNode inverse = simplify.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_TRUE, t2), RexUnknownAs.UNKNOWN);
            RelOptPredicateList newPredicates = simplify.predicates.union(this.rexBuilder, RelOptPredicateList.of(this.rexBuilder, ImmutableList.of(inverse)));
            simplify = simplify.withPredicates(newPredicates);
        }
        for (i = 0; i < terms.size(); ++i) {
            t = terms.get(i);
            if (doneTerms.get(i)) continue;
            terms.set(i, simplify.simplify(t, unknownAs));
        }
    }

    private boolean allowedAsPredicateDuringOrSimplification(RexNode t) {
        Predicate predicate = Predicate.of(t);
        return predicate != null && predicate.allowedInOr(this.predicates);
    }

    private RexNode simplifyNot(RexCall call, RexUnknownAs unknownAs) {
        RexNode a = call.getOperands().get(0);
        switch (a.getKind()) {
            case NOT: {
                return this.simplify(((RexCall)a).getOperands().get(0), unknownAs);
            }
            case LITERAL: {
                if (a.getType().getSqlTypeName() != SqlTypeName.BOOLEAN || RexLiteral.isNullLiteral(a)) break;
                return this.rexBuilder.makeLiteral(!RexLiteral.booleanValue(a));
            }
        }
        SqlKind negateKind = a.getKind().negate();
        if (a.getKind() != negateKind) {
            return this.simplify(this.rexBuilder.makeCall(RexUtil.op(negateKind), ((RexCall)a).getOperands()), unknownAs);
        }
        SqlKind negateKind2 = a.getKind().negateNullSafe();
        if (a.getKind() != negateKind2) {
            return this.simplify(this.rexBuilder.makeCall(RexUtil.op(negateKind2), ((RexCall)a).getOperands()), unknownAs);
        }
        if (a.getKind() == SqlKind.AND) {
            ArrayList<RexNode> newOperands = new ArrayList<RexNode>();
            for (RexNode operand : ((RexCall)a).getOperands()) {
                newOperands.add(this.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, operand), unknownAs));
            }
            return this.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, newOperands), unknownAs);
        }
        if (a.getKind() == SqlKind.OR) {
            ArrayList<RexNode> newOperands = new ArrayList<RexNode>();
            for (RexNode operand : ((RexCall)a).getOperands()) {
                newOperands.add(this.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, operand), unknownAs));
            }
            return this.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, newOperands), unknownAs);
        }
        if (a.getKind() == SqlKind.CASE) {
            ArrayList<RexNode> newOperands = new ArrayList<RexNode>();
            List<RexNode> operands = ((RexCall)a).getOperands();
            for (int i = 0; i < operands.size(); i += 2) {
                if (i + 1 == operands.size()) {
                    newOperands.add(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, operands.get(i)));
                    continue;
                }
                newOperands.add(operands.get(i));
                newOperands.add(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, operands.get(i + 1)));
            }
            return this.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, newOperands), unknownAs);
        }
        RexNode a2 = this.simplify(a, unknownAs.negate());
        if (a == a2) {
            return call;
        }
        if (a2.isAlwaysTrue()) {
            return this.rexBuilder.makeLiteral(false);
        }
        if (a2.isAlwaysFalse()) {
            return this.rexBuilder.makeLiteral(true);
        }
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, a2);
    }

    private RexNode simplifyUnaryMinus(RexCall call, RexUnknownAs unknownAs) {
        RexNode a = call.getOperands().get(0);
        if (a.getKind() == SqlKind.MINUS_PREFIX) {
            return this.simplify(((RexCall)a).getOperands().get(0), unknownAs);
        }
        return this.simplifyGenericNode(call);
    }

    private RexNode simplifyUnaryPlus(RexCall call, RexUnknownAs unknownAs) {
        return this.simplify(call.getOperands().get(0), unknownAs);
    }

    @Nonnull
    private RexNode simplifyIs(RexCall call, RexUnknownAs unknownAs) {
        RexNode a;
        SqlKind kind = call.getKind();
        RexNode simplified = this.simplifyIs1(kind, a = call.getOperands().get(0), unknownAs);
        return simplified == null ? call : simplified;
    }

    private RexNode simplifyIs1(SqlKind kind, RexNode a, RexUnknownAs unknownAs) {
        if (kind == SqlKind.IS_TRUE && unknownAs == RexUnknownAs.FALSE) {
            return this.simplify(a, unknownAs);
        }
        if (kind == SqlKind.IS_FALSE && unknownAs == RexUnknownAs.FALSE) {
            return this.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, a), unknownAs);
        }
        if (kind == SqlKind.IS_NOT_FALSE && unknownAs == RexUnknownAs.TRUE) {
            return this.simplify(a, unknownAs);
        }
        if (kind == SqlKind.IS_NOT_TRUE && unknownAs == RexUnknownAs.TRUE) {
            return this.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, a), unknownAs);
        }
        RexNode pred = this.simplifyIsPredicate(kind, a);
        if (pred != null) {
            return pred;
        }
        return this.simplifyIs2(kind, a, unknownAs);
    }

    private RexNode simplifyIsPredicate(SqlKind kind, RexNode a) {
        if (!RexUtil.isReferenceOrAccess(a, true)) {
            return null;
        }
        for (RexNode p : this.predicates.pulledUpPredicates) {
            IsPredicate pred = IsPredicate.of(p);
            if (pred == null || !a.equals(pred.ref) || kind != pred.kind) continue;
            return this.rexBuilder.makeLiteral(true);
        }
        return null;
    }

    private RexNode simplifyIs2(SqlKind kind, RexNode a, RexUnknownAs unknownAs) {
        switch (kind) {
            case IS_NULL: {
                this.validateStrongPolicy(a);
                RexNode simplified = this.simplifyIsNull(a);
                if (simplified == null) break;
                return simplified;
            }
            case IS_NOT_NULL: {
                this.validateStrongPolicy(a);
                RexNode simplified = this.simplifyIsNotNull(a);
                if (simplified == null) break;
                return simplified;
            }
            case IS_TRUE: 
            case IS_NOT_FALSE: {
                if (this.predicates.isEffectivelyNotNull(a)) {
                    return this.simplify(a, unknownAs);
                }
                RexNode newSub = this.simplify(a, kind == SqlKind.IS_TRUE ? RexUnknownAs.FALSE : RexUnknownAs.TRUE);
                if (newSub == a) {
                    return null;
                }
                return this.rexBuilder.makeCall(RexUtil.op(kind), ImmutableList.of(newSub));
            }
            case IS_NOT_TRUE: 
            case IS_FALSE: {
                if (!this.predicates.isEffectivelyNotNull(a)) break;
                return this.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, a), unknownAs);
            }
        }
        switch (a.getKind()) {
            case NOT: {
                SqlOperator notKind = RexUtil.op(kind.negateNullSafe());
                RexNode arg = (RexNode)((RexCall)a).operands.get(0);
                return this.simplify(this.rexBuilder.makeCall(notKind, arg), RexUnknownAs.UNKNOWN);
            }
        }
        RexNode a2 = this.simplify(a, RexUnknownAs.UNKNOWN);
        if (a != a2) {
            return this.rexBuilder.makeCall(RexUtil.op(kind), ImmutableList.of(a2));
        }
        return null;
    }

    private RexNode simplifyIsNotNull(RexNode a) {
        if (!(a = this.simplify(a, RexUnknownAs.UNKNOWN)).getType().isNullable() && RexSimplify.isSafeExpression(a)) {
            return this.rexBuilder.makeLiteral(true);
        }
        if (this.predicates.pulledUpPredicates.contains(a)) {
            return this.rexBuilder.makeLiteral(true);
        }
        if (this.hasCustomNullabilityRules(a.getKind())) {
            return null;
        }
        switch (Strong.policy(a)) {
            case NOT_NULL: {
                return this.rexBuilder.makeLiteral(true);
            }
            case ANY: {
                ArrayList<RexNode> operands = new ArrayList<RexNode>();
                for (RexNode operand : ((RexCall)a).getOperands()) {
                    RexNode simplified = this.simplifyIsNotNull(operand);
                    if (simplified == null) {
                        operands.add(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, operand));
                        continue;
                    }
                    if (simplified.isAlwaysFalse()) {
                        return this.rexBuilder.makeLiteral(false);
                    }
                    operands.add(simplified);
                }
                return RexUtil.composeConjunction(this.rexBuilder, operands);
            }
            case CUSTOM: {
                switch (a.getKind()) {
                    case LITERAL: {
                        return this.rexBuilder.makeLiteral(!((RexLiteral)a).isNull());
                    }
                }
                throw new AssertionError((Object)("every CUSTOM policy needs a handler, " + (Object)((Object)a.getKind())));
            }
        }
        return null;
    }

    private RexNode simplifyIsNull(RexNode a) {
        if (!(a = this.simplify(a, RexUnknownAs.UNKNOWN)).getType().isNullable() && RexSimplify.isSafeExpression(a)) {
            return this.rexBuilder.makeLiteral(false);
        }
        if (RexUtil.isNull(a)) {
            return this.rexBuilder.makeLiteral(true);
        }
        if (this.hasCustomNullabilityRules(a.getKind())) {
            return null;
        }
        switch (Strong.policy(a)) {
            case NOT_NULL: {
                return this.rexBuilder.makeLiteral(false);
            }
            case ANY: {
                ArrayList<RexNode> operands = new ArrayList<RexNode>();
                for (RexNode operand : ((RexCall)a).getOperands()) {
                    RexNode simplified = this.simplifyIsNull(operand);
                    if (simplified == null) {
                        operands.add(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, operand));
                        continue;
                    }
                    operands.add(simplified);
                }
                return RexUtil.composeDisjunction(this.rexBuilder, operands, false);
            }
        }
        return null;
    }

    private void validateStrongPolicy(RexNode rexNode) {
        if (this.hasCustomNullabilityRules(rexNode.getKind())) {
            return;
        }
        switch (Strong.policy(rexNode)) {
            case NOT_NULL: {
                assert (!rexNode.getType().isNullable());
                break;
            }
            case ANY: {
                List<RexNode> operands = ((RexCall)rexNode).getOperands();
                if (rexNode.getType().isNullable() ? !$assertionsDisabled && !operands.stream().map(RexNode::getType).anyMatch(RelDataType::isNullable) : !$assertionsDisabled && !operands.stream().map(RexNode::getType).noneMatch(RelDataType::isNullable)) {
                    throw new AssertionError();
                }
                break;
            }
        }
    }

    private boolean hasCustomNullabilityRules(SqlKind sqlKind) {
        switch (sqlKind) {
            case CAST: 
            case ITEM: {
                return true;
            }
        }
        return false;
    }

    private RexNode simplifyCoalesce(RexCall call) {
        HashSet<RexNode> operandSet = new HashSet<RexNode>();
        ArrayList<RexNode> operands = new ArrayList<RexNode>();
        for (RexNode operand : call.getOperands()) {
            if (!RexUtil.isNull(operand = this.simplify(operand, RexUnknownAs.UNKNOWN)) && operandSet.add(operand)) {
                operands.add(operand);
            }
            if (operand.getType().isNullable()) continue;
            break;
        }
        switch (operands.size()) {
            case 0: {
                return this.rexBuilder.makeNullLiteral(call.type);
            }
            case 1: {
                return (RexNode)operands.get(0);
            }
        }
        if (operands.equals(call.operands)) {
            return call;
        }
        return call.clone(call.type, operands);
    }

    private RexNode simplifyCase(RexCall call, RexUnknownAs unknownAs) {
        RexNode result;
        CaseBranch branch;
        List inputBranches = CaseBranch.fromCaseOperands(this.rexBuilder, new ArrayList<RexNode>(call.getOperands()));
        RexSimplify condSimplifier = this.withPredicates(RelOptPredicateList.EMPTY);
        RexSimplify valueSimplifier = this;
        RelDataType caseType = call.getType();
        boolean conditionNeedsSimplify = false;
        CaseBranch lastBranch = null;
        ArrayList<CaseBranch> branches = new ArrayList<CaseBranch>();
        for (CaseBranch inputBranch : inputBranches) {
            RexNode newCond = condSimplifier.simplify(inputBranch.cond, RexUnknownAs.FALSE);
            if (newCond.isAlwaysFalse()) continue;
            RexNode newValue = valueSimplifier.simplify(inputBranch.value, unknownAs);
            if (lastBranch != null) {
                if (lastBranch.value.equals(newValue) && RexSimplify.isSafeExpression(newCond)) {
                    newCond = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, lastBranch.cond, newCond);
                    conditionNeedsSimplify = true;
                } else {
                    CaseBranch branch2 = this.generateBranch(conditionNeedsSimplify, condSimplifier, lastBranch);
                    if (!branch2.cond.isAlwaysFalse()) {
                        branches.add(branch2);
                        if (branch2.cond.isAlwaysTrue()) {
                            lastBranch = null;
                            break;
                        }
                    }
                    conditionNeedsSimplify = false;
                }
            }
            lastBranch = new CaseBranch(newCond, newValue);
            if (!newCond.isAlwaysTrue()) continue;
            break;
        }
        if (lastBranch != null && !(branch = this.generateBranch(conditionNeedsSimplify, condSimplifier, lastBranch)).cond.isAlwaysFalse()) {
            branches.add(branch);
        }
        if (branches.size() == 1) {
            RexNode value = ((CaseBranch)branches.get(0)).value;
            if (this.sameTypeOrNarrowsNullability(caseType, value.getType())) {
                return value;
            }
            return this.rexBuilder.makeAbstractCast(caseType, value);
        }
        if (call.getType().getSqlTypeName() == SqlTypeName.BOOLEAN && (result = RexSimplify.simplifyBooleanCase(this.rexBuilder, branches, unknownAs, caseType)) != null) {
            if (this.sameTypeOrNarrowsNullability(caseType, result.getType())) {
                return this.simplify(result, unknownAs);
            }
            RexNode simplified = this.simplify(result, RexUnknownAs.UNKNOWN);
            if (!simplified.getType().isNullable()) {
                return simplified;
            }
            return this.rexBuilder.makeCast(call.getType(), simplified);
        }
        List newOperands = CaseBranch.toCaseOperands(branches);
        if (newOperands.equals(call.getOperands())) {
            return call;
        }
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, newOperands);
    }

    private CaseBranch generateBranch(boolean simplifyCond, RexSimplify simplifier, CaseBranch branch) {
        if (simplifyCond) {
            return new CaseBranch(simplifier.simplify(branch.cond, RexUnknownAs.FALSE), branch.value);
        }
        return branch;
    }

    private boolean sameTypeOrNarrowsNullability(RelDataType oldType, RelDataType newType) {
        return oldType.equals(newType) || SqlTypeUtil.equalSansNullability(this.rexBuilder.typeFactory, oldType, newType) && oldType.isNullable();
    }

    static boolean isSafeExpression(RexNode r) {
        return r.accept(SafeRexVisitor.INSTANCE);
    }

    private static RexNode simplifyBooleanCase(RexBuilder rexBuilder, List<CaseBranch> inputBranches, RexUnknownAs unknownAs, RelDataType branchType) {
        ArrayList<CaseBranch> branches = new ArrayList<CaseBranch>();
        for (CaseBranch branch : inputBranches) {
            if (branches.size() > 0 && !RexSimplify.isSafeExpression(branch.cond) || !RexSimplify.isSafeExpression(branch.value)) {
                return null;
            }
            RexNode cond = branch.cond.getType().isNullable() ? rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_TRUE, branch.cond) : branch.cond;
            RexNode value = !branchType.equals(branch.value.getType()) ? rexBuilder.makeAbstractCast(branchType, branch.value) : branch.value;
            branches.add(new CaseBranch(cond, value));
        }
        RexNode result = RexSimplify.simplifyBooleanCaseGeneric(rexBuilder, branches);
        return result;
    }

    private static RexNode simplifyBooleanCaseGeneric(RexBuilder rexBuilder, List<CaseBranch> branches) {
        boolean booleanBranches = branches.stream().allMatch(branch -> ((CaseBranch)branch).value.isAlwaysTrue() || ((CaseBranch)branch).value.isAlwaysFalse());
        ArrayList<RexNode> terms = new ArrayList<RexNode>();
        ArrayList<RexNode> notTerms = new ArrayList<RexNode>();
        for (CaseBranch branch2 : branches) {
            boolean useBranch;
            boolean bl = useBranch = !branch2.value.isAlwaysFalse();
            if (useBranch) {
                RexNode branchTerm = branch2.value.isAlwaysTrue() ? branch2.cond : rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, branch2.cond, branch2.value);
                terms.add(RexUtil.andNot(rexBuilder, branchTerm, notTerms));
            }
            if (booleanBranches && useBranch) continue;
            notTerms.add(branch2.cond);
        }
        return RexUtil.composeDisjunction(rexBuilder, terms);
    }

    @Deprecated
    public RexNode simplifyAnd(RexCall e) {
        this.ensureParanoidOff();
        return this.simplifyAnd(e, this.defaultUnknownAs);
    }

    RexNode simplifyAnd(RexCall e, RexUnknownAs unknownAs) {
        List<RexNode> operands = RelOptUtil.conjunctions(e);
        if (unknownAs == RexUnknownAs.FALSE && this.predicateElimination) {
            this.simplifyAndTerms(operands, RexUnknownAs.FALSE);
        } else {
            this.simplifyList(operands, unknownAs);
        }
        ArrayList<RexNode> terms = new ArrayList<RexNode>();
        ArrayList<RexNode> notTerms = new ArrayList<RexNode>();
        SargCollector sargCollector = new SargCollector(this.rexBuilder, true);
        operands.forEach(t -> sargCollector.accept(t, terms));
        if (sargCollector.needToFix()) {
            operands.clear();
            terms.forEach(t -> operands.add(sargCollector.fix(this.rexBuilder, (RexNode)t)));
        }
        terms.clear();
        for (RexNode o : operands) {
            RelOptUtil.decomposeConjunction(o, terms, notTerms);
        }
        switch (unknownAs) {
            case FALSE: {
                return this.simplifyAnd2ForUnknownAsFalse(terms, notTerms, Comparable.class);
            }
        }
        return this.simplifyAnd2(terms, notTerms);
    }

    RexNode simplifyAnd2(List<RexNode> terms, List<RexNode> notTerms) {
        for (RexNode term2 : terms) {
            if (!term2.isAlwaysFalse()) continue;
            return this.rexBuilder.makeLiteral(false);
        }
        if (terms.isEmpty() && notTerms.isEmpty()) {
            return this.rexBuilder.makeLiteral(true);
        }
        ArrayList<RexNode> notSatisfiableNullables = null;
        for (RexNode notDisjunction : notTerms) {
            List<RexNode> terms2 = RelOptUtil.conjunctions(notDisjunction);
            if (!terms.containsAll(terms2)) continue;
            if (!notDisjunction.getType().isNullable()) {
                return this.rexBuilder.makeLiteral(false);
            }
            if (notSatisfiableNullables == null) {
                notSatisfiableNullables = new ArrayList<RexNode>();
            }
            notSatisfiableNullables.add(notDisjunction);
        }
        if (notSatisfiableNullables != null) {
            terms.removeAll(notSatisfiableNullables);
            notTerms.removeAll(notSatisfiableNullables);
            terms.add(this.rexBuilder.makeNullLiteral(((RexNode)notSatisfiableNullables.get(0)).getType()));
            for (RexNode notSatisfiableNullable : notSatisfiableNullables) {
                terms.add(this.simplifyIs((RexCall)this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, notSatisfiableNullable), RexUnknownAs.UNKNOWN));
            }
        }
        for (RexNode notDisjunction : notTerms) {
            terms.add(this.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, notDisjunction), RexUnknownAs.UNKNOWN));
        }
        return RexUtil.composeConjunction(this.rexBuilder, terms);
    }

    RexNode simplifyAnd2ForUnknownAsFalse(List<RexNode> terms, List<RexNode> notTerms) {
        return this.simplifyAnd2ForUnknownAsFalse(terms, notTerms, Comparable.class);
    }

    private <C extends Comparable<C>> RexNode simplifyAnd2ForUnknownAsFalse(List<RexNode> terms, List<RexNode> notTerms, Class<C> clazz) {
        for (RexNode term2 : terms) {
            if (!term2.isAlwaysFalse() && !RexLiteral.isNullLiteral(term2)) continue;
            return this.rexBuilder.makeLiteral(false);
        }
        if (terms.isEmpty() && notTerms.isEmpty()) {
            return this.rexBuilder.makeLiteral(true);
        }
        if (terms.size() == 1 && notTerms.isEmpty()) {
            return this.simplify(terms.get(0), RexUnknownAs.FALSE);
        }
        ArrayListMultimap<RexNode, Pair<RexNode, RexNode>> equalityTerms = ArrayListMultimap.create();
        HashMap<RexNode, Pair<Range<C>, List<RexNode>>> rangeTerms = new HashMap<RexNode, Pair<Range<C>, List<RexNode>>>();
        HashMap<RexNode, RexLiteral> equalityConstantTerms = new HashMap<RexNode, RexLiteral>();
        HashSet<RexNode> negatedTerms = new HashSet<RexNode>();
        HashSet<RexNode> nullOperands = new HashSet<RexNode>();
        LinkedHashSet<RexNode> notNullOperands = new LinkedHashSet<RexNode>();
        HashSet<RexNode> comparedOperands = new HashSet<RexNode>();
        for (RexNode predicate : this.predicates.pulledUpPredicates) {
            RexNode result;
            Comparable v0;
            Comparison comparison2 = Comparison.of(predicate);
            if (comparison2 == null || comparison2.kind == SqlKind.NOT_EQUALS || (v0 = (Comparable)comparison2.literal.getValueAs(clazz)) == null || (result = RexSimplify.processRange(this.rexBuilder, terms, rangeTerms, predicate, comparison2.ref, v0, comparison2.kind)) == null) continue;
            return result;
        }
        block9: for (int i = 0; i < terms.size(); ++i) {
            RexCall call;
            RexNode term3 = terms.get(i);
            if (!RexUtil.isDeterministic(term3)) continue;
            while (term3.getKind() == SqlKind.EQUALS) {
                call = (RexCall)term3;
                if (call.getOperands().get(0).isAlwaysTrue()) {
                    term3 = call.getOperands().get(1);
                    terms.set(i, term3);
                    continue;
                }
                if (!call.getOperands().get(1).isAlwaysTrue()) break;
                term3 = call.getOperands().get(0);
                terms.set(i, term3);
            }
            switch (term3.getKind()) {
                case EQUALS: 
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: 
                case NOT_EQUALS: {
                    Comparable constant;
                    RexNode result;
                    RexNode term2;
                    RexNode negatedTerm;
                    Comparison comparison3;
                    call = (RexCall)term3;
                    RexNode left = call.getOperands().get(0);
                    comparedOperands.add(left);
                    if (left.getKind() == SqlKind.CAST) {
                        RexCall leftCast = (RexCall)left;
                        comparedOperands.add(leftCast.getOperands().get(0));
                    }
                    RexNode right = call.getOperands().get(1);
                    comparedOperands.add(right);
                    if (right.getKind() == SqlKind.CAST) {
                        RexCall rightCast = (RexCall)right;
                        comparedOperands.add(rightCast.getOperands().get(0));
                    }
                    if ((comparison3 = Comparison.of(term3)) != null && comparison3.literal.getValue() == null) {
                        return this.rexBuilder.makeLiteral(false);
                    }
                    if (term3.getKind() == SqlKind.EQUALS) {
                        if (comparison3 != null) {
                            RexLiteral literal = comparison3.literal;
                            RexLiteral prevLiteral = equalityConstantTerms.put(comparison3.ref, literal);
                            if (prevLiteral != null && !literal.equals(prevLiteral)) {
                                return this.rexBuilder.makeLiteral(false);
                            }
                        } else if (RexUtil.isReferenceOrAccess(left, true) && RexUtil.isReferenceOrAccess(right, true)) {
                            equalityTerms.put(left, Pair.of(right, term3));
                        }
                    }
                    if ((negatedTerm = RexUtil.negate(this.rexBuilder, call)) != null) {
                        negatedTerms.add(negatedTerm);
                        RexNode invertNegatedTerm = RexUtil.invert(this.rexBuilder, (RexCall)negatedTerm);
                        if (invertNegatedTerm != null) {
                            negatedTerms.add(invertNegatedTerm);
                        }
                    }
                    if ((term2 = this.simplifyUsingPredicates(term3, clazz)) != term3) {
                        term3 = term2;
                        terms.set(i, term3);
                    }
                    if (comparison3 == null || comparison3.kind == SqlKind.NOT_EQUALS || (result = RexSimplify.processRange(this.rexBuilder, terms, rangeTerms, term3, comparison3.ref, constant = (Comparable)comparison3.literal.getValueAs(clazz), comparison3.kind)) == null) continue block9;
                    return result;
                }
                case IN: {
                    comparedOperands.add((RexNode)((RexCall)term3).operands.get(0));
                    continue block9;
                }
                case BETWEEN: {
                    comparedOperands.add((RexNode)((RexCall)term3).operands.get(1));
                    continue block9;
                }
                case IS_NOT_NULL: {
                    notNullOperands.add(((RexCall)term3).getOperands().get(0));
                    terms.remove(i);
                    --i;
                    continue block9;
                }
                case IS_NULL: {
                    nullOperands.add(((RexCall)term3).getOperands().get(0));
                }
            }
        }
        if (!Collections.disjoint(nullOperands, comparedOperands)) {
            return this.rexBuilder.makeLiteral(false);
        }
        for (RexNode ref1 : equalityTerms.keySet()) {
            RexLiteral literal1 = (RexLiteral)equalityConstantTerms.get(ref1);
            if (literal1 == null) continue;
            Collection references = equalityTerms.get(ref1);
            for (Pair ref2 : references) {
                RexLiteral literal2 = (RexLiteral)equalityConstantTerms.get(ref2.left);
                if (literal2 == null) continue;
                if (!literal1.equals(literal2)) {
                    return this.rexBuilder.makeLiteral(false);
                }
                terms.remove(ref2.right);
            }
        }
        for (RexNode operand : notNullOperands) {
            if (comparedOperands.contains(operand)) continue;
            terms.add(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, operand));
        }
        HashSet<RexNode> termsSet = new HashSet<RexNode>(terms);
        for (RexNode notDisjunction : notTerms) {
            List<RexNode> terms2Set;
            if (!RexUtil.isDeterministic(notDisjunction) || !termsSet.containsAll(terms2Set = RelOptUtil.conjunctions(notDisjunction))) continue;
            return this.rexBuilder.makeLiteral(false);
        }
        for (RexNode notDisjunction : notTerms) {
            terms.add(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, notDisjunction));
        }
        for (RexNode negatedTerm : negatedTerms) {
            if (!termsSet.contains(negatedTerm)) continue;
            return this.rexBuilder.makeLiteral(false);
        }
        return RexUtil.composeConjunction(this.rexBuilder, terms);
    }

    private <C extends Comparable<C>> RexNode simplifyUsingPredicates(RexNode e, Class<C> clazz) {
        if (this.predicates.pulledUpPredicates.isEmpty()) {
            return e;
        }
        Comparison comparison2 = Comparison.of(e);
        if (comparison2 == null || comparison2.literal.getValue() == null) {
            return e;
        }
        Comparable v0 = (Comparable)comparison2.literal.getValueAs(clazz);
        RangeSet<Comparable> rangeSet = RexSimplify.rangeSet(comparison2.kind, v0);
        RangeSet<Comparable> rangeSet2 = this.residue(comparison2.ref, rangeSet, this.predicates.pulledUpPredicates, clazz);
        if (rangeSet2.isEmpty()) {
            return this.rexBuilder.makeLiteral(false);
        }
        if (rangeSet2.equals(rangeSet)) {
            return e;
        }
        if (rangeSet2.equals(RangeSets.rangeSetAll())) {
            return this.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, comparison2.ref), RexUnknownAs.UNKNOWN);
        }
        if (rangeSet2.asRanges().size() == 1 && Iterables.getOnlyElement(rangeSet2.asRanges()).hasLowerBound() && Iterables.getOnlyElement(rangeSet2.asRanges()).hasUpperBound() && Iterables.getOnlyElement(rangeSet2.asRanges()).lowerEndpoint().equals(Iterables.getOnlyElement(rangeSet2.asRanges()).upperEndpoint())) {
            Range<Comparable> r = Iterables.getOnlyElement(rangeSet2.asRanges());
            return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, comparison2.ref, this.rexBuilder.makeLiteral(r.lowerEndpoint(), comparison2.literal.getType(), comparison2.literal.getTypeName()));
        }
        return e;
    }

    private <C extends Comparable<C>> RangeSet<C> residue(RexNode ref, RangeSet<C> r0, List<RexNode> predicates, Class<C> clazz) {
        RangeSet<Object> result = r0;
        for (RexNode predicate : predicates) {
            block0 : switch (predicate.getKind()) {
                case EQUALS: 
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: 
                case NOT_EQUALS: {
                    RexCall call = (RexCall)predicate;
                    if (!((RexNode)call.operands.get(0)).equals(ref) || !(call.operands.get(1) instanceof RexLiteral)) break;
                    RexLiteral literal = (RexLiteral)call.operands.get(1);
                    Comparable c1 = (Comparable)literal.getValueAs(clazz);
                    switch (predicate.getKind()) {
                        case NOT_EQUALS: {
                            Range<Comparable> pointRange = RexSimplify.range(SqlKind.EQUALS, c1);
                            RangeSet notEqualsRangeSet = ImmutableRangeSet.of(pointRange).complement();
                            if (result.enclosesAll(notEqualsRangeSet)) {
                                result = RangeSets.rangeSetAll();
                                break block0;
                            }
                            result = RangeSets.minus(result, pointRange);
                            break;
                        }
                        default: {
                            Range<Comparable> r1 = RexSimplify.range(predicate.getKind(), c1);
                            if (result.encloses(r1)) {
                                result = RangeSets.rangeSetAll();
                                break block0;
                            }
                            result = result.subRangeSet(r1);
                        }
                    }
                    if (!result.isEmpty()) break;
                    break;
                }
            }
        }
        return result;
    }

    @Deprecated
    public RexNode simplifyOr(RexCall call) {
        this.ensureParanoidOff();
        return this.simplifyOr(call, RexUnknownAs.UNKNOWN);
    }

    private RexNode simplifyOr(RexCall call, RexUnknownAs unknownAs) {
        List<RexNode> terms;
        assert (call.getKind() == SqlKind.OR);
        List<RexNode> terms0 = RelOptUtil.disjunctions(call);
        if (this.predicateElimination) {
            terms = Util.moveToHead(terms0, e -> e.getKind() == SqlKind.IS_NULL);
            this.simplifyOrTerms(terms, unknownAs);
        } else {
            terms = terms0;
            this.simplifyList(terms, unknownAs);
        }
        return this.simplifyOrs(terms, unknownAs);
    }

    @Deprecated
    public RexNode simplifyOrs(List<RexNode> terms) {
        this.ensureParanoidOff();
        return this.simplifyOrs(terms, RexUnknownAs.UNKNOWN);
    }

    private void ensureParanoidOff() {
        if (this.paranoid) {
            throw new UnsupportedOperationException("Paranoid is not supported for this method");
        }
    }

    private RexNode simplifyOrs(List<RexNode> terms, RexUnknownAs unknownAs) {
        SargCollector sargCollector = new SargCollector(this.rexBuilder, false);
        ArrayList newTerms = new ArrayList();
        terms.forEach(t -> sargCollector.accept(t, newTerms));
        if (sargCollector.needToFix()) {
            terms.clear();
            newTerms.forEach(t -> terms.add(sargCollector.fix(this.rexBuilder, (RexNode)t)));
        }
        HashMap<RexNode, RexNode> notEqualsComparisonMap = new HashMap<RexNode, RexNode>();
        RexLiteral trueLiteral = this.rexBuilder.makeLiteral(true);
        block4: for (int i = 0; i < terms.size(); ++i) {
            RexNode term2 = terms.get(i);
            switch (term2.getKind()) {
                case LITERAL: {
                    if (RexLiteral.isNullLiteral(term2)) {
                        if (unknownAs == RexUnknownAs.FALSE) {
                            terms.remove(i);
                            --i;
                            continue block4;
                        }
                        if (unknownAs != RexUnknownAs.TRUE) continue block4;
                        return trueLiteral;
                    }
                    if (RexLiteral.booleanValue(term2)) {
                        return term2;
                    }
                    terms.remove(i);
                    --i;
                    continue block4;
                }
                case NOT_EQUALS: {
                    Comparable comparable2;
                    Comparable comparable1;
                    Comparison notEqualsComparison = Comparison.of(term2);
                    if (notEqualsComparison == null) continue block4;
                    RexNode prevNotEquals = (RexNode)notEqualsComparisonMap.get(notEqualsComparison.ref);
                    if (prevNotEquals == null) {
                        notEqualsComparisonMap.put(notEqualsComparison.ref, term2);
                        continue block4;
                    }
                    if (prevNotEquals.getKind() != SqlKind.IS_NOT_NULL && (comparable1 = notEqualsComparison.literal.getValue()).compareTo(comparable2 = Comparison.of((RexNode)prevNotEquals).literal.getValue()) != 0) {
                        RexLiteral constantNull;
                        RexNode isNotNull = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, notEqualsComparison.ref);
                        RexNode newCondition = this.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, isNotNull, constantNull = this.rexBuilder.makeNullLiteral(trueLiteral.getType())), unknownAs);
                        if (newCondition.isAlwaysTrue()) {
                            return trueLiteral;
                        }
                        notEqualsComparisonMap.put(notEqualsComparison.ref, isNotNull);
                        int pos = terms.indexOf(prevNotEquals);
                        terms.set(pos, newCondition);
                    }
                    terms.remove(i);
                    --i;
                    continue block4;
                }
            }
        }
        return RexUtil.composeDisjunction(this.rexBuilder, terms);
    }

    private void verify(RexNode before, RexNode simplified, RexUnknownAs unknownAs) {
        if (simplified.isAlwaysFalse() && before.isAlwaysTrue()) {
            throw new AssertionError((Object)("always true [" + before + "] simplified to always false [" + simplified + "]"));
        }
        if (simplified.isAlwaysTrue() && before.isAlwaysFalse()) {
            throw new AssertionError((Object)("always false [" + before + "] simplified to always true [" + simplified + "]"));
        }
        RexAnalyzer foo0 = new RexAnalyzer(before, this.predicates);
        RexAnalyzer foo1 = new RexAnalyzer(simplified, this.predicates);
        if (foo0.unsupportedCount > 0 || foo1.unsupportedCount > 0) {
            return;
        }
        if (!foo0.variables.containsAll(foo1.variables)) {
            throw new AssertionError((Object)("variable mismatch: " + before + " has " + foo0.variables + ", " + simplified + " has " + foo1.variables));
        }
        block3: for (Map<RexNode, Comparable> map : foo0.assignments()) {
            for (RexNode predicate : this.predicates.pulledUpPredicates) {
                Comparable v = RexInterpreter.evaluate(predicate, map);
                if (v.equals(true)) continue;
                continue block3;
            }
            Comparable v0 = RexInterpreter.evaluate(foo0.e, map);
            if (v0 == null) {
                throw new AssertionError((Object)("interpreter returned null for " + foo0.e));
            }
            Comparable v1 = RexInterpreter.evaluate(foo1.e, map);
            if (v1 == null) {
                throw new AssertionError((Object)("interpreter returned null for " + foo1.e));
            }
            if (before.getType().getSqlTypeName() == SqlTypeName.BOOLEAN) {
                switch (unknownAs) {
                    case FALSE: 
                    case TRUE: {
                        if (v0 == NullSentinel.INSTANCE) {
                            v0 = Boolean.valueOf(unknownAs.toBoolean());
                        }
                        if (v1 != NullSentinel.INSTANCE) break;
                        v1 = Boolean.valueOf(unknownAs.toBoolean());
                    }
                }
            }
            if (!v0.equals(v1)) {
                throw new AssertionError((Object)("result mismatch: when applied to " + map + ", " + before + " yielded " + v0 + ", and " + simplified + " yielded " + v1));
            }
        }
    }

    private RexNode simplifySearch(RexCall call, RexUnknownAs unknownAs) {
        assert (call.getKind() == SqlKind.SEARCH);
        RexNode a = call.getOperands().get(0);
        if (call.getOperands().get(1) instanceof RexLiteral) {
            RexNode simplified;
            RexLiteral literal = (RexLiteral)call.getOperands().get(1);
            Sarg sarg = literal.getValueAs(Sarg.class);
            if (sarg.containsNull && (simplified = this.simplifyIs1(SqlKind.IS_NULL, a, unknownAs)) != null && simplified.isAlwaysFalse()) {
                Sarg sarg2 = Sarg.of(false, sarg.rangeSet);
                RexLiteral literal2 = this.rexBuilder.makeLiteral(sarg2, literal.getType(), literal.getTypeName());
                return call.clone(call.type, ImmutableList.of(a, literal2));
            }
        }
        return call;
    }

    private RexNode simplifyCast(RexCall e) {
        RexNode operand = e.getOperands().get(0);
        operand = this.simplify(operand, RexUnknownAs.UNKNOWN);
        if (this.sameTypeOrNarrowsNullability(e.getType(), operand.getType())) {
            return operand;
        }
        if (RexUtil.isLosslessCast(operand)) {
            RexNode intExpr = (RexNode)((RexCall)operand).operands.get(0);
            if ((intExpr.getType().getSqlTypeName() == SqlTypeName.CHAR || operand.getType().getSqlTypeName() != SqlTypeName.CHAR) && this.sameTypeOrNarrowsNullability(e.getType(), intExpr.getType())) {
                return intExpr;
            }
            if (RexUtil.isLosslessCast(intExpr.getType(), operand.getType()) && (e.getType().getSqlTypeName() == operand.getType().getSqlTypeName() || e.getType().getSqlTypeName() == SqlTypeName.CHAR || operand.getType().getSqlTypeName() != SqlTypeName.CHAR) && SqlTypeCoercionRule.instance().canApplyFrom(intExpr.getType().getSqlTypeName(), e.getType().getSqlTypeName())) {
                return this.rexBuilder.makeCast(e.getType(), intExpr);
            }
        }
        switch (operand.getKind()) {
            case LITERAL: {
                RexLiteral literal = (RexLiteral)operand;
                Comparable value = literal.getValueAs(Comparable.class);
                SqlTypeName typeName = literal.getTypeName();
                if (this.rexBuilder.canRemoveCastFromLiteral(e.getType(), value, typeName)) {
                    return this.rexBuilder.makeCast(e.getType(), operand);
                }
                switch (literal.getTypeName()) {
                    case TIME: {
                        switch (e.getType().getSqlTypeName()) {
                            case TIMESTAMP: {
                                return e;
                            }
                        }
                    }
                }
                ArrayList<RexNode> reducedValues = new ArrayList<RexNode>();
                RexNode simplifiedExpr = this.rexBuilder.makeCast(e.getType(), operand);
                this.executor.reduce(this.rexBuilder, ImmutableList.of(simplifiedExpr), reducedValues);
                return Objects.requireNonNull(Iterables.getOnlyElement(reducedValues));
            }
        }
        if (operand == e.getOperands().get(0)) {
            return e;
        }
        return this.rexBuilder.makeCast(e.getType(), operand);
    }

    private RexNode simplifyCeilFloor(RexCall e) {
        if (e.getOperands().size() != 2) {
            return e;
        }
        RexNode operand = this.simplify(e.getOperands().get(0), RexUnknownAs.UNKNOWN);
        if (e.getKind() == operand.getKind()) {
            assert (e.getKind() == SqlKind.CEIL || e.getKind() == SqlKind.FLOOR);
            RexCall child = (RexCall)operand;
            if (child.getOperands().size() != 2) {
                return e;
            }
            RexLiteral parentFlag = (RexLiteral)e.operands.get(1);
            TimeUnitRange parentFlagValue = (TimeUnitRange)((Object)parentFlag.getValue());
            RexLiteral childFlag = (RexLiteral)child.operands.get(1);
            TimeUnitRange childFlagValue = (TimeUnitRange)((Object)childFlag.getValue());
            if (parentFlagValue != null && childFlagValue != null && RexSimplify.canRollUp(parentFlagValue.startUnit, childFlagValue.startUnit)) {
                return e.clone(e.getType(), ImmutableList.of(child.getOperands().get(0), parentFlag));
            }
        }
        return e.clone(e.getType(), ImmutableList.of(operand, e.getOperands().get(1)));
    }

    private static boolean canRollUp(TimeUnit outer, TimeUnit inner) {
        switch (outer) {
            case YEAR: 
            case MONTH: 
            case DAY: 
            case HOUR: 
            case MINUTE: 
            case SECOND: 
            case MILLISECOND: 
            case MICROSECOND: {
                switch (inner) {
                    case YEAR: 
                    case QUARTER: 
                    case MONTH: 
                    case DAY: 
                    case HOUR: 
                    case MINUTE: 
                    case SECOND: 
                    case MILLISECOND: 
                    case MICROSECOND: {
                        if (inner == TimeUnit.QUARTER) {
                            return outer == TimeUnit.YEAR;
                        }
                        return outer.ordinal() <= inner.ordinal();
                    }
                }
                break;
            }
            case QUARTER: {
                switch (inner) {
                    case QUARTER: 
                    case MONTH: 
                    case DAY: 
                    case HOUR: 
                    case MINUTE: 
                    case SECOND: 
                    case MILLISECOND: 
                    case MICROSECOND: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public RexNode removeNullabilityCast(RexNode e) {
        return RexUtil.removeNullabilityCast(this.rexBuilder.getTypeFactory(), e);
    }

    private static <C extends Comparable<C>> RexNode processRange(RexBuilder rexBuilder, List<RexNode> terms, Map<RexNode, Pair<Range<C>, List<RexNode>>> rangeTerms, RexNode term2, RexNode ref, C v0, SqlKind comparison2) {
        Pair<Range<C>, List<RexNode>> p = rangeTerms.get(ref);
        if (p == null) {
            rangeTerms.put(ref, Pair.of(RexSimplify.range(comparison2, v0), ImmutableList.of(term2)));
        } else {
            ImmutableList.Builder newBounds;
            boolean removeUpperBound = false;
            boolean removeLowerBound = false;
            Range<C> r = (Range<C>)p.left;
            RexLiteral trueLiteral = rexBuilder.makeLiteral(true);
            switch (comparison2) {
                case EQUALS: {
                    if (!r.contains(v0)) {
                        return rexBuilder.makeLiteral(false);
                    }
                    rangeTerms.put(ref, Pair.of(Range.singleton(v0), ImmutableList.of(term2)));
                    for (RexNode e : (List)p.right) {
                        RexSimplify.replaceLast(terms, e, trueLiteral);
                    }
                    break;
                }
                case LESS_THAN: {
                    int comparisonResult = 0;
                    if (r.hasUpperBound()) {
                        comparisonResult = v0.compareTo(r.upperEndpoint());
                    }
                    if (comparisonResult <= 0) {
                        if (r.hasLowerBound()) {
                            if (v0.compareTo(r.lowerEndpoint()) <= 0) {
                                return rexBuilder.makeLiteral(false);
                            }
                            r = Range.range(r.lowerEndpoint(), r.lowerBoundType(), v0, BoundType.OPEN);
                        } else {
                            r = Range.lessThan(v0);
                        }
                        if (r.isEmpty()) {
                            return rexBuilder.makeLiteral(false);
                        }
                        removeUpperBound = true;
                        break;
                    }
                    RexSimplify.replaceLast(terms, term2, trueLiteral);
                    break;
                }
                case LESS_THAN_OR_EQUAL: {
                    int comparisonResult = -1;
                    if (r.hasUpperBound()) {
                        comparisonResult = v0.compareTo(r.upperEndpoint());
                    }
                    if (comparisonResult < 0) {
                        if (r.hasLowerBound()) {
                            if (v0.compareTo(r.lowerEndpoint()) < 0) {
                                return rexBuilder.makeLiteral(false);
                            }
                            r = Range.range(r.lowerEndpoint(), r.lowerBoundType(), v0, BoundType.CLOSED);
                        } else {
                            r = Range.atMost(v0);
                        }
                        if (r.isEmpty()) {
                            return rexBuilder.makeLiteral(false);
                        }
                        removeUpperBound = true;
                        break;
                    }
                    RexSimplify.replaceLast(terms, term2, trueLiteral);
                    break;
                }
                case GREATER_THAN: {
                    int comparisonResult = 0;
                    if (r.hasLowerBound()) {
                        comparisonResult = v0.compareTo(r.lowerEndpoint());
                    }
                    if (comparisonResult >= 0) {
                        if (r.hasUpperBound()) {
                            if (v0.compareTo(r.upperEndpoint()) >= 0) {
                                return rexBuilder.makeLiteral(false);
                            }
                            r = Range.range(v0, BoundType.OPEN, r.upperEndpoint(), r.upperBoundType());
                        } else {
                            r = Range.greaterThan(v0);
                        }
                        if (r.isEmpty()) {
                            return rexBuilder.makeLiteral(false);
                        }
                        removeLowerBound = true;
                        break;
                    }
                    RexSimplify.replaceLast(terms, term2, trueLiteral);
                    break;
                }
                case GREATER_THAN_OR_EQUAL: {
                    int comparisonResult = 1;
                    if (r.hasLowerBound()) {
                        comparisonResult = v0.compareTo(r.lowerEndpoint());
                    }
                    if (comparisonResult > 0) {
                        if (r.hasUpperBound()) {
                            if (v0.compareTo(r.upperEndpoint()) > 0) {
                                return rexBuilder.makeLiteral(false);
                            }
                            r = Range.range(v0, BoundType.CLOSED, r.upperEndpoint(), r.upperBoundType());
                        } else {
                            r = Range.atLeast(v0);
                        }
                        if (r.isEmpty()) {
                            return rexBuilder.makeLiteral(false);
                        }
                        removeLowerBound = true;
                        break;
                    }
                    RexSimplify.replaceLast(terms, term2, trueLiteral);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (removeUpperBound) {
                newBounds = ImmutableList.builder();
                for (RexNode e : (List)p.right) {
                    if (RexSimplify.isUpperBound(e)) {
                        RexSimplify.replaceLast(terms, e, trueLiteral);
                        continue;
                    }
                    newBounds.add(e);
                }
                newBounds.add(term2);
                rangeTerms.put(ref, Pair.of(r, newBounds.build()));
            } else if (removeLowerBound) {
                newBounds = ImmutableList.builder();
                for (RexNode e : (List)p.right) {
                    if (RexSimplify.isLowerBound(e)) {
                        RexSimplify.replaceLast(terms, e, trueLiteral);
                        continue;
                    }
                    newBounds.add(e);
                }
                newBounds.add(term2);
                rangeTerms.put(ref, Pair.of(r, newBounds.build()));
            }
        }
        return null;
    }

    private static <C extends Comparable<C>> Range<C> range(SqlKind comparison2, C c) {
        switch (comparison2) {
            case EQUALS: {
                return Range.singleton(c);
            }
            case LESS_THAN: {
                return Range.lessThan(c);
            }
            case LESS_THAN_OR_EQUAL: {
                return Range.atMost(c);
            }
            case GREATER_THAN: {
                return Range.greaterThan(c);
            }
            case GREATER_THAN_OR_EQUAL: {
                return Range.atLeast(c);
            }
        }
        throw new AssertionError();
    }

    private static <C extends Comparable<C>> RangeSet<C> rangeSet(SqlKind comparison2, C c) {
        switch (comparison2) {
            case EQUALS: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                return ImmutableRangeSet.of(RexSimplify.range(comparison2, c));
            }
            case NOT_EQUALS: {
                return ImmutableRangeSet.builder().add(RexSimplify.range(SqlKind.LESS_THAN, c)).add(RexSimplify.range(SqlKind.GREATER_THAN, c)).build();
            }
        }
        throw new AssertionError();
    }

    private static boolean isUpperBound(RexNode e) {
        switch (e.getKind()) {
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                List<RexNode> operands = ((RexCall)e).getOperands();
                return RexUtil.isReferenceOrAccess(operands.get(0), true) && operands.get(1).isA(SqlKind.LITERAL);
            }
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                List<RexNode> operands = ((RexCall)e).getOperands();
                return RexUtil.isReferenceOrAccess(operands.get(1), true) && operands.get(0).isA(SqlKind.LITERAL);
            }
        }
        return false;
    }

    private static boolean isLowerBound(RexNode e) {
        switch (e.getKind()) {
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                List<RexNode> operands = ((RexCall)e).getOperands();
                return RexUtil.isReferenceOrAccess(operands.get(1), true) && operands.get(0).isA(SqlKind.LITERAL);
            }
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                List<RexNode> operands = ((RexCall)e).getOperands();
                return RexUtil.isReferenceOrAccess(operands.get(0), true) && operands.get(1).isA(SqlKind.LITERAL);
            }
        }
        return false;
    }

    public RexNode simplifyFilterPredicates(Iterable<? extends RexNode> predicates) {
        RexNode simplifiedAnds = this.withPredicateElimination(false).simplifyUnknownAsFalse(RexUtil.composeConjunction(this.rexBuilder, predicates));
        if (simplifiedAnds.isAlwaysFalse()) {
            return null;
        }
        return this.removeNullabilityCast(simplifiedAnds);
    }

    private static <E> boolean replaceLast(List<E> list, E oldVal, E newVal) {
        int index = list.lastIndexOf(oldVal);
        if (index < 0) {
            return false;
        }
        list.set(index, newVal);
        return true;
    }

    static class RexSargBuilder
    extends RexNode {
        final RexNode ref;
        private final RexBuilder rexBuilder;
        private List<RelDataType> types = new ArrayList<RelDataType>();
        final RangeSet<Comparable> rangeSet = TreeRangeSet.create();
        boolean containsNull;

        RexSargBuilder(RexNode ref, RexBuilder rexBuilder, boolean negate) {
            this.ref = Objects.requireNonNull(ref);
            this.rexBuilder = Objects.requireNonNull(rexBuilder);
            this.containsNull = false;
        }

        @Override
        public String toString() {
            return "SEARCH(" + this.ref + ", " + this.rangeSet + (this.containsNull ? " + null)" : ")");
        }

        int complexity() {
            int complexity = 0;
            complexity = this.rangeSet.asRanges().size() == 2 && this.rangeSet.complement().asRanges().size() == 1 && RangeSets.isPoint(Iterables.getOnlyElement(this.rangeSet.complement().asRanges())) ? ++complexity : (complexity += this.rangeSet.asRanges().size());
            if (this.containsNull) {
                ++complexity;
            }
            return complexity;
        }

        <C extends Comparable<C>> Sarg<C> build(boolean negate) {
            RangeSet<Comparable> rangeSet = negate ? this.rangeSet.complement() : this.rangeSet;
            return Sarg.of(this.containsNull, rangeSet);
        }

        @Override
        public RelDataType getType() {
            if (this.types.isEmpty()) {
                return this.ref.getType();
            }
            List<RelDataType> distinctTypes = Util.distinctList(this.types);
            return Objects.requireNonNull(this.rexBuilder.typeFactory.leastRestrictive(distinctTypes), () -> "Can't find leastRestrictive type among " + distinctTypes);
        }

        @Override
        public <R> R accept(RexVisitor<R> visitor) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <R, P> R accept(RexBiVisitor<R, P> visitor, P arg) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            throw new UnsupportedOperationException();
        }

        void addRange(Range<Comparable> range2, RelDataType type) {
            this.types.add(type);
            this.rangeSet.add(range2);
        }

        void addSarg(Sarg sarg, boolean negate, RelDataType type) {
            this.types.add(type);
            this.rangeSet.addAll(negate ? sarg.rangeSet.complement() : sarg.rangeSet);
            this.containsNull |= sarg.containsNull;
        }
    }

    static class SargCollector {
        final Map<RexNode, RexSargBuilder> map = new HashMap<RexNode, RexSargBuilder>();
        private final RexBuilder rexBuilder;
        private final boolean negate;
        private int newTermsCount;

        SargCollector(RexBuilder rexBuilder, boolean negate) {
            this.rexBuilder = rexBuilder;
            this.negate = negate;
        }

        private void accept(RexNode term2, List<RexNode> newTerms) {
            if (!this.accept_(term2, newTerms)) {
                newTerms.add(term2);
            }
            this.newTermsCount = newTerms.size();
        }

        private boolean accept_(RexNode e, List<RexNode> newTerms) {
            switch (e.getKind()) {
                case EQUALS: 
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: 
                case NOT_EQUALS: 
                case SEARCH: {
                    return this.accept2((RexNode)((RexCall)e).operands.get(0), (RexNode)((RexCall)e).operands.get(1), e.getKind(), newTerms);
                }
                case IS_NULL: {
                    if (this.negate) {
                        return false;
                    }
                    RexNode arg = (RexNode)((RexCall)e).operands.get(0);
                    return this.accept1(arg, e.getKind(), this.rexBuilder.makeNullLiteral(arg.getType()), newTerms);
                }
            }
            return false;
        }

        private boolean accept2(RexNode left, RexNode right, SqlKind kind, List<RexNode> newTerms) {
            switch (left.getKind()) {
                case INPUT_REF: 
                case FIELD_ACCESS: {
                    switch (right.getKind()) {
                        case LITERAL: {
                            return this.accept1(left, kind, (RexLiteral)right, newTerms);
                        }
                    }
                    return false;
                }
                case LITERAL: {
                    switch (right.getKind()) {
                        case INPUT_REF: 
                        case FIELD_ACCESS: {
                            return this.accept1(right, kind.reverse(), (RexLiteral)left, newTerms);
                        }
                    }
                    return false;
                }
            }
            return false;
        }

        private static <E> E addFluent(List<? super E> list, E e) {
            list.add(e);
            return e;
        }

        private boolean accept1(RexNode e, SqlKind kind, @Nonnull RexLiteral literal, List<RexNode> newTerms) {
            RexSargBuilder b = this.map.computeIfAbsent(e, e2 -> SargCollector.addFluent(newTerms, new RexSargBuilder((RexNode)e2, this.rexBuilder, this.negate)));
            if (this.negate) {
                kind = kind.negateNullSafe();
            }
            Comparable value = literal.getValueAs(Comparable.class);
            switch (kind) {
                case LESS_THAN: {
                    b.addRange(Range.lessThan(value), literal.getType());
                    return true;
                }
                case LESS_THAN_OR_EQUAL: {
                    b.addRange(Range.atMost(value), literal.getType());
                    return true;
                }
                case GREATER_THAN: {
                    b.addRange(Range.greaterThan(value), literal.getType());
                    return true;
                }
                case GREATER_THAN_OR_EQUAL: {
                    b.addRange(Range.atLeast(value), literal.getType());
                    return true;
                }
                case EQUALS: {
                    b.addRange(Range.singleton(value), literal.getType());
                    return true;
                }
                case NOT_EQUALS: {
                    b.addRange(Range.lessThan(value), literal.getType());
                    b.addRange(Range.greaterThan(value), literal.getType());
                    return true;
                }
                case SEARCH: {
                    Sarg sarg = literal.getValueAs(Sarg.class);
                    b.addSarg(sarg, this.negate, literal.getType());
                    return true;
                }
                case IS_NULL: {
                    if (this.negate) {
                        throw new AssertionError((Object)"negate is not supported for IS_NULL");
                    }
                    b.containsNull = true;
                    return true;
                }
            }
            throw new AssertionError((Object)("unexpected " + (Object)((Object)kind)));
        }

        boolean needToFix() {
            boolean allPoints = this.newTermsCount == 1;
            for (RexSargBuilder builder : this.map.values()) {
                if (builder.complexity() > 1) {
                    return true;
                }
                if (!allPoints) continue;
                Sarg sarg = builder.build(this.negate);
                allPoints = sarg.isPoints();
            }
            return allPoints;
        }

        RexNode fix(RexBuilder rexBuilder, RexNode term2) {
            if (term2 instanceof RexSargBuilder) {
                RexSargBuilder sargBuilder = (RexSargBuilder)term2;
                return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.SEARCH, sargBuilder.ref, rexBuilder.makeSearchArgumentLiteral(sargBuilder.build(this.negate), term2.getType()));
            }
            return term2;
        }
    }

    private static class IsPredicate
    implements Predicate {
        final RexNode ref;
        final SqlKind kind;

        private IsPredicate(RexNode ref, SqlKind kind) {
            this.ref = Objects.requireNonNull(ref);
            this.kind = Objects.requireNonNull(kind);
        }

        static IsPredicate of(RexNode e) {
            switch (e.getKind()) {
                case IS_NULL: 
                case IS_NOT_NULL: {
                    RexNode pA = ((RexCall)e).getOperands().get(0);
                    if (!RexUtil.isReferenceOrAccess(pA, true)) {
                        return null;
                    }
                    return new IsPredicate(pA, e.getKind());
                }
            }
            return null;
        }
    }

    private static class Comparison
    implements Predicate {
        final RexNode ref;
        final SqlKind kind;
        final RexLiteral literal;

        private Comparison(RexNode ref, SqlKind kind, RexLiteral literal) {
            this.ref = Objects.requireNonNull(ref);
            this.kind = Objects.requireNonNull(kind);
            this.literal = Objects.requireNonNull(literal);
        }

        static Comparison of(RexNode e) {
            return Comparison.of(e, node -> RexUtil.isReferenceOrAccess(node, true) || RexUtil.isDeterministic(node));
        }

        /*
         * Enabled aggressive block sorting
         */
        static Comparison of(RexNode e, java.util.function.Predicate<RexNode> nodePredicate) {
            switch (e.getKind()) {
                case EQUALS: 
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: 
                case NOT_EQUALS: {
                    RexCall call = (RexCall)e;
                    RexNode left = call.getOperands().get(0);
                    RexNode right = call.getOperands().get(1);
                    switch (right.getKind()) {
                        case LITERAL: {
                            if (!nodePredicate.test(left)) break;
                            return new Comparison(left, e.getKind(), (RexLiteral)right);
                        }
                    }
                    switch (left.getKind()) {
                        case LITERAL: {
                            if (!nodePredicate.test(right)) return null;
                            return new Comparison(right, e.getKind().reverse(), (RexLiteral)left);
                        }
                    }
                    return null;
                }
            }
            return null;
        }

        @Override
        public boolean allowedInOr(RelOptPredicateList predicates) {
            return !this.ref.getType().isNullable() || predicates.isEffectivelyNotNull(this.ref);
        }
    }

    private static interface Predicate {
        public static Predicate of(RexNode t) {
            Comparison p = Comparison.of(t);
            if (p != null) {
                return p;
            }
            return IsPredicate.of(t);
        }

        default public boolean allowedInOr(RelOptPredicateList predicates) {
            return true;
        }
    }

    static enum SafeRexVisitor implements RexVisitor<Boolean>
    {
        INSTANCE;

        private final Set<SqlKind> safeOps;

        private SafeRexVisitor() {
            EnumSet<SqlKind> safeOps = EnumSet.noneOf(SqlKind.class);
            safeOps.addAll(SqlKind.COMPARISON);
            safeOps.add(SqlKind.PLUS_PREFIX);
            safeOps.add(SqlKind.MINUS_PREFIX);
            safeOps.add(SqlKind.PLUS);
            safeOps.add(SqlKind.MINUS);
            safeOps.add(SqlKind.TIMES);
            safeOps.add(SqlKind.IS_FALSE);
            safeOps.add(SqlKind.IS_NOT_FALSE);
            safeOps.add(SqlKind.IS_TRUE);
            safeOps.add(SqlKind.IS_NOT_TRUE);
            safeOps.add(SqlKind.IS_NULL);
            safeOps.add(SqlKind.IS_NOT_NULL);
            safeOps.add(SqlKind.IS_DISTINCT_FROM);
            safeOps.add(SqlKind.IS_NOT_DISTINCT_FROM);
            safeOps.add(SqlKind.IN);
            safeOps.add(SqlKind.SEARCH);
            safeOps.add(SqlKind.OR);
            safeOps.add(SqlKind.AND);
            safeOps.add(SqlKind.NOT);
            safeOps.add(SqlKind.CASE);
            safeOps.add(SqlKind.LIKE);
            safeOps.add(SqlKind.COALESCE);
            safeOps.add(SqlKind.TRIM);
            safeOps.add(SqlKind.LTRIM);
            safeOps.add(SqlKind.RTRIM);
            safeOps.add(SqlKind.BETWEEN);
            safeOps.add(SqlKind.CEIL);
            safeOps.add(SqlKind.FLOOR);
            safeOps.add(SqlKind.REVERSE);
            safeOps.add(SqlKind.TIMESTAMP_ADD);
            safeOps.add(SqlKind.TIMESTAMP_DIFF);
            this.safeOps = Sets.immutableEnumSet(safeOps);
        }

        @Override
        public Boolean visitInputRef(RexInputRef inputRef) {
            return true;
        }

        @Override
        public Boolean visitLocalRef(RexLocalRef localRef) {
            return false;
        }

        @Override
        public Boolean visitLiteral(RexLiteral literal) {
            return true;
        }

        @Override
        public Boolean visitCall(RexCall call) {
            if (!this.safeOps.contains((Object)call.getKind())) {
                return false;
            }
            return RexVisitorImpl.visitArrayAnd(this, call.operands);
        }

        @Override
        public Boolean visitOver(RexOver over2) {
            return false;
        }

        @Override
        public Boolean visitCorrelVariable(RexCorrelVariable correlVariable) {
            return false;
        }

        @Override
        public Boolean visitDynamicParam(RexDynamicParam dynamicParam) {
            return false;
        }

        @Override
        public Boolean visitRangeRef(RexRangeRef rangeRef) {
            return false;
        }

        @Override
        public Boolean visitFieldAccess(RexFieldAccess fieldAccess) {
            return true;
        }

        @Override
        public Boolean visitSubQuery(RexSubQuery subQuery) {
            return false;
        }

        @Override
        public Boolean visitTableInputRef(RexTableInputRef fieldRef) {
            return false;
        }

        @Override
        public Boolean visitPatternFieldRef(RexPatternFieldRef fieldRef) {
            return false;
        }
    }

    static final class CaseBranch {
        private final RexNode cond;
        private final RexNode value;

        CaseBranch(RexNode cond, RexNode value) {
            this.cond = cond;
            this.value = value;
        }

        public String toString() {
            return this.cond + " => " + this.value;
        }

        private static List<CaseBranch> fromCaseOperands(RexBuilder rexBuilder, List<RexNode> operands) {
            ArrayList<CaseBranch> ret = new ArrayList<CaseBranch>();
            for (int i = 0; i < operands.size() - 1; i += 2) {
                ret.add(new CaseBranch(operands.get(i), operands.get(i + 1)));
            }
            ret.add(new CaseBranch(rexBuilder.makeLiteral(true), Util.last(operands)));
            return ret;
        }

        private static List<RexNode> toCaseOperands(List<CaseBranch> branches) {
            ArrayList<RexNode> ret = new ArrayList<RexNode>();
            for (int i = 0; i < branches.size() - 1; ++i) {
                CaseBranch branch = branches.get(i);
                ret.add(branch.cond);
                ret.add(branch.value);
            }
            CaseBranch lastBranch = Util.last(branches);
            assert (lastBranch.cond.isAlwaysTrue());
            ret.add(lastBranch.value);
            return ret;
        }
    }
}

