/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import java.math.BigDecimal;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.rel.metadata.NullSentinel;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexInterpreter;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableMap;

public class RexAnalyzer {
    public final RexNode e;
    public final List<RexNode> variables;
    public final int unsupportedCount;

    public RexAnalyzer(RexNode e, RelOptPredicateList predicates) {
        this.e = e;
        VariableCollector variableCollector = new VariableCollector();
        e.accept(variableCollector);
        variableCollector.visitEach(predicates.pulledUpPredicates);
        this.variables = ImmutableList.copyOf(variableCollector.builder);
        this.unsupportedCount = variableCollector.unsupportedCount;
    }

    public Iterable<Map<RexNode, Comparable>> assignments() {
        List generators = this.variables.stream().map(RexAnalyzer::getComparables).collect(Util.toImmutableList());
        Iterable product2 = Linq4j.product(generators);
        return Util.transform(product2, values -> ImmutableMap.copyOf(Pair.zip(this.variables, values)));
    }

    private static List<Comparable> getComparables(RexNode variable) {
        ImmutableList.Builder values = ImmutableList.builder();
        switch (variable.getType().getSqlTypeName()) {
            case BOOLEAN: {
                values.add((Object)true);
                values.add((Object)false);
                break;
            }
            case INTEGER: {
                values.add(BigDecimal.valueOf(-1L));
                values.add(BigDecimal.valueOf(0L));
                values.add(BigDecimal.valueOf(1L));
                values.add(BigDecimal.valueOf(1000000L));
                break;
            }
            case DECIMAL: {
                values.add(BigDecimal.valueOf(-100L));
                values.add(BigDecimal.valueOf(100L));
                break;
            }
            case VARCHAR: {
                values.add(new NlsString("", null, null));
                values.add(new NlsString("hello", null, null));
                break;
            }
            case TIMESTAMP: {
                values.add((Object)0L);
                break;
            }
            case DATE: {
                values.add((Object)0);
                values.add((Object)365);
                values.add((Object)-365);
                break;
            }
            case TIME: {
                values.add((Object)0);
                values.add((Object)86399000);
                break;
            }
            default: {
                throw new AssertionError((Object)("don't know values for " + variable + " of type " + variable.getType()));
            }
        }
        if (variable.getType().isNullable()) {
            values.add((Object)NullSentinel.INSTANCE);
        }
        return values.build();
    }

    private static class VariableCollector
    extends RexVisitorImpl<Void> {
        private final Set<RexNode> builder = new LinkedHashSet<RexNode>();
        private int unsupportedCount = 0;

        VariableCollector() {
            super(true);
        }

        @Override
        public Void visitInputRef(RexInputRef inputRef) {
            this.builder.add(inputRef);
            return (Void)super.visitInputRef(inputRef);
        }

        @Override
        public Void visitFieldAccess(RexFieldAccess fieldAccess) {
            if (fieldAccess.getReferenceExpr() instanceof RexDynamicParam) {
                this.builder.add(fieldAccess);
                return null;
            }
            return (Void)super.visitFieldAccess(fieldAccess);
        }

        @Override
        public Void visitCall(RexCall call) {
            if (!RexInterpreter.SUPPORTED_SQL_KIND.contains((Object)call.getKind())) {
                ++this.unsupportedCount;
                return null;
            }
            return (Void)super.visitCall(call);
        }
    }
}

