/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan.volcano;

import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.plan.volcano.VolcanoRuleMatch;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.util.Util;

public abstract class RuleQueue {
    protected final VolcanoPlanner planner;

    protected RuleQueue(VolcanoPlanner planner) {
        this.planner = planner;
    }

    public abstract void addMatch(VolcanoRuleMatch var1);

    public abstract boolean clear();

    protected boolean skipMatch(VolcanoRuleMatch match) {
        for (RelNode rel : match.rels) {
            if (!this.planner.prunedNodes.contains(rel)) continue;
            return true;
        }
        ArrayDeque<RelSubset> subsets = new ArrayDeque<RelSubset>();
        try {
            this.checkDuplicateSubsets(subsets, match.rule.getOperand(), match.rels);
        }
        catch (Util.FoundOne e) {
            return true;
        }
        return false;
    }

    private void checkDuplicateSubsets(Deque<RelSubset> subsets, RelOptRuleOperand operand, RelNode[] rels) {
        RelSubset subset = this.planner.getSubset(rels[operand.ordinalInRule]);
        if (subsets.contains(subset)) {
            throw Util.FoundOne.NULL;
        }
        if (!operand.getChildOperands().isEmpty()) {
            subsets.push(subset);
            for (RelOptRuleOperand childOperand : operand.getChildOperands()) {
                this.checkDuplicateSubsets(subsets, childOperand, rels);
            }
            RelSubset x = subsets.pop();
            assert (x == subset);
        }
    }
}

