/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types;

import java.time.DayOfWeek;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypeQueryable;
import org.apache.flink.table.types.utils.DataTypeFactoryMock;
import org.apache.flink.table.types.utils.TypeInfoDataTypeConverter;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class TypeInfoDataTypeConverterTest {
    TypeInfoDataTypeConverterTest() {
    }

    private static Stream<TestSpec> testData() {
        return Stream.of(TestSpec.forType(Types.INT).expectDataType((DataType)DataTypes.INT().notNull()), TestSpec.forType(Types.BIG_DEC).expectDataType((DataType)DataTypes.DECIMAL((int)38, (int)18).nullable()), TestSpec.forType(Types.ROW_NAMED((String[])new String[]{"a", "b", "c"}, (TypeInformation[])new TypeInformation[]{Types.DOUBLE, Types.INT, Types.STRING})).expectDataType((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"b", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"c", (DataType)DataTypes.STRING())}).notNull()), TestSpec.forType(Types.TUPLE((TypeInformation[])new TypeInformation[]{Types.INT, Types.TUPLE((TypeInformation[])new TypeInformation[]{Types.STRING, Types.BOOLEAN}), Types.LONG})).expectDataType((DataType)DataTypes.STRUCTURED(Tuple3.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)((DataType)DataTypes.INT().notNull())), DataTypes.FIELD((String)"f1", (DataType)((DataType)DataTypes.STRUCTURED(Tuple2.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)((DataType)DataTypes.STRING().nullable())), DataTypes.FIELD((String)"f1", (DataType)((DataType)DataTypes.BOOLEAN().notNull()))}).notNull())), DataTypes.FIELD((String)"f2", (DataType)((DataType)DataTypes.BIGINT().notNull()))}).notNull()), TestSpec.forType(Types.POJO(PojoWithFieldOrder.class)).expectDataType(DataTypes.STRUCTURED(PojoWithFieldOrder.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"name", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"gender", (DataType)((DataType)((DataType)DataTypes.BOOLEAN().notNull()).bridgedTo(Boolean.TYPE))), DataTypes.FIELD((String)"age", (DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))})), TestSpec.forType(Types.POJO(PojoWithDefaultFieldOrder.class)).expectDataType(DataTypes.STRUCTURED(PojoWithDefaultFieldOrder.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"age", (DataType)((DataType)DataTypes.INT().nullable())), DataTypes.FIELD((String)"gender", (DataType)((DataType)((DataType)DataTypes.BOOLEAN().notNull()).bridgedTo(Boolean.TYPE))), DataTypes.FIELD((String)"name", (DataType)DataTypes.STRING())})), TestSpec.forType(new QueryableTypeInfo()).expectDataType(DataTypes.BYTES()), TestSpec.forType(Types.ENUM(DayOfWeek.class)).lookupExpects(DayOfWeek.class).expectDataType(DataTypeFactoryMock.dummyRaw(DayOfWeek.class)));
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"testData"})
    void testConversion(TestSpec testSpec) {
        Assertions.assertThat((Object)TypeInfoDataTypeConverter.toDataType((DataTypeFactory)testSpec.typeFactory, testSpec.typeInfo)).isEqualTo((Object)testSpec.expectedDataType);
    }

    public static class QueryableTypeInfo
    extends TypeInformation<Object>
    implements DataTypeQueryable {
        public boolean isBasicType() {
            return false;
        }

        public boolean isTupleType() {
            return false;
        }

        public int getArity() {
            return 0;
        }

        public int getTotalFields() {
            return 0;
        }

        public Class<Object> getTypeClass() {
            return null;
        }

        public boolean isKeyType() {
            return false;
        }

        public TypeSerializer<Object> createSerializer(ExecutionConfig config) {
            return null;
        }

        public String toString() {
            return null;
        }

        public boolean equals(Object obj) {
            return false;
        }

        public int hashCode() {
            return 0;
        }

        public boolean canEqual(Object obj) {
            return false;
        }

        public DataType getDataType() {
            return DataTypes.BYTES();
        }
    }

    public static class PojoWithDefaultFieldOrder {
        public boolean gender;
        public String name;
        public Integer age;
    }

    public static class PojoWithFieldOrder {
        public boolean gender;
        public String name;
        public int age;

        public PojoWithFieldOrder() {
        }

        public PojoWithFieldOrder(String name, boolean gender, int age) {
            this.name = name;
            this.gender = gender;
            this.age = age;
        }
    }

    static class TestSpec {
        final DataTypeFactoryMock typeFactory = new DataTypeFactoryMock();
        final TypeInformation<?> typeInfo;
        DataType expectedDataType;

        private TestSpec(TypeInformation<?> typeInfo) {
            this.typeInfo = typeInfo;
        }

        static TestSpec forType(TypeInformation<?> typeInfo) {
            return new TestSpec(typeInfo);
        }

        TestSpec lookupExpects(Class<?> lookupClass) {
            this.typeFactory.dataType = Optional.of(DataTypeFactoryMock.dummyRaw(lookupClass));
            this.typeFactory.expectedClass = Optional.of(lookupClass);
            return this;
        }

        TestSpec expectDataType(DataType expectedDataType) {
            this.expectedDataType = expectedDataType;
            return this;
        }

        public String toString() {
            return this.typeInfo + " to " + this.expectedDataType;
        }
    }
}

