/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.expressions.TimeIntervalUnit;
import org.apache.flink.table.test.LogicalTypeAssert;
import org.apache.flink.table.test.TableAssertions;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DayTimeIntervalType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.NullType;
import org.apache.flink.table.types.logical.RawType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.SymbolType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.TypeInformationRawType;
import org.apache.flink.table.types.logical.UnresolvedUserDefinedType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.YearMonthIntervalType;
import org.apache.flink.table.types.logical.ZonedTimestampType;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;

public class LogicalTypesTest {
    private static final LogicalType UDT_NAME_TYPE = new VarCharType();
    private static final LogicalType UDT_SETTING_TYPE = new IntType();
    private static final LogicalType UDT_TIMESTAMP_TYPE = new TimestampType();

    @Test
    void testCharType() {
        TableAssertions.assertThat((LogicalType)new CharType(33)).satisfies(new ThrowingConsumer[]{LogicalTypesTest.baseAssertions("CHAR(33)", "CHAR(33)", new Class[]{String.class, byte[].class}, new Class[]{String.class, byte[].class}, new LogicalType[0], (LogicalType)new CharType(Integer.MAX_VALUE))});
    }

    @Test
    void testVarCharType() {
        TableAssertions.assertThat((LogicalType)new VarCharType(33)).satisfies(new ThrowingConsumer[]{LogicalTypesTest.baseAssertions("VARCHAR(33)", "VARCHAR(33)", new Class[]{String.class, byte[].class}, new Class[]{String.class, byte[].class}, new LogicalType[0], (LogicalType)new VarCharType(12))});
    }

    @Test
    void testVarCharTypeWithMaximumLength() {
        TableAssertions.assertThat((LogicalType)new VarCharType(Integer.MAX_VALUE)).satisfies(new ThrowingConsumer[]{LogicalTypesTest.baseAssertions("VARCHAR(2147483647)", "STRING", new Class[]{String.class, byte[].class}, new Class[]{String.class, byte[].class}, new LogicalType[0], (LogicalType)new VarCharType(12))});
    }

    @Test
    void testBooleanType() {
        TableAssertions.assertThat((LogicalType)new BooleanType()).satisfies(new ThrowingConsumer[]{LogicalTypesTest.baseAssertions("BOOLEAN", "BOOLEAN", new Class[]{Boolean.class, Boolean.TYPE}, new Class[]{Boolean.class}, new LogicalType[0], (LogicalType)new BooleanType(false))});
    }

    @Test
    void testBinaryType() {
        TableAssertions.assertThat((LogicalType)new BinaryType(22)).satisfies(new ThrowingConsumer[]{LogicalTypesTest.baseAssertions("BINARY(22)", "BINARY(22)", new Class[]{byte[].class}, new Class[]{byte[].class}, new LogicalType[0], (LogicalType)new BinaryType())});
    }

    @Test
    void testVarBinaryType() {
        TableAssertions.assertThat((LogicalType)new VarBinaryType(22)).satisfies(new ThrowingConsumer[]{LogicalTypesTest.baseAssertions("VARBINARY(22)", "VARBINARY(22)", new Class[]{byte[].class}, new Class[]{byte[].class}, new LogicalType[0], (LogicalType)new VarBinaryType())});
    }

    @Test
    void testVarBinaryTypeWithMaximumLength() {
        TableAssertions.assertThat((LogicalType)new VarBinaryType(Integer.MAX_VALUE)).satisfies(new ThrowingConsumer[]{LogicalTypesTest.baseAssertions("VARBINARY(2147483647)", "BYTES", new Class[]{byte[].class}, new Class[]{byte[].class}, new LogicalType[0], (LogicalType)new VarBinaryType(12))});
    }

    @Test
    void testDecimalType() {
        TableAssertions.assertThat((LogicalType)new DecimalType(10, 2)).satisfies(new ThrowingConsumer[]{LogicalTypesTest.baseAssertions("DECIMAL(10, 2)", "DECIMAL(10, 2)", new Class[]{BigDecimal.class}, new Class[]{BigDecimal.class}, new LogicalType[0], (LogicalType)new DecimalType())});
    }

    @Test
    void testTinyIntType() {
        TableAssertions.assertThat((LogicalType)new TinyIntType()).satisfies(new ThrowingConsumer[]{LogicalTypesTest.baseAssertions("TINYINT", "TINYINT", new Class[]{Byte.class, Byte.TYPE}, new Class[]{Byte.class}, new LogicalType[0], (LogicalType)new TinyIntType(false))});
    }

    @Test
    void testSmallIntType() {
        TableAssertions.assertThat((LogicalType)new SmallIntType()).satisfies(new ThrowingConsumer[]{LogicalTypesTest.baseAssertions("SMALLINT", "SMALLINT", new Class[]{Short.class, Short.TYPE}, new Class[]{Short.class}, new LogicalType[0], (LogicalType)new SmallIntType(false))});
    }

    @Test
    void testIntType() {
        TableAssertions.assertThat((LogicalType)new IntType()).satisfies(new ThrowingConsumer[]{LogicalTypesTest.baseAssertions("INT", "INT", new Class[]{Integer.class, Integer.TYPE}, new Class[]{Integer.class}, new LogicalType[0], (LogicalType)new IntType(false))});
    }

    @Test
    void testBigIntType() {
        TableAssertions.assertThat((LogicalType)new BigIntType()).satisfies(new ThrowingConsumer[]{LogicalTypesTest.baseAssertions("BIGINT", "BIGINT", new Class[]{Long.class, Long.TYPE}, new Class[]{Long.class}, new LogicalType[0], (LogicalType)new BigIntType(false))});
    }

    @Test
    void testFloatType() {
        TableAssertions.assertThat((LogicalType)new FloatType()).satisfies(new ThrowingConsumer[]{LogicalTypesTest.baseAssertions("FLOAT", "FLOAT", new Class[]{Float.class, Float.TYPE}, new Class[]{Float.class}, new LogicalType[0], (LogicalType)new FloatType(false))});
    }

    @Test
    void testDoubleType() {
        TableAssertions.assertThat((LogicalType)new DoubleType()).satisfies(new ThrowingConsumer[]{LogicalTypesTest.baseAssertions("DOUBLE", "DOUBLE", new Class[]{Double.class, Double.TYPE}, new Class[]{Double.class}, new LogicalType[0], (LogicalType)new DoubleType(false))});
    }

    @Test
    void testDateType() {
        TableAssertions.assertThat((LogicalType)new DateType()).satisfies(new ThrowingConsumer[]{LogicalTypesTest.baseAssertions("DATE", "DATE", new Class[]{Date.class, LocalDate.class, Integer.TYPE}, new Class[]{LocalDate.class}, new LogicalType[0], (LogicalType)new DateType(false))});
    }

    @Test
    void testTimeType() {
        TableAssertions.assertThat((LogicalType)new TimeType(9)).satisfies(new ThrowingConsumer[]{LogicalTypesTest.baseAssertions("TIME(9)", "TIME(9)", new Class[]{Time.class, LocalTime.class, Long.TYPE}, new Class[]{LocalTime.class}, new LogicalType[0], (LogicalType)new TimeType())});
    }

    @Test
    void testTimestampType() {
        TableAssertions.assertThat((LogicalType)new TimestampType(9)).satisfies(new ThrowingConsumer[]{LogicalTypesTest.baseAssertions("TIMESTAMP(9)", "TIMESTAMP(9)", new Class[]{Timestamp.class, LocalDateTime.class}, new Class[]{LocalDateTime.class}, new LogicalType[0], (LogicalType)new TimestampType(3))});
    }

    @Test
    void testTimestampTypeWithTimeAttribute() {
        TableAssertions.assertThat((LogicalType)new TimestampType(true, TimestampKind.ROWTIME, 9)).satisfies(new ThrowingConsumer[]{LogicalTypesTest.baseAssertions("TIMESTAMP(9)", "TIMESTAMP(9) *ROWTIME*", new Class[]{Timestamp.class, LocalDateTime.class}, new Class[]{LocalDateTime.class}, new LogicalType[0], (LogicalType)new TimestampType(3))});
    }

    @Test
    void testZonedTimestampType() {
        TableAssertions.assertThat((LogicalType)new ZonedTimestampType(9)).satisfies(new ThrowingConsumer[]{LogicalTypesTest.baseAssertions("TIMESTAMP(9) WITH TIME ZONE", "TIMESTAMP(9) WITH TIME ZONE", new Class[]{ZonedDateTime.class, OffsetDateTime.class}, new Class[]{OffsetDateTime.class}, new LogicalType[0], (LogicalType)new ZonedTimestampType(3))});
    }

    @Test
    void testZonedTimestampTypeWithTimeAttribute() {
        TableAssertions.assertThat((LogicalType)new ZonedTimestampType(true, TimestampKind.ROWTIME, 9)).satisfies(new ThrowingConsumer[]{LogicalTypesTest.baseAssertions("TIMESTAMP(9) WITH TIME ZONE", "TIMESTAMP(9) WITH TIME ZONE *ROWTIME*", new Class[]{ZonedDateTime.class, OffsetDateTime.class}, new Class[]{OffsetDateTime.class}, new LogicalType[0], (LogicalType)new ZonedTimestampType(3))});
    }

    @Test
    void testLocalZonedTimestampType() {
        TableAssertions.assertThat((LogicalType)new LocalZonedTimestampType(9)).satisfies(new ThrowingConsumer[]{LogicalTypesTest.baseAssertions("TIMESTAMP(9) WITH LOCAL TIME ZONE", "TIMESTAMP_LTZ(9)", new Class[]{Instant.class, Long.TYPE, Integer.TYPE}, new Class[]{Instant.class}, new LogicalType[0], (LogicalType)new LocalZonedTimestampType(3))});
    }

    @Test
    void testLocalZonedTimestampTypeWithTimeAttribute() {
        TableAssertions.assertThat((LogicalType)new LocalZonedTimestampType(true, TimestampKind.ROWTIME, 9)).satisfies(new ThrowingConsumer[]{LogicalTypesTest.baseAssertions("TIMESTAMP(9) WITH LOCAL TIME ZONE", "TIMESTAMP_LTZ(9) *ROWTIME*", new Class[]{Instant.class, Long.TYPE, Integer.TYPE}, new Class[]{Instant.class}, new LogicalType[0], (LogicalType)new LocalZonedTimestampType(3))});
    }

    @Test
    void testYearMonthIntervalType() {
        TableAssertions.assertThat((LogicalType)new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.YEAR_TO_MONTH, 2)).satisfies(new ThrowingConsumer[]{LogicalTypesTest.baseAssertions("INTERVAL YEAR(2) TO MONTH", "INTERVAL YEAR(2) TO MONTH", new Class[]{Period.class, Integer.TYPE}, new Class[]{Period.class}, new LogicalType[0], (LogicalType)new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.MONTH))});
    }

    @Test
    void testDayTimeIntervalType() {
        TableAssertions.assertThat((LogicalType)new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.DAY_TO_SECOND, 2, 6)).satisfies(new ThrowingConsumer[]{LogicalTypesTest.baseAssertions("INTERVAL DAY(2) TO SECOND(6)", "INTERVAL DAY(2) TO SECOND(6)", new Class[]{Duration.class, Long.TYPE}, new Class[]{Duration.class}, new LogicalType[0], (LogicalType)new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.DAY_TO_SECOND, 2, 7))});
    }

    @Test
    void testArrayType() {
        TableAssertions.assertThat((LogicalType)new ArrayType((LogicalType)new TimestampType())).satisfies(new ThrowingConsumer[]{LogicalTypesTest.baseAssertions("ARRAY<TIMESTAMP(6)>", "ARRAY<TIMESTAMP(6)>", new Class[]{Timestamp[].class, LocalDateTime[].class, List.class, ArrayList.class}, new Class[]{Timestamp[].class, LocalDateTime[].class, List.class}, new LogicalType[]{new TimestampType()}, (LogicalType)new ArrayType((LogicalType)new SmallIntType()))});
        TableAssertions.assertThat((LogicalType)new ArrayType((LogicalType)new ArrayType((LogicalType)new TimestampType()))).satisfies(new ThrowingConsumer[]{LogicalTypesTest.baseAssertions("ARRAY<ARRAY<TIMESTAMP(6)>>", "ARRAY<ARRAY<TIMESTAMP(6)>>", new Class[]{Timestamp[][].class, LocalDateTime[][].class}, new Class[]{Timestamp[][].class, LocalDateTime[][].class}, new LogicalType[]{new ArrayType((LogicalType)new TimestampType())}, (LogicalType)new ArrayType((LogicalType)new ArrayType((LogicalType)new SmallIntType())))});
        ArrayType nestedArray = new ArrayType((LogicalType)new ArrayType((LogicalType)new TimestampType()));
        TableAssertions.assertThat((LogicalType)nestedArray).doesNotSupportInputConversion(Timestamp[].class).doesNotSupportOutputConversion(Timestamp[].class);
    }

    @Test
    void testMultisetType() {
        TableAssertions.assertThat((LogicalType)new MultisetType((LogicalType)new TimestampType())).satisfies(new ThrowingConsumer[]{LogicalTypesTest.baseAssertions("MULTISET<TIMESTAMP(6)>", "MULTISET<TIMESTAMP(6)>", new Class[]{Map.class, HashMap.class, TreeMap.class}, new Class[]{Map.class}, new LogicalType[]{new TimestampType()}, (LogicalType)new MultisetType((LogicalType)new SmallIntType()))});
        TableAssertions.assertThat((LogicalType)new MultisetType((LogicalType)new MultisetType((LogicalType)new TimestampType()))).satisfies(new ThrowingConsumer[]{LogicalTypesTest.baseAssertions("MULTISET<MULTISET<TIMESTAMP(6)>>", "MULTISET<MULTISET<TIMESTAMP(6)>>", new Class[]{Map.class, HashMap.class, TreeMap.class}, new Class[]{Map.class}, new LogicalType[]{new MultisetType((LogicalType)new TimestampType())}, (LogicalType)new MultisetType((LogicalType)new MultisetType((LogicalType)new SmallIntType())))});
    }

    @Test
    void testMapType() {
        TableAssertions.assertThat((LogicalType)new MapType((LogicalType)new VarCharType(20), (LogicalType)new TimestampType())).satisfies(new ThrowingConsumer[]{LogicalTypesTest.baseAssertions("MAP<VARCHAR(20), TIMESTAMP(6)>", "MAP<VARCHAR(20), TIMESTAMP(6)>", new Class[]{Map.class, HashMap.class, TreeMap.class}, new Class[]{Map.class}, new LogicalType[]{new VarCharType(20), new TimestampType()}, (LogicalType)new MapType((LogicalType)new VarCharType(99), (LogicalType)new TimestampType()))});
    }

    @Test
    void testRowType() {
        TableAssertions.assertThat((LogicalType)new RowType(Arrays.asList(new RowType.RowField("a", (LogicalType)new VarCharType(), "Someone's desc."), new RowType.RowField("b`", (LogicalType)new TimestampType())))).satisfies(new ThrowingConsumer[]{LogicalTypesTest.baseAssertions("ROW<`a` VARCHAR(1) 'Someone''s desc.', `b``` TIMESTAMP(6)>", "ROW<`a` VARCHAR(1) '...', `b``` TIMESTAMP(6)>", new Class[]{Row.class}, new Class[]{Row.class}, new LogicalType[]{new VarCharType(), new TimestampType()}, (LogicalType)new RowType(Arrays.asList(new RowType.RowField("a", (LogicalType)new VarCharType(), "Different desc."), new RowType.RowField("b`", (LogicalType)new TimestampType()))))});
        Assertions.assertThatThrownBy(() -> new RowType(Arrays.asList(new RowType.RowField("b", (LogicalType)new VarCharType()), new RowType.RowField("b", (LogicalType)new VarCharType()), new RowType.RowField("a", (LogicalType)new VarCharType()), new RowType.RowField("a", (LogicalType)new TimestampType())))).isInstanceOf(ValidationException.class);
        Assertions.assertThatThrownBy(() -> new RowType(Collections.singletonList(new RowType.RowField("", (LogicalType)new VarCharType())))).isInstanceOf(ValidationException.class);
    }

    @Test
    void testDistinctType() {
        TableAssertions.assertThat((LogicalType)this.createDistinctType("Money")).satisfies(new ThrowingConsumer[]{LogicalTypesTest.baseAssertions("`cat`.`db`.`Money`", "`cat`.`db`.`Money`", new Class[]{BigDecimal.class}, new Class[]{BigDecimal.class}, new LogicalType[]{new DecimalType(10, 2)}, (LogicalType)this.createDistinctType("Monetary"))});
    }

    @Test
    void testStructuredType() {
        TableAssertions.assertThat((LogicalType)this.createUserType(true, true)).satisfies(new ThrowingConsumer[]{LogicalTypesTest.baseAssertions("`cat`.`db`.`User`", "`cat`.`db`.`User`", new Class[]{Row.class, User.class}, new Class[]{Row.class, Human.class, User.class}, new LogicalType[]{UDT_NAME_TYPE, UDT_SETTING_TYPE, UDT_TIMESTAMP_TYPE}, (LogicalType)this.createUserType(true, false))});
        TableAssertions.assertThat((LogicalType)this.createHumanType(false)).satisfies(new ThrowingConsumer[]{LogicalTypesTest.conversions(new Class[]{Row.class, Human.class, User.class}, new Class[]{Row.class, Human.class})});
        TableAssertions.assertThat((LogicalType)this.createUserType(true, true)).doesNotSupportInputConversion(Human.class);
        TableAssertions.assertThat((LogicalType)this.createHumanType(true)).doesNotSupportInputConversion(User.class);
    }

    @Test
    void testNullType() {
        ((LogicalTypeAssert)TableAssertions.assertThat((LogicalType)new NullType()).isJavaSerializable().satisfies(new ThrowingConsumer[]{LogicalTypesTest.nonEqualityCheckWithOtherType((LogicalType)new TimeType())})).hasSerializableString("NULL").hasSummaryString("NULL").supportsInputConversion(Object.class).supportsOutputConversion(Object.class).supportsOutputConversion(Integer.class).doesNotSupportOutputConversion(Integer.TYPE);
    }

    @Test
    void testTypeInformationRawType() throws Exception {
        TypeInformationRawType rawType = new TypeInformationRawType(Types.TUPLE((TypeInformation[])new TypeInformation[]{Types.STRING, Types.INT}));
        ((LogicalTypeAssert)((LogicalTypeAssert)TableAssertions.assertThat((LogicalType)rawType).satisfies(new ThrowingConsumer[]{LogicalTypesTest.nonEqualityCheckWithOtherType((LogicalType)new TypeInformationRawType(Types.TUPLE((TypeInformation[])new TypeInformation[]{Types.STRING, Types.LONG})))})).satisfies(new ThrowingConsumer[]{LogicalTypesTest::nullability})).isJavaSerializable().hasSummaryString("RAW('org.apache.flink.api.java.tuple.Tuple2', ?)").hasNoSerializableString().satisfies(new ThrowingConsumer[]{LogicalTypesTest.conversions(new Class[]{Tuple2.class}, new Class[]{Tuple.class})});
    }

    @Test
    void testRawType() {
        RawType rawType = new RawType(Human.class, (TypeSerializer)new KryoSerializer(Human.class, new ExecutionConfig()));
        String className = "org.apache.flink.table.types.LogicalTypesTest$Human";
        String serializerString = "AEdvcmcuYXBhY2hlLmZsaW5rLmFwaS5qYXZhLnR5cGV1dGlscy5ydW50aW1lLmtyeW8uS3J5b1NlcmlhbGl6ZXJTbmFwc2hvdAAAAAIAM29yZy5hcGFjaGUuZmxpbmsudGFibGUudHlwZXMuTG9naWNhbFR5cGVzVGVzdCRIdW1hbgAABPLGmj1wAAAAAgAzb3JnLmFwYWNoZS5mbGluay50YWJsZS50eXBlcy5Mb2dpY2FsVHlwZXNUZXN0JEh1bWFuAQAAADUAM29yZy5hcGFjaGUuZmxpbmsudGFibGUudHlwZXMuTG9naWNhbFR5cGVzVGVzdCRIdW1hbgEAAAA5ADNvcmcuYXBhY2hlLmZsaW5rLnRhYmxlLnR5cGVzLkxvZ2ljYWxUeXBlc1Rlc3QkSHVtYW4AAAAAAClvcmcuYXBhY2hlLmF2cm8uZ2VuZXJpYy5HZW5lcmljRGF0YSRBcnJheQEAAAArAClvcmcuYXBhY2hlLmF2cm8uZ2VuZXJpYy5HZW5lcmljRGF0YSRBcnJheQEAAAC2AFVvcmcuYXBhY2hlLmZsaW5rLmFwaS5qYXZhLnR5cGV1dGlscy5ydW50aW1lLmtyeW8uU2VyaWFsaXplcnMkRHVtbXlBdnJvUmVnaXN0ZXJlZENsYXNzAAAAAQBZb3JnLmFwYWNoZS5mbGluay5hcGkuamF2YS50eXBldXRpbHMucnVudGltZS5rcnlvLlNlcmlhbGl6ZXJzJER1bW15QXZyb0tyeW9TZXJpYWxpemVyQ2xhc3MAAATyxpo9cAAAAAAAAATyxpo9cAAAAAA=";
        TableAssertions.assertThat((LogicalType)rawType).satisfies(new ThrowingConsumer[]{LogicalTypesTest.baseAssertions("RAW('org.apache.flink.table.types.LogicalTypesTest$Human', 'AEdvcmcuYXBhY2hlLmZsaW5rLmFwaS5qYXZhLnR5cGV1dGlscy5ydW50aW1lLmtyeW8uS3J5b1NlcmlhbGl6ZXJTbmFwc2hvdAAAAAIAM29yZy5hcGFjaGUuZmxpbmsudGFibGUudHlwZXMuTG9naWNhbFR5cGVzVGVzdCRIdW1hbgAABPLGmj1wAAAAAgAzb3JnLmFwYWNoZS5mbGluay50YWJsZS50eXBlcy5Mb2dpY2FsVHlwZXNUZXN0JEh1bWFuAQAAADUAM29yZy5hcGFjaGUuZmxpbmsudGFibGUudHlwZXMuTG9naWNhbFR5cGVzVGVzdCRIdW1hbgEAAAA5ADNvcmcuYXBhY2hlLmZsaW5rLnRhYmxlLnR5cGVzLkxvZ2ljYWxUeXBlc1Rlc3QkSHVtYW4AAAAAAClvcmcuYXBhY2hlLmF2cm8uZ2VuZXJpYy5HZW5lcmljRGF0YSRBcnJheQEAAAArAClvcmcuYXBhY2hlLmF2cm8uZ2VuZXJpYy5HZW5lcmljRGF0YSRBcnJheQEAAAC2AFVvcmcuYXBhY2hlLmZsaW5rLmFwaS5qYXZhLnR5cGV1dGlscy5ydW50aW1lLmtyeW8uU2VyaWFsaXplcnMkRHVtbXlBdnJvUmVnaXN0ZXJlZENsYXNzAAAAAQBZb3JnLmFwYWNoZS5mbGluay5hcGkuamF2YS50eXBldXRpbHMucnVudGltZS5rcnlvLlNlcmlhbGl6ZXJzJER1bW15QXZyb0tyeW9TZXJpYWxpemVyQ2xhc3MAAATyxpo9cAAAAAAAAATyxpo9cAAAAAA=')", "RAW('org.apache.flink.table.types.LogicalTypesTest$Human', '...')", new Class[]{Human.class, User.class}, new Class[]{Human.class}, new LogicalType[0], (LogicalType)new RawType(User.class, (TypeSerializer)new KryoSerializer(User.class, new ExecutionConfig())))});
        TableAssertions.assertThat((LogicalType)RawType.restore((ClassLoader)LogicalTypesTest.class.getClassLoader(), (String)"org.apache.flink.table.types.LogicalTypesTest$Human", (String)"AEdvcmcuYXBhY2hlLmZsaW5rLmFwaS5qYXZhLnR5cGV1dGlscy5ydW50aW1lLmtyeW8uS3J5b1NlcmlhbGl6ZXJTbmFwc2hvdAAAAAIAM29yZy5hcGFjaGUuZmxpbmsudGFibGUudHlwZXMuTG9naWNhbFR5cGVzVGVzdCRIdW1hbgAABPLGmj1wAAAAAgAzb3JnLmFwYWNoZS5mbGluay50YWJsZS50eXBlcy5Mb2dpY2FsVHlwZXNUZXN0JEh1bWFuAQAAADUAM29yZy5hcGFjaGUuZmxpbmsudGFibGUudHlwZXMuTG9naWNhbFR5cGVzVGVzdCRIdW1hbgEAAAA5ADNvcmcuYXBhY2hlLmZsaW5rLnRhYmxlLnR5cGVzLkxvZ2ljYWxUeXBlc1Rlc3QkSHVtYW4AAAAAAClvcmcuYXBhY2hlLmF2cm8uZ2VuZXJpYy5HZW5lcmljRGF0YSRBcnJheQEAAAArAClvcmcuYXBhY2hlLmF2cm8uZ2VuZXJpYy5HZW5lcmljRGF0YSRBcnJheQEAAAC2AFVvcmcuYXBhY2hlLmZsaW5rLmFwaS5qYXZhLnR5cGV1dGlscy5ydW50aW1lLmtyeW8uU2VyaWFsaXplcnMkRHVtbXlBdnJvUmVnaXN0ZXJlZENsYXNzAAAAAQBZb3JnLmFwYWNoZS5mbGluay5hcGkuamF2YS50eXBldXRpbHMucnVudGltZS5rcnlvLlNlcmlhbGl6ZXJzJER1bW15QXZyb0tyeW9TZXJpYWxpemVyQ2xhc3MAAATyxpo9cAAAAAAAAATyxpo9cAAAAAA=")).isEqualTo(rawType);
    }

    @Test
    void testSymbolType() {
        SymbolType symbolType = new SymbolType();
        ((LogicalTypeAssert)((LogicalTypeAssert)TableAssertions.assertThat((LogicalType)symbolType).hasSummaryString("SYMBOL").satisfies(new ThrowingConsumer[]{LogicalTypesTest::nullability})).isJavaSerializable().satisfies(new ThrowingConsumer[]{LogicalTypesTest.conversions(new Class[]{TimeIntervalUnit.class}, new Class[]{TimeIntervalUnit.class})})).hasNoSerializableString();
    }

    @Test
    void testUnresolvedUserDefinedType() {
        UnresolvedUserDefinedType unresolvedType = new UnresolvedUserDefinedType(UnresolvedIdentifier.of((String[])new String[]{"catalog", "database", "Type"}));
        ((LogicalTypeAssert)TableAssertions.assertThat((LogicalType)unresolvedType).satisfies(new ThrowingConsumer[]{LogicalTypesTest.nonEqualityCheckWithOtherType((LogicalType)new UnresolvedUserDefinedType(UnresolvedIdentifier.of((String[])new String[]{"different", "database", "Type"})))})).hasSummaryString("`catalog`.`database`.`Type`");
    }

    @Test
    void testEmptyStringLiterals() {
        CharType charType = CharType.ofEmptyLiteral();
        VarCharType varcharType = VarCharType.ofEmptyLiteral();
        BinaryType binaryType = BinaryType.ofEmptyLiteral();
        VarBinaryType varBinaryType = VarBinaryType.ofEmptyLiteral();
        TableAssertions.assertThat(charType.copy(true)).satisfies(new ThrowingConsumer[]{LogicalTypesTest.nonEqualityCheckWithOtherType((LogicalType)new CharType(1))});
        TableAssertions.assertThat(varcharType.copy(true)).satisfies(new ThrowingConsumer[]{LogicalTypesTest.nonEqualityCheckWithOtherType((LogicalType)new VarCharType(1))});
        TableAssertions.assertThat(binaryType.copy(true)).satisfies(new ThrowingConsumer[]{LogicalTypesTest.nonEqualityCheckWithOtherType((LogicalType)new BinaryType(1))});
        TableAssertions.assertThat(varBinaryType.copy(true)).satisfies(new ThrowingConsumer[]{LogicalTypesTest.nonEqualityCheckWithOtherType((LogicalType)new VarBinaryType(1))});
        TableAssertions.assertThat((LogicalType)charType).hasSummaryString("CHAR(0) NOT NULL");
        TableAssertions.assertThat((LogicalType)varcharType).hasSummaryString("VARCHAR(0) NOT NULL");
        TableAssertions.assertThat((LogicalType)binaryType).hasSummaryString("BINARY(0) NOT NULL");
        TableAssertions.assertThat((LogicalType)varBinaryType).hasSummaryString("VARBINARY(0) NOT NULL");
        TableAssertions.assertThat((LogicalType)charType).hasNoSerializableString();
        TableAssertions.assertThat((LogicalType)varcharType).hasNoSerializableString();
        TableAssertions.assertThat((LogicalType)binaryType).hasNoSerializableString();
        TableAssertions.assertThat((LogicalType)varBinaryType).hasNoSerializableString();
    }

    @Test
    void testUnregisteredStructuredType() {
        StructuredType structuredType = this.createUserType(false, true);
        ((LogicalTypeAssert)((LogicalTypeAssert)((LogicalTypeAssert)TableAssertions.assertThat((LogicalType)structuredType).satisfies(new ThrowingConsumer[]{LogicalTypesTest.nonEqualityCheckWithOtherType((LogicalType)this.createUserType(false, false))})).satisfies(new ThrowingConsumer[]{LogicalTypesTest::nullability})).isJavaSerializable().hasNoSerializableString().hasSummaryString(String.format("*%s<`name` VARCHAR(1) '...', `setting` INT, `timestamp` TIMESTAMP(6)>*", User.class.getName())).satisfies(new ThrowingConsumer[]{LogicalTypesTest.conversions(new Class[]{Row.class, User.class}, new Class[]{Row.class, Human.class, User.class})})).hasExactlyChildren(UDT_NAME_TYPE, UDT_SETTING_TYPE, UDT_TIMESTAMP_TYPE);
    }

    private static ThrowingConsumer<LogicalType> baseAssertions(String serializableString, String summaryString, Class<?>[] supportedInputClasses, Class<?>[] supportedOutputClasses, LogicalType[] children, LogicalType otherType) {
        return nullableType -> ((LogicalTypeAssert)((LogicalTypeAssert)((LogicalTypeAssert)TableAssertions.assertThat(nullableType).satisfies(new ThrowingConsumer[]{LogicalTypesTest.nonEqualityCheckWithOtherType(otherType)})).satisfies(new ThrowingConsumer[]{LogicalTypesTest::nullability})).isJavaSerializable().hasSerializableString(serializableString).hasSummaryString(summaryString).satisfies(new ThrowingConsumer[]{LogicalTypesTest.conversions(supportedInputClasses, supportedOutputClasses)})).hasExactlyChildren(children);
    }

    private static ThrowingConsumer<LogicalType> nonEqualityCheckWithOtherType(LogicalType otherType) {
        return nullableType -> {
            ((LogicalTypeAssert)((LogicalTypeAssert)TableAssertions.assertThat(nullableType).isNullable().isEqualTo(nullableType)).isEqualTo(nullableType.copy())).isNotEqualTo(otherType);
            Assertions.assertThat((int)nullableType.hashCode()).isEqualTo(nullableType.hashCode()).isNotEqualTo(otherType.hashCode());
        };
    }

    private static void nullability(LogicalType nullableType) {
        LogicalType notNullInstance = nullableType.copy(false);
        TableAssertions.assertThat(notNullInstance).isNotNullable();
        TableAssertions.assertThat(nullableType).isNotEqualTo(notNullInstance);
    }

    private static ThrowingConsumer<LogicalType> conversions(Class<?>[] inputs, Class<?>[] outputs) {
        return type -> {
            TableAssertions.assertThat(type).supportsInputConversion(type.getDefaultConversion()).supportsOutputConversion(type.getDefaultConversion()).doesNotSupportInputConversion(LogicalTypesTest.class).doesNotSupportOutputConversion(LogicalTypesTest.class);
            for (Class clazz : inputs) {
                TableAssertions.assertThat(type).supportsInputConversion(clazz);
            }
            for (Class clazz : outputs) {
                TableAssertions.assertThat(type).supportsOutputConversion(clazz);
            }
        };
    }

    private DistinctType createDistinctType(String typeName) {
        return DistinctType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)typeName), (LogicalType)new DecimalType(10, 2)).description("Money type desc.").build();
    }

    private StructuredType createHumanType(boolean useDifferentImplementation) {
        return StructuredType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)"Human"), useDifferentImplementation ? SpecialHuman.class : Human.class).attributes(Collections.singletonList(new StructuredType.StructuredAttribute("name", UDT_NAME_TYPE, "Description."))).description("Human type desc.").setFinal(false).setInstantiable(false).build();
    }

    private StructuredType createUserType(boolean isRegistered, boolean isFinal) {
        StructuredType.Builder builder = isRegistered ? StructuredType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)"User"), User.class) : StructuredType.newBuilder(User.class);
        return builder.attributes(Arrays.asList(new StructuredType.StructuredAttribute("setting", UDT_SETTING_TYPE), new StructuredType.StructuredAttribute("timestamp", UDT_TIMESTAMP_TYPE))).description("User type desc.").setFinal(isFinal).setInstantiable(true).superType(this.createHumanType(false)).build();
    }

    private static final class User
    extends Human {
        public int setting;
        public LocalDateTime timestamp;

        private User() {
        }
    }

    private static abstract class Human {
        public String name;

        private Human() {
        }
    }

    private static abstract class SpecialHuman {
        public String name;

        private SpecialHuman() {
        }
    }
}

