/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.VoidSerializer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.test.TableAssertions;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.UnresolvedDataType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DayTimeIntervalType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.NullType;
import org.apache.flink.table.types.logical.RawType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.YearMonthIntervalType;
import org.apache.flink.table.types.logical.ZonedTimestampType;
import org.apache.flink.table.types.utils.DataTypeFactoryMock;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class DataTypesTest {
    DataTypesTest() {
    }

    private static Stream<TestSpec> testData() {
        return Stream.of(TestSpec.forDataType(DataTypes.CHAR((int)2)).expectLogicalType((LogicalType)new CharType(2)).expectConversionClass(String.class), TestSpec.forDataType(DataTypes.VARCHAR((int)2)).expectLogicalType((LogicalType)new VarCharType(2)).expectConversionClass(String.class), TestSpec.forDataType(DataTypes.STRING()).expectLogicalType((LogicalType)VarCharType.STRING_TYPE).expectConversionClass(String.class), TestSpec.forDataType(DataTypes.BOOLEAN()).expectLogicalType((LogicalType)new BooleanType()).expectConversionClass(Boolean.class), TestSpec.forDataType(DataTypes.BINARY((int)42)).expectLogicalType((LogicalType)new BinaryType(42)).expectConversionClass(byte[].class), TestSpec.forDataType(DataTypes.VARBINARY((int)42)).expectLogicalType((LogicalType)new VarBinaryType(42)).expectConversionClass(byte[].class), TestSpec.forDataType(DataTypes.BYTES()).expectLogicalType((LogicalType)new VarBinaryType(Integer.MAX_VALUE)).expectConversionClass(byte[].class), TestSpec.forDataType(DataTypes.DECIMAL((int)10, (int)10)).expectLogicalType((LogicalType)new DecimalType(10, 10)).expectConversionClass(BigDecimal.class), TestSpec.forDataType(DataTypes.TINYINT()).expectLogicalType((LogicalType)new TinyIntType()).expectConversionClass(Byte.class), TestSpec.forDataType(DataTypes.SMALLINT()).expectLogicalType((LogicalType)new SmallIntType()).expectConversionClass(Short.class), TestSpec.forDataType(DataTypes.INT()).expectLogicalType((LogicalType)new IntType()).expectConversionClass(Integer.class), TestSpec.forDataType(DataTypes.BIGINT()).expectLogicalType((LogicalType)new BigIntType()).expectConversionClass(Long.class), TestSpec.forDataType(DataTypes.FLOAT()).expectLogicalType((LogicalType)new FloatType()).expectConversionClass(Float.class), TestSpec.forDataType(DataTypes.DOUBLE()).expectLogicalType((LogicalType)new DoubleType()).expectConversionClass(Double.class), TestSpec.forDataType(DataTypes.DATE()).expectLogicalType((LogicalType)new DateType()).expectConversionClass(LocalDate.class), TestSpec.forDataType(DataTypes.TIME((int)3)).expectLogicalType((LogicalType)new TimeType(3)).expectConversionClass(LocalTime.class), TestSpec.forDataType(DataTypes.TIME()).expectLogicalType((LogicalType)new TimeType(0)).expectConversionClass(LocalTime.class), TestSpec.forDataType(DataTypes.TIMESTAMP((int)3)).expectLogicalType((LogicalType)new TimestampType(3)).expectConversionClass(LocalDateTime.class), TestSpec.forDataType(DataTypes.TIMESTAMP()).expectLogicalType((LogicalType)new TimestampType(6)).expectConversionClass(LocalDateTime.class), TestSpec.forDataType(DataTypes.TIMESTAMP_WITH_TIME_ZONE((int)3)).expectLogicalType((LogicalType)new ZonedTimestampType(3)).expectConversionClass(OffsetDateTime.class), TestSpec.forDataType(DataTypes.TIMESTAMP_WITH_TIME_ZONE()).expectLogicalType((LogicalType)new ZonedTimestampType(6)).expectConversionClass(OffsetDateTime.class), TestSpec.forDataType(DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3)).expectLogicalType((LogicalType)new LocalZonedTimestampType(3)).expectConversionClass(Instant.class), TestSpec.forDataType(DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE()).expectLogicalType((LogicalType)new LocalZonedTimestampType(6)).expectConversionClass(Instant.class), TestSpec.forDataType(DataTypes.TIMESTAMP_LTZ((int)3)).expectLogicalType((LogicalType)new LocalZonedTimestampType(3)).expectConversionClass(Instant.class), TestSpec.forDataType(DataTypes.TIMESTAMP_LTZ()).expectLogicalType((LogicalType)new LocalZonedTimestampType(6)).expectConversionClass(Instant.class), TestSpec.forDataType(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MINUTE(), (DataTypes.Resolution)DataTypes.SECOND((int)3))).expectLogicalType((LogicalType)new DayTimeIntervalType(DayTimeIntervalType.DayTimeResolution.MINUTE_TO_SECOND, 2, 3)).expectConversionClass(Duration.class), TestSpec.forDataType(DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH())).expectLogicalType((LogicalType)new YearMonthIntervalType(YearMonthIntervalType.YearMonthResolution.MONTH)).expectConversionClass(Period.class), TestSpec.forDataType(DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)DataTypes.INT()))).expectLogicalType((LogicalType)new ArrayType((LogicalType)new ArrayType((LogicalType)new IntType()))).expectConversionClass(Integer[][].class), TestSpec.forDataType((DataType)DataTypes.ARRAY((DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.INT().notNull()))).bridgedTo(int[][].class)).expectLogicalType((LogicalType)new ArrayType((LogicalType)new ArrayType((LogicalType)new IntType(false)))).expectConversionClass(int[][].class).expectChildren((DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.INT().notNull())).bridgedTo(int[].class)), TestSpec.forDataType(DataTypes.MULTISET((DataType)DataTypes.MULTISET((DataType)DataTypes.INT()))).expectLogicalType((LogicalType)new MultisetType((LogicalType)new MultisetType((LogicalType)new IntType()))).expectConversionClass(Map.class), TestSpec.forDataType(DataTypes.MAP((DataType)DataTypes.INT(), (DataType)DataTypes.SMALLINT())).expectLogicalType((LogicalType)new MapType((LogicalType)new IntType(), (LogicalType)new SmallIntType())).expectConversionClass(Map.class), TestSpec.forDataType(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"field1", (DataType)DataTypes.CHAR((int)2)), DataTypes.FIELD((String)"field2", (DataType)DataTypes.BOOLEAN())})).expectLogicalType((LogicalType)new RowType(Arrays.asList(new RowType.RowField("field1", (LogicalType)new CharType(2)), new RowType.RowField("field2", (LogicalType)new BooleanType())))).expectConversionClass(Row.class), TestSpec.forDataType(DataTypes.ROW((DataType[])new DataType[]{DataTypes.INT(), DataTypes.FLOAT()})).expectResolvedDataType(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.FLOAT())})), TestSpec.forDataType(DataTypes.NULL()).expectLogicalType((LogicalType)new NullType()).expectConversionClass(Object.class), TestSpec.forDataType(DataTypes.RAW(Void.class, (TypeSerializer)VoidSerializer.INSTANCE)).expectLogicalType((LogicalType)new RawType(Void.class, (TypeSerializer)VoidSerializer.INSTANCE)).expectConversionClass(Void.class), TestSpec.forUnresolvedDataType(DataTypes.RAW((TypeInformation)Types.VOID)).expectUnresolvedString("[RAW('java.lang.Void', '?')]").lookupReturns(DataTypeFactoryMock.dummyRaw(Void.class)).expectResolvedDataType(DataTypeFactoryMock.dummyRaw(Void.class)), TestSpec.forUnresolvedDataType(DataTypes.of((String)"INT")).expectUnresolvedString("[INT]").lookupReturns(DataTypes.INT()).expectLogicalType((LogicalType)new IntType()), TestSpec.forUnresolvedDataType(DataTypes.of(Integer.class)).expectUnresolvedString("['java.lang.Integer']").expectResolvedDataType(DataTypes.INT()), TestSpec.forUnresolvedDataType(DataTypes.of(Timestamp.class).notNull()).expectUnresolvedString("['java.sql.Timestamp']").expectResolvedDataType((DataType)((DataType)DataTypes.TIMESTAMP((int)9).notNull()).bridgedTo(Timestamp.class)), TestSpec.forUnresolvedDataType(DataTypes.of(Timestamp.class).bridgedTo(LocalDateTime.class)).expectUnresolvedString("['java.sql.Timestamp']").expectResolvedDataType((DataType)DataTypes.TIMESTAMP((int)9).bridgedTo(LocalDateTime.class)), TestSpec.forUnresolvedDataType(DataTypes.MAP((AbstractDataType)DataTypes.of((String)"INT"), (AbstractDataType)DataTypes.of((String)"STRING"))).expectUnresolvedString("[MAP<[INT], [STRING]>]").expectResolvedDataType(DataTypes.MAP((DataType)DataTypes.INT(), (DataType)DataTypes.STRING())), TestSpec.forUnresolvedDataType(DataTypes.MAP((AbstractDataType)DataTypes.of((String)"INT"), (AbstractDataType)DataTypes.STRING().notNull())).expectUnresolvedString("[MAP<[INT], STRING NOT NULL>]").expectResolvedDataType(DataTypes.MAP((DataType)DataTypes.INT(), (DataType)((DataType)DataTypes.STRING().notNull()))), TestSpec.forUnresolvedDataType(DataTypes.MULTISET((AbstractDataType)DataTypes.of((String)"STRING"))).expectUnresolvedString("[MULTISET<[STRING]>]").expectResolvedDataType(DataTypes.MULTISET((DataType)DataTypes.STRING())), TestSpec.forUnresolvedDataType(DataTypes.ARRAY((AbstractDataType)DataTypes.of((String)"STRING"))).expectUnresolvedString("[ARRAY<[STRING]>]").expectResolvedDataType(DataTypes.ARRAY((DataType)DataTypes.STRING())), TestSpec.forUnresolvedDataType(DataTypes.ARRAY((AbstractDataType)DataTypes.of((String)"INT").notNull()).bridgedTo(int[].class)).expectUnresolvedString("[ARRAY<[INT]>]").expectResolvedDataType((DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.INT().notNull())).bridgedTo(int[].class)), TestSpec.forUnresolvedDataType(DataTypes.ROW((DataTypes.AbstractField[])new DataTypes.AbstractField[]{DataTypes.FIELD((String)"field1", (AbstractDataType)DataTypes.of((String)"CHAR(2)")), DataTypes.FIELD((String)"field2", (DataType)DataTypes.BOOLEAN())})).expectUnresolvedString("[ROW<field1 [CHAR(2)], field2 BOOLEAN>]").expectResolvedDataType(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"field1", (DataType)DataTypes.CHAR((int)2)), DataTypes.FIELD((String)"field2", (DataType)DataTypes.BOOLEAN())})), TestSpec.forUnresolvedDataType(DataTypes.ROW((AbstractDataType[])new AbstractDataType[]{DataTypes.of((String)"CHAR(2)"), DataTypes.BOOLEAN()})).expectResolvedDataType(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.CHAR((int)2)), DataTypes.FIELD((String)"f1", (DataType)DataTypes.BOOLEAN())})), TestSpec.forUnresolvedDataType(DataTypes.ARRAY((AbstractDataType)DataTypes.ROW((DataTypes.AbstractField[])new DataTypes.AbstractField[]{DataTypes.FIELD((String)"f0", (AbstractDataType)DataTypes.of((String)"ARRAY<INT>")), DataTypes.FIELD((String)"f1", (DataType)DataTypes.ARRAY((DataType)DataTypes.INT()))}))).expectUnresolvedString("[ARRAY<[ROW<f0 [ARRAY<INT>], f1 ARRAY<INT>>]>]").expectResolvedDataType(DataTypes.ARRAY((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.ARRAY((DataType)DataTypes.INT())), DataTypes.FIELD((String)"f1", (DataType)DataTypes.ARRAY((DataType)DataTypes.INT()))}))), TestSpec.forUnresolvedDataType(DataTypes.RAW(Object.class)).expectUnresolvedString("[RAW('java.lang.Object', '?')]").lookupReturns(DataTypeFactoryMock.dummyRaw(Object.class)).expectResolvedDataType(DataTypeFactoryMock.dummyRaw(Object.class)), TestSpec.forUnresolvedDataType(DataTypes.of(SimplePojo.class)).expectResolvedDataType(DataTypes.STRUCTURED(SimplePojo.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"name", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"count", (DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))})), TestSpec.forUnresolvedDataType(DataTypes.of((TypeInformation)Types.ENUM(DayOfWeek.class))).expectUnresolvedString("['EnumTypeInfo<java.time.DayOfWeek>']").lookupReturns(DataTypeFactoryMock.dummyRaw(DayOfWeek.class)).expectResolvedDataType(DataTypeFactoryMock.dummyRaw(DayOfWeek.class)));
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"testData"})
    void testLogicalType(TestSpec testSpec) {
        if (testSpec.expectedLogicalType != null) {
            DataType dataType = testSpec.typeFactory.createDataType(testSpec.abstractDataType);
            TableAssertions.assertThat(dataType).hasLogicalType(testSpec.expectedLogicalType);
            TableAssertions.assertThat((DataType)DataTypes.of((LogicalType)testSpec.expectedLogicalType).bridgedTo(dataType.getConversionClass())).isEqualTo(dataType);
        }
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"testData"})
    void testConversionClass(TestSpec testSpec) {
        if (testSpec.expectedConversionClass != null) {
            TableAssertions.assertThat(testSpec.typeFactory.createDataType(testSpec.abstractDataType)).hasConversionClass(testSpec.expectedConversionClass);
        }
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"testData"})
    void testChildren(TestSpec testSpec) {
        if (testSpec.expectedChildren != null) {
            TableAssertions.assertThat(testSpec.typeFactory.createDataType(testSpec.abstractDataType)).getChildren().isEqualTo((Object)testSpec.expectedChildren);
        }
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"testData"})
    void testUnresolvedString(TestSpec testSpec) {
        if (testSpec.expectedUnresolvedString != null) {
            Assertions.assertThat((String)testSpec.abstractDataType.toString()).isEqualTo(testSpec.expectedUnresolvedString);
        }
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"testData"})
    void testResolvedDataType(TestSpec testSpec) {
        if (testSpec.expectedResolvedDataType != null) {
            TableAssertions.assertThat(testSpec.typeFactory.createDataType(testSpec.abstractDataType)).isEqualTo(testSpec.expectedResolvedDataType);
        }
    }

    public static class SimplePojo {
        public final String name;
        public final int count;

        public SimplePojo(String name, int count) {
            this.name = name;
            this.count = count;
        }
    }

    private static class TestSpec {
        private final DataTypeFactoryMock typeFactory = new DataTypeFactoryMock();
        private final AbstractDataType<?> abstractDataType;
        @Nullable
        private LogicalType expectedLogicalType;
        @Nullable
        private Class<?> expectedConversionClass;
        @Nullable
        private List<DataType> expectedChildren;
        @Nullable
        private String expectedUnresolvedString;
        @Nullable
        private DataType expectedResolvedDataType;

        private TestSpec(AbstractDataType<?> abstractDataType) {
            this.abstractDataType = abstractDataType;
        }

        static TestSpec forDataType(DataType dataType) {
            return new TestSpec((AbstractDataType<?>)dataType);
        }

        static TestSpec forUnresolvedDataType(UnresolvedDataType unresolvedDataType) {
            return new TestSpec((AbstractDataType<?>)unresolvedDataType);
        }

        TestSpec expectLogicalType(LogicalType expectedLogicalType) {
            this.expectedLogicalType = expectedLogicalType;
            return this;
        }

        TestSpec expectConversionClass(Class<?> expectedConversionClass) {
            this.expectedConversionClass = expectedConversionClass;
            return this;
        }

        TestSpec expectChildren(DataType ... expectedChildren) {
            this.expectedChildren = Arrays.asList(expectedChildren);
            return this;
        }

        TestSpec expectUnresolvedString(String expectedUnresolvedString) {
            this.expectedUnresolvedString = expectedUnresolvedString;
            return this;
        }

        TestSpec expectResolvedDataType(DataType expectedResolvedDataType) {
            this.expectedResolvedDataType = expectedResolvedDataType;
            return this;
        }

        TestSpec lookupReturns(DataType dataType) {
            this.typeFactory.dataType = Optional.of(dataType);
            return this;
        }

        public String toString() {
            return this.abstractDataType.toString();
        }
    }
}

