/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.test;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.test.InternalDataUtils;
import org.apache.flink.table.test.RowDataAssert;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.types.Row;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.ListAssert;

@Experimental
public class RowDataListAssert
extends AbstractListAssert<RowDataListAssert, List<RowData>, RowData, RowDataAssert> {
    public RowDataListAssert(List<RowData> rowDataList) {
        super(rowDataList, RowDataListAssert.class);
    }

    protected RowDataAssert toAssert(RowData value, String description) {
        return (RowDataAssert)((Object)new RowDataAssert(value).as(description, new Object[0]));
    }

    protected RowDataListAssert newAbstractIterableAssert(Iterable<? extends RowData> iterable) {
        if (iterable instanceof List) {
            return new RowDataListAssert((List)iterable);
        }
        return new RowDataListAssert(StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList()));
    }

    public RowDataListAssert asGeneric(DataType dataType) {
        return this.asGeneric(dataType.getLogicalType());
    }

    public RowDataListAssert asGeneric(LogicalType logicalType) {
        return (RowDataListAssert)this.usingElementComparator((x, y) -> {
            if (Objects.equals(x = InternalDataUtils.toGenericRow(x, logicalType), y = InternalDataUtils.toGenericRow(y, logicalType))) {
                return 0;
            }
            return Objects.hashCode(x) < Objects.hashCode(y) ? -1 : 1;
        });
    }

    public ListAssert<Row> asRows(DataType dataType) {
        return new ListAssert(((List)this.actual).stream().map(InternalDataUtils.resolveToExternalOrNull(dataType)));
    }
}

