/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.test;

import java.io.IOException;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.test.LogicalTypeConditions;
import org.apache.flink.table.types.LogicalTypesTest;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.util.InstantiationUtil;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.ListAssert;

@Experimental
public class LogicalTypeAssert
extends AbstractAssert<LogicalTypeAssert, LogicalType> {
    public LogicalTypeAssert(LogicalType logicalType) {
        super((Object)logicalType, LogicalTypeAssert.class);
    }

    public LogicalTypeAssert isNullable() {
        this.isNotNull();
        this.satisfies(LogicalTypeConditions.NULLABLE);
        return (LogicalTypeAssert)this.myself;
    }

    public LogicalTypeAssert isNotNullable() {
        this.isNotNull();
        this.satisfies((Condition)Assertions.not(LogicalTypeConditions.NULLABLE));
        return (LogicalTypeAssert)this.myself;
    }

    public ListAssert<LogicalType> getChildren() {
        this.isNotNull();
        return new ListAssert(((LogicalType)this.actual).getChildren());
    }

    public LogicalTypeAssert hasExactlyChildren(LogicalType ... children) {
        this.isNotNull();
        this.getChildren().containsExactly((Object[])children);
        return (LogicalTypeAssert)this.myself;
    }

    public LogicalTypeAssert hasSerializableString(String serializableString) {
        this.isNotNull();
        Assertions.assertThat((String)((LogicalType)this.actual).asSerializableString()).isEqualTo(serializableString);
        return (LogicalTypeAssert)this.myself;
    }

    public LogicalTypeAssert hasNoSerializableString() {
        this.isNotNull();
        Assertions.assertThatThrownBy(() -> ((LogicalType)((LogicalType)this.actual)).asSerializableString()).isInstanceOf(TableException.class);
        return (LogicalTypeAssert)this.myself;
    }

    public LogicalTypeAssert hasSummaryString(String summaryString) {
        this.isNotNull();
        Assertions.assertThat((String)((LogicalType)this.actual).asSummaryString()).isEqualTo(summaryString);
        return (LogicalTypeAssert)this.myself;
    }

    public LogicalTypeAssert supportsInputConversion(Class<?> clazz) {
        this.isNotNull();
        Assertions.assertThat((boolean)((LogicalType)this.actual).supportsInputConversion(clazz)).isTrue();
        return (LogicalTypeAssert)this.myself;
    }

    public LogicalTypeAssert doesNotSupportInputConversion(Class<?> clazz) {
        this.isNotNull();
        Assertions.assertThat((boolean)((LogicalType)this.actual).supportsInputConversion(clazz)).isFalse();
        return (LogicalTypeAssert)this.myself;
    }

    public LogicalTypeAssert supportsOutputConversion(Class<?> clazz) {
        this.isNotNull();
        Assertions.assertThat((boolean)((LogicalType)this.actual).supportsOutputConversion(clazz)).isTrue();
        return (LogicalTypeAssert)this.myself;
    }

    public LogicalTypeAssert doesNotSupportOutputConversion(Class<?> clazz) {
        this.isNotNull();
        Assertions.assertThat((boolean)((LogicalType)this.actual).supportsOutputConversion(clazz)).isFalse();
        return (LogicalTypeAssert)this.myself;
    }

    public LogicalTypeAssert isJavaSerializable() {
        this.isNotNull();
        try {
            Assertions.assertThat((Object)InstantiationUtil.deserializeObject((byte[])InstantiationUtil.serializeObject((Object)this.actual), (ClassLoader)LogicalTypesTest.class.getClassLoader())).isEqualTo(this.actual);
        }
        catch (IOException | ClassNotFoundException e) {
            Assertions.fail((String)("Error when trying to serialize logical type " + ((LogicalType)this.actual).asSummaryString() + " to string"), (Throwable)e);
        }
        return (LogicalTypeAssert)this.myself;
    }

    public LogicalTypeAssert isDecimalType() {
        this.isNotNull();
        Assertions.assertThat((Comparable)((LogicalType)this.actual).getTypeRoot()).isEqualTo((Object)LogicalTypeRoot.DECIMAL);
        this.isInstanceOf(DecimalType.class);
        return (LogicalTypeAssert)this.myself;
    }

    public LogicalTypeAssert hasPrecision(int precision) {
        Assertions.assertThat((int)LogicalTypeChecks.getPrecision((LogicalType)((LogicalType)this.actual))).isEqualTo(precision);
        return (LogicalTypeAssert)this.myself;
    }

    public LogicalTypeAssert hasScale(int scale) {
        Assertions.assertThat((int)LogicalTypeChecks.getScale((LogicalType)((LogicalType)this.actual))).isEqualTo(scale);
        return (LogicalTypeAssert)this.myself;
    }

    public LogicalTypeAssert hasPrecisionAndScale(int precision, int scale) {
        return this.hasPrecision(precision).hasScale(scale);
    }
}

