/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.test;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.types.Row;
import org.junit.jupiter.api.Assertions;

class InternalDataUtils {
    InternalDataUtils() {
    }

    static Object toGenericInternalData(Object object, LogicalType logicalType) {
        if (object instanceof RowData) {
            return InternalDataUtils.toGenericRow((RowData)object, logicalType);
        }
        if (object instanceof ArrayData) {
            return InternalDataUtils.toGenericArray((ArrayData)object, logicalType);
        }
        if (object instanceof MapData) {
            return InternalDataUtils.toGenericMap((MapData)object, logicalType);
        }
        return object;
    }

    static GenericRowData toGenericRow(RowData rowData, LogicalType logicalType) {
        List fieldTypes = LogicalTypeChecks.getFieldTypes((LogicalType)logicalType);
        GenericRowData row = new GenericRowData(fieldTypes.size());
        row.setRowKind(rowData.getRowKind());
        for (int i = 0; i < fieldTypes.size(); ++i) {
            if (rowData.isNullAt(i)) {
                row.setField(i, null);
                continue;
            }
            LogicalType fieldType = (LogicalType)fieldTypes.get(i);
            RowData.FieldGetter fieldGetter = RowData.createFieldGetter((LogicalType)fieldType, (int)i);
            row.setField(i, InternalDataUtils.toGenericInternalData(fieldGetter.getFieldOrNull(rowData), fieldType));
        }
        return row;
    }

    static GenericArrayData toGenericArray(ArrayData arrayData, LogicalType logicalType) {
        LogicalType innerElement = ((ArrayType)logicalType).getElementType();
        ArrayData.ElementGetter elementGetter = ArrayData.createElementGetter((LogicalType)innerElement);
        Object[] newArray = new Object[arrayData.size()];
        for (int i = 0; i < arrayData.size(); ++i) {
            newArray[i] = arrayData.isNullAt(i) ? null : InternalDataUtils.toGenericInternalData(elementGetter.getElementOrNull(arrayData, i), innerElement);
        }
        return new GenericArrayData(newArray);
    }

    static GenericMapData toGenericMap(MapData mapData, LogicalType logicalType) {
        LogicalType keyType = logicalType.is(LogicalTypeRoot.MULTISET) ? ((MultisetType)logicalType).getElementType() : ((MapType)logicalType).getKeyType();
        IntType valueType = logicalType.is(LogicalTypeRoot.MULTISET) ? new IntType(false) : ((MapType)logicalType).getValueType();
        ArrayData.ElementGetter keyGetter = ArrayData.createElementGetter((LogicalType)keyType);
        ArrayData.ElementGetter valueGetter = ArrayData.createElementGetter((LogicalType)valueType);
        ArrayData keys = mapData.keyArray();
        ArrayData values = mapData.valueArray();
        LinkedHashMap<Object, Object> newMap = new LinkedHashMap<Object, Object>();
        for (int i = 0; i < mapData.size(); ++i) {
            Object key = null;
            Object value = null;
            if (!keys.isNullAt(i)) {
                key = InternalDataUtils.toGenericInternalData(keyGetter.getElementOrNull(keys, i), keyType);
            }
            if (!values.isNullAt(i)) {
                value = InternalDataUtils.toGenericInternalData(valueGetter.getElementOrNull(values, i), (LogicalType)valueType);
            }
            newMap.put(key, value);
        }
        return new GenericMapData(newMap);
    }

    static Function<RowData, Row> resolveToExternalOrNull(DataType dataType) {
        try {
            Method getConverter = Class.forName("org.apache.flink.table.data.conversion.DataStructureConverters").getMethod("getConverter", DataType.class);
            Object converter = getConverter.invoke(null, dataType);
            converter.getClass().getMethod("open", ClassLoader.class).invoke(converter, Thread.currentThread().getContextClassLoader());
            Method toExternalOrNull = converter.getClass().getMethod("toExternalOrNull", Object.class);
            return rowData -> {
                try {
                    return (Row)toExternalOrNull.invoke(converter, rowData);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    Assertions.fail((String)"Something went wrong when trying to use the DataStructureConverter from flink-table-runtime", (Throwable)e);
                    return null;
                }
            };
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Assertions.fail((String)"Error when trying to use the RowData to Row conversion. Perhaps you miss flink-table-runtime in your test classpath?", (Throwable)e);
            return null;
        }
    }
}

