/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.test;

import java.util.Objects;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.test.InternalDataUtils;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;

@Experimental
public class ArrayDataAssert
extends AbstractAssert<ArrayDataAssert, ArrayData> {
    public ArrayDataAssert(ArrayData arrayData) {
        super((Object)arrayData, ArrayDataAssert.class);
    }

    public ArrayDataAssert hasSize(int size) {
        this.isNotNull();
        Assertions.assertThat((int)((ArrayData)this.actual).size()).isEqualTo(size);
        return this;
    }

    public ArrayDataAssert asGeneric(DataType dataType) {
        return this.asGeneric(dataType.getLogicalType());
    }

    public ArrayDataAssert asGeneric(LogicalType logicalType) {
        GenericArrayData actual = InternalDataUtils.toGenericArray((ArrayData)this.actual, logicalType);
        return (ArrayDataAssert)new ArrayDataAssert((ArrayData)actual).usingComparator((x, y) -> {
            x = x == actual ? x : InternalDataUtils.toGenericArray(x, logicalType);
            Object object = y = y == actual ? y : InternalDataUtils.toGenericArray(y, logicalType);
            if (Objects.equals(x, y)) {
                return 0;
            }
            return Objects.hashCode(x) < Objects.hashCode(y) ? -1 : 1;
        });
    }
}

