/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.FunctionLanguage;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.TableAggregateFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.functions.UserDefinedFunctionHelper;
import org.apache.flink.table.resource.ResourceUri;
import org.apache.flink.util.Collector;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class UserDefinedFunctionHelperTest {
    UserDefinedFunctionHelperTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"testSpecs"})
    void testInstantiation(TestSpec testSpec) {
        Supplier<UserDefinedFunction> supplier;
        if (testSpec.functionClass != null) {
            supplier = () -> UserDefinedFunctionHelper.instantiateFunction(testSpec.functionClass);
        } else if (testSpec.catalogFunction != null) {
            supplier = () -> UserDefinedFunctionHelper.instantiateFunction((ClassLoader)UserDefinedFunctionHelperTest.class.getClassLoader(), (ReadableConfig)new Configuration(), (String)"f", (CatalogFunction)testSpec.catalogFunction);
        } else {
            return;
        }
        if (testSpec.expectedErrorMessage != null) {
            Assertions.assertThatThrownBy(supplier::get).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(ValidationException.class, (String)testSpec.expectedErrorMessage)});
        } else {
            Assertions.assertThat((Object)supplier.get()).isNotNull();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"testSpecs"})
    void testValidation(TestSpec testSpec) {
        Runnable runnable;
        if (testSpec.functionClass != null) {
            runnable = () -> UserDefinedFunctionHelper.validateClass(testSpec.functionClass);
        } else if (testSpec.functionInstance != null) {
            runnable = () -> UserDefinedFunctionHelper.prepareInstance((ReadableConfig)new Configuration(), (UserDefinedFunction)testSpec.functionInstance);
        } else {
            return;
        }
        if (testSpec.expectedErrorMessage != null) {
            Assertions.assertThatThrownBy(runnable::run).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(ValidationException.class, (String)testSpec.expectedErrorMessage)});
        } else {
            runnable.run();
        }
    }

    @Test
    void testSerialization() {
        Assertions.assertThat((boolean)UserDefinedFunctionHelper.isClassNameSerializable((UserDefinedFunction)new ValidTableFunction())).isTrue();
        Assertions.assertThat((boolean)UserDefinedFunctionHelper.isClassNameSerializable((UserDefinedFunction)new ValidScalarFunction())).isTrue();
        Assertions.assertThat((boolean)UserDefinedFunctionHelper.isClassNameSerializable((UserDefinedFunction)new ParameterizedTableFunction(12))).isFalse();
        Assertions.assertThat((boolean)UserDefinedFunctionHelper.isClassNameSerializable((UserDefinedFunction)new StatefulScalarFunction())).isFalse();
    }

    private static List<TestSpec> testSpecs() {
        return Arrays.asList(TestSpec.forClass(ValidScalarFunction.class).expectSuccess(), TestSpec.forInstance((UserDefinedFunction)new ValidScalarFunction()).expectSuccess(), TestSpec.forClass(PrivateScalarFunction.class).expectErrorMessage("Function class '" + PrivateScalarFunction.class.getName() + "' is not public."), TestSpec.forClass(MissingImplementationScalarFunction.class).expectErrorMessage("Function class '" + MissingImplementationScalarFunction.class.getName() + "' does not implement a method named 'eval'."), TestSpec.forClass(PrivateMethodScalarFunction.class).expectErrorMessage("Method 'eval' of function class '" + PrivateMethodScalarFunction.class.getName() + "' is not public."), TestSpec.forInstance((UserDefinedFunction)new ValidTableAggregateFunction()).expectSuccess(), TestSpec.forInstance((UserDefinedFunction)new MissingEmitTableAggregateFunction()).expectErrorMessage("Function class '" + MissingEmitTableAggregateFunction.class.getName() + "' does not implement a method named 'emitUpdateWithRetract' or 'emitValue'."), TestSpec.forInstance((UserDefinedFunction)new ValidTableFunction()).expectSuccess(), TestSpec.forInstance((UserDefinedFunction)new ParameterizedTableFunction(12)).expectSuccess(), TestSpec.forClass(ParameterizedTableFunction.class).expectErrorMessage("Function class '" + ParameterizedTableFunction.class.getName() + "' must have a public default constructor."), TestSpec.forClass(HierarchicalTableAggregateFunction.class).expectSuccess(), TestSpec.forCatalogFunction(ValidScalarFunction.class.getName()).expectSuccess(), TestSpec.forCatalogFunction("I don't exist.").expectErrorMessage("Cannot instantiate user-defined function 'f'."));
    }

    public static class StatefulScalarFunction
    extends ScalarFunction {
        public String state;

        public String eval() {
            return this.state;
        }
    }

    public static class HierarchicalTableAggregateFunction
    extends AbstractTableAggregateFunction {
        public void emitValue(String acc, Collector<String> out) {
        }

        public String createAccumulator() {
            return null;
        }
    }

    private static abstract class AbstractTableAggregateFunction
    extends TableAggregateFunction<String, String> {
        private AbstractTableAggregateFunction() {
        }

        public void accumulate(String acc, String in) {
        }
    }

    public static class ParameterizedTableFunction
    extends TableFunction<String> {
        public ParameterizedTableFunction(int param) {
        }

        public void eval(String i) {
        }
    }

    public static class ValidTableFunction
    extends TableFunction<String> {
        public void eval(String i) {
        }
    }

    public static class MissingEmitTableAggregateFunction
    extends TableAggregateFunction<String, String> {
        public void accumulate(String acc, String in) {
        }

        public String createAccumulator() {
            return null;
        }
    }

    public static class ValidTableAggregateFunction
    extends TableAggregateFunction<String, String> {
        public void accumulate(String acc, String in) {
        }

        public void emitValue(String acc, Collector<String> out) {
        }

        public String createAccumulator() {
            return null;
        }
    }

    public static class PrivateMethodScalarFunction
    extends ScalarFunction {
        private String eval(int i) {
            return null;
        }
    }

    public static class MissingImplementationScalarFunction
    extends ScalarFunction {
    }

    private static class PrivateScalarFunction
    extends ScalarFunction {
        private PrivateScalarFunction() {
        }

        public String eval(int i) {
            return null;
        }
    }

    public static class ValidScalarFunction
    extends ScalarFunction {
        public String eval(int i) {
            return null;
        }
    }

    private static class CatalogFunctionMock
    implements CatalogFunction {
        private final String className;

        CatalogFunctionMock(String className) {
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }

        public CatalogFunction copy() {
            return null;
        }

        public Optional<String> getDescription() {
            return Optional.empty();
        }

        public Optional<String> getDetailedDescription() {
            return Optional.empty();
        }

        public boolean isGeneric() {
            return false;
        }

        public FunctionLanguage getFunctionLanguage() {
            return FunctionLanguage.JAVA;
        }

        public List<ResourceUri> getFunctionResources() {
            return Collections.emptyList();
        }
    }

    private static class TestSpec {
        @Nullable
        final Class<? extends UserDefinedFunction> functionClass;
        @Nullable
        final UserDefinedFunction functionInstance;
        @Nullable
        final CatalogFunction catalogFunction;
        @Nullable
        String expectedErrorMessage;

        TestSpec(@Nullable Class<? extends UserDefinedFunction> functionClass, @Nullable UserDefinedFunction functionInstance, @Nullable CatalogFunction catalogFunction) {
            this.functionClass = functionClass;
            this.functionInstance = functionInstance;
            this.catalogFunction = catalogFunction;
        }

        static TestSpec forClass(Class<? extends UserDefinedFunction> function) {
            return new TestSpec(function, null, null);
        }

        static TestSpec forInstance(UserDefinedFunction function) {
            return new TestSpec(null, function, null);
        }

        static TestSpec forCatalogFunction(String className) {
            return new TestSpec(null, null, new CatalogFunctionMock(className));
        }

        TestSpec expectErrorMessage(String expectedErrorMessage) {
            this.expectedErrorMessage = expectedErrorMessage;
            return this;
        }

        TestSpec expectSuccess() {
            this.expectedErrorMessage = null;
            return this;
        }
    }
}

